# MonsterInsights eCommerce

## Overview
The MonsterInsights eCommerce addon enables enhanced eCommerce tracking for popular eCommerce and membership platforms in WordPress. It allows MonsterInsights to automatically track and report on shopping behavior, including product impressions, clicks, detail views, cart actions, checkout process, and purchases in Google Analytics.

## Architecture

### Core Components

1. **Main Plugin Class** (`MonsterInsights_eCommerce`)
   - Handles plugin initialization and compatibility checks
   - Manages addon updates and licensing
   - Loads required provider integrations
   - Path: `ga-ecommerce.php` / `exactmetrics-ecommerce.php`

2. **Base Integration Class** (`MonsterInsights_Enhanced_eCommerce_Integration`)
   - Provides common functionality for all eCommerce integrations
   - Handles impression and event tracking
   - Manages JavaScript generation and output
   - Path: `includes/providers/ecommerce-integration.php`

3. **Platform-Specific Providers**
   - Individual implementation classes for each supported eCommerce platform
   - Implement platform-specific tracking hooks
   - Handle checkout and purchase tracking
   - Path: `includes/providers/{platform}.php`

4. **Helper Class** (`MonsterInsights_eCommerce_Helper`)
   - Contains utility methods used across different integrations
   - Handles test mode detection for various platforms
   - Provides helper functions for data formatting
   - Path: `includes/class-monsterinsights-ecommerce-helper.php`

### Directory Structure

```
monsterinsights-ecommerce/
├── languages/                # Translation files
├── includes/
│   ├── providers/            # Platform-specific integration classes
│   │   ├── woocommerce.php   # WooCommerce integration
│   │   ├── edd.php           # Easy Digital Downloads integration
│   │   ├── memberpress.php   # MemberPress integration
│   │   ├── lifterlms.php     # LifterLMS integration
│   │   ├── givewp.php        # GiveWP integration
│   │   └── ...               # Other platform integrations
│   ├── class-monsterinsights-ecommerce-helper.php  # Utility functions
│   └── compatibility-check.php                     # Version compatibility checks
├── index.php
├── ga-ecommerce.php          # Main plugin file for MonsterInsights
└── exactmetrics-ecommerce.php # Main plugin file for ExactMetrics
```

## Implementation Details

### Version Management
- Current Version: 8.5.5
- Requires WordPress: 5.6.0+
- Requires PHP: 7.2+
- Requires MonsterInsights Pro: 8.8.0+

### Initialization Flow
1. Plugin loads and performs compatibility checks
2. Registers with MonsterInsights updater system
3. Initializes on `monsterinsights_load_plugins` action
4. Checks for active eCommerce platforms
5. Loads platform-specific integrations
6. Deactivates conflicting plugins on activation

### Supported Platforms
The addon provides tracking for the following platforms:

1. **WooCommerce** - Full eCommerce funnel tracking
2. **Easy Digital Downloads** - Digital product sales tracking
3. **MemberPress** - Membership subscriptions
4. **LifterLMS** - Learning management system
5. **Restrict Content Pro** - Membership and content restriction
6. **GiveWP** - Donation platform
7. **MemberMouse** - Membership management
8. **WishList Member** - Membership platform
9. **Charitable** - Donation management
10. **Easy Affiliate** - Affiliate tracking

### Tracking Features
The addon tracks the following Enhanced eCommerce events in Google Analytics:

1. **Product Impressions** - When products are viewed in lists
2. **Product Clicks** - When products are clicked in lists
3. **Product Detail Views** - When a product detail page is viewed
4. **Add to Cart** - When products are added to cart
5. **Remove from Cart** - When products are removed from cart
6. **Begin Checkout** - When the checkout process is started
7. **Purchase** - When an order is completed
8. **Refund** - When an order is refunded (full or partial)

## Development Guidelines

### Customization Points

#### Filters
- `monsterinsights_ecommerce_track_test_payments` - Control whether to track test/sandbox transactions (default: false)
- `monsterinsights_track_woocommerce` - Toggle WooCommerce integration (default: true)
- `monsterinsights_track_edd` - Toggle Easy Digital Downloads integration (default: true)
- `monsterinsights_track_memberpress` - Toggle MemberPress integration (default: true)
- `monsterinsights_track_lifterlms` - Toggle LifterLMS integration (default: true)
- `monsterinsights_track_givewp` - Toggle GiveWP integration (default: true)
- `monsterinsights_track_rcp` - Toggle Restrict Content Pro integration (default: true)
- `monsterinsights_track_mm` - Toggle MemberMouse integration (default: true)
- `monsterinsights_track_charitable` - Toggle Charitable integration (default: true)

#### Integration Points
Each platform integration uses specific hooks from the platform to integrate tracking. For example:
- WooCommerce: `woocommerce_add_to_cart`, `woocommerce_before_cart_item_quantity_zero`
- EDD: `edd_post_add_to_cart`, `edd_complete_purchase`
- MemberPress: `mepr-txn-status-complete`, `mepr-event-transaction-completed`

### Key Files
- `ga-ecommerce.php` - Main plugin file that initializes the addon
- `includes/class-monsterinsights-ecommerce-helper.php` - Utility functions for eCommerce tracking
- `includes/providers/ecommerce-integration.php` - Base integration class with common functionality
- `includes/providers/woocommerce.php` - WooCommerce integration implementation
- `includes/providers/edd.php` - Easy Digital Downloads integration
- `includes/providers/memberpress.php` - MemberPress integration
- `includes/providers/lifterlms.php` - LifterLMS integration
- `includes/providers/givewp.php` - GiveWP integration
- `includes/providers/charitable.php` - Charitable integration

## Troubleshooting

### Known Issues & Workarounds

1. **Test Mode Transactions**: By default, transactions in test/sandbox mode are not tracked. This behavior can be overridden with the `monsterinsights_ecommerce_track_test_payments` filter.
   - Workaround: Add `add_filter('monsterinsights_ecommerce_track_test_payments', '__return_true');` to track test transactions

2. **Duplicate Tracking**: The addon automatically deactivates conflicting WooCommerce Google Analytics integrations to prevent duplicate tracking.
   - Workaround: Check for and manually deactivate other GA tracking plugins if duplicates appear

3. **Payment Gateway Redirects**: Special handling is implemented for external payment gateways (like PayPal) to maintain tracking through redirects.
   - Workaround: For custom payment gateways, implement the `woocommerce_get_return_url` filter

4. **Variable Products**: Additional logic is needed to properly track variable products with their variations.
   - Workaround: For custom product types, follow the pattern in woocommerce.php for variation handling

5. **Custom Thank You Pages**: If a store uses custom thank you pages, additional configuration might be needed.
   - Workaround: Use the `monsterinsights_ecommerce_include_purchase_event` hook to add tracking to custom pages

## Integration Points

### MonsterInsights Core
- Hooks into `monsterinsights_load_plugins` for initialization
- Uses MonsterInsights licensing and update system
- Leverages MonsterInsights tracking infrastructure
- Integrates with MonsterInsights frontend tracking options

### WordPress
- Uses WordPress hooks and filters system
- Integrates with WordPress plugin update mechanism
- Follows WordPress coding standards
- Handles multi-site compatibility

### Third-Party Platforms
- Integrates with multiple eCommerce and membership platforms
- Handles platform-specific data structures and events
- Manages compatibility across platform versions
- Provides platform-specific filters for customization

## Best Practices

1. **Test Mode Detection**
   - The addon implements comprehensive test mode detection for each platform
   - Separate detection methods for each payment gateway
   - Configurable via filter to allow testing when needed

2. **Cross-Domain Tracking**
   - Special attention for platforms with external checkout flows
   - Parameter passing for maintaining tracking across domains
   - Enhanced link attribution for third-party gateways

3. **Performance Optimization**
   - JavaScript is batched and only loaded when necessary
   - Events are queued and processed efficiently
   - Conditional loading based on page context

4. **Tracking Configuration**
   - Automatic handling of both Universal Analytics (UA) and Google Analytics 4 (GA4)
   - Dual tracking support for transition periods
   - Consistent data structure across platforms

5. **Platform-Specific Considerations**
   - WooCommerce: Detailed funnel tracking from product view to purchase
   - Easy Digital Downloads: Digital-specific attribution models
   - Membership platforms: Recurring payment tracking
   - Donation platforms: Campaign attribution

## Related Documentation
* [MonsterInsights Core](../../monsterinsights/Internal-Readme.md) - Main plugin architecture
* [MonsterInsights Forms](../../monsterinsights-forms/Internal-Readme.md) - Form tracking integration 