<?php
/**
 * Plugin Name: Fluent Forms - ReCAPTCHA Terms Links
 * Description: Adds a custom field type to Fluent Forms that displays Google reCAPTCHA terms and privacy policy links.
 * Version: 1.0.0
 * Author: Billy Moon
 * License: GPL v2 or later
 */

if (!defined('ABSPATH')) {
    exit;
}

class FF_ReCaptcha_Terms_Field {

    public function __construct() {
        add_filter('fluentform/editor_components', [$this, 'addComponent']);
        add_filter('fluentform/editor_element_settings_placement', [$this, 'addElementSettings']);
        add_filter('fluentform/editor_element_search_tags', [$this, 'addSearchTags'], 10, 2);
        add_action('fluentform/render_item_recaptcha_terms', [$this, 'renderField'], 10, 2);
    }

    public function addComponent($components) {
        $components['advanced'][] = [
            'index'          => 20,
            'element'        => 'recaptcha_terms',
            'attributes'     => [],
            'settings'       => [
                'container_class'    => '',
                'conditional_logics' => [],
            ],
            'editor_options' => [
                'title'      => 'ReCAPTCHA Terms Links',
                'icon_class' => 'ff-edit-html',
                'template'   => 'customHTML'
            ],
        ];

        return $components;
    }

    public function addElementSettings($placements) {
        $placements['recaptcha_terms'] = [
            'general' => [
                'container_class',
            ],
            'advanced' => [
                'conditional_logics',
            ],
        ];

        return $placements;
    }

    public function addSearchTags($tags, $form) {
        $tags['recaptcha_terms'] = ['recaptcha', 'terms', 'google', 'privacy', 'policy', 'captcha'];
        return $tags;
    }

    public function renderField($item, $form) {
        $containerClass = 'ff-el-group ff-recaptcha-terms';
        if (!empty($item['settings']['container_class'])) {
            $containerClass .= ' ' . esc_attr($item['settings']['container_class']);
        }

        echo '<div class="' . esc_attr($containerClass) . '">';
        echo '<p>This site is protected by reCAPTCHA and the Google
            <a id="google-link-pp" href="https://policies.google.com/privacy">Privacy Policy</a> and
            <a id="google-link-tos" href="https://policies.google.com/terms">Terms of Service</a> apply.</p>';
        echo '<style>#google-link-pp,#google-link-tos{text-decoration:underline;font-weight:bold;}#google-link-pp:hover,#google-link-tos:hover{text-decoration:none;}</style>';
        echo '</div>';
    }
}

// Initialize when Fluent Forms is ready
add_action('plugins_loaded', function () {
    if (defined('FLUENTFORM')) {
        new FF_ReCaptcha_Terms_Field();
    }
}, 20);
