<?php

/**
 * Add all ajax hooks
 */

use FluentForm\App\Modules\Acl\Acl;

/**
 * App instance
 *
 * @var $app \FluentForm\Framework\Foundation\Application
 */

$app->addAction('wp_ajax_nopriv_fluentform_submit', function () use ($app) {
    (new \FluentForm\App\Modules\SubmissionHandler\SubmissionHandler($app))->submit();
});

$app->addAction('wp_ajax_fluentform_submit', function () use ($app) {
    //    (new \FluentForm\App\Modules\Form\FormHandler($app))->onSubmit();
    (new \FluentForm\App\Modules\SubmissionHandler\SubmissionHandler($app))->submit();
});

/*
 * We are using this ajax call for updating form fields
 * REST API seems not working for some servers with Mod Security Enabled
 */
$app->addAction('wp_ajax_fluentform-form-update', function () use ($app) {
    Acl::verify('fluentform_forms_manager', $app->request->get('form_id'));
    try {
        $data = $app->request->all();
        $isValidJson = (!empty($data['formFields'])) && json_decode($data['formFields'], true);

        if(!$isValidJson) {
            wp_send_json([
                'message' => 'Looks like the provided JSON is invalid. Please try again or contact support',
                'reason' => 'formFields JSON validation failed'
            ], 422);
        }

        $formService = new \FluentForm\App\Services\Form\FormService();
        $form = $formService->update($data);
        wp_send_json([
            'message' => __('The form is successfully updated.', 'fluentform')
        ], 200);
    } catch (\Exception $exception) {
        wp_send_json([
            'message' => $exception->getMessage(),
        ], 422);
    }
});

/*
 * This ajax endpoint is used to update form general settings
 * Mod-Security also block this request
 */
$app->addAction('wp_ajax_fluentform-save-settings-general-formSettings', function () use ($app) {
    Acl::verify('fluentform_forms_manager');
    try {
        $settingsService = new \FluentForm\App\Services\Settings\SettingsService();
        $settingsService->saveGeneral($app->request->all());
        wp_send_json([
            'message' => __('Settings has been saved.', 'fluentform'),
        ]);
    } catch (\FluentForm\Framework\Validator\ValidationException $exception) {
        wp_send_json($exception->errors(), 422);
    }
});

/*
 * This ajax endpoint is used to update form email notifications settings
 * Mod-Security also block this request
 */
$app->addAction('wp_ajax_fluentform-save-form-email-notification', function () use ($app) {
    Acl::verify('fluentform_forms_manager');
    try {
        $settingsService = new \FluentForm\App\Services\Settings\SettingsService();
        [$settingsId, $settings] = $settingsService->store($app->request->all());

        wp_send_json([
            'message'  => __('Settings has been saved.', 'fluentform'),
            'id'       => $settingsId,
            'settings' => $settings,
        ]);
    } catch (\FluentForm\Framework\Validator\ValidationException $exception) {
        wp_send_json($exception->errors(), 422);
    }
});


$app->addAction('wp_ajax_fluentform-forms', function () use ($app) {
    dd('wp_ajax_fluentform-forms');
    Acl::verify('fluentform_dashboard_access');
    (new \FluentForm\App\Modules\Form\Form($app))->index();
});

$app->addAction('wp_ajax_fluentform-form-store', function () use ($app) {
    dd('wp_ajax_fluentform-form-store');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Form($app))->store();
});

$app->addAction('wp_ajax_fluentform-form-find', function () use ($app) {
    //No usage found
    Acl::verify('fluentform_dashboard_access');
    (new \FluentForm\App\Modules\Form\Form($app))->find();
});

$app->addAction('wp_ajax_fluentform-form-delete', function () use ($app) {
    dd('wp_ajax_fluentform-form-delete');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Form($app))->delete();
});

$app->addAction('wp_ajax_fluentform-form-duplicate', function () use ($app) {
    dd('wp_ajax_fluentform-form-duplicate');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Form($app))->duplicate();
});
$app->addAdminAjaxAction('fluentform-form-find-shortcode-locations', function () use ($app) {
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Form($app))->findFormLocations();
});

$app->addAction('wp_ajax_fluentform-convert-to-conversational', function () use ($app) {
    dd('wp_ajax_fluentform-convert-to-conversational');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Form($app))->convertToConversational();
});


$app->addAction('wp_ajax_fluentform-form-inputs', function () use ($app) {
    dd('wp_ajax_fluentform-form-inputs');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Inputs($app))->index();
});

$app->addAction('wp_ajax_fluentform-load-editor-shortcodes', function () use ($app) {
    dd('wp_ajax_fluentform-load-editor-shortcodes');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Component\Component($app))->getEditorShortcodes();
});

$app->addAction('wp_ajax_fluentform-load-all-editor-shortcodes', function () use ($app) {
    dd('wp_ajax_fluentform-load-all-editor-shortcodes');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Component\Component($app))->getAllEditorShortcodes();
});

$app->addAction('wp_ajax_fluentform-settings-formSettings', function () use ($app) {
    dd('wp_ajax_fluentform-settings-formSettings');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\FormSettings($app))->index();
});

$app->addAction('wp_ajax_fluentform-settings-general-formSettings', function () use ($app) {
    dd('wp_ajax_fluentform-settings-general-formSettings');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\FormSettings($app))->getGeneralSettingsAjax();
});

$app->addAction('wp_ajax_fluentform-settings-formSettings-store', function () use ($app) {
    dd('wp_ajax_fluentform-settings-formSettings-store');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\FormSettings($app))->store();
});

$app->addAction('wp_ajax_fluentform-settings-formSettings-remove', function () use ($app) {
    dd('wp_ajax_fluentform-settings-formSettings-remove');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\FormSettings($app))->remove();
});

$app->addAction('wp_ajax_fluentform-get-form-custom_css_js', function () {
    dd('wp_ajax_fluentform-get-form-custom_css_js');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\FormCssJs())->getSettingsAjax();
});

$app->addAction('wp_ajax_fluentform-save-form-custom_css_js', function () {
    dd('wp_ajax_fluentform-save-form-custom_css_js');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\FormCssJs())->saveSettingsAjax();
});

$app->addAction('wp_ajax_fluentform-save-form-entry_column_view_settings', function () {
    dd('wp_ajax_fluentform-save-form-entry_column_view_settings');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\EntryColumnViewSettings())->saveVisibleColumnsAjax();
});

$app->addAction('wp_ajax_fluentform-save-form-entry_column_order_settings', function () {
    dd('wp_ajax_fluentform-save-form-entry_column_order_settings');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\EntryColumnViewSettings())->saveEntryColumnsOrderAjax();
});

$app->addAction('wp_ajax_fluentform-reset-form-entry_column_order_settings', function () {
    dd('wp_ajax_fluentform-reset-form-entry_column_order_settings');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Form\Settings\EntryColumnViewSettings())->resetEntryDisplaySettings();
});

$app->addAction('wp_ajax_fluentform-load-editor-components', function () use ($app) {
    dd('wp_ajax_fluentform-load-editor-components');
    Acl::verify('fluentform_forms_manager');
    (new \FluentForm\App\Modules\Component\Component($app))->index();
});



$app->addAction('wp_ajax_fluentform-form-entries-export', function () use ($app) {
    Acl::verify('fluentform_entries_viewer');
    (new \FluentForm\App\Modules\Transfer\Transfer())->exportEntries();
});

$app->addAction('wp_ajax_fluentform-update-entry-user', function () use ($app) {
    Acl::verify('fluentform_entries_viewer');
    $userId = intval($app->request->get('user_id'));
    $submissionId = intval($app->request->get('submission_id'));
    try {
        $result = (new \FluentForm\App\Services\Submission\SubmissionService())->updateSubmissionUser($userId, $submissionId);
        wp_send_json_success($result);
    } catch (\Exception $e) {
        wp_send_json_error(['message' => $e->getMessage()], 423);
    }
});

$app->addAction('wp_ajax_fluentform-get-users', function () use ($app) {
    Acl::verify('fluentform_entries_viewer');
    $search = sanitize_text_field($app->request->get('search'));
    $users = get_users([
        'search' => "*{$search}*",
        'number' => 50,
    ]);
    $formattedUsers = [];
    foreach ($users as $user) {
        $formattedUsers[] = [
            'ID'    => $user->ID,
            'label' => $user->display_name . ' - ' . $user->user_email,
        ];
    }
    wp_send_json_success(['users' => $formattedUsers]);
});


$app->addAction('wp_ajax_fluentform-get-entry-logs', function () use ($app) {
    dd('wp_ajax_fluentform-get-entry-logs');
    Acl::verify('fluentform_entries_viewer');
    $entry_id = intval($app->request->get('entry_id'));
    $logType = sanitize_text_field($app->request->get('log_type'));
    (new \FluentForm\App\Modules\Logger\DataLogger($app))->getLogsByEntry($entry_id, $logType);
});

$app->addAction('wp_ajax_fluentform_get_activity_log_filters', function () use ($app) {
    dd('wp_ajax_fluentform_get_activity_log_filters');
    Acl::verify('fluentform_entries_viewer');
    (new \FluentForm\App\Modules\Logger\DataLogger($app))->getLogFilters();
});

$app->addAction('wp_ajax_fluentform_get_activity_api_log_filters', function () use ($app) {
    dd('wp_ajax_fluentform_get_activity_api_log_filters');
    Acl::verify('fluentform_entries_viewer');
    (new \FluentForm\App\Modules\Logger\DataLogger($app))->getApiLogFilters();
});

$app->addAction('wp_ajax_fluentform_get_all_logs', function () use ($app) {
    dd('wp_ajax_fluentform_get_all_logs');
    Acl::verify('fluentform_entries_viewer');
    (new \FluentForm\App\Modules\Logger\DataLogger($app))->getAllLogs();
});

$app->addAction('wp_ajax_fluentform_get_api_logs', function () use ($app) {
    dd('wp_ajax_fluentform_get_api_logs');
    Acl::verify('fluentform_entries_viewer');
    (new \FluentForm\App\Modules\Logger\DataLogger($app))->getApiLogs();
});

$app->addAction('wp_ajax_fluentform_retry_api_action', function () use ($app) {
    // No usage found
    Acl::verify('fluentform_entries_viewer');
    (new \FluentForm\App\Modules\Logger\DataLogger($app))->retryApiAction();
});

$app->addAction('wp_ajax_fluentform_delete_logs_by_ids', function () use ($app) {
    dd('wp_ajax_fluentform_delete_logs_by_ids');
    Acl::verify('fluentform_manage_entries');
    (new \FluentForm\App\Modules\Logger\DataLogger($app))->deleteLogsByIds();
});

$app->addAction('wp_ajax_fluentform_delete_api_logs_by_ids', function () use ($app) {
    dd('wp_ajax_fluentform_delete_api_logs_by_ids');
    Acl::verify('fluentform_manage_entries');
    (new \FluentForm\App\Modules\Logger\DataLogger($app))->deleteApiLogsByIds();
});

$app->addAction('wp_ajax_fluentform-change-entry-status', function () use ($app) {
    Acl::verify('fluentform_manage_entries');
    $attributes = [
        'entry_id' => intval($app->request->get('entry_id')),
        'status'   => sanitize_text_field($app->request->get('status')),
    ];
    $newStatus = (new \FluentForm\App\Services\Submission\SubmissionService())->updateStatus($attributes);
    wp_send_json_success([
        'message' => sprintf(__('Item has been marked as %s', 'fluentform'), $newStatus),
        'status'  => $newStatus,
    ], 200);
});


$app->addAction('wp_ajax_fluentform_notice_action_track_yes', function () {
    Acl::hasAnyFormPermission();
    (new FluentForm\App\Modules\Track\TrackModule())->sendInitialInfo();
});

$app->addAction('wp_ajax_fluentform_install_fluentsmtp', function () {
    Acl::verify('fluentform_settings_manager');
    (new FluentForm\App\Modules\Track\SetupModule())->installPlugin('fluent-smtp');
});

// Export forms
$app->addAction('wp_ajax_fluentform-export-forms', function () use ($app) {
    Acl::verify('fluentform_settings_manager', $app->request->get('forms'));
    (new \FluentForm\App\Modules\Transfer\Transfer())->exportForms();
});

// Import forms
$app->addAction('wp_ajax_fluentform-import-forms', function () use ($app) {
    Acl::verify('fluentform_settings_manager');
    (new \FluentForm\App\Modules\Transfer\Transfer())->importForms();
});

/*
 * Background Process Receiver
 */

$app->addAction('wp_ajax_fluentform_background_process', function () {
    $this->app['fluentFormAsyncRequest']->handleBackgroundCall();
});

$app->addAction('wp_ajax_nopriv_fluentform_background_process', function () {
    $this->app['fluentFormAsyncRequest']->handleBackgroundCall();
});

/*
 * For REST API Nonce Renewal
 */
$app->addAction('wp_ajax_fluentform_renew_rest_nonce', function () {
    if (!Acl::getCurrentUserPermissions()) {
        wp_send_json([
            'error' => 'You do not have permission to do this',
        ], 403);
    }
    
    wp_send_json([
        'nonce' => wp_create_nonce('wp_rest'),
    ], 200);
});
/*
 * For selectGroup Component Grouped Options
 * Use this filter to pass data to component
 */

add_action('wp_ajax_fluentform_select_group_ajax_data', function () {
    Acl::verify('fluentform_dashboard_access');
    $requestData = wpFluentForm('request')->all();
    $ajaxList = apply_filters('fluentform/select_group_component_ajax_options', [], $requestData);
    wp_send_json_success($ajaxList);
});
