<?php

namespace FluentForm\App\Modules\Registerer;

use FluentForm\App\Models\Form;
use FluentForm\App\Helpers\Helper;
use FluentForm\App\Http\Controllers\AdminNoticeController;

class ReviewQuery
{
    public static function register()
    {
        if (static::shouldRegister()) {
            add_action('fluentform/global_menu', [static::class, 'show'], 99);
        }
    }

    protected static function shouldRegister()
    {
        if (Helper::isFluentAdminPage() && !wp_doing_ajax()) {
            return Form::count() > 3;
        }

        return false;
    }

    public static function show()
    {
        $notice = new AdminNoticeController();
        $msg = static::getMessage();
        $notice->addNotice($msg);
        $notice->showNotice();
    }

    private static function getMessage()
    {
        return [
            'name'    => 'review_query',
            'title'   => '',
            'message' => sprintf('Thank you for using Fluent Forms. We would greatly appreciate it if you could share your experience and leave a review for us on %s. Your review inspires us to keep improving the plugin and delivering a better user experience.',
                '<a target="_blank" href="https://wordpress.org/support/plugin/fluentform/reviews/#new-post">WordPress.org</a>'),
            'links' => [
                [
                    'href'     => 'https://wordpress.org/support/plugin/fluentform/reviews/#new-post',
                    'btn_text' => 'Yes',
                    'btn_atts' => 'class="mr-1 el-button--success el-button--mini ff_review_now" data-notice_name="review_query"',
                ],
                [
                    'href'     => admin_url('admin.php?page=fluent_forms'),
                    'btn_text' => 'Maybe Later',
                    'btn_atts' => 'class="mr-1 el-button--info el-button--soft el-button--mini ff_nag_cross" data-notice_type="temp" data-notice_name="review_query"',
                ],
                [
                    'href'     => admin_url('admin.php?page=fluent_forms'),
                    'btn_text' => 'Do not show again',
                    'btn_atts' => 'class="text-button el-button--mini ff_nag_cross" data-notice_type="permanent" data-notice_name="review_query"',
                ],
            ],
        ];
    }
}
