<?php

/**
 * element_settings_placement
 *
 * Returns an array of countries and codes.
 *
 * @author      WooThemes
 *
 * @category    i18n
 * @package     fluentform/i18n
 *
 * @version     2.5.0
 */

return [
    'input_name' => [
        'general' => [
            'admin_field_label',
            'name_fields',
            'label_placement',
        ],
        'advanced' => [
            'container_class',
            'name',
            'conditional_logics',
        ],
    ],
    'input_email' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'validation_rules',
        ],
        'advanced' => [
            'value',
            'container_class',
            'class',
            'help_message',
            'is_unique',
            'unique_validation_message',
            'prefix_label',
            'suffix_label',
            'name',
            'conditional_logics',
        ],
    ],
    'input_text' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'temp_mask',
            'data-mask',
            'data-mask-reverse',
            'data-clear-if-not-match',
            'validation_rules',
        ],
        'advanced' => [
            'value',
            'container_class',
            'class',
            'help_message',
            'prefix_label',
            'suffix_label',
            'name',
            'maxlength',
            'is_unique',
            'unique_validation_message',
            'conditional_logics',
        ],
        'generalExtras'  => [],
        'advancedExtras' => [],
    ],
    'textarea' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'rows',
            'cols',
            'validation_rules',
        ],
        'advanced' => [
            'value',
            'container_class',
            'class',
            'help_message',
            'name',
            'maxlength',
            'conditional_logics',
        ],
    ],
    'address' => [
        'general' => [
            'label',
            'admin_field_label',
            'address_fields',
        ],
        'advanced' => [
            'class',
            'name',
            'conditional_logics',
        ],
    ],
    'select_country' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'enable_select_2',
            'placeholder',
            'validation_rules',
        ],
        'advanced' => [
            'container_class',
            'class',
            'country_list',
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'input_number' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'validation_rules',
            'numeric_formatter',
            'mobile_keyboard_type',
        ],
        'advanced' => [
            'value',
            'container_class',
            'class',
            'help_message',
            'number_step',
            'prefix_label',
            'suffix_label',
            'name',
            'conditional_logics',
            'calculation_settings',
        ],
    ],
    'select' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'advanced_options',
            'randomize_options',
            'enable_select_2',
            'max_selection',
            'validation_rules',
        ],
        'advanced' => [
            'dynamic_default_value',
            'container_class',
            'class',
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'input_radio' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'advanced_options',
            'layout_class',
            'randomize_options',
            'validation_rules',
        ],
        'advanced' => [
            'dynamic_default_value',
            'container_class',
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'input_checkbox' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'advanced_options',
            'layout_class',
            'randomize_options',
            'validation_rules',
        ],
        'advanced' => [
            'dynamic_default_value',
            'container_class',
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'input_url' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'validation_rules',
        ],
        'advanced' => [
            'value',
            'container_class',
            'class',
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'input_password' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'validation_rules',
        ],
        'advanced' => [
            'value',
            'container_class',
            'class',
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'input_date' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'placeholder',
            'date_format',
            'validation_rules',
        ],
        'advanced' => [
            'value',
            'container_class',
            'class',
            'help_message',
            'name',
            'date_config',
            'conditional_logics',
        ],
    ],
    'input_file' => [
        'general' => [
            'label',
            'btn_text',
            'upload_bttn_ui',
            'label_placement',
            'admin_field_label',
            'validation_rules',
        ],
        'advanced' => [
            'container_class',
            'class',
            'help_message',
            'name',
            'conditional_logics',
            'file_location_type',
            'upload_file_location',
        ],
    ],
    'input_image' => [
        'general' => [
            'label',
            'btn_text',
            'upload_bttn_ui',
            'label_placement',
            'admin_field_label',
            'validation_rules',
            'file_location_type',
            'upload_file_location',
        ],
        'advanced' => [
            'container_class',
            'class',
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'input_repeat' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'multi_column',
            'repeat_fields',
        ],
        'advanced' => [
            'container_class',
            'name',
            'conditional_logics',
            'max_repeat_field',
        ],
    ],
    'input_hidden' => [
        'general' => [
            'admin_field_label',
            'value',
            'name',
        ],
    ],
    'section_break' => [
        'general' => [
            'label',
            'description',
            'align',
        ],
        'advanced' => [
            'class',
            'conditional_logics',
        ],
    ],
    'recaptcha' => [
        'general' => [
            'label',
            'label_placement',
            'name',
            'validation_rules',
        ],
    ],
    'hcaptcha' => [
        'general' => [
            'label',
            'label_placement',
            'name',
            'validation_rules',
        ],
    ],
    'turnstile' => [
        'general' => [
            'label',
            'label_placement',
            'name',
            'validation_rules'
        ],
    ],
    'custom_html' => [
        'general' => [
            'html_codes',
            'conditional_logics',
            'container_class',
        ],
    ],
    'shortcode' => [
        'general' => [
            'shortcode',
        ],
        'generalExtras' => [
            'message' => [
                'template' => 'infoBlock',
                'text'     => 'Hello',
            ],
        ],
        'advanced' => [
            'class',
            'conditional_logics',
        ],
    ],
    'terms_and_condition' => [
        'general' => [
            'admin_field_label',
            'validation_rules',
            'tnc_html',
            'has_checkbox',
        ],
        'advanced' => [
            'container_class',
            'class',
            'name',
            'conditional_logics',
        ],
    ],
    'action_hook' => [
        'general' => [
            'hook_name',
        ],
        'advanced' => [
            'class',
            'conditional_logics',
        ],
    ],
    'form_step' => [
        'general' => [
            'prev_btn',
            'next_btn',
            'class',
        ],
    ],
    'button' => [
        'general' => [
            'btn_text',
            'button_ui',
            'button_style',
            'button_size',
            'align',
        ],
        'advanced' => [
            'container_class',
            'class',
            'help_message',
            'conditional_logics',
        ],
        'generalExtras' => [
            'btn_text' => [
                'template'  => 'inputText',
                'label'     => __('Button Text', 'fluentform'),
                'help_text' => __('Form submission button text.', 'fluentform'),
            ],
        ],
    ],
    'step_start' => [
        'general' => [
            'class',
            'progress_indicator',
            'step_animation',
            'step_titles',
            'disable_auto_focus',
            'enable_auto_slider',
            'enable_step_data_persistency',
            'enable_step_page_resume',
        ],
    ],
    'step_end' => [
        'general' => [
            'class',
            'prev_btn',
        ],
    ],
    'ratings' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'options',
            'show_text',
            'validation_rules',
        ],
        'advanced' => [
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'tabular_grid' => [
        'general' => [
            'label',
            'label_placement',
            'admin_field_label',
            'tabular_field_type',
            'grid_columns',
            'grid_rows',
            'validation_rules',
        ],
        'advanced' => [
            'container_class',
            'help_message',
            'name',
            'conditional_logics',
        ],
    ],
    'gdpr_agreement' => [
        'general' => [
            'admin_field_label',
            'tnc_html',
            'required_field_message',
            'container_class',
        ],
        'advanced' => [
            'class',
            'name',
            'conditional_logics',
        ],
        'generalExtras' => [
            'tnc_html' => [
                'template'  => 'inputTextarea',
                'label'     => __('Description', 'fluentform'),
                'help_text' => __('Write HTML content for GDPR agreement checkbox', 'fluentform'),
                'rows'      => 5,
                'cols'      => 3,
            ],
        ],
    ],
    'container' => [
        'general' => [
            'container_class',
            'conditional_logics',
            'container_width',
        ],
        'advanced' => [],
    ],
];
