<?php
/**
 * States
 *
 * Returns an array of country states. This deprecates and replaces the /states/ directory found in older versions.
 *
 * States should be defined in English and translated native through localisation files.
 *
 * Country codes and states (or province) names should follow the Unicode CLDR recommendation (https://cldr.unicode.org/translation/displaynames/countryregion-territory-names).
 *
 * Countries defined with empty arrays have no states. These should also be defined in class-wc-countries.php to mark the state field as not required and hidden.
 *
 * @version 1.0.0
 */

defined('ABSPATH') || exit;

return array(
    'AF' => [
        'AF-BDS' => __('Badakhshan', 'fluent-cart'),
        'AF-BDG' => __('Badghis', 'fluent-cart'),
        'AF-BGL' => __('Baghlan', 'fluent-cart'),
        'AF-BAL' => __('Balkh', 'fluent-cart'),
        'AF-BAM' => __('Bamyan', 'fluent-cart'),
        'AF-DAY' => __('Daykundi', 'fluent-cart'),
        'AF-FRA' => __('Farah', 'fluent-cart'),
        'AF-FYB' => __('Faryab', 'fluent-cart'),
        'AF-GHA' => __('Ghazni', 'fluent-cart'),
        'AF-GHO' => __('Ghor', 'fluent-cart'),
        'AF-HEL' => __('Helmand', 'fluent-cart'),
        'AF-HER' => __('Herat', 'fluent-cart'),
        'AF-JOW' => __('Jowzjan', 'fluent-cart'),
        'AF-KAB' => __('Kabul', 'fluent-cart'),
        'AF-KAN' => __('Kandahar', 'fluent-cart'),
        'AF-KAP' => __('Kapisa', 'fluent-cart'),
        'AF-KHO' => __('Khost', 'fluent-cart'),
        'AF-KNR' => __('Kunar', 'fluent-cart'),
        'AF-KDZ' => __('Kunduz', 'fluent-cart'),
        'AF-LAG' => __('Laghman', 'fluent-cart'),
        'AF-LOG' => __('Logar', 'fluent-cart'),
        'AF-NAN' => __('Nangarhar', 'fluent-cart'),
        'AF-NIM' => __('Nimruz', 'fluent-cart'),
        'AF-NUR' => __('Nuristan', 'fluent-cart'),
        'AF-PIA' => __('Paktia', 'fluent-cart'),
        'AF-PKA' => __('Paktika', 'fluent-cart'),
        'AF-PAN' => __('Panjshir', 'fluent-cart'),
        'AF-PAR' => __('Parwan', 'fluent-cart'),
        'AF-SAM' => __('Samangan', 'fluent-cart'),
        'AF-SAR' => __('Sar-e Pol', 'fluent-cart'),
        'AF-TAK' => __('Takhar', 'fluent-cart'),
        'AF-URU' => __('Uruzgan', 'fluent-cart'),
        'AF-WAR' => __('Wardak', 'fluent-cart'),
        'AF-ZAB' => __('Zabul', 'fluent-cart'),
    ],
    'AL' => array( // Albanian states.
        'AL-01' => __('Berat', 'fluent-cart'),
        'AL-09' => __('Dibër', 'fluent-cart'),
        'AL-02' => __('Durrës', 'fluent-cart'),
        'AL-03' => __('Elbasan', 'fluent-cart'),
        'AL-04' => __('Fier', 'fluent-cart'),
        'AL-05' => __('Gjirokastër', 'fluent-cart'),
        'AL-06' => __('Korçë', 'fluent-cart'),
        'AL-07' => __('Kukës', 'fluent-cart'),
        'AL-08' => __('Lezhë', 'fluent-cart'),
        'AL-10' => __('Shkodër', 'fluent-cart'),
        'AL-11' => __('Tirana', 'fluent-cart'),
        'AL-12' => __('Vlorë', 'fluent-cart'),
    ),
    'AO' => array( // Angolan states.
        'BGO' => __('Bengo', 'fluent-cart'),
        'BLU' => __('Benguela', 'fluent-cart'),
        'BIE' => __('Bié', 'fluent-cart'),
        'CAB' => __('Cabinda', 'fluent-cart'),
        'CNN' => __('Cunene', 'fluent-cart'),
        'HUA' => __('Huambo', 'fluent-cart'),
        'HUI' => __('Huíla', 'fluent-cart'),
        'CCU' => __('Kuando Kubango', 'fluent-cart'),
        'CNO' => __('Kwanza-Norte', 'fluent-cart'),
        'CUS' => __('Kwanza-Sul', 'fluent-cart'),
        'LUA' => __('Luanda', 'fluent-cart'),
        'LNO' => __('Lunda-Norte', 'fluent-cart'),
        'LSU' => __('Lunda-Sul', 'fluent-cart'),
        'MAL' => __('Malanje', 'fluent-cart'),
        'MOX' => __('Moxico', 'fluent-cart'),
        'NAM' => __('Namibe', 'fluent-cart'),
        'UIG' => __('Uíge', 'fluent-cart'),
        'ZAI' => __('Zaire', 'fluent-cart'),
    ),
    'AR' => array( // Argentinian provinces.
        'C' => __('Ciudad Autónoma de Buenos Aires', 'fluent-cart'),
        'B' => __('Buenos Aires', 'fluent-cart'),
        'K' => __('Catamarca', 'fluent-cart'),
        'H' => __('Chaco', 'fluent-cart'),
        'U' => __('Chubut', 'fluent-cart'),
        'X' => __('Córdoba', 'fluent-cart'),
        'W' => __('Corrientes', 'fluent-cart'),
        'E' => __('Entre Ríos', 'fluent-cart'),
        'P' => __('Formosa', 'fluent-cart'),
        'Y' => __('Jujuy', 'fluent-cart'),
        'L' => __('La Pampa', 'fluent-cart'),
        'F' => __('La Rioja', 'fluent-cart'),
        'M' => __('Mendoza', 'fluent-cart'),
        'N' => __('Misiones', 'fluent-cart'),
        'Q' => __('Neuquén', 'fluent-cart'),
        'R' => __('Río Negro', 'fluent-cart'),
        'A' => __('Salta', 'fluent-cart'),
        'J' => __('San Juan', 'fluent-cart'),
        'D' => __('San Luis', 'fluent-cart'),
        'Z' => __('Santa Cruz', 'fluent-cart'),
        'S' => __('Santa Fe', 'fluent-cart'),
        'G' => __('Santiago del Estero', 'fluent-cart'),
        'V' => __('Tierra del Fuego', 'fluent-cart'),
        'T' => __('Tucumán', 'fluent-cart'),
    ),
    'AT' => array(),
    'AU' => array( // Australian states.
        'ACT' => __('Australian Capital Territory', 'fluent-cart'),
        'NSW' => __('New South Wales', 'fluent-cart'),
        'NT' => __('Northern Territory', 'fluent-cart'),
        'QLD' => __('Queensland', 'fluent-cart'),
        'SA' => __('South Australia', 'fluent-cart'),
        'TAS' => __('Tasmania', 'fluent-cart'),
        'VIC' => __('Victoria', 'fluent-cart'),
        'WA' => __('Western Australia', 'fluent-cart'),
    ),
    'AX' => array(),
    'BD' => array( // Bangladeshi districts.
        'BD-05' => __('Bagerhat', 'fluent-cart'),
        'BD-01' => __('Bandarban', 'fluent-cart'),
        'BD-02' => __('Barguna', 'fluent-cart'),
        'BD-06' => __('Barishal', 'fluent-cart'),
        'BD-07' => __('Bhola', 'fluent-cart'),
        'BD-03' => __('Bogura', 'fluent-cart'),
        'BD-04' => __('Brahmanbaria', 'fluent-cart'),
        'BD-09' => __('Chandpur', 'fluent-cart'),
        'BD-10' => __('Chattogram', 'fluent-cart'),
        'BD-12' => __('Chuadanga', 'fluent-cart'),
        'BD-11' => __("Cox's Bazar", 'fluent-cart'),
        'BD-08' => __('Cumilla', 'fluent-cart'),
        'BD-13' => __('Dhaka', 'fluent-cart'),
        'BD-14' => __('Dinajpur', 'fluent-cart'),
        'BD-15' => __('Faridpur ', 'fluent-cart'),
        'BD-16' => __('Feni', 'fluent-cart'),
        'BD-19' => __('Gaibandha', 'fluent-cart'),
        'BD-18' => __('Gazipur', 'fluent-cart'),
        'BD-17' => __('Gopalganj', 'fluent-cart'),
        'BD-20' => __('Habiganj', 'fluent-cart'),
        'BD-21' => __('Jamalpur', 'fluent-cart'),
        'BD-22' => __('Jashore', 'fluent-cart'),
        'BD-25' => __('Jhalokati', 'fluent-cart'),
        'BD-23' => __('Jhenaidah', 'fluent-cart'),
        'BD-24' => __('Joypurhat', 'fluent-cart'),
        'BD-29' => __('Khagrachhari', 'fluent-cart'),
        'BD-27' => __('Khulna', 'fluent-cart'),
        'BD-26' => __('Kishoreganj', 'fluent-cart'),
        'BD-28' => __('Kurigram', 'fluent-cart'),
        'BD-30' => __('Kushtia', 'fluent-cart'),
        'BD-31' => __('Lakshmipur', 'fluent-cart'),
        'BD-32' => __('Lalmonirhat', 'fluent-cart'),
        'BD-36' => __('Madaripur', 'fluent-cart'),
        'BD-37' => __('Magura', 'fluent-cart'),
        'BD-33' => __('Manikganj ', 'fluent-cart'),
        'BD-39' => __('Meherpur', 'fluent-cart'),
        'BD-38' => __('Moulvibazar', 'fluent-cart'),
        'BD-35' => __('Munshiganj', 'fluent-cart'),
        'BD-34' => __('Mymensingh', 'fluent-cart'),
        'BD-48' => __('Naogaon', 'fluent-cart'),
        'BD-43' => __('Narail', 'fluent-cart'),
        'BD-40' => __('Narayanganj', 'fluent-cart'),
        'BD-42' => __('Narsingdi', 'fluent-cart'),
        'BD-44' => __('Natore', 'fluent-cart'),
        'BD-45' => __('Nawabganj', 'fluent-cart'),
        'BD-41' => __('Netrakona', 'fluent-cart'),
        'BD-46' => __('Nilphamari', 'fluent-cart'),
        'BD-47' => __('Noakhali', 'fluent-cart'),
        'BD-49' => __('Pabna', 'fluent-cart'),
        'BD-52' => __('Panchagarh', 'fluent-cart'),
        'BD-51' => __('Patuakhali', 'fluent-cart'),
        'BD-50' => __('Pirojpur', 'fluent-cart'),
        'BD-53' => __('Rajbari', 'fluent-cart'),
        'BD-54' => __('Rajshahi', 'fluent-cart'),
        'BD-56' => __('Rangamati', 'fluent-cart'),
        'BD-55' => __('Rangpur', 'fluent-cart'),
        'BD-58' => __('Satkhira', 'fluent-cart'),
        'BD-62' => __('Shariatpur', 'fluent-cart'),
        'BD-57' => __('Sherpur', 'fluent-cart'),
        'BD-59' => __('Sirajganj', 'fluent-cart'),
        'BD-61' => __('Sunamganj', 'fluent-cart'),
        'BD-60' => __('Sylhet', 'fluent-cart'),
        'BD-63' => __('Tangail', 'fluent-cart'),
        'BD-64' => __('Thakurgaon', 'fluent-cart'),
    ),
    'BE' => array(),
    'BG' => array( // Bulgarian states.
        'BG-01' => __('Blagoevgrad', 'fluent-cart'),
        'BG-02' => __('Burgas', 'fluent-cart'),
        'BG-08' => __('Dobrich', 'fluent-cart'),
        'BG-07' => __('Gabrovo', 'fluent-cart'),
        'BG-26' => __('Haskovo', 'fluent-cart'),
        'BG-09' => __('Kardzhali', 'fluent-cart'),
        'BG-10' => __('Kyustendil', 'fluent-cart'),
        'BG-11' => __('Lovech', 'fluent-cart'),
        'BG-12' => __('Montana', 'fluent-cart'),
        'BG-13' => __('Pazardzhik', 'fluent-cart'),
        'BG-14' => __('Pernik', 'fluent-cart'),
        'BG-15' => __('Pleven', 'fluent-cart'),
        'BG-16' => __('Plovdiv', 'fluent-cart'),
        'BG-17' => __('Razgrad', 'fluent-cart'),
        'BG-18' => __('Ruse', 'fluent-cart'),
        'BG-27' => __('Shumen', 'fluent-cart'),
        'BG-19' => __('Silistra', 'fluent-cart'),
        'BG-20' => __('Sliven', 'fluent-cart'),
        'BG-21' => __('Smolyan', 'fluent-cart'),
        'BG-23' => __('Sofia District', 'fluent-cart'),
        'BG-22' => __('Sofia', 'fluent-cart'),
        'BG-24' => __('Stara Zagora', 'fluent-cart'),
        'BG-25' => __('Targovishte', 'fluent-cart'),
        'BG-03' => __('Varna', 'fluent-cart'),
        'BG-04' => __('Veliko Tarnovo', 'fluent-cart'),
        'BG-05' => __('Vidin', 'fluent-cart'),
        'BG-06' => __('Vratsa', 'fluent-cart'),
        'BG-28' => __('Yambol', 'fluent-cart'),
    ),
    'BH' => array(),
    'BI' => array(),
    'BJ' => array( // Beninese states.
        'AL' => __('Alibori', 'fluent-cart'),
        'AK' => __('Atakora', 'fluent-cart'),
        'AQ' => __('Atlantique', 'fluent-cart'),
        'BO' => __('Borgou', 'fluent-cart'),
        'CO' => __('Collines', 'fluent-cart'),
        'KO' => __('Kouffo', 'fluent-cart'),
        'DO' => __('Donga', 'fluent-cart'),
        'LI' => __('Littoral', 'fluent-cart'),
        'MO' => __('Mono', 'fluent-cart'),
        'OU' => __('Ouémé', 'fluent-cart'),
        'PL' => __('Plateau', 'fluent-cart'),
        'ZO' => __('Zou', 'fluent-cart'),
    ),
    'BO' => array( // Bolivian states.
        'BO-B' => __('Beni', 'fluent-cart'),
        'BO-H' => __('Chuquisaca', 'fluent-cart'),
        'BO-C' => __('Cochabamba', 'fluent-cart'),
        'BO-L' => __('La Paz', 'fluent-cart'),
        'BO-O' => __('Oruro', 'fluent-cart'),
        'BO-N' => __('Pando', 'fluent-cart'),
        'BO-P' => __('Potosí', 'fluent-cart'),
        'BO-S' => __('Santa Cruz', 'fluent-cart'),
        'BO-T' => __('Tarija', 'fluent-cart'),
    ),
    'BR' => array( // Brazilian states.
        'AC' => __('Acre', 'fluent-cart'),
        'AL' => __('Alagoas', 'fluent-cart'),
        'AP' => __('Amapá', 'fluent-cart'),
        'AM' => __('Amazonas', 'fluent-cart'),
        'BA' => __('Bahia', 'fluent-cart'),
        'CE' => __('Ceará', 'fluent-cart'),
        'DF' => __('Distrito Federal', 'fluent-cart'),
        'ES' => __('Espírito Santo', 'fluent-cart'),
        'GO' => __('Goiás', 'fluent-cart'),
        'MA' => __('Maranhão', 'fluent-cart'),
        'MT' => __('Mato Grosso', 'fluent-cart'),
        'MS' => __('Mato Grosso do Sul', 'fluent-cart'),
        'MG' => __('Minas Gerais', 'fluent-cart'),
        'PA' => __('Pará', 'fluent-cart'),
        'PB' => __('Paraíba', 'fluent-cart'),
        'PR' => __('Paraná', 'fluent-cart'),
        'PE' => __('Pernambuco', 'fluent-cart'),
        'PI' => __('Piauí', 'fluent-cart'),
        'RJ' => __('Rio de Janeiro', 'fluent-cart'),
        'RN' => __('Rio Grande do Norte', 'fluent-cart'),
        'RS' => __('Rio Grande do Sul', 'fluent-cart'),
        'RO' => __('Rondônia', 'fluent-cart'),
        'RR' => __('Roraima', 'fluent-cart'),
        'SC' => __('Santa Catarina', 'fluent-cart'),
        'SP' => __('São Paulo', 'fluent-cart'),
        'SE' => __('Sergipe', 'fluent-cart'),
        'TO' => __('Tocantins', 'fluent-cart'),
    ),
    'CA' => array( // Canadian states.
        'AB' => __('Alberta', 'fluent-cart'),
        'BC' => __('British Columbia', 'fluent-cart'),
        'MB' => __('Manitoba', 'fluent-cart'),
        'NB' => __('New Brunswick', 'fluent-cart'),
        'NL' => __('Newfoundland and Labrador', 'fluent-cart'),
        'NT' => __('Northwest Territories', 'fluent-cart'),
        'NS' => __('Nova Scotia', 'fluent-cart'),
        'NU' => __('Nunavut', 'fluent-cart'),
        'ON' => __('Ontario', 'fluent-cart'),
        'PE' => __('Prince Edward Island', 'fluent-cart'),
        'QC' => __('Quebec', 'fluent-cart'),
        'SK' => __('Saskatchewan', 'fluent-cart'),
        'YT' => __('Yukon Territory', 'fluent-cart'),
    ),
    'CH' => array( // Swiss cantons.
        'AG' => __('Aargau', 'fluent-cart'),
        'AR' => __('Appenzell Ausserrhoden', 'fluent-cart'),
        'AI' => __('Appenzell Innerrhoden', 'fluent-cart'),
        'BL' => __('Basel-Landschaft', 'fluent-cart'),
        'BS' => __('Basel-Stadt', 'fluent-cart'),
        'BE' => __('Bern', 'fluent-cart'),
        'FR' => __('Fribourg', 'fluent-cart'),
        'GE' => __('Geneva', 'fluent-cart'),
        'GL' => __('Glarus', 'fluent-cart'),
        'GR' => __('Graubünden', 'fluent-cart'),
        'JU' => __('Jura', 'fluent-cart'),
        'LU' => __('Luzern', 'fluent-cart'),
        'NE' => __('Neuchâtel', 'fluent-cart'),
        'NW' => __('Nidwalden', 'fluent-cart'),
        'OW' => __('Obwalden', 'fluent-cart'),
        'SH' => __('Schaffhausen', 'fluent-cart'),
        'SZ' => __('Schwyz', 'fluent-cart'),
        'SO' => __('Solothurn', 'fluent-cart'),
        'SG' => __('St. Gallen', 'fluent-cart'),
        'TG' => __('Thurgau', 'fluent-cart'),
        'TI' => __('Ticino', 'fluent-cart'),
        'UR' => __('Uri', 'fluent-cart'),
        'VS' => __('Valais', 'fluent-cart'),
        'VD' => __('Vaud', 'fluent-cart'),
        'ZG' => __('Zug', 'fluent-cart'),
        'ZH' => __('Zürich', 'fluent-cart'),
    ),
    'CL' => array( // Chilean states.
        'CL-AI' => __('Aisén del General Carlos Ibañez del Campo', 'fluent-cart'),
        'CL-AN' => __('Antofagasta', 'fluent-cart'),
        'CL-AP' => __('Arica y Parinacota', 'fluent-cart'),
        'CL-AR' => __('La Araucanía', 'fluent-cart'),
        'CL-AT' => __('Atacama', 'fluent-cart'),
        'CL-BI' => __('Biobío', 'fluent-cart'),
        'CL-CO' => __('Coquimbo', 'fluent-cart'),
        'CL-LI' => __('Libertador General Bernardo O\'Higgins', 'fluent-cart'),
        'CL-LL' => __('Los Lagos', 'fluent-cart'),
        'CL-LR' => __('Los Ríos', 'fluent-cart'),
        'CL-MA' => __('Magallanes', 'fluent-cart'),
        'CL-ML' => __('Maule', 'fluent-cart'),
        'CL-NB' => __('Ñuble', 'fluent-cart'),
        'CL-RM' => __('Región Metropolitana de Santiago', 'fluent-cart'),
        'CL-TA' => __('Tarapacá', 'fluent-cart'),
        'CL-VS' => __('Valparaíso', 'fluent-cart'),
    ),
    'CN' => array( // Chinese states.
        'CN1' => __('Yunnan / 云南', 'fluent-cart'),
        'CN2' => __('Beijing / 北京', 'fluent-cart'),
        'CN3' => __('Tianjin / 天津', 'fluent-cart'),
        'CN4' => __('Hebei / 河北', 'fluent-cart'),
        'CN5' => __('Shanxi / 山西', 'fluent-cart'),
        'CN6' => __('Inner Mongolia / 內蒙古', 'fluent-cart'),
        'CN7' => __('Liaoning / 辽宁', 'fluent-cart'),
        'CN8' => __('Jilin / 吉林', 'fluent-cart'),
        'CN9' => __('Heilongjiang / 黑龙江', 'fluent-cart'),
        'CN10' => __('Shanghai / 上海', 'fluent-cart'),
        'CN11' => __('Jiangsu / 江苏', 'fluent-cart'),
        'CN12' => __('Zhejiang / 浙江', 'fluent-cart'),
        'CN13' => __('Anhui / 安徽', 'fluent-cart'),
        'CN14' => __('Fujian / 福建', 'fluent-cart'),
        'CN15' => __('Jiangxi / 江西', 'fluent-cart'),
        'CN16' => __('Shandong / 山东', 'fluent-cart'),
        'CN17' => __('Henan / 河南', 'fluent-cart'),
        'CN18' => __('Hubei / 湖北', 'fluent-cart'),
        'CN19' => __('Hunan / 湖南', 'fluent-cart'),
        'CN20' => __('Guangdong / 广东', 'fluent-cart'),
        'CN21' => __('Guangxi Zhuang / 广西壮族', 'fluent-cart'),
        'CN22' => __('Hainan / 海南', 'fluent-cart'),
        'CN23' => __('Chongqing / 重庆', 'fluent-cart'),
        'CN24' => __('Sichuan / 四川', 'fluent-cart'),
        'CN25' => __('Guizhou / 贵州', 'fluent-cart'),
        'CN26' => __('Shaanxi / 陕西', 'fluent-cart'),
        'CN27' => __('Gansu / 甘肃', 'fluent-cart'),
        'CN28' => __('Qinghai / 青海', 'fluent-cart'),
        'CN29' => __('Ningxia Hui / 宁夏', 'fluent-cart'),
        'CN30' => __('Macao / 澳门', 'fluent-cart'),
        'CN31' => __('Tibet / 西藏', 'fluent-cart'),
        'CN32' => __('Xinjiang / 新疆', 'fluent-cart'),
    ),
    'CO' => array( // Colombian states.
        'CO-AMA' => __('Amazonas', 'fluent-cart'),
        'CO-ANT' => __('Antioquia', 'fluent-cart'),
        'CO-ARA' => __('Arauca', 'fluent-cart'),
        'CO-ATL' => __('Atlántico', 'fluent-cart'),
        'CO-BOL' => __('Bolívar', 'fluent-cart'),
        'CO-BOY' => __('Boyacá', 'fluent-cart'),
        'CO-CAL' => __('Caldas', 'fluent-cart'),
        'CO-CAQ' => __('Caquetá', 'fluent-cart'),
        'CO-CAS' => __('Casanare', 'fluent-cart'),
        'CO-CAU' => __('Cauca', 'fluent-cart'),
        'CO-CES' => __('Cesar', 'fluent-cart'),
        'CO-CHO' => __('Chocó', 'fluent-cart'),
        'CO-COR' => __('Córdoba', 'fluent-cart'),
        'CO-CUN' => __('Cundinamarca', 'fluent-cart'),
        'CO-DC' => __('Capital District', 'fluent-cart'),
        'CO-GUA' => __('Guainía', 'fluent-cart'),
        'CO-GUV' => __('Guaviare', 'fluent-cart'),
        'CO-HUI' => __('Huila', 'fluent-cart'),
        'CO-LAG' => __('La Guajira', 'fluent-cart'),
        'CO-MAG' => __('Magdalena', 'fluent-cart'),
        'CO-MET' => __('Meta', 'fluent-cart'),
        'CO-NAR' => __('Nariño', 'fluent-cart'),
        'CO-NSA' => __('Norte de Santander', 'fluent-cart'),
        'CO-PUT' => __('Putumayo', 'fluent-cart'),
        'CO-QUI' => __('Quindío', 'fluent-cart'),
        'CO-RIS' => __('Risaralda', 'fluent-cart'),
        'CO-SAN' => __('Santander', 'fluent-cart'),
        'CO-SAP' => __('San Andrés & Providencia', 'fluent-cart'),
        'CO-SUC' => __('Sucre', 'fluent-cart'),
        'CO-TOL' => __('Tolima', 'fluent-cart'),
        'CO-VAC' => __('Valle del Cauca', 'fluent-cart'),
        'CO-VAU' => __('Vaupés', 'fluent-cart'),
        'CO-VID' => __('Vichada', 'fluent-cart'),
    ),
    'CR' => array( // Costa Rican states.
        'CR-A' => __('Alajuela', 'fluent-cart'),
        'CR-C' => __('Cartago', 'fluent-cart'),
        'CR-G' => __('Guanacaste', 'fluent-cart'),
        'CR-H' => __('Heredia', 'fluent-cart'),
        'CR-L' => __('Limón', 'fluent-cart'),
        'CR-P' => __('Puntarenas', 'fluent-cart'),
        'CR-SJ' => __('San José', 'fluent-cart'),
    ),
    'CZ' => array(),
    'DE' => array( // German states.
        'DE-BW' => __('Baden-Württemberg', 'fluent-cart'),
        'DE-BY' => __('Bavaria', 'fluent-cart'),
        'DE-BE' => __('Berlin', 'fluent-cart'),
        'DE-BB' => __('Brandenburg', 'fluent-cart'),
        'DE-HB' => __('Bremen', 'fluent-cart'),
        'DE-HH' => __('Hamburg', 'fluent-cart'),
        'DE-HE' => __('Hesse', 'fluent-cart'),
        'DE-MV' => __('Mecklenburg-Vorpommern', 'fluent-cart'),
        'DE-NI' => __('Lower Saxony', 'fluent-cart'),
        'DE-NW' => __('North Rhine-Westphalia', 'fluent-cart'),
        'DE-RP' => __('Rhineland-Palatinate', 'fluent-cart'),
        'DE-SL' => __('Saarland', 'fluent-cart'),
        'DE-SN' => __('Saxony', 'fluent-cart'),
        'DE-ST' => __('Saxony-Anhalt', 'fluent-cart'),
        'DE-SH' => __('Schleswig-Holstein', 'fluent-cart'),
        'DE-TH' => __('Thuringia', 'fluent-cart'),
    ),
    'DK' => array(),
    'DO' => array( // Dominican states.
        'DO-01' => __('Distrito Nacional', 'fluent-cart'),
        'DO-02' => __('Azua', 'fluent-cart'),
        'DO-03' => __('Baoruco', 'fluent-cart'),
        'DO-04' => __('Barahona', 'fluent-cart'),
        'DO-33' => __('Cibao Nordeste', 'fluent-cart'),
        'DO-34' => __('Cibao Noroeste', 'fluent-cart'),
        'DO-35' => __('Cibao Norte', 'fluent-cart'),
        'DO-36' => __('Cibao Sur', 'fluent-cart'),
        'DO-05' => __('Dajabón', 'fluent-cart'),
        'DO-06' => __('Duarte', 'fluent-cart'),
        'DO-08' => __('El Seibo', 'fluent-cart'),
        'DO-37' => __('El Valle', 'fluent-cart'),
        'DO-07' => __('Elías Piña', 'fluent-cart'),
        'DO-38' => __('Enriquillo', 'fluent-cart'),
        'DO-09' => __('Espaillat', 'fluent-cart'),
        'DO-30' => __('Hato Mayor', 'fluent-cart'),
        'DO-19' => __('Hermanas Mirabal', 'fluent-cart'),
        'DO-39' => __('Higüamo', 'fluent-cart'),
        'DO-10' => __('Independencia', 'fluent-cart'),
        'DO-11' => __('La Altagracia', 'fluent-cart'),
        'DO-12' => __('La Romana', 'fluent-cart'),
        'DO-13' => __('La Vega', 'fluent-cart'),
        'DO-14' => __('María Trinidad Sánchez', 'fluent-cart'),
        'DO-28' => __('Monseñor Nouel', 'fluent-cart'),
        'DO-15' => __('Monte Cristi', 'fluent-cart'),
        'DO-29' => __('Monte Plata', 'fluent-cart'),
        'DO-40' => __('Ozama', 'fluent-cart'),
        'DO-16' => __('Pedernales', 'fluent-cart'),
        'DO-17' => __('Peravia', 'fluent-cart'),
        'DO-18' => __('Puerto Plata', 'fluent-cart'),
        'DO-20' => __('Samaná', 'fluent-cart'),
        'DO-21' => __('San Cristóbal', 'fluent-cart'),
        'DO-31' => __('San José de Ocoa', 'fluent-cart'),
        'DO-22' => __('San Juan', 'fluent-cart'),
        'DO-23' => __('San Pedro de Macorís', 'fluent-cart'),
        'DO-24' => __('Sánchez Ramírez', 'fluent-cart'),
        'DO-25' => __('Santiago', 'fluent-cart'),
        'DO-26' => __('Santiago Rodríguez', 'fluent-cart'),
        'DO-32' => __('Santo Domingo', 'fluent-cart'),
        'DO-41' => __('Valdesia', 'fluent-cart'),
        'DO-27' => __('Valverde', 'fluent-cart'),
        'DO-42' => __('Yuma', 'fluent-cart'),
    ),
    'DZ' => array( // Algerian states.
        'DZ-01' => __('Adrar', 'fluent-cart'),
        'DZ-02' => __('Chlef', 'fluent-cart'),
        'DZ-03' => __('Laghouat', 'fluent-cart'),
        'DZ-04' => __('Oum El Bouaghi', 'fluent-cart'),
        'DZ-05' => __('Batna', 'fluent-cart'),
        'DZ-06' => __('Béjaïa', 'fluent-cart'),
        'DZ-07' => __('Biskra', 'fluent-cart'),
        'DZ-08' => __('Béchar', 'fluent-cart'),
        'DZ-09' => __('Blida', 'fluent-cart'),
        'DZ-10' => __('Bouira', 'fluent-cart'),
        'DZ-11' => __('Tamanghasset', 'fluent-cart'),
        'DZ-12' => __('Tébessa', 'fluent-cart'),
        'DZ-13' => __('Tlemcen', 'fluent-cart'),
        'DZ-14' => __('Tiaret', 'fluent-cart'),
        'DZ-15' => __('Tizi Ouzou', 'fluent-cart'),
        'DZ-16' => __('Algiers', 'fluent-cart'),
        'DZ-17' => __('Djelfa', 'fluent-cart'),
        'DZ-18' => __('Jijel', 'fluent-cart'),
        'DZ-19' => __('Sétif', 'fluent-cart'),
        'DZ-20' => __('Saïda', 'fluent-cart'),
        'DZ-21' => __('Skikda', 'fluent-cart'),
        'DZ-22' => __('Sidi Bel Abbès', 'fluent-cart'),
        'DZ-23' => __('Annaba', 'fluent-cart'),
        'DZ-24' => __('Guelma', 'fluent-cart'),
        'DZ-25' => __('Constantine', 'fluent-cart'),
        'DZ-26' => __('Médéa', 'fluent-cart'),
        'DZ-27' => __('Mostaganem', 'fluent-cart'),
        'DZ-28' => __('M’Sila', 'fluent-cart'),
        'DZ-29' => __('Mascara', 'fluent-cart'),
        'DZ-30' => __('Ouargla', 'fluent-cart'),
        'DZ-31' => __('Oran', 'fluent-cart'),
        'DZ-32' => __('El Bayadh', 'fluent-cart'),
        'DZ-33' => __('Illizi', 'fluent-cart'),
        'DZ-34' => __('Bordj Bou Arréridj', 'fluent-cart'),
        'DZ-35' => __('Boumerdès', 'fluent-cart'),
        'DZ-36' => __('El Tarf', 'fluent-cart'),
        'DZ-37' => __('Tindouf', 'fluent-cart'),
        'DZ-38' => __('Tissemsilt', 'fluent-cart'),
        'DZ-39' => __('El Oued', 'fluent-cart'),
        'DZ-40' => __('Khenchela', 'fluent-cart'),
        'DZ-41' => __('Souk Ahras', 'fluent-cart'),
        'DZ-42' => __('Tipasa', 'fluent-cart'),
        'DZ-43' => __('Mila', 'fluent-cart'),
        'DZ-44' => __('Aïn Defla', 'fluent-cart'),
        'DZ-45' => __('Naama', 'fluent-cart'),
        'DZ-46' => __('Aïn Témouchent', 'fluent-cart'),
        'DZ-47' => __('Ghardaïa', 'fluent-cart'),
        'DZ-48' => __('Relizane', 'fluent-cart'),
    ),
    'EE' => array(),
    'EC' => array( // Ecuadorian states.
        'EC-A' => __('Azuay', 'fluent-cart'),
        'EC-B' => __('Bolívar', 'fluent-cart'),
        'EC-F' => __('Cañar', 'fluent-cart'),
        'EC-C' => __('Carchi', 'fluent-cart'),
        'EC-H' => __('Chimborazo', 'fluent-cart'),
        'EC-X' => __('Cotopaxi', 'fluent-cart'),
        'EC-O' => __('El Oro', 'fluent-cart'),
        'EC-E' => __('Esmeraldas', 'fluent-cart'),
        'EC-W' => __('Galápagos', 'fluent-cart'),
        'EC-G' => __('Guayas', 'fluent-cart'),
        'EC-I' => __('Imbabura', 'fluent-cart'),
        'EC-L' => __('Loja', 'fluent-cart'),
        'EC-R' => __('Los Ríos', 'fluent-cart'),
        'EC-M' => __('Manabí', 'fluent-cart'),
        'EC-S' => __('Morona-Santiago', 'fluent-cart'),
        'EC-N' => __('Napo', 'fluent-cart'),
        'EC-D' => __('Orellana', 'fluent-cart'),
        'EC-Y' => __('Pastaza', 'fluent-cart'),
        'EC-P' => __('Pichincha', 'fluent-cart'),
        'EC-SE' => __('Santa Elena', 'fluent-cart'),
        'EC-SD' => __('Santo Domingo de los Tsáchilas', 'fluent-cart'),
        'EC-U' => __('Sucumbíos', 'fluent-cart'),
        'EC-T' => __('Tungurahua', 'fluent-cart'),
        'EC-Z' => __('Zamora-Chinchipe', 'fluent-cart'),
    ),
    'EG' => array( // Egyptian states.
        'EGALX' => __('Alexandria', 'fluent-cart'),
        'EGASN' => __('Aswan', 'fluent-cart'),
        'EGAST' => __('Asyut', 'fluent-cart'),
        'EGBA' => __('Red Sea', 'fluent-cart'),
        'EGBH' => __('Beheira', 'fluent-cart'),
        'EGBNS' => __('Beni Suef', 'fluent-cart'),
        'EGC' => __('Cairo', 'fluent-cart'),
        'EGDK' => __('Dakahlia', 'fluent-cart'),
        'EGDT' => __('Damietta', 'fluent-cart'),
        'EGFYM' => __('Faiyum', 'fluent-cart'),
        'EGGH' => __('Gharbia', 'fluent-cart'),
        'EGGZ' => __('Giza', 'fluent-cart'),
        'EGIS' => __('Ismailia', 'fluent-cart'),
        'EGJS' => __('South Sinai', 'fluent-cart'),
        'EGKB' => __('Qalyubia', 'fluent-cart'),
        'EGKFS' => __('Kafr el-Sheikh', 'fluent-cart'),
        'EGKN' => __('Qena', 'fluent-cart'),
        'EGLX' => __('Luxor', 'fluent-cart'),
        'EGMN' => __('Minya', 'fluent-cart'),
        'EGMNF' => __('Monufia', 'fluent-cart'),
        'EGMT' => __('Matrouh', 'fluent-cart'),
        'EGPTS' => __('Port Said', 'fluent-cart'),
        'EGSHG' => __('Sohag', 'fluent-cart'),
        'EGSHR' => __('Al Sharqia', 'fluent-cart'),
        'EGSIN' => __('North Sinai', 'fluent-cart'),
        'EGSUZ' => __('Suez', 'fluent-cart'),
        'EGWAD' => __('New Valley', 'fluent-cart'),
    ),
    'ES' => array( // Spanish states.
        'C' => __('A Coruña', 'fluent-cart'),
        'VI' => __('Araba/Álava', 'fluent-cart'),
        'AB' => __('Albacete', 'fluent-cart'),
        'A' => __('Alicante', 'fluent-cart'),
        'AL' => __('Almería', 'fluent-cart'),
        'O' => __('Asturias', 'fluent-cart'),
        'AV' => __('Ávila', 'fluent-cart'),
        'BA' => __('Badajoz', 'fluent-cart'),
        'PM' => __('Baleares', 'fluent-cart'),
        'B' => __('Barcelona', 'fluent-cart'),
        'BU' => __('Burgos', 'fluent-cart'),
        'CC' => __('Cáceres', 'fluent-cart'),
        'CA' => __('Cádiz', 'fluent-cart'),
        'S' => __('Cantabria', 'fluent-cart'),
        'CS' => __('Castellón', 'fluent-cart'),
        'CE' => __('Ceuta', 'fluent-cart'),
        'CR' => __('Ciudad Real', 'fluent-cart'),
        'CO' => __('Córdoba', 'fluent-cart'),
        'CU' => __('Cuenca', 'fluent-cart'),
        'GI' => __('Girona', 'fluent-cart'),
        'GR' => __('Granada', 'fluent-cart'),
        'GU' => __('Guadalajara', 'fluent-cart'),
        'SS' => __('Gipuzkoa', 'fluent-cart'),
        'H' => __('Huelva', 'fluent-cart'),
        'HU' => __('Huesca', 'fluent-cart'),
        'J' => __('Jaén', 'fluent-cart'),
        'LO' => __('La Rioja', 'fluent-cart'),
        'GC' => __('Las Palmas', 'fluent-cart'),
        'LE' => __('León', 'fluent-cart'),
        'L' => __('Lleida', 'fluent-cart'),
        'LU' => __('Lugo', 'fluent-cart'),
        'M' => __('Madrid', 'fluent-cart'),
        'MA' => __('Málaga', 'fluent-cart'),
        'ML' => __('Melilla', 'fluent-cart'),
        'MU' => __('Murcia', 'fluent-cart'),
        'NA' => __('Navarra', 'fluent-cart'),
        'OR' => __('Ourense', 'fluent-cart'),
        'P' => __('Palencia', 'fluent-cart'),
        'PO' => __('Pontevedra', 'fluent-cart'),
        'SA' => __('Salamanca', 'fluent-cart'),
        'TF' => __('Santa Cruz de Tenerife', 'fluent-cart'),
        'SG' => __('Segovia', 'fluent-cart'),
        'SE' => __('Sevilla', 'fluent-cart'),
        'SO' => __('Soria', 'fluent-cart'),
        'T' => __('Tarragona', 'fluent-cart'),
        'TE' => __('Teruel', 'fluent-cart'),
        'TO' => __('Toledo', 'fluent-cart'),
        'V' => __('Valencia', 'fluent-cart'),
        'VA' => __('Valladolid', 'fluent-cart'),
        'BI' => __('Biscay', 'fluent-cart'),
        'ZA' => __('Zamora', 'fluent-cart'),
        'Z' => __('Zaragoza', 'fluent-cart'),
    ),
    'ET' => array(),
    'FI' => array(),
    'FR' => array(),
    'GF' => array(),
    'GH' => array( // Ghanaian regions.
        'AF' => __('Ahafo', 'fluent-cart'),
        'AH' => __('Ashanti', 'fluent-cart'),
        'BA' => __('Brong-Ahafo', 'fluent-cart'),
        'BO' => __('Bono', 'fluent-cart'),
        'BE' => __('Bono East', 'fluent-cart'),
        'CP' => __('Central', 'fluent-cart'),
        'EP' => __('Eastern', 'fluent-cart'),
        'AA' => __('Greater Accra', 'fluent-cart'),
        'NE' => __('North East', 'fluent-cart'),
        'NP' => __('Northern', 'fluent-cart'),
        'OT' => __('Oti', 'fluent-cart'),
        'SV' => __('Savannah', 'fluent-cart'),
        'UE' => __('Upper East', 'fluent-cart'),
        'UW' => __('Upper West', 'fluent-cart'),
        'TV' => __('Volta', 'fluent-cart'),
        'WP' => __('Western', 'fluent-cart'),
        'WN' => __('Western North', 'fluent-cart'),
    ),
    'GP' => array(),
    'GR' => array( // Greek regions.
        'I' => __('Attica', 'fluent-cart'),
        'A' => __('East Macedonia and Thrace', 'fluent-cart'),
        'B' => __('Central Macedonia', 'fluent-cart'),
        'C' => __('West Macedonia', 'fluent-cart'),
        'D' => __('Epirus', 'fluent-cart'),
        'E' => __('Thessaly', 'fluent-cart'),
        'F' => __('Ionian Islands', 'fluent-cart'),
        'G' => __('West Greece', 'fluent-cart'),
        'H' => __('Central Greece', 'fluent-cart'),
        'J' => __('Peloponnese', 'fluent-cart'),
        'K' => __('North Aegean', 'fluent-cart'),
        'L' => __('South Aegean', 'fluent-cart'),
        'M' => __('Crete', 'fluent-cart'),
    ),
    'GT' => array( // Guatemalan states.
        'GT-AV' => __('Alta Verapaz', 'fluent-cart'),
        'GT-BV' => __('Baja Verapaz', 'fluent-cart'),
        'GT-CM' => __('Chimaltenango', 'fluent-cart'),
        'GT-CQ' => __('Chiquimula', 'fluent-cart'),
        'GT-PR' => __('El Progreso', 'fluent-cart'),
        'GT-ES' => __('Escuintla', 'fluent-cart'),
        'GT-GU' => __('Guatemala', 'fluent-cart'),
        'GT-HU' => __('Huehuetenango', 'fluent-cart'),
        'GT-IZ' => __('Izabal', 'fluent-cart'),
        'GT-JA' => __('Jalapa', 'fluent-cart'),
        'GT-JU' => __('Jutiapa', 'fluent-cart'),
        'GT-PE' => __('Petén', 'fluent-cart'),
        'GT-QZ' => __('Quetzaltenango', 'fluent-cart'),
        'GT-QC' => __('Quiché', 'fluent-cart'),
        'GT-RE' => __('Retalhuleu', 'fluent-cart'),
        'GT-SA' => __('Sacatepéquez', 'fluent-cart'),
        'GT-SM' => __('San Marcos', 'fluent-cart'),
        'GT-SR' => __('Santa Rosa', 'fluent-cart'),
        'GT-SO' => __('Sololá', 'fluent-cart'),
        'GT-SU' => __('Suchitepéquez', 'fluent-cart'),
        'GT-TO' => __('Totonicapán', 'fluent-cart'),
        'GT-ZA' => __('Zacapa', 'fluent-cart'),
    ),
    'HK' => array( // Hong Kong states.
        'HONG KONG' => __('Hong Kong Island', 'fluent-cart'),
        'KOWLOON' => __('Kowloon', 'fluent-cart'),
        'NEW TERRITORIES' => __('New Territories', 'fluent-cart'),
    ),
    'HN' => array( // Honduran states.
        'HN-AT' => __('Atlántida', 'fluent-cart'),
        'HN-IB' => __('Bay Islands', 'fluent-cart'),
        'HN-CH' => __('Choluteca', 'fluent-cart'),
        'HN-CL' => __('Colón', 'fluent-cart'),
        'HN-CM' => __('Comayagua', 'fluent-cart'),
        'HN-CP' => __('Copán', 'fluent-cart'),
        'HN-CR' => __('Cortés', 'fluent-cart'),
        'HN-EP' => __('El Paraíso', 'fluent-cart'),
        'HN-FM' => __('Francisco Morazán', 'fluent-cart'),
        'HN-GD' => __('Gracias a Dios', 'fluent-cart'),
        'HN-IN' => __('Intibucá', 'fluent-cart'),
        'HN-LE' => __('Lempira', 'fluent-cart'),
        'HN-LP' => __('La Paz', 'fluent-cart'),
        'HN-OC' => __('Ocotepeque', 'fluent-cart'),
        'HN-OL' => __('Olancho', 'fluent-cart'),
        'HN-SB' => __('Santa Bárbara', 'fluent-cart'),
        'HN-VA' => __('Valle', 'fluent-cart'),
        'HN-YO' => __('Yoro', 'fluent-cart'),
    ),
    'HR' => array( // Croatian counties.
        'HR-01' => __('Zagreb County', 'fluent-cart'),
        'HR-02' => __('Krapina-Zagorje County', 'fluent-cart'),
        'HR-03' => __('Sisak-Moslavina County', 'fluent-cart'),
        'HR-04' => __('Karlovac County', 'fluent-cart'),
        'HR-05' => __('Varaždin County', 'fluent-cart'),
        'HR-06' => __('Koprivnica-Križevci County', 'fluent-cart'),
        'HR-07' => __('Bjelovar-Bilogora County', 'fluent-cart'),
        'HR-08' => __('Primorje-Gorski Kotar County', 'fluent-cart'),
        'HR-09' => __('Lika-Senj County', 'fluent-cart'),
        'HR-10' => __('Virovitica-Podravina County', 'fluent-cart'),
        'HR-11' => __('Požega-Slavonia County', 'fluent-cart'),
        'HR-12' => __('Brod-Posavina County', 'fluent-cart'),
        'HR-13' => __('Zadar County', 'fluent-cart'),
        'HR-14' => __('Osijek-Baranja County', 'fluent-cart'),
        'HR-15' => __('Šibenik-Knin County', 'fluent-cart'),
        'HR-16' => __('Vukovar-Srijem County', 'fluent-cart'),
        'HR-17' => __('Split-Dalmatia County', 'fluent-cart'),
        'HR-18' => __('Istria County', 'fluent-cart'),
        'HR-19' => __('Dubrovnik-Neretva County', 'fluent-cart'),
        'HR-20' => __('Međimurje County', 'fluent-cart'),
        'HR-21' => __('Zagreb City', 'fluent-cart'),
    ),
    'HU' => array( // Hungarian states.
        'BK' => __('Bács-Kiskun', 'fluent-cart'),
        'BE' => __('Békés', 'fluent-cart'),
        'BA' => __('Baranya', 'fluent-cart'),
        'BZ' => __('Borsod-Abaúj-Zemplén', 'fluent-cart'),
        'BU' => __('Budapest', 'fluent-cart'),
        'CS' => __('Csongrád-Csanád', 'fluent-cart'),
        'FE' => __('Fejér', 'fluent-cart'),
        'GS' => __('Győr-Moson-Sopron', 'fluent-cart'),
        'HB' => __('Hajdú-Bihar', 'fluent-cart'),
        'HE' => __('Heves', 'fluent-cart'),
        'JN' => __('Jász-Nagykun-Szolnok', 'fluent-cart'),
        'KE' => __('Komárom-Esztergom', 'fluent-cart'),
        'NO' => __('Nógrád', 'fluent-cart'),
        'PE' => __('Pest', 'fluent-cart'),
        'SO' => __('Somogy', 'fluent-cart'),
        'SZ' => __('Szabolcs-Szatmár-Bereg', 'fluent-cart'),
        'TO' => __('Tolna', 'fluent-cart'),
        'VA' => __('Vas', 'fluent-cart'),
        'VE' => __('Veszprém', 'fluent-cart'),
        'ZA' => __('Zala', 'fluent-cart'),
    ),
    'ID' => array( // Indonesian provinces.
        'AC' => __('Daerah Istimewa Aceh', 'fluent-cart'),
        'SU' => __('Sumatera Utara', 'fluent-cart'),
        'SB' => __('Sumatera Barat', 'fluent-cart'),
        'RI' => __('Riau', 'fluent-cart'),
        'KR' => __('Kepulauan Riau', 'fluent-cart'),
        'JA' => __('Jambi', 'fluent-cart'),
        'SS' => __('Sumatera Selatan', 'fluent-cart'),
        'BB' => __('Bangka Belitung', 'fluent-cart'),
        'BE' => __('Bengkulu', 'fluent-cart'),
        'LA' => __('Lampung', 'fluent-cart'),
        'JK' => __('DKI Jakarta', 'fluent-cart'),
        'JB' => __('Jawa Barat', 'fluent-cart'),
        'BT' => __('Banten', 'fluent-cart'),
        'JT' => __('Jawa Tengah', 'fluent-cart'),
        'JI' => __('Jawa Timur', 'fluent-cart'),
        'YO' => __('Daerah Istimewa Yogyakarta', 'fluent-cart'),
        'BA' => __('Bali', 'fluent-cart'),
        'NB' => __('Nusa Tenggara Barat', 'fluent-cart'),
        'NT' => __('Nusa Tenggara Timur', 'fluent-cart'),
        'KB' => __('Kalimantan Barat', 'fluent-cart'),
        'KT' => __('Kalimantan Tengah', 'fluent-cart'),
        'KI' => __('Kalimantan Timur', 'fluent-cart'),
        'KS' => __('Kalimantan Selatan', 'fluent-cart'),
        'KU' => __('Kalimantan Utara', 'fluent-cart'),
        'SA' => __('Sulawesi Utara', 'fluent-cart'),
        'ST' => __('Sulawesi Tengah', 'fluent-cart'),
        'SG' => __('Sulawesi Tenggara', 'fluent-cart'),
        'SR' => __('Sulawesi Barat', 'fluent-cart'),
        'SN' => __('Sulawesi Selatan', 'fluent-cart'),
        'GO' => __('Gorontalo', 'fluent-cart'),
        'MA' => __('Maluku', 'fluent-cart'),
        'MU' => __('Maluku Utara', 'fluent-cart'),
        'PA' => __('Papua', 'fluent-cart'),
        'PB' => __('Papua Barat', 'fluent-cart'),
    ),
    'IE' => array( // Irish states.
        'CW' => __('Carlow', 'fluent-cart'),
        'CN' => __('Cavan', 'fluent-cart'),
        'CE' => __('Clare', 'fluent-cart'),
        'CO' => __('Cork', 'fluent-cart'),
        'DL' => __('Donegal', 'fluent-cart'),
        'D' => __('Dublin', 'fluent-cart'),
        'G' => __('Galway', 'fluent-cart'),
        'KY' => __('Kerry', 'fluent-cart'),
        'KE' => __('Kildare', 'fluent-cart'),
        'KK' => __('Kilkenny', 'fluent-cart'),
        'LS' => __('Laois', 'fluent-cart'),
        'LM' => __('Leitrim', 'fluent-cart'),
        'LK' => __('Limerick', 'fluent-cart'),
        'LD' => __('Longford', 'fluent-cart'),
        'LH' => __('Louth', 'fluent-cart'),
        'MO' => __('Mayo', 'fluent-cart'),
        'MH' => __('Meath', 'fluent-cart'),
        'MN' => __('Monaghan', 'fluent-cart'),
        'OY' => __('Offaly', 'fluent-cart'),
        'RN' => __('Roscommon', 'fluent-cart'),
        'SO' => __('Sligo', 'fluent-cart'),
        'TA' => __('Tipperary', 'fluent-cart'),
        'WD' => __('Waterford', 'fluent-cart'),
        'WH' => __('Westmeath', 'fluent-cart'),
        'WX' => __('Wexford', 'fluent-cart'),
        'WW' => __('Wicklow', 'fluent-cart'),
    ),
    'IN' => array( // Indian states.
        'AP' => __('Andhra Pradesh', 'fluent-cart'),
        'AR' => __('Arunachal Pradesh', 'fluent-cart'),
        'AS' => __('Assam', 'fluent-cart'),
        'BR' => __('Bihar', 'fluent-cart'),
        'CT' => __('Chhattisgarh', 'fluent-cart'),
        'GA' => __('Goa', 'fluent-cart'),
        'GJ' => __('Gujarat', 'fluent-cart'),
        'HR' => __('Haryana', 'fluent-cart'),
        'HP' => __('Himachal Pradesh', 'fluent-cart'),
        'JK' => __('Jammu and Kashmir', 'fluent-cart'),
        'JH' => __('Jharkhand', 'fluent-cart'),
        'KA' => __('Karnataka', 'fluent-cart'),
        'KL' => __('Kerala', 'fluent-cart'),
        'LA' => __('Ladakh', 'fluent-cart'),
        'MP' => __('Madhya Pradesh', 'fluent-cart'),
        'MH' => __('Maharashtra', 'fluent-cart'),
        'MN' => __('Manipur', 'fluent-cart'),
        'ML' => __('Meghalaya', 'fluent-cart'),
        'MZ' => __('Mizoram', 'fluent-cart'),
        'NL' => __('Nagaland', 'fluent-cart'),
        'OD' => __('Odisha', 'fluent-cart'),
        'PB' => __('Punjab', 'fluent-cart'),
        'RJ' => __('Rajasthan', 'fluent-cart'),
        'SK' => __('Sikkim', 'fluent-cart'),
        'TN' => __('Tamil Nadu', 'fluent-cart'),
        'TS' => __('Telangana', 'fluent-cart'),
        'TR' => __('Tripura', 'fluent-cart'),
        'UK' => __('Uttarakhand', 'fluent-cart'),
        'UP' => __('Uttar Pradesh', 'fluent-cart'),
        'WB' => __('West Bengal', 'fluent-cart'),
        'AN' => __('Andaman and Nicobar Islands', 'fluent-cart'),
        'CH' => __('Chandigarh', 'fluent-cart'),
        'DN' => __('Dadra and Nagar Haveli', 'fluent-cart'),
        'DD' => __('Daman and Diu', 'fluent-cart'),
        'DL' => __('Delhi', 'fluent-cart'),
        'LD' => __('Lakshadeep', 'fluent-cart'),
        'PY' => __('Pondicherry (Puducherry)', 'fluent-cart'),
    ),
    'IR' => array( // Iranian states.
        'KHZ' => __('Khuzestan (خوزستان)', 'fluent-cart'),
        'THR' => __('Tehran (تهران)', 'fluent-cart'),
        'ILM' => __('Ilaam (ایلام)', 'fluent-cart'),
        'BHR' => __('Bushehr (بوشهر)', 'fluent-cart'),
        'ADL' => __('Ardabil (اردبیل)', 'fluent-cart'),
        'ESF' => __('Isfahan (اصفهان)', 'fluent-cart'),
        'YZD' => __('Yazd (یزد)', 'fluent-cart'),
        'KRH' => __('Kermanshah (کرمانشاه)', 'fluent-cart'),
        'KRN' => __('Kerman (کرمان)', 'fluent-cart'),
        'HDN' => __('Hamadan (همدان)', 'fluent-cart'),
        'GZN' => __('Ghazvin (قزوین)', 'fluent-cart'),
        'ZJN' => __('Zanjan (زنجان)', 'fluent-cart'),
        'LRS' => __('Luristan (لرستان)', 'fluent-cart'),
        'ABZ' => __('Alborz (البرز)', 'fluent-cart'),
        'EAZ' => __('East Azarbaijan (آذربایجان شرقی)', 'fluent-cart'),
        'WAZ' => __('West Azarbaijan (آذربایجان غربی)', 'fluent-cart'),
        'CHB' => __('Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'fluent-cart'),
        'SKH' => __('South Khorasan (خراسان جنوبی)', 'fluent-cart'),
        'RKH' => __('Razavi Khorasan (خراسان رضوی)', 'fluent-cart'),
        'NKH' => __('North Khorasan (خراسان شمالی)', 'fluent-cart'),
        'SMN' => __('Semnan (سمنان)', 'fluent-cart'),
        'FRS' => __('Fars (فارس)', 'fluent-cart'),
        'QHM' => __('Qom (قم)', 'fluent-cart'),
        'KRD' => __('Kurdistan / کردستان)', 'fluent-cart'),
        'KBD' => __('Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'fluent-cart'),
        'GLS' => __('Golestan (گلستان)', 'fluent-cart'),
        'GIL' => __('Gilan (گیلان)', 'fluent-cart'),
        'MZN' => __('Mazandaran (مازندران)', 'fluent-cart'),
        'MKZ' => __('Markazi (مرکزی)', 'fluent-cart'),
        'HRZ' => __('Hormozgan (هرمزگان)', 'fluent-cart'),
        'SBN' => __('Sistan and Baluchestan (سیستان و بلوچستان)', 'fluent-cart'),
    ),
    'IS' => array(),
    'IT' => array( // Italian provinces.
        'AG' => __('Agrigento', 'fluent-cart'),
        'AL' => __('Alessandria', 'fluent-cart'),
        'AN' => __('Ancona', 'fluent-cart'),
        'AO' => __('Aosta', 'fluent-cart'),
        'AR' => __('Arezzo', 'fluent-cart'),
        'AP' => __('Ascoli Piceno', 'fluent-cart'),
        'AT' => __('Asti', 'fluent-cart'),
        'AV' => __('Avellino', 'fluent-cart'),
        'BA' => __('Bari', 'fluent-cart'),
        'BT' => __('Barletta-Andria-Trani', 'fluent-cart'),
        'BL' => __('Belluno', 'fluent-cart'),
        'BN' => __('Benevento', 'fluent-cart'),
        'BG' => __('Bergamo', 'fluent-cart'),
        'BI' => __('Biella', 'fluent-cart'),
        'BO' => __('Bologna', 'fluent-cart'),
        'BZ' => __('Bolzano', 'fluent-cart'),
        'BS' => __('Brescia', 'fluent-cart'),
        'BR' => __('Brindisi', 'fluent-cart'),
        'CA' => __('Cagliari', 'fluent-cart'),
        'CL' => __('Caltanissetta', 'fluent-cart'),
        'CB' => __('Campobasso', 'fluent-cart'),
        'CE' => __('Caserta', 'fluent-cart'),
        'CT' => __('Catania', 'fluent-cart'),
        'CZ' => __('Catanzaro', 'fluent-cart'),
        'CH' => __('Chieti', 'fluent-cart'),
        'CO' => __('Como', 'fluent-cart'),
        'CS' => __('Cosenza', 'fluent-cart'),
        'CR' => __('Cremona', 'fluent-cart'),
        'KR' => __('Crotone', 'fluent-cart'),
        'CN' => __('Cuneo', 'fluent-cart'),
        'EN' => __('Enna', 'fluent-cart'),
        'FM' => __('Fermo', 'fluent-cart'),
        'FE' => __('Ferrara', 'fluent-cart'),
        'FI' => __('Firenze', 'fluent-cart'),
        'FG' => __('Foggia', 'fluent-cart'),
        'FC' => __('Forlì-Cesena', 'fluent-cart'),
        'FR' => __('Frosinone', 'fluent-cart'),
        'GE' => __('Genova', 'fluent-cart'),
        'GO' => __('Gorizia', 'fluent-cart'),
        'GR' => __('Grosseto', 'fluent-cart'),
        'IM' => __('Imperia', 'fluent-cart'),
        'IS' => __('Isernia', 'fluent-cart'),
        'SP' => __('La Spezia', 'fluent-cart'),
        'AQ' => __("L'Aquila", 'fluent-cart'),
        'LT' => __('Latina', 'fluent-cart'),
        'LE' => __('Lecce', 'fluent-cart'),
        'LC' => __('Lecco', 'fluent-cart'),
        'LI' => __('Livorno', 'fluent-cart'),
        'LO' => __('Lodi', 'fluent-cart'),
        'LU' => __('Lucca', 'fluent-cart'),
        'MC' => __('Macerata', 'fluent-cart'),
        'MN' => __('Mantova', 'fluent-cart'),
        'MS' => __('Massa-Carrara', 'fluent-cart'),
        'MT' => __('Matera', 'fluent-cart'),
        'ME' => __('Messina', 'fluent-cart'),
        'MI' => __('Milano', 'fluent-cart'),
        'MO' => __('Modena', 'fluent-cart'),
        'MB' => __('Monza e della Brianza', 'fluent-cart'),
        'NA' => __('Napoli', 'fluent-cart'),
        'NO' => __('Novara', 'fluent-cart'),
        'NU' => __('Nuoro', 'fluent-cart'),
        'OR' => __('Oristano', 'fluent-cart'),
        'PD' => __('Padova', 'fluent-cart'),
        'PA' => __('Palermo', 'fluent-cart'),
        'PR' => __('Parma', 'fluent-cart'),
        'PV' => __('Pavia', 'fluent-cart'),
        'PG' => __('Perugia', 'fluent-cart'),
        'PU' => __('Pesaro e Urbino', 'fluent-cart'),
        'PE' => __('Pescara', 'fluent-cart'),
        'PC' => __('Piacenza', 'fluent-cart'),
        'PI' => __('Pisa', 'fluent-cart'),
        'PT' => __('Pistoia', 'fluent-cart'),
        'PN' => __('Pordenone', 'fluent-cart'),
        'PZ' => __('Potenza', 'fluent-cart'),
        'PO' => __('Prato', 'fluent-cart'),
        'RG' => __('Ragusa', 'fluent-cart'),
        'RA' => __('Ravenna', 'fluent-cart'),
        'RC' => __('Reggio Calabria', 'fluent-cart'),
        'RE' => __('Reggio Emilia', 'fluent-cart'),
        'RI' => __('Rieti', 'fluent-cart'),
        'RN' => __('Rimini', 'fluent-cart'),
        'RM' => __('Roma', 'fluent-cart'),
        'RO' => __('Rovigo', 'fluent-cart'),
        'SA' => __('Salerno', 'fluent-cart'),
        'SS' => __('Sassari', 'fluent-cart'),
        'SV' => __('Savona', 'fluent-cart'),
        'SI' => __('Siena', 'fluent-cart'),
        'SR' => __('Siracusa', 'fluent-cart'),
        'SO' => __('Sondrio', 'fluent-cart'),
        'SU' => __('Sud Sardegna', 'fluent-cart'),
        'TA' => __('Taranto', 'fluent-cart'),
        'TE' => __('Teramo', 'fluent-cart'),
        'TR' => __('Terni', 'fluent-cart'),
        'TO' => __('Torino', 'fluent-cart'),
        'TP' => __('Trapani', 'fluent-cart'),
        'TN' => __('Trento', 'fluent-cart'),
        'TV' => __('Treviso', 'fluent-cart'),
        'TS' => __('Trieste', 'fluent-cart'),
        'UD' => __('Udine', 'fluent-cart'),
        'VA' => __('Varese', 'fluent-cart'),
        'VE' => __('Venezia', 'fluent-cart'),
        'VB' => __('Verbano-Cusio-Ossola', 'fluent-cart'),
        'VC' => __('Vercelli', 'fluent-cart'),
        'VR' => __('Verona', 'fluent-cart'),
        'VV' => __('Vibo Valentia', 'fluent-cart'),
        'VI' => __('Vicenza', 'fluent-cart'),
        'VT' => __('Viterbo', 'fluent-cart'),
    ),
    'IL' => array(),
    'IM' => array(),
    'JM' => array( // Jamaican parishes.
        'JM-01' => __('Kingston', 'fluent-cart'),
        'JM-02' => __('Saint Andrew', 'fluent-cart'),
        'JM-03' => __('Saint Thomas', 'fluent-cart'),
        'JM-04' => __('Portland', 'fluent-cart'),
        'JM-05' => __('Saint Mary', 'fluent-cart'),
        'JM-06' => __('Saint Ann', 'fluent-cart'),
        'JM-07' => __('Trelawny', 'fluent-cart'),
        'JM-08' => __('Saint James', 'fluent-cart'),
        'JM-09' => __('Hanover', 'fluent-cart'),
        'JM-10' => __('Westmoreland', 'fluent-cart'),
        'JM-11' => __('Saint Elizabeth', 'fluent-cart'),
        'JM-12' => __('Manchester', 'fluent-cart'),
        'JM-13' => __('Clarendon', 'fluent-cart'),
        'JM-14' => __('Saint Catherine', 'fluent-cart'),
    ),

    /**
     * Japanese states.
     *
     * English notation of prefectures conform to the notation of Japan Post.
     * The suffix corresponds with the Japanese translation file.
     */
    'JP' => array(
        'JP01' => __('Hokkaido', 'fluent-cart'),
        'JP02' => __('Aomori', 'fluent-cart'),
        'JP03' => __('Iwate', 'fluent-cart'),
        'JP04' => __('Miyagi', 'fluent-cart'),
        'JP05' => __('Akita', 'fluent-cart'),
        'JP06' => __('Yamagata', 'fluent-cart'),
        'JP07' => __('Fukushima', 'fluent-cart'),
        'JP08' => __('Ibaraki', 'fluent-cart'),
        'JP09' => __('Tochigi', 'fluent-cart'),
        'JP10' => __('Gunma', 'fluent-cart'),
        'JP11' => __('Saitama', 'fluent-cart'),
        'JP12' => __('Chiba', 'fluent-cart'),
        'JP13' => __('Tokyo', 'fluent-cart'),
        'JP14' => __('Kanagawa', 'fluent-cart'),
        'JP15' => __('Niigata', 'fluent-cart'),
        'JP16' => __('Toyama', 'fluent-cart'),
        'JP17' => __('Ishikawa', 'fluent-cart'),
        'JP18' => __('Fukui', 'fluent-cart'),
        'JP19' => __('Yamanashi', 'fluent-cart'),
        'JP20' => __('Nagano', 'fluent-cart'),
        'JP21' => __('Gifu', 'fluent-cart'),
        'JP22' => __('Shizuoka', 'fluent-cart'),
        'JP23' => __('Aichi', 'fluent-cart'),
        'JP24' => __('Mie', 'fluent-cart'),
        'JP25' => __('Shiga', 'fluent-cart'),
        'JP26' => __('Kyoto', 'fluent-cart'),
        'JP27' => __('Osaka', 'fluent-cart'),
        'JP28' => __('Hyogo', 'fluent-cart'),
        'JP29' => __('Nara', 'fluent-cart'),
        'JP30' => __('Wakayama', 'fluent-cart'),
        'JP31' => __('Tottori', 'fluent-cart'),
        'JP32' => __('Shimane', 'fluent-cart'),
        'JP33' => __('Okayama', 'fluent-cart'),
        'JP34' => __('Hiroshima', 'fluent-cart'),
        'JP35' => __('Yamaguchi', 'fluent-cart'),
        'JP36' => __('Tokushima', 'fluent-cart'),
        'JP37' => __('Kagawa', 'fluent-cart'),
        'JP38' => __('Ehime', 'fluent-cart'),
        'JP39' => __('Kochi', 'fluent-cart'),
        'JP40' => __('Fukuoka', 'fluent-cart'),
        'JP41' => __('Saga', 'fluent-cart'),
        'JP42' => __('Nagasaki', 'fluent-cart'),
        'JP43' => __('Kumamoto', 'fluent-cart'),
        'JP44' => __('Oita', 'fluent-cart'),
        'JP45' => __('Miyazaki', 'fluent-cart'),
        'JP46' => __('Kagoshima', 'fluent-cart'),
        'JP47' => __('Okinawa', 'fluent-cart'),
    ),
    'KE' => array( // Kenyan counties.
        'KE01' => __('Baringo', 'fluent-cart'),
        'KE02' => __('Bomet', 'fluent-cart'),
        'KE03' => __('Bungoma', 'fluent-cart'),
        'KE04' => __('Busia', 'fluent-cart'),
        'KE05' => __('Elgeyo-Marakwet', 'fluent-cart'),
        'KE06' => __('Embu', 'fluent-cart'),
        'KE07' => __('Garissa', 'fluent-cart'),
        'KE08' => __('Homa Bay', 'fluent-cart'),
        'KE09' => __('Isiolo', 'fluent-cart'),
        'KE10' => __('Kajiado', 'fluent-cart'),
        'KE11' => __('Kakamega', 'fluent-cart'),
        'KE12' => __('Kericho', 'fluent-cart'),
        'KE13' => __('Kiambu', 'fluent-cart'),
        'KE14' => __('Kilifi', 'fluent-cart'),
        'KE15' => __('Kirinyaga', 'fluent-cart'),
        'KE16' => __('Kisii', 'fluent-cart'),
        'KE17' => __('Kisumu', 'fluent-cart'),
        'KE18' => __('Kitui', 'fluent-cart'),
        'KE19' => __('Kwale', 'fluent-cart'),
        'KE20' => __('Laikipia', 'fluent-cart'),
        'KE21' => __('Lamu', 'fluent-cart'),
        'KE22' => __('Machakos', 'fluent-cart'),
        'KE23' => __('Makueni', 'fluent-cart'),
        'KE24' => __('Mandera', 'fluent-cart'),
        'KE25' => __('Marsabit', 'fluent-cart'),
        'KE26' => __('Meru', 'fluent-cart'),
        'KE27' => __('Migori', 'fluent-cart'),
        'KE28' => __('Mombasa', 'fluent-cart'),
        'KE29' => __('Murang’a', 'fluent-cart'),
        'KE30' => __('Nairobi County', 'fluent-cart'),
        'KE31' => __('Nakuru', 'fluent-cart'),
        'KE32' => __('Nandi', 'fluent-cart'),
        'KE33' => __('Narok', 'fluent-cart'),
        'KE34' => __('Nyamira', 'fluent-cart'),
        'KE35' => __('Nyandarua', 'fluent-cart'),
        'KE36' => __('Nyeri', 'fluent-cart'),
        'KE37' => __('Samburu', 'fluent-cart'),
        'KE38' => __('Siaya', 'fluent-cart'),
        'KE39' => __('Taita-Taveta', 'fluent-cart'),
        'KE40' => __('Tana River', 'fluent-cart'),
        'KE41' => __('Tharaka-Nithi', 'fluent-cart'),
        'KE42' => __('Trans Nzoia', 'fluent-cart'),
        'KE43' => __('Turkana', 'fluent-cart'),
        'KE44' => __('Uasin Gishu', 'fluent-cart'),
        'KE45' => __('Vihiga', 'fluent-cart'),
        'KE46' => __('Wajir', 'fluent-cart'),
        'KE47' => __('West Pokot', 'fluent-cart'),
    ),
    'KN' => array( // Saint Kitts and Nevis parishes.
        'KNK' => __('Saint Kitts', 'fluent-cart'),
        'KNN' => __('Nevis', 'fluent-cart'),
        'KN01' => __('Christ Church Nichola Town', 'fluent-cart'),
        'KN02' => __('Saint Anne Sandy Point', 'fluent-cart'),
        'KN03' => __('Saint George Basseterre', 'fluent-cart'),
        'KN04' => __('Saint George Gingerland', 'fluent-cart'),
        'KN05' => __('Saint James Windward', 'fluent-cart'),
        'KN06' => __('Saint John Capisterre', 'fluent-cart'),
        'KN07' => __('Saint John Figtree', 'fluent-cart'),
        'KN08' => __('Saint Mary Cayon', 'fluent-cart'),
        'KN09' => __('Saint Paul Capisterre', 'fluent-cart'),
        'KN10' => __('Saint Paul Charlestown', 'fluent-cart'),
        'KN11' => __('Saint Peter Basseterre', 'fluent-cart'),
        'KN12' => __('Saint Thomas Lowland', 'fluent-cart'),
        'KN13' => __('Saint Thomas Middle Island', 'fluent-cart'),
        'KN15' => __('Trinity Palmetto Point', 'fluent-cart'),
    ),
    'KR' => array(),
    'KW' => array(),
    'LA' => array( // Laotian provinces.
        'AT' => __('Attapeu', 'fluent-cart'),
        'BK' => __('Bokeo', 'fluent-cart'),
        'BL' => __('Bolikhamsai', 'fluent-cart'),
        'CH' => __('Champasak', 'fluent-cart'),
        'HO' => __('Houaphanh', 'fluent-cart'),
        'KH' => __('Khammouane', 'fluent-cart'),
        'LM' => __('Luang Namtha', 'fluent-cart'),
        'LP' => __('Luang Prabang', 'fluent-cart'),
        'OU' => __('Oudomxay', 'fluent-cart'),
        'PH' => __('Phongsaly', 'fluent-cart'),
        'SL' => __('Salavan', 'fluent-cart'),
        'SV' => __('Savannakhet', 'fluent-cart'),
        'VI' => __('Vientiane Province', 'fluent-cart'),
        'VT' => __('Vientiane', 'fluent-cart'),
        'XA' => __('Sainyabuli', 'fluent-cart'),
        'XE' => __('Sekong', 'fluent-cart'),
        'XI' => __('Xiangkhouang', 'fluent-cart'),
        'XS' => __('Xaisomboun', 'fluent-cart'),
    ),
    'LB' => array(),
    'LI' => array(),
    'LR' => array( // Liberian provinces.
        'BM' => __('Bomi', 'fluent-cart'),
        'BN' => __('Bong', 'fluent-cart'),
        'GA' => __('Gbarpolu', 'fluent-cart'),
        'GB' => __('Grand Bassa', 'fluent-cart'),
        'GC' => __('Grand Cape Mount', 'fluent-cart'),
        'GG' => __('Grand Gedeh', 'fluent-cart'),
        'GK' => __('Grand Kru', 'fluent-cart'),
        'LO' => __('Lofa', 'fluent-cart'),
        'MA' => __('Margibi', 'fluent-cart'),
        'MY' => __('Maryland', 'fluent-cart'),
        'MO' => __('Montserrado', 'fluent-cart'),
        'NM' => __('Nimba', 'fluent-cart'),
        'RV' => __('Rivercess', 'fluent-cart'),
        'RG' => __('River Gee', 'fluent-cart'),
        'SN' => __('Sinoe', 'fluent-cart'),
    ),
    'LU' => array(),
    'MA' => array( // Moroccan regions.
        'maagd' => __('Agadir-Ida Ou Tanane', 'fluent-cart'),
        'maazi' => __('Azilal', 'fluent-cart'),
        'mabem' => __('Béni-Mellal', 'fluent-cart'),
        'maber' => __('Berkane', 'fluent-cart'),
        'mabes' => __('Ben Slimane', 'fluent-cart'),
        'mabod' => __('Boujdour', 'fluent-cart'),
        'mabom' => __('Boulemane', 'fluent-cart'),
        'mabrr' => __('Berrechid', 'fluent-cart'),
        'macas' => __('Casablanca', 'fluent-cart'),
        'mache' => __('Chefchaouen', 'fluent-cart'),
        'machi' => __('Chichaoua', 'fluent-cart'),
        'macht' => __('Chtouka Aït Baha', 'fluent-cart'),
        'madri' => __('Driouch', 'fluent-cart'),
        'maedi' => __('Essaouira', 'fluent-cart'),
        'maerr' => __('Errachidia', 'fluent-cart'),
        'mafah' => __('Fahs-Beni Makada', 'fluent-cart'),
        'mafes' => __('Fès-Dar-Dbibegh', 'fluent-cart'),
        'mafig' => __('Figuig', 'fluent-cart'),
        'mafqh' => __('Fquih Ben Salah', 'fluent-cart'),
        'mafes' => __('Fès-Dar-Dbibegh', 'fluent-cart'),
        'mague' => __('Guelmim', 'fluent-cart'),
        'maguf' => __('Guercif', 'fluent-cart'),
        'mahaj' => __('El Hajeb', 'fluent-cart'),
        'mahao' => __('Al Haouz', 'fluent-cart'),
        'mahoc' => __('Al Hoceïma', 'fluent-cart'),
        'maifr' => __('Ifrane', 'fluent-cart'),
        'maine' => __('Inezgane-Aït Melloul', 'fluent-cart'),
        'majdi' => __('El Jadida', 'fluent-cart'),
        'majra' => __('Jerada', 'fluent-cart'),
        'maken' => __('Kénitra', 'fluent-cart'),
        'makes' => __('Kelaat Sraghna', 'fluent-cart'),
        'makhe' => __('Khemisset', 'fluent-cart'),
        'makhn' => __('Khénifra', 'fluent-cart'),
        'makho' => __('Khouribga', 'fluent-cart'),
        'malaa' => __('Laâyoune', 'fluent-cart'),
        'malar' => __('Larache', 'fluent-cart'),
        'mamar' => __('Marrakech', 'fluent-cart'),
        'mamdf' => __('M’diq-Fnideq', 'fluent-cart'),
        'mamed' => __('Médiouna', 'fluent-cart'),
        'mamek' => __('Meknès', 'fluent-cart'),
        'mamid' => __('Midelt', 'fluent-cart'),
        'mammd' => __('Marrakech-Medina', 'fluent-cart'),
        'mammn' => __('Marrakech-Menara', 'fluent-cart'),
        'mamoh' => __('Mohammedia', 'fluent-cart'),
        'mamou' => __('Moulay Yacoub', 'fluent-cart'),
        'manad' => __('Nador', 'fluent-cart'),
        'manou' => __('Nouaceur', 'fluent-cart'),
        'maoua' => __('Ouarzazate', 'fluent-cart'),
        'maoud' => __('Oued Ed-Dahab', 'fluent-cart'),
        'maouj' => __('Oujda-Angad', 'fluent-cart'),
        'maouz' => __('Ouezzane', 'fluent-cart'),
        'marab' => __('Rabat', 'fluent-cart'),
        'mareh' => __('Rehamna', 'fluent-cart'),
        'masaf' => __('Safi', 'fluent-cart'),
        'masal' => __('Salé', 'fluent-cart'),
        'masef' => __('Sefrou', 'fluent-cart'),
        'maset' => __('Settat', 'fluent-cart'),
        'masib' => __('Sidi Bennour', 'fluent-cart'),
        'masif' => __('Sidi Ifni', 'fluent-cart'),
        'masik' => __('Sidi Kacem', 'fluent-cart'),
        'masil' => __('Sidi Slimane', 'fluent-cart'),
        'maskh' => __('Skhirat-Témara', 'fluent-cart'),
        'masyb' => __('Sidi Youssef Ben Ali', 'fluent-cart'),
        'mataf' => __('Tarfaya (EH-partial)', 'fluent-cart'),
        'matai' => __('Taourirt', 'fluent-cart'),
        'matao' => __('Taounate', 'fluent-cart'),
        'matar' => __('Taroudant', 'fluent-cart'),
        'matat' => __('Tata', 'fluent-cart'),
        'mataz' => __('Taza', 'fluent-cart'),
        'matet' => __('Tétouan', 'fluent-cart'),
        'matin' => __('Tinghir', 'fluent-cart'),
        'matiz' => __('Tiznit', 'fluent-cart'),
        'matng' => __('Tangier-Assilah', 'fluent-cart'),
        'matnt' => __('Tan-Tan', 'fluent-cart'),
        'mayus' => __('Youssoufia', 'fluent-cart'),
        'mazag' => __('Zagora', 'fluent-cart')
    ),
    'MD' => array( // Moldovan states.
        'C' => __('Chișinău', 'fluent-cart'),
        'BL' => __('Bălți', 'fluent-cart'),
        'AN' => __('Anenii Noi', 'fluent-cart'),
        'BS' => __('Basarabeasca', 'fluent-cart'),
        'BR' => __('Briceni', 'fluent-cart'),
        'CH' => __('Cahul', 'fluent-cart'),
        'CT' => __('Cantemir', 'fluent-cart'),
        'CL' => __('Călărași', 'fluent-cart'),
        'CS' => __('Căușeni', 'fluent-cart'),
        'CM' => __('Cimișlia', 'fluent-cart'),
        'CR' => __('Criuleni', 'fluent-cart'),
        'DN' => __('Dondușeni', 'fluent-cart'),
        'DR' => __('Drochia', 'fluent-cart'),
        'DB' => __('Dubăsari', 'fluent-cart'),
        'ED' => __('Edineț', 'fluent-cart'),
        'FL' => __('Fălești', 'fluent-cart'),
        'FR' => __('Florești', 'fluent-cart'),
        'GE' => __('UTA Găgăuzia', 'fluent-cart'),
        'GL' => __('Glodeni', 'fluent-cart'),
        'HN' => __('Hîncești', 'fluent-cart'),
        'IL' => __('Ialoveni', 'fluent-cart'),
        'LV' => __('Leova', 'fluent-cart'),
        'NS' => __('Nisporeni', 'fluent-cart'),
        'OC' => __('Ocnița', 'fluent-cart'),
        'OR' => __('Orhei', 'fluent-cart'),
        'RZ' => __('Rezina', 'fluent-cart'),
        'RS' => __('Rîșcani', 'fluent-cart'),
        'SG' => __('Sîngerei', 'fluent-cart'),
        'SR' => __('Soroca', 'fluent-cart'),
        'ST' => __('Strășeni', 'fluent-cart'),
        'SD' => __('Șoldănești', 'fluent-cart'),
        'SV' => __('Ștefan Vodă', 'fluent-cart'),
        'TR' => __('Taraclia', 'fluent-cart'),
        'TL' => __('Telenești', 'fluent-cart'),
        'UN' => __('Ungheni', 'fluent-cart'),
    ),
    'MF' => array(),
    'MQ' => array(),
    'MT' => array(),
    'MX' => array( // Mexican states.
        'DF' => __('Ciudad de México', 'fluent-cart'),
        'JA' => __('Jalisco', 'fluent-cart'),
        'NL' => __('Nuevo León', 'fluent-cart'),
        'AG' => __('Aguascalientes', 'fluent-cart'),
        'BC' => __('Baja California', 'fluent-cart'),
        'BS' => __('Baja California Sur', 'fluent-cart'),
        'CM' => __('Campeche', 'fluent-cart'),
        'CS' => __('Chiapas', 'fluent-cart'),
        'CH' => __('Chihuahua', 'fluent-cart'),
        'CO' => __('Coahuila', 'fluent-cart'),
        'CL' => __('Colima', 'fluent-cart'),
        'DG' => __('Durango', 'fluent-cart'),
        'GT' => __('Guanajuato', 'fluent-cart'),
        'GR' => __('Guerrero', 'fluent-cart'),
        'HG' => __('Hidalgo', 'fluent-cart'),
        'MX' => __('Estado de México', 'fluent-cart'),
        'MI' => __('Michoacán', 'fluent-cart'),
        'MO' => __('Morelos', 'fluent-cart'),
        'NA' => __('Nayarit', 'fluent-cart'),
        'OA' => __('Oaxaca', 'fluent-cart'),
        'PU' => __('Puebla', 'fluent-cart'),
        'QT' => __('Querétaro', 'fluent-cart'),
        'QR' => __('Quintana Roo', 'fluent-cart'),
        'SL' => __('San Luis Potosí', 'fluent-cart'),
        'SI' => __('Sinaloa', 'fluent-cart'),
        'SO' => __('Sonora', 'fluent-cart'),
        'TB' => __('Tabasco', 'fluent-cart'),
        'TM' => __('Tamaulipas', 'fluent-cart'),
        'TL' => __('Tlaxcala', 'fluent-cart'),
        'VE' => __('Veracruz', 'fluent-cart'),
        'YU' => __('Yucatán', 'fluent-cart'),
        'ZA' => __('Zacatecas', 'fluent-cart'),
    ),
    'MY' => array( // Malaysian states.
        'JHR' => __('Johor', 'fluent-cart'),
        'KDH' => __('Kedah', 'fluent-cart'),
        'KTN' => __('Kelantan', 'fluent-cart'),
        'LBN' => __('Labuan', 'fluent-cart'),
        'MLK' => __('Malacca (Melaka)', 'fluent-cart'),
        'NSN' => __('Negeri Sembilan', 'fluent-cart'),
        'PHG' => __('Pahang', 'fluent-cart'),
        'PNG' => __('Penang (Pulau Pinang)', 'fluent-cart'),
        'PRK' => __('Perak', 'fluent-cart'),
        'PLS' => __('Perlis', 'fluent-cart'),
        'SBH' => __('Sabah', 'fluent-cart'),
        'SWK' => __('Sarawak', 'fluent-cart'),
        'SGR' => __('Selangor', 'fluent-cart'),
        'TRG' => __('Terengganu', 'fluent-cart'),
        'PJY' => __('Putrajaya', 'fluent-cart'),
        'KUL' => __('Kuala Lumpur', 'fluent-cart'),
    ),
    'MZ' => array( // Mozambican provinces.
        'MZP' => __('Cabo Delgado', 'fluent-cart'),
        'MZG' => __('Gaza', 'fluent-cart'),
        'MZI' => __('Inhambane', 'fluent-cart'),
        'MZB' => __('Manica', 'fluent-cart'),
        'MZL' => __('Maputo Province', 'fluent-cart'),
        'MZMPM' => __('Maputo', 'fluent-cart'),
        'MZN' => __('Nampula', 'fluent-cart'),
        'MZA' => __('Niassa', 'fluent-cart'),
        'MZS' => __('Sofala', 'fluent-cart'),
        'MZT' => __('Tete', 'fluent-cart'),
        'MZQ' => __('Zambézia', 'fluent-cart'),
    ),
    'NA' => array( // Namibian regions.
        'ER' => __('Erongo', 'fluent-cart'),
        'HA' => __('Hardap', 'fluent-cart'),
        'KA' => __('Karas', 'fluent-cart'),
        'KE' => __('Kavango East', 'fluent-cart'),
        'KW' => __('Kavango West', 'fluent-cart'),
        'KH' => __('Khomas', 'fluent-cart'),
        'KU' => __('Kunene', 'fluent-cart'),
        'OW' => __('Ohangwena', 'fluent-cart'),
        'OH' => __('Omaheke', 'fluent-cart'),
        'OS' => __('Omusati', 'fluent-cart'),
        'ON' => __('Oshana', 'fluent-cart'),
        'OT' => __('Oshikoto', 'fluent-cart'),
        'OD' => __('Otjozondjupa', 'fluent-cart'),
        'CA' => __('Zambezi', 'fluent-cart'),
    ),
    'NG' => array( // Nigerian provinces.
        'AB' => __('Abia', 'fluent-cart'),
        'FC' => __('Abuja', 'fluent-cart'),
        'AD' => __('Adamawa', 'fluent-cart'),
        'AK' => __('Akwa Ibom', 'fluent-cart'),
        'AN' => __('Anambra', 'fluent-cart'),
        'BA' => __('Bauchi', 'fluent-cart'),
        'BY' => __('Bayelsa', 'fluent-cart'),
        'BE' => __('Benue', 'fluent-cart'),
        'BO' => __('Borno', 'fluent-cart'),
        'CR' => __('Cross River', 'fluent-cart'),
        'DE' => __('Delta', 'fluent-cart'),
        'EB' => __('Ebonyi', 'fluent-cart'),
        'ED' => __('Edo', 'fluent-cart'),
        'EK' => __('Ekiti', 'fluent-cart'),
        'EN' => __('Enugu', 'fluent-cart'),
        'GO' => __('Gombe', 'fluent-cart'),
        'IM' => __('Imo', 'fluent-cart'),
        'JI' => __('Jigawa', 'fluent-cart'),
        'KD' => __('Kaduna', 'fluent-cart'),
        'KN' => __('Kano', 'fluent-cart'),
        'KT' => __('Katsina', 'fluent-cart'),
        'KE' => __('Kebbi', 'fluent-cart'),
        'KO' => __('Kogi', 'fluent-cart'),
        'KW' => __('Kwara', 'fluent-cart'),
        'LA' => __('Lagos', 'fluent-cart'),
        'NA' => __('Nasarawa', 'fluent-cart'),
        'NI' => __('Niger', 'fluent-cart'),
        'OG' => __('Ogun', 'fluent-cart'),
        'ON' => __('Ondo', 'fluent-cart'),
        'OS' => __('Osun', 'fluent-cart'),
        'OY' => __('Oyo', 'fluent-cart'),
        'PL' => __('Plateau', 'fluent-cart'),
        'RI' => __('Rivers', 'fluent-cart'),
        'SO' => __('Sokoto', 'fluent-cart'),
        'TA' => __('Taraba', 'fluent-cart'),
        'YO' => __('Yobe', 'fluent-cart'),
        'ZA' => __('Zamfara', 'fluent-cart'),
    ),
    'NL' => array(),
    'NO' => array(),
    'NP' => array( // Nepalese zones.
        'BAG' => __('Bagmati', 'fluent-cart'),
        'BHE' => __('Bheri', 'fluent-cart'),
        'DHA' => __('Dhaulagiri', 'fluent-cart'),
        'GAN' => __('Gandaki', 'fluent-cart'),
        'JAN' => __('Janakpur', 'fluent-cart'),
        'KAR' => __('Karnali', 'fluent-cart'),
        'KOS' => __('Koshi', 'fluent-cart'),
        'LUM' => __('Lumbini', 'fluent-cart'),
        'MAH' => __('Mahakali', 'fluent-cart'),
        'MEC' => __('Mechi', 'fluent-cart'),
        'NAR' => __('Narayani', 'fluent-cart'),
        'RAP' => __('Rapti', 'fluent-cart'),
        'SAG' => __('Sagarmatha', 'fluent-cart'),
        'SET' => __('Seti', 'fluent-cart'),
    ),
    'NI' => array( // Nicaraguan states.
        'NI-AN' => __('Atlántico Norte', 'fluent-cart'),
        'NI-AS' => __('Atlántico Sur', 'fluent-cart'),
        'NI-BO' => __('Boaco', 'fluent-cart'),
        'NI-CA' => __('Carazo', 'fluent-cart'),
        'NI-CI' => __('Chinandega', 'fluent-cart'),
        'NI-CO' => __('Chontales', 'fluent-cart'),
        'NI-ES' => __('Estelí', 'fluent-cart'),
        'NI-GR' => __('Granada', 'fluent-cart'),
        'NI-JI' => __('Jinotega', 'fluent-cart'),
        'NI-LE' => __('León', 'fluent-cart'),
        'NI-MD' => __('Madriz', 'fluent-cart'),
        'NI-MN' => __('Managua', 'fluent-cart'),
        'NI-MS' => __('Masaya', 'fluent-cart'),
        'NI-MT' => __('Matagalpa', 'fluent-cart'),
        'NI-NS' => __('Nueva Segovia', 'fluent-cart'),
        'NI-RI' => __('Rivas', 'fluent-cart'),
        'NI-SJ' => __('Río San Juan', 'fluent-cart'),
    ),
    'NZ' => array( // New Zealand states.
        'NTL' => __('Northland', 'fluent-cart'),
        'AUK' => __('Auckland', 'fluent-cart'),
        'WKO' => __('Waikato', 'fluent-cart'),
        'BOP' => __('Bay of Plenty', 'fluent-cart'),
        'TKI' => __('Taranaki', 'fluent-cart'),
        'GIS' => __('Gisborne', 'fluent-cart'),
        'HKB' => __('Hawke’s Bay', 'fluent-cart'),
        'MWT' => __('Manawatu-Whanganui', 'fluent-cart'),
        'WGN' => __('Wellington', 'fluent-cart'),
        'NSN' => __('Nelson', 'fluent-cart'),
        'MBH' => __('Marlborough', 'fluent-cart'),
        'TAS' => __('Tasman', 'fluent-cart'),
        'WTC' => __('West Coast', 'fluent-cart'),
        'CAN' => __('Canterbury', 'fluent-cart'),
        'OTA' => __('Otago', 'fluent-cart'),
        'STL' => __('Southland', 'fluent-cart'),
    ),
    'PA' => array( // Panamanian states.
        'PA-1' => __('Bocas del Toro', 'fluent-cart'),
        'PA-2' => __('Coclé', 'fluent-cart'),
        'PA-3' => __('Colón', 'fluent-cart'),
        'PA-4' => __('Chiriquí', 'fluent-cart'),
        'PA-5' => __('Darién', 'fluent-cart'),
        'PA-6' => __('Herrera', 'fluent-cart'),
        'PA-7' => __('Los Santos', 'fluent-cart'),
        'PA-8' => __('Panamá', 'fluent-cart'),
        'PA-9' => __('Veraguas', 'fluent-cart'),
        'PA-10' => __('West Panamá', 'fluent-cart'),
        'PA-EM' => __('Emberá', 'fluent-cart'),
        'PA-KY' => __('Guna Yala', 'fluent-cart'),
        'PA-NB' => __('Ngöbe-Buglé', 'fluent-cart'),
    ),
    'PE' => array( // Peruvian states.
        'CAL' => __('El Callao', 'fluent-cart'),
        'LMA' => __('Municipalidad Metropolitana de Lima', 'fluent-cart'),
        'AMA' => __('Amazonas', 'fluent-cart'),
        'ANC' => __('Ancash', 'fluent-cart'),
        'APU' => __('Apurímac', 'fluent-cart'),
        'ARE' => __('Arequipa', 'fluent-cart'),
        'AYA' => __('Ayacucho', 'fluent-cart'),
        'CAJ' => __('Cajamarca', 'fluent-cart'),
        'CUS' => __('Cusco', 'fluent-cart'),
        'HUV' => __('Huancavelica', 'fluent-cart'),
        'HUC' => __('Huánuco', 'fluent-cart'),
        'ICA' => __('Ica', 'fluent-cart'),
        'JUN' => __('Junín', 'fluent-cart'),
        'LAL' => __('La Libertad', 'fluent-cart'),
        'LAM' => __('Lambayeque', 'fluent-cart'),
        'LIM' => __('Lima', 'fluent-cart'),
        'LOR' => __('Loreto', 'fluent-cart'),
        'MDD' => __('Madre de Dios', 'fluent-cart'),
        'MOQ' => __('Moquegua', 'fluent-cart'),
        'PAS' => __('Pasco', 'fluent-cart'),
        'PIU' => __('Piura', 'fluent-cart'),
        'PUN' => __('Puno', 'fluent-cart'),
        'SAM' => __('San Martín', 'fluent-cart'),
        'TAC' => __('Tacna', 'fluent-cart'),
        'TUM' => __('Tumbes', 'fluent-cart'),
        'UCA' => __('Ucayali', 'fluent-cart'),
    ),
    'PH' => array( // Philippine provinces.
        'ABR' => __('Abra', 'fluent-cart'),
        'AGN' => __('Agusan del Norte', 'fluent-cart'),
        'AGS' => __('Agusan del Sur', 'fluent-cart'),
        'AKL' => __('Aklan', 'fluent-cart'),
        'ALB' => __('Albay', 'fluent-cart'),
        'ANT' => __('Antique', 'fluent-cart'),
        'APA' => __('Apayao', 'fluent-cart'),
        'AUR' => __('Aurora', 'fluent-cart'),
        'BAS' => __('Basilan', 'fluent-cart'),
        'BAN' => __('Bataan', 'fluent-cart'),
        'BTN' => __('Batanes', 'fluent-cart'),
        'BTG' => __('Batangas', 'fluent-cart'),
        'BEN' => __('Benguet', 'fluent-cart'),
        'BIL' => __('Biliran', 'fluent-cart'),
        'BOH' => __('Bohol', 'fluent-cart'),
        'BUK' => __('Bukidnon', 'fluent-cart'),
        'BUL' => __('Bulacan', 'fluent-cart'),
        'CAG' => __('Cagayan', 'fluent-cart'),
        'CAN' => __('Camarines Norte', 'fluent-cart'),
        'CAS' => __('Camarines Sur', 'fluent-cart'),
        'CAM' => __('Camiguin', 'fluent-cart'),
        'CAP' => __('Capiz', 'fluent-cart'),
        'CAT' => __('Catanduanes', 'fluent-cart'),
        'CAV' => __('Cavite', 'fluent-cart'),
        'CEB' => __('Cebu', 'fluent-cart'),
        'COM' => __('Compostela Valley', 'fluent-cart'),
        'NCO' => __('Cotabato', 'fluent-cart'),
        'DAV' => __('Davao del Norte', 'fluent-cart'),
        'DAS' => __('Davao del Sur', 'fluent-cart'),
        'DAC' => __('Davao Occidental', 'fluent-cart'),
        'DAO' => __('Davao Oriental', 'fluent-cart'),
        'DIN' => __('Dinagat Islands', 'fluent-cart'),
        'EAS' => __('Eastern Samar', 'fluent-cart'),
        'GUI' => __('Guimaras', 'fluent-cart'),
        'IFU' => __('Ifugao', 'fluent-cart'),
        'ILN' => __('Ilocos Norte', 'fluent-cart'),
        'ILS' => __('Ilocos Sur', 'fluent-cart'),
        'ILI' => __('Iloilo', 'fluent-cart'),
        'ISA' => __('Isabela', 'fluent-cart'),
        'KAL' => __('Kalinga', 'fluent-cart'),
        'LUN' => __('La Union', 'fluent-cart'),
        'LAG' => __('Laguna', 'fluent-cart'),
        'LAN' => __('Lanao del Norte', 'fluent-cart'),
        'LAS' => __('Lanao del Sur', 'fluent-cart'),
        'LEY' => __('Leyte', 'fluent-cart'),
        'MAG' => __('Maguindanao', 'fluent-cart'),
        'MAD' => __('Marinduque', 'fluent-cart'),
        'MAS' => __('Masbate', 'fluent-cart'),
        'MSC' => __('Misamis Occidental', 'fluent-cart'),
        'MSR' => __('Misamis Oriental', 'fluent-cart'),
        'MOU' => __('Mountain Province', 'fluent-cart'),
        'NEC' => __('Negros Occidental', 'fluent-cart'),
        'NER' => __('Negros Oriental', 'fluent-cart'),
        'NSA' => __('Northern Samar', 'fluent-cart'),
        'NUE' => __('Nueva Ecija', 'fluent-cart'),
        'NUV' => __('Nueva Vizcaya', 'fluent-cart'),
        'MDC' => __('Occidental Mindoro', 'fluent-cart'),
        'MDR' => __('Oriental Mindoro', 'fluent-cart'),
        'PLW' => __('Palawan', 'fluent-cart'),
        'PAM' => __('Pampanga', 'fluent-cart'),
        'PAN' => __('Pangasinan', 'fluent-cart'),
        'QUE' => __('Quezon', 'fluent-cart'),
        'QUI' => __('Quirino', 'fluent-cart'),
        'RIZ' => __('Rizal', 'fluent-cart'),
        'ROM' => __('Romblon', 'fluent-cart'),
        'WSA' => __('Samar', 'fluent-cart'),
        'SAR' => __('Sarangani', 'fluent-cart'),
        'SIQ' => __('Siquijor', 'fluent-cart'),
        'SOR' => __('Sorsogon', 'fluent-cart'),
        'SCO' => __('South Cotabato', 'fluent-cart'),
        'SLE' => __('Southern Leyte', 'fluent-cart'),
        'SUK' => __('Sultan Kudarat', 'fluent-cart'),
        'SLU' => __('Sulu', 'fluent-cart'),
        'SUN' => __('Surigao del Norte', 'fluent-cart'),
        'SUR' => __('Surigao del Sur', 'fluent-cart'),
        'TAR' => __('Tarlac', 'fluent-cart'),
        'TAW' => __('Tawi-Tawi', 'fluent-cart'),
        'ZMB' => __('Zambales', 'fluent-cart'),
        'ZAN' => __('Zamboanga del Norte', 'fluent-cart'),
        'ZAS' => __('Zamboanga del Sur', 'fluent-cart'),
        'ZSI' => __('Zamboanga Sibugay', 'fluent-cart'),
        '00' => __('Metro Manila', 'fluent-cart'),
    ),
    'PK' => array( // Pakistani states.
        'JK' => __('Azad Kashmir', 'fluent-cart'),
        'BA' => __('Balochistan', 'fluent-cart'),
        'TA' => __('FATA', 'fluent-cart'),
        'GB' => __('Gilgit Baltistan', 'fluent-cart'),
        'IS' => __('Islamabad Capital Territory', 'fluent-cart'),
        'KP' => __('Khyber Pakhtunkhwa', 'fluent-cart'),
        'PB' => __('Punjab', 'fluent-cart'),
        'SD' => __('Sindh', 'fluent-cart'),
    ),
    'PL' => array(),
    'PR' => array(),
    'PT' => array(),
    'PY' => array( // Paraguayan states.
        'PY-ASU' => __('Asunción', 'fluent-cart'),
        'PY-1' => __('Concepción', 'fluent-cart'),
        'PY-2' => __('San Pedro', 'fluent-cart'),
        'PY-3' => __('Cordillera', 'fluent-cart'),
        'PY-4' => __('Guairá', 'fluent-cart'),
        'PY-5' => __('Caaguazú', 'fluent-cart'),
        'PY-6' => __('Caazapá', 'fluent-cart'),
        'PY-7' => __('Itapúa', 'fluent-cart'),
        'PY-8' => __('Misiones', 'fluent-cart'),
        'PY-9' => __('Paraguarí', 'fluent-cart'),
        'PY-10' => __('Alto Paraná', 'fluent-cart'),
        'PY-11' => __('Central', 'fluent-cart'),
        'PY-12' => __('Ñeembucú', 'fluent-cart'),
        'PY-13' => __('Amambay', 'fluent-cart'),
        'PY-14' => __('Canindeyú', 'fluent-cart'),
        'PY-15' => __('Presidente Hayes', 'fluent-cart'),
        'PY-16' => __('Alto Paraguay', 'fluent-cart'),
        'PY-17' => __('Boquerón', 'fluent-cart'),
    ),
    'RE' => array(),
    'RO' => array( // Romanian states.
        'AB' => __('Alba', 'fluent-cart'),
        'AR' => __('Arad', 'fluent-cart'),
        'AG' => __('Argeș', 'fluent-cart'),
        'BC' => __('Bacău', 'fluent-cart'),
        'BH' => __('Bihor', 'fluent-cart'),
        'BN' => __('Bistrița-Năsăud', 'fluent-cart'),
        'BT' => __('Botoșani', 'fluent-cart'),
        'BR' => __('Brăila', 'fluent-cart'),
        'BV' => __('Brașov', 'fluent-cart'),
        'B' => __('București', 'fluent-cart'),
        'BZ' => __('Buzău', 'fluent-cart'),
        'CL' => __('Călărași', 'fluent-cart'),
        'CS' => __('Caraș-Severin', 'fluent-cart'),
        'CJ' => __('Cluj', 'fluent-cart'),
        'CT' => __('Constanța', 'fluent-cart'),
        'CV' => __('Covasna', 'fluent-cart'),
        'DB' => __('Dâmbovița', 'fluent-cart'),
        'DJ' => __('Dolj', 'fluent-cart'),
        'GL' => __('Galați', 'fluent-cart'),
        'GR' => __('Giurgiu', 'fluent-cart'),
        'GJ' => __('Gorj', 'fluent-cart'),
        'HR' => __('Harghita', 'fluent-cart'),
        'HD' => __('Hunedoara', 'fluent-cart'),
        'IL' => __('Ialomița', 'fluent-cart'),
        'IS' => __('Iași', 'fluent-cart'),
        'IF' => __('Ilfov', 'fluent-cart'),
        'MM' => __('Maramureș', 'fluent-cart'),
        'MH' => __('Mehedinți', 'fluent-cart'),
        'MS' => __('Mureș', 'fluent-cart'),
        'NT' => __('Neamț', 'fluent-cart'),
        'OT' => __('Olt', 'fluent-cart'),
        'PH' => __('Prahova', 'fluent-cart'),
        'SJ' => __('Sălaj', 'fluent-cart'),
        'SM' => __('Satu Mare', 'fluent-cart'),
        'SB' => __('Sibiu', 'fluent-cart'),
        'SV' => __('Suceava', 'fluent-cart'),
        'TR' => __('Teleorman', 'fluent-cart'),
        'TM' => __('Timiș', 'fluent-cart'),
        'TL' => __('Tulcea', 'fluent-cart'),
        'VL' => __('Vâlcea', 'fluent-cart'),
        'VS' => __('Vaslui', 'fluent-cart'),
        'VN' => __('Vrancea', 'fluent-cart'),
    ),
    'SN' => array( // Regions of Senegal. Ref: https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L4801.
        'SNDB' => __('Diourbel', 'fluent-cart'),
        'SNDK' => __('Dakar', 'fluent-cart'),
        'SNFK' => __('Fatick', 'fluent-cart'),
        'SNKA' => __('Kaffrine', 'fluent-cart'),
        'SNKD' => __('Kolda', 'fluent-cart'),
        'SNKE' => __('Kédougou', 'fluent-cart'),
        'SNKL' => __('Kaolack', 'fluent-cart'),
        'SNLG' => __('Louga', 'fluent-cart'),
        'SNMT' => __('Matam', 'fluent-cart'),
        'SNSE' => __('Sédhiou', 'fluent-cart'),
        'SNSL' => __('Saint-Louis', 'fluent-cart'),
        'SNTC' => __('Tambacounda', 'fluent-cart'),
        'SNTH' => __('Thiès', 'fluent-cart'),
        'SNZG' => __('Ziguinchor', 'fluent-cart'),
    ),
    'SG' => array(),
    'SK' => array(),
    'SI' => array(),
    'SV' => array( // Salvadoran states.
        'SV-AH' => __('Ahuachapán', 'fluent-cart'),
        'SV-CA' => __('Cabañas', 'fluent-cart'),
        'SV-CH' => __('Chalatenango', 'fluent-cart'),
        'SV-CU' => __('Cuscatlán', 'fluent-cart'),
        'SV-LI' => __('La Libertad', 'fluent-cart'),
        'SV-MO' => __('Morazán', 'fluent-cart'),
        'SV-PA' => __('La Paz', 'fluent-cart'),
        'SV-SA' => __('Santa Ana', 'fluent-cart'),
        'SV-SM' => __('San Miguel', 'fluent-cart'),
        'SV-SO' => __('Sonsonate', 'fluent-cart'),
        'SV-SS' => __('San Salvador', 'fluent-cart'),
        'SV-SV' => __('San Vicente', 'fluent-cart'),
        'SV-UN' => __('La Unión', 'fluent-cart'),
        'SV-US' => __('Usulután', 'fluent-cart'),
    ),
    'TH' => array( // Thai states.
        'TH-37' => __('Amnat Charoen', 'fluent-cart'),
        'TH-15' => __('Ang Thong', 'fluent-cart'),
        'TH-14' => __('Ayutthaya', 'fluent-cart'),
        'TH-10' => __('Bangkok', 'fluent-cart'),
        'TH-38' => __('Bueng Kan', 'fluent-cart'),
        'TH-31' => __('Buri Ram', 'fluent-cart'),
        'TH-24' => __('Chachoengsao', 'fluent-cart'),
        'TH-18' => __('Chai Nat', 'fluent-cart'),
        'TH-36' => __('Chaiyaphum', 'fluent-cart'),
        'TH-22' => __('Chanthaburi', 'fluent-cart'),
        'TH-50' => __('Chiang Mai', 'fluent-cart'),
        'TH-57' => __('Chiang Rai', 'fluent-cart'),
        'TH-20' => __('Chonburi', 'fluent-cart'),
        'TH-86' => __('Chumphon', 'fluent-cart'),
        'TH-46' => __('Kalasin', 'fluent-cart'),
        'TH-62' => __('Kamphaeng Phet', 'fluent-cart'),
        'TH-71' => __('Kanchanaburi', 'fluent-cart'),
        'TH-40' => __('Khon Kaen', 'fluent-cart'),
        'TH-81' => __('Krabi', 'fluent-cart'),
        'TH-52' => __('Lampang', 'fluent-cart'),
        'TH-51' => __('Lamphun', 'fluent-cart'),
        'TH-42' => __('Loei', 'fluent-cart'),
        'TH-16' => __('Lopburi', 'fluent-cart'),
        'TH-58' => __('Mae Hong Son', 'fluent-cart'),
        'TH-44' => __('Maha Sarakham', 'fluent-cart'),
        'TH-49' => __('Mukdahan', 'fluent-cart'),
        'TH-26' => __('Nakhon Nayok', 'fluent-cart'),
        'TH-73' => __('Nakhon Pathom', 'fluent-cart'),
        'TH-48' => __('Nakhon Phanom', 'fluent-cart'),
        'TH-30' => __('Nakhon Ratchasima', 'fluent-cart'),
        'TH-60' => __('Nakhon Sawan', 'fluent-cart'),
        'TH-80' => __('Nakhon Si Thammarat', 'fluent-cart'),
        'TH-55' => __('Nan', 'fluent-cart'),
        'TH-96' => __('Narathiwat', 'fluent-cart'),
        'TH-39' => __('Nong Bua Lam Phu', 'fluent-cart'),
        'TH-43' => __('Nong Khai', 'fluent-cart'),
        'TH-12' => __('Nonthaburi', 'fluent-cart'),
        'TH-13' => __('Pathum Thani', 'fluent-cart'),
        'TH-94' => __('Pattani', 'fluent-cart'),
        'TH-82' => __('Phang Nga', 'fluent-cart'),
        'TH-93' => __('Phatthalung', 'fluent-cart'),
        'TH-56' => __('Phayao', 'fluent-cart'),
        'TH-67' => __('Phetchabun', 'fluent-cart'),
        'TH-76' => __('Phetchaburi', 'fluent-cart'),
        'TH-66' => __('Phichit', 'fluent-cart'),
        'TH-65' => __('Phitsanulok', 'fluent-cart'),
        'TH-54' => __('Phrae', 'fluent-cart'),
        'TH-83' => __('Phuket', 'fluent-cart'),
        'TH-25' => __('Prachin Buri', 'fluent-cart'),
        'TH-77' => __('Prachuap Khiri Khan', 'fluent-cart'),
        'TH-85' => __('Ranong', 'fluent-cart'),
        'TH-70' => __('Ratchaburi', 'fluent-cart'),
        'TH-21' => __('Rayong', 'fluent-cart'),
        'TH-45' => __('Roi Et', 'fluent-cart'),
        'TH-27' => __('Sa Kaeo', 'fluent-cart'),
        'TH-47' => __('Sakon Nakhon', 'fluent-cart'),
        'TH-11' => __('Samut Prakan', 'fluent-cart'),
        'TH-74' => __('Samut Sakhon', 'fluent-cart'),
        'TH-75' => __('Samut Songkhram', 'fluent-cart'),
        'TH-19' => __('Saraburi', 'fluent-cart'),
        'TH-91' => __('Satun', 'fluent-cart'),
        'TH-17' => __('Sing Buri', 'fluent-cart'),
        'TH-33' => __('Sisaket', 'fluent-cart'),
        'TH-90' => __('Songkhla', 'fluent-cart'),
        'TH-64' => __('Sukhothai', 'fluent-cart'),
        'TH-72' => __('Suphan Buri', 'fluent-cart'),
        'TH-84' => __('Surat Thani', 'fluent-cart'),
        'TH-32' => __('Surin', 'fluent-cart'),
        'TH-63' => __('Tak', 'fluent-cart'),
        'TH-92' => __('Trang', 'fluent-cart'),
        'TH-23' => __('Trat', 'fluent-cart'),
        'TH-34' => __('Ubon Ratchathani', 'fluent-cart'),
        'TH-41' => __('Udon Thani', 'fluent-cart'),
        'TH-61' => __('Uthai Thani', 'fluent-cart'),
        'TH-53' => __('Uttaradit', 'fluent-cart'),
        'TH-95' => __('Yala', 'fluent-cart'),
        'TH-35' => __('Yasothon', 'fluent-cart'),
    ),
    'TR' => array( // Turkish states.
        'TR01' => __('Adana', 'fluent-cart'),
        'TR02' => __('Adıyaman', 'fluent-cart'),
        'TR03' => __('Afyon', 'fluent-cart'),
        'TR04' => __('Ağrı', 'fluent-cart'),
        'TR05' => __('Amasya', 'fluent-cart'),
        'TR06' => __('Ankara', 'fluent-cart'),
        'TR07' => __('Antalya', 'fluent-cart'),
        'TR08' => __('Artvin', 'fluent-cart'),
        'TR09' => __('Aydın', 'fluent-cart'),
        'TR10' => __('Balıkesir', 'fluent-cart'),
        'TR11' => __('Bilecik', 'fluent-cart'),
        'TR12' => __('Bingöl', 'fluent-cart'),
        'TR13' => __('Bitlis', 'fluent-cart'),
        'TR14' => __('Bolu', 'fluent-cart'),
        'TR15' => __('Burdur', 'fluent-cart'),
        'TR16' => __('Bursa', 'fluent-cart'),
        'TR17' => __('Çanakkale', 'fluent-cart'),
        'TR18' => __('Çankırı', 'fluent-cart'),
        'TR19' => __('Çorum', 'fluent-cart'),
        'TR20' => __('Denizli', 'fluent-cart'),
        'TR21' => __('Diyarbakır', 'fluent-cart'),
        'TR22' => __('Edirne', 'fluent-cart'),
        'TR23' => __('Elazığ', 'fluent-cart'),
        'TR24' => __('Erzincan', 'fluent-cart'),
        'TR25' => __('Erzurum', 'fluent-cart'),
        'TR26' => __('Eskişehir', 'fluent-cart'),
        'TR27' => __('Gaziantep', 'fluent-cart'),
        'TR28' => __('Giresun', 'fluent-cart'),
        'TR29' => __('Gümüşhane', 'fluent-cart'),
        'TR30' => __('Hakkari', 'fluent-cart'),
        'TR31' => __('Hatay', 'fluent-cart'),
        'TR32' => __('Isparta', 'fluent-cart'),
        'TR33' => __('İçel', 'fluent-cart'),
        'TR34' => __('İstanbul', 'fluent-cart'),
        'TR35' => __('İzmir', 'fluent-cart'),
        'TR36' => __('Kars', 'fluent-cart'),
        'TR37' => __('Kastamonu', 'fluent-cart'),
        'TR38' => __('Kayseri', 'fluent-cart'),
        'TR39' => __('Kırklareli', 'fluent-cart'),
        'TR40' => __('Kırşehir', 'fluent-cart'),
        'TR41' => __('Kocaeli', 'fluent-cart'),
        'TR42' => __('Konya', 'fluent-cart'),
        'TR43' => __('Kütahya', 'fluent-cart'),
        'TR44' => __('Malatya', 'fluent-cart'),
        'TR45' => __('Manisa', 'fluent-cart'),
        'TR46' => __('Kahramanmaraş', 'fluent-cart'),
        'TR47' => __('Mardin', 'fluent-cart'),
        'TR48' => __('Muğla', 'fluent-cart'),
        'TR49' => __('Muş', 'fluent-cart'),
        'TR50' => __('Nevşehir', 'fluent-cart'),
        'TR51' => __('Niğde', 'fluent-cart'),
        'TR52' => __('Ordu', 'fluent-cart'),
        'TR53' => __('Rize', 'fluent-cart'),
        'TR54' => __('Sakarya', 'fluent-cart'),
        'TR55' => __('Samsun', 'fluent-cart'),
        'TR56' => __('Siirt', 'fluent-cart'),
        'TR57' => __('Sinop', 'fluent-cart'),
        'TR58' => __('Sivas', 'fluent-cart'),
        'TR59' => __('Tekirdağ', 'fluent-cart'),
        'TR60' => __('Tokat', 'fluent-cart'),
        'TR61' => __('Trabzon', 'fluent-cart'),
        'TR62' => __('Tunceli', 'fluent-cart'),
        'TR63' => __('Şanlıurfa', 'fluent-cart'),
        'TR64' => __('Uşak', 'fluent-cart'),
        'TR65' => __('Van', 'fluent-cart'),
        'TR66' => __('Yozgat', 'fluent-cart'),
        'TR67' => __('Zonguldak', 'fluent-cart'),
        'TR68' => __('Aksaray', 'fluent-cart'),
        'TR69' => __('Bayburt', 'fluent-cart'),
        'TR70' => __('Karaman', 'fluent-cart'),
        'TR71' => __('Kırıkkale', 'fluent-cart'),
        'TR72' => __('Batman', 'fluent-cart'),
        'TR73' => __('Şırnak', 'fluent-cart'),
        'TR74' => __('Bartın', 'fluent-cart'),
        'TR75' => __('Ardahan', 'fluent-cart'),
        'TR76' => __('Iğdır', 'fluent-cart'),
        'TR77' => __('Yalova', 'fluent-cart'),
        'TR78' => __('Karabük', 'fluent-cart'),
        'TR79' => __('Kilis', 'fluent-cart'),
        'TR80' => __('Osmaniye', 'fluent-cart'),
        'TR81' => __('Düzce', 'fluent-cart'),
    ),
    'TZ' => array( // Tanzanian states.
        'TZ01' => __('Arusha', 'fluent-cart'),
        'TZ02' => __('Dar es Salaam', 'fluent-cart'),
        'TZ03' => __('Dodoma', 'fluent-cart'),
        'TZ04' => __('Iringa', 'fluent-cart'),
        'TZ05' => __('Kagera', 'fluent-cart'),
        'TZ06' => __('Pemba North', 'fluent-cart'),
        'TZ07' => __('Zanzibar North', 'fluent-cart'),
        'TZ08' => __('Kigoma', 'fluent-cart'),
        'TZ09' => __('Kilimanjaro', 'fluent-cart'),
        'TZ10' => __('Pemba South', 'fluent-cart'),
        'TZ11' => __('Zanzibar South', 'fluent-cart'),
        'TZ12' => __('Lindi', 'fluent-cart'),
        'TZ13' => __('Mara', 'fluent-cart'),
        'TZ14' => __('Mbeya', 'fluent-cart'),
        'TZ15' => __('Zanzibar West', 'fluent-cart'),
        'TZ16' => __('Morogoro', 'fluent-cart'),
        'TZ17' => __('Mtwara', 'fluent-cart'),
        'TZ18' => __('Mwanza', 'fluent-cart'),
        'TZ19' => __('Coast', 'fluent-cart'),
        'TZ20' => __('Rukwa', 'fluent-cart'),
        'TZ21' => __('Ruvuma', 'fluent-cart'),
        'TZ22' => __('Shinyanga', 'fluent-cart'),
        'TZ23' => __('Singida', 'fluent-cart'),
        'TZ24' => __('Tabora', 'fluent-cart'),
        'TZ25' => __('Tanga', 'fluent-cart'),
        'TZ26' => __('Manyara', 'fluent-cart'),
        'TZ27' => __('Geita', 'fluent-cart'),
        'TZ28' => __('Katavi', 'fluent-cart'),
        'TZ29' => __('Njombe', 'fluent-cart'),
        'TZ30' => __('Simiyu', 'fluent-cart'),
    ),
    'LK' => array(),
    'RS' => array( // Serbian districts.
        'RS00' => _x('Belgrade', 'district', 'fluent-cart'),
        'RS14' => _x('Bor', 'district', 'fluent-cart'),
        'RS11' => _x('Braničevo', 'district', 'fluent-cart'),
        'RS02' => _x('Central Banat', 'district', 'fluent-cart'),
        'RS10' => _x('Danube', 'district', 'fluent-cart'),
        'RS23' => _x('Jablanica', 'district', 'fluent-cart'),
        'RS09' => _x('Kolubara', 'district', 'fluent-cart'),
        'RS08' => _x('Mačva', 'district', 'fluent-cart'),
        'RS17' => _x('Morava', 'district', 'fluent-cart'),
        'RS20' => _x('Nišava', 'district', 'fluent-cart'),
        'RS01' => _x('North Bačka', 'district', 'fluent-cart'),
        'RS03' => _x('North Banat', 'district', 'fluent-cart'),
        'RS24' => _x('Pčinja', 'district', 'fluent-cart'),
        'RS22' => _x('Pirot', 'district', 'fluent-cart'),
        'RS13' => _x('Pomoravlje', 'district', 'fluent-cart'),
        'RS19' => _x('Rasina', 'district', 'fluent-cart'),
        'RS18' => _x('Raška', 'district', 'fluent-cart'),
        'RS06' => _x('South Bačka', 'district', 'fluent-cart'),
        'RS04' => _x('South Banat', 'district', 'fluent-cart'),
        'RS07' => _x('Srem', 'district', 'fluent-cart'),
        'RS12' => _x('Šumadija', 'district', 'fluent-cart'),
        'RS21' => _x('Toplica', 'district', 'fluent-cart'),
        'RS05' => _x('West Bačka', 'district', 'fluent-cart'),
        'RS15' => _x('Zaječar', 'district', 'fluent-cart'),
        'RS16' => _x('Zlatibor', 'district', 'fluent-cart'),
        'RS25' => _x('Kosovo', 'district', 'fluent-cart'),
        'RS26' => _x('Peć', 'district', 'fluent-cart'),
        'RS27' => _x('Prizren', 'district', 'fluent-cart'),
        'RS28' => _x('Kosovska Mitrovica', 'district', 'fluent-cart'),
        'RS29' => _x('Kosovo-Pomoravlje', 'district', 'fluent-cart'),
        'RSKM' => _x('Kosovo-Metohija', 'district', 'fluent-cart'),
        'RSVO' => _x('Vojvodina', 'district', 'fluent-cart'),
    ),
    'RW' => array(),
    'SE' => array(),
    'UA' => array( // Ukrainian oblasts. https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L5243.
        'UA05' => __('Vinnychchyna', 'fluent-cart'),
        'UA07' => __('Volyn', 'fluent-cart'),
        'UA09' => __('Luhanshchyna', 'fluent-cart'),
        'UA12' => __('Dnipropetrovshchyna', 'fluent-cart'),
        'UA14' => __('Donechchyna', 'fluent-cart'),
        'UA18' => __('Zhytomyrshchyna', 'fluent-cart'),
        'UA21' => __('Zakarpattia', 'fluent-cart'),
        'UA23' => __('Zaporizhzhya', 'fluent-cart'),
        'UA26' => __('Prykarpattia', 'fluent-cart'),
        'UA30' => __('Kyiv', 'fluent-cart'),
        'UA32' => __('Kyivshchyna', 'fluent-cart'),
        'UA35' => __('Kirovohradschyna', 'fluent-cart'),
        'UA40' => __('Sevastopol', 'fluent-cart'),
        'UA43' => __('Crimea', 'fluent-cart'),
        'UA46' => __('Lvivshchyna', 'fluent-cart'),
        'UA48' => __('Mykolayivschyna', 'fluent-cart'),
        'UA51' => __('Odeshchyna', 'fluent-cart'),
        'UA53' => __('Poltavshchyna', 'fluent-cart'),
        'UA56' => __('Rivnenshchyna', 'fluent-cart'),
        'UA59' => __('Sumshchyna', 'fluent-cart'),
        'UA61' => __('Ternopilshchyna', 'fluent-cart'),
        'UA63' => __('Kharkivshchyna', 'fluent-cart'),
        'UA65' => __('Khersonshchyna', 'fluent-cart'),
        'UA68' => __('Khmelnychchyna', 'fluent-cart'),
        'UA71' => __('Cherkashchyna', 'fluent-cart'),
        'UA74' => __('Chernihivshchyna', 'fluent-cart'),
        'UA77' => __('Chernivtsi Oblast', 'fluent-cart'),
    ),
    'UG' => array( // Ugandan districts.
        'UG314' => __('Abim', 'fluent-cart'),
        'UG301' => __('Adjumani', 'fluent-cart'),
        'UG322' => __('Agago', 'fluent-cart'),
        'UG323' => __('Alebtong', 'fluent-cart'),
        'UG315' => __('Amolatar', 'fluent-cart'),
        'UG324' => __('Amudat', 'fluent-cart'),
        'UG216' => __('Amuria', 'fluent-cart'),
        'UG316' => __('Amuru', 'fluent-cart'),
        'UG302' => __('Apac', 'fluent-cart'),
        'UG303' => __('Arua', 'fluent-cart'),
        'UG217' => __('Budaka', 'fluent-cart'),
        'UG218' => __('Bududa', 'fluent-cart'),
        'UG201' => __('Bugiri', 'fluent-cart'),
        'UG235' => __('Bugweri', 'fluent-cart'),
        'UG420' => __('Buhweju', 'fluent-cart'),
        'UG117' => __('Buikwe', 'fluent-cart'),
        'UG219' => __('Bukedea', 'fluent-cart'),
        'UG118' => __('Bukomansimbi', 'fluent-cart'),
        'UG220' => __('Bukwa', 'fluent-cart'),
        'UG225' => __('Bulambuli', 'fluent-cart'),
        'UG416' => __('Buliisa', 'fluent-cart'),
        'UG401' => __('Bundibugyo', 'fluent-cart'),
        'UG430' => __('Bunyangabu', 'fluent-cart'),
        'UG402' => __('Bushenyi', 'fluent-cart'),
        'UG202' => __('Busia', 'fluent-cart'),
        'UG221' => __('Butaleja', 'fluent-cart'),
        'UG119' => __('Butambala', 'fluent-cart'),
        'UG233' => __('Butebo', 'fluent-cart'),
        'UG120' => __('Buvuma', 'fluent-cart'),
        'UG226' => __('Buyende', 'fluent-cart'),
        'UG317' => __('Dokolo', 'fluent-cart'),
        'UG121' => __('Gomba', 'fluent-cart'),
        'UG304' => __('Gulu', 'fluent-cart'),
        'UG403' => __('Hoima', 'fluent-cart'),
        'UG417' => __('Ibanda', 'fluent-cart'),
        'UG203' => __('Iganga', 'fluent-cart'),
        'UG418' => __('Isingiro', 'fluent-cart'),
        'UG204' => __('Jinja', 'fluent-cart'),
        'UG318' => __('Kaabong', 'fluent-cart'),
        'UG404' => __('Kabale', 'fluent-cart'),
        'UG405' => __('Kabarole', 'fluent-cart'),
        'UG213' => __('Kaberamaido', 'fluent-cart'),
        'UG427' => __('Kagadi', 'fluent-cart'),
        'UG428' => __('Kakumiro', 'fluent-cart'),
        'UG101' => __('Kalangala', 'fluent-cart'),
        'UG222' => __('Kaliro', 'fluent-cart'),
        'UG122' => __('Kalungu', 'fluent-cart'),
        'UG102' => __('Kampala', 'fluent-cart'),
        'UG205' => __('Kamuli', 'fluent-cart'),
        'UG413' => __('Kamwenge', 'fluent-cart'),
        'UG414' => __('Kanungu', 'fluent-cart'),
        'UG206' => __('Kapchorwa', 'fluent-cart'),
        'UG236' => __('Kapelebyong', 'fluent-cart'),
        'UG126' => __('Kasanda', 'fluent-cart'),
        'UG406' => __('Kasese', 'fluent-cart'),
        'UG207' => __('Katakwi', 'fluent-cart'),
        'UG112' => __('Kayunga', 'fluent-cart'),
        'UG407' => __('Kibaale', 'fluent-cart'),
        'UG103' => __('Kiboga', 'fluent-cart'),
        'UG227' => __('Kibuku', 'fluent-cart'),
        'UG432' => __('Kikuube', 'fluent-cart'),
        'UG419' => __('Kiruhura', 'fluent-cart'),
        'UG421' => __('Kiryandongo', 'fluent-cart'),
        'UG408' => __('Kisoro', 'fluent-cart'),
        'UG305' => __('Kitgum', 'fluent-cart'),
        'UG319' => __('Koboko', 'fluent-cart'),
        'UG325' => __('Kole', 'fluent-cart'),
        'UG306' => __('Kotido', 'fluent-cart'),
        'UG208' => __('Kumi', 'fluent-cart'),
        'UG333' => __('Kwania', 'fluent-cart'),
        'UG228' => __('Kween', 'fluent-cart'),
        'UG123' => __('Kyankwanzi', 'fluent-cart'),
        'UG422' => __('Kyegegwa', 'fluent-cart'),
        'UG415' => __('Kyenjojo', 'fluent-cart'),
        'UG125' => __('Kyotera', 'fluent-cart'),
        'UG326' => __('Lamwo', 'fluent-cart'),
        'UG307' => __('Lira', 'fluent-cart'),
        'UG229' => __('Luuka', 'fluent-cart'),
        'UG104' => __('Luwero', 'fluent-cart'),
        'UG124' => __('Lwengo', 'fluent-cart'),
        'UG114' => __('Lyantonde', 'fluent-cart'),
        'UG223' => __('Manafwa', 'fluent-cart'),
        'UG320' => __('Maracha', 'fluent-cart'),
        'UG105' => __('Masaka', 'fluent-cart'),
        'UG409' => __('Masindi', 'fluent-cart'),
        'UG214' => __('Mayuge', 'fluent-cart'),
        'UG209' => __('Mbale', 'fluent-cart'),
        'UG410' => __('Mbarara', 'fluent-cart'),
        'UG423' => __('Mitooma', 'fluent-cart'),
        'UG115' => __('Mityana', 'fluent-cart'),
        'UG308' => __('Moroto', 'fluent-cart'),
        'UG309' => __('Moyo', 'fluent-cart'),
        'UG106' => __('Mpigi', 'fluent-cart'),
        'UG107' => __('Mubende', 'fluent-cart'),
        'UG108' => __('Mukono', 'fluent-cart'),
        'UG334' => __('Nabilatuk', 'fluent-cart'),
        'UG311' => __('Nakapiripirit', 'fluent-cart'),
        'UG116' => __('Nakaseke', 'fluent-cart'),
        'UG109' => __('Nakasongola', 'fluent-cart'),
        'UG230' => __('Namayingo', 'fluent-cart'),
        'UG234' => __('Namisindwa', 'fluent-cart'),
        'UG224' => __('Namutumba', 'fluent-cart'),
        'UG327' => __('Napak', 'fluent-cart'),
        'UG310' => __('Nebbi', 'fluent-cart'),
        'UG231' => __('Ngora', 'fluent-cart'),
        'UG424' => __('Ntoroko', 'fluent-cart'),
        'UG411' => __('Ntungamo', 'fluent-cart'),
        'UG328' => __('Nwoya', 'fluent-cart'),
        'UG331' => __('Omoro', 'fluent-cart'),
        'UG329' => __('Otuke', 'fluent-cart'),
        'UG321' => __('Oyam', 'fluent-cart'),
        'UG312' => __('Pader', 'fluent-cart'),
        'UG332' => __('Pakwach', 'fluent-cart'),
        'UG210' => __('Pallisa', 'fluent-cart'),
        'UG110' => __('Rakai', 'fluent-cart'),
        'UG429' => __('Rubanda', 'fluent-cart'),
        'UG425' => __('Rubirizi', 'fluent-cart'),
        'UG431' => __('Rukiga', 'fluent-cart'),
        'UG412' => __('Rukungiri', 'fluent-cart'),
        'UG111' => __('Sembabule', 'fluent-cart'),
        'UG232' => __('Serere', 'fluent-cart'),
        'UG426' => __('Sheema', 'fluent-cart'),
        'UG215' => __('Sironko', 'fluent-cart'),
        'UG211' => __('Soroti', 'fluent-cart'),
        'UG212' => __('Tororo', 'fluent-cart'),
        'UG113' => __('Wakiso', 'fluent-cart'),
        'UG313' => __('Yumbe', 'fluent-cart'),
        'UG330' => __('Zombo', 'fluent-cart'),
    ),
    'UM' => array(
        '81' => __('Baker Island', 'fluent-cart'),
        '84' => __('Howland Island', 'fluent-cart'),
        '86' => __('Jarvis Island', 'fluent-cart'),
        '67' => __('Johnston Atoll', 'fluent-cart'),
        '89' => __('Kingman Reef', 'fluent-cart'),
        '71' => __('Midway Atoll', 'fluent-cart'),
        '76' => __('Navassa Island', 'fluent-cart'),
        '95' => __('Palmyra Atoll', 'fluent-cart'),
        '79' => __('Wake Island', 'fluent-cart'),
    ),
    'US' => array( // U.S. states.
        'AL' => __('Alabama', 'fluent-cart'),
        'AK' => __('Alaska', 'fluent-cart'),
        'AZ' => __('Arizona', 'fluent-cart'),
        'AR' => __('Arkansas', 'fluent-cart'),
        'CA' => __('California', 'fluent-cart'),
        'CO' => __('Colorado', 'fluent-cart'),
        'CT' => __('Connecticut', 'fluent-cart'),
        'DE' => __('Delaware', 'fluent-cart'),
        'DC' => __('District of Columbia', 'fluent-cart'),
        'FL' => __('Florida', 'fluent-cart'),
        'GA' => _x('Georgia', 'US state of Georgia', 'fluent-cart'),
        'HI' => __('Hawaii', 'fluent-cart'),
        'ID' => __('Idaho', 'fluent-cart'),
        'IL' => __('Illinois', 'fluent-cart'),
        'IN' => __('Indiana', 'fluent-cart'),
        'IA' => __('Iowa', 'fluent-cart'),
        'KS' => __('Kansas', 'fluent-cart'),
        'KY' => __('Kentucky', 'fluent-cart'),
        'LA' => __('Louisiana', 'fluent-cart'),
        'ME' => __('Maine', 'fluent-cart'),
        'MD' => __('Maryland', 'fluent-cart'),
        'MA' => __('Massachusetts', 'fluent-cart'),
        'MI' => __('Michigan', 'fluent-cart'),
        'MN' => __('Minnesota', 'fluent-cart'),
        'MS' => __('Mississippi', 'fluent-cart'),
        'MO' => __('Missouri', 'fluent-cart'),
        'MT' => __('Montana', 'fluent-cart'),
        'NE' => __('Nebraska', 'fluent-cart'),
        'NV' => __('Nevada', 'fluent-cart'),
        'NH' => __('New Hampshire', 'fluent-cart'),
        'NJ' => __('New Jersey', 'fluent-cart'),
        'NM' => __('New Mexico', 'fluent-cart'),
        'NY' => __('New York', 'fluent-cart'),
        'NC' => __('North Carolina', 'fluent-cart'),
        'ND' => __('North Dakota', 'fluent-cart'),
        'OH' => __('Ohio', 'fluent-cart'),
        'OK' => __('Oklahoma', 'fluent-cart'),
        'OR' => __('Oregon', 'fluent-cart'),
        'PA' => __('Pennsylvania', 'fluent-cart'),
        'RI' => __('Rhode Island', 'fluent-cart'),
        'SC' => __('South Carolina', 'fluent-cart'),
        'SD' => __('South Dakota', 'fluent-cart'),
        'TN' => __('Tennessee', 'fluent-cart'),
        'TX' => __('Texas', 'fluent-cart'),
        'UT' => __('Utah', 'fluent-cart'),
        'VT' => __('Vermont', 'fluent-cart'),
        'VA' => __('Virginia', 'fluent-cart'),
        'WA' => __('Washington', 'fluent-cart'),
        'WV' => __('West Virginia', 'fluent-cart'),
        'WI' => __('Wisconsin', 'fluent-cart'),
        'WY' => __('Wyoming', 'fluent-cart'),
        'AA' => __('Armed Forces (AA)', 'fluent-cart'),
        'AE' => __('Armed Forces (AE)', 'fluent-cart'),
        'AP' => __('Armed Forces (AP)', 'fluent-cart'),
    ),
    'UY' => array( // Uruguayan states.
        'UY-AR' => __('Artigas', 'fluent-cart'),
        'UY-CA' => __('Canelones', 'fluent-cart'),
        'UY-CL' => __('Cerro Largo', 'fluent-cart'),
        'UY-CO' => __('Colonia', 'fluent-cart'),
        'UY-DU' => __('Durazno', 'fluent-cart'),
        'UY-FS' => __('Flores', 'fluent-cart'),
        'UY-FD' => __('Florida', 'fluent-cart'),
        'UY-LA' => __('Lavalleja', 'fluent-cart'),
        'UY-MA' => __('Maldonado', 'fluent-cart'),
        'UY-MO' => __('Montevideo', 'fluent-cart'),
        'UY-PA' => __('Paysandú', 'fluent-cart'),
        'UY-RN' => __('Río Negro', 'fluent-cart'),
        'UY-RV' => __('Rivera', 'fluent-cart'),
        'UY-RO' => __('Rocha', 'fluent-cart'),
        'UY-SA' => __('Salto', 'fluent-cart'),
        'UY-SJ' => __('San José', 'fluent-cart'),
        'UY-SO' => __('Soriano', 'fluent-cart'),
        'UY-TA' => __('Tacuarembó', 'fluent-cart'),
        'UY-TT' => __('Treinta y Tres', 'fluent-cart'),
    ),
    'VE' => array( // Venezuelan states.
        'VE-A' => __('Capital', 'fluent-cart'),
        'VE-B' => __('Anzoátegui', 'fluent-cart'),
        'VE-C' => __('Apure', 'fluent-cart'),
        'VE-D' => __('Aragua', 'fluent-cart'),
        'VE-E' => __('Barinas', 'fluent-cart'),
        'VE-F' => __('Bolívar', 'fluent-cart'),
        'VE-G' => __('Carabobo', 'fluent-cart'),
        'VE-H' => __('Cojedes', 'fluent-cart'),
        'VE-I' => __('Falcón', 'fluent-cart'),
        'VE-J' => __('Guárico', 'fluent-cart'),
        'VE-K' => __('Lara', 'fluent-cart'),
        'VE-L' => __('Mérida', 'fluent-cart'),
        'VE-M' => __('Miranda', 'fluent-cart'),
        'VE-N' => __('Monagas', 'fluent-cart'),
        'VE-O' => __('Nueva Esparta', 'fluent-cart'),
        'VE-P' => __('Portuguesa', 'fluent-cart'),
        'VE-R' => __('Sucre', 'fluent-cart'),
        'VE-S' => __('Táchira', 'fluent-cart'),
        'VE-T' => __('Trujillo', 'fluent-cart'),
        'VE-U' => __('Yaracuy', 'fluent-cart'),
        'VE-V' => __('Zulia', 'fluent-cart'),
        'VE-W' => __('Federal Dependencies', 'fluent-cart'),
        'VE-X' => __('La Guaira (Vargas)', 'fluent-cart'),
        'VE-Y' => __('Delta Amacuro', 'fluent-cart'),
        'VE-Z' => __('Amazonas', 'fluent-cart'),
    ),
    'VN' => array(),
    'YT' => array(),
    'ZA' => array( // South African states.
        'EC' => __('Eastern Cape', 'fluent-cart'),
        'FS' => __('Free State', 'fluent-cart'),
        'GP' => __('Gauteng', 'fluent-cart'),
        'KZN' => __('KwaZulu-Natal', 'fluent-cart'),
        'LP' => __('Limpopo', 'fluent-cart'),
        'MP' => __('Mpumalanga', 'fluent-cart'),
        'NC' => __('Northern Cape', 'fluent-cart'),
        'NW' => __('North West', 'fluent-cart'),
        'WC' => __('Western Cape', 'fluent-cart'),
    ),
    'ZM' => array( // Zambian provinces.
        'ZM-01' => __('Western', 'fluent-cart'),
        'ZM-02' => __('Central', 'fluent-cart'),
        'ZM-03' => __('Eastern', 'fluent-cart'),
        'ZM-04' => __('Luapula', 'fluent-cart'),
        'ZM-05' => __('Northern', 'fluent-cart'),
        'ZM-06' => __('North-Western', 'fluent-cart'),
        'ZM-07' => __('Southern', 'fluent-cart'),
        'ZM-08' => __('Copperbelt', 'fluent-cart'),
        'ZM-09' => __('Lusaka', 'fluent-cart'),
        'ZM-10' => __('Muchinga', 'fluent-cart'),
    ),
);
