<?php

defined( 'ABSPATH' ) || exit;

return array(
    'AE' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'required' => false,
        ),
    ),
    'AF' => array(
        'state' => array(
            'required' => false,
            'hidden'   => false,
        ),
    ),
    'AL' => array(
        'state' => array(
            'label' => __( 'County', 'fluent-cart' ),
        ),
    ),
    'AO' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'AT' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'AU' => array(
        'city'     => array(
            'label' => __( 'Suburb', 'fluent-cart' ),
        ),
        'postcode' => array(
            'label' => __( 'Postcode', 'fluent-cart' ),
        ),
        'state'    => array(
            'label' => __( 'State', 'fluent-cart' ),
        ),
    ),
    'AX' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'BA' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'label'    => __( 'Canton', 'fluent-cart' ),
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'BD' => array(
        'postcode' => array(
            'required' => false,
        ),
        'state'    => array(
            'label' => __( 'District', 'fluent-cart' ),
        ),
    ),
    'BE' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'BG' => array(
        'state' => array(
            'required' => false,
        ),
    ),
    'BH' => array(
        'postcode' => array(
            'required' => false,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'BI' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'BO' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'label' => __( 'Department', 'fluent-cart' ),
        ),
    ),
    'BS' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'BW' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
            'label'    => __( 'District', 'fluent-cart' ),
        ),
    ),
    'BZ' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'required' => false,
        ),
    ),
    'CA' => array(
        'postcode' => array(
            'label' => __( 'Postal code', 'fluent-cart' ),
        ),
        'state'    => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'CH' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'label'    => __( 'Canton', 'fluent-cart' ),
            'required' => false,
        ),
    ),
    'CL' => array(
        'city'     => array(
            'required' => true,
        ),
        'postcode' => array(
            'required' => false,
            'hidden'   => 'CL'
        ),
        'state'    => array(
            'label' => __( 'Region', 'fluent-cart' ),
        ),
    ),
    'CN' => array(
        'state' => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'CO' => array(
        'postcode' => array(
            'required' => false,
        ),
        'state'    => array(
            'label' => __( 'Department', 'fluent-cart' ),
        ),
    ),
    'CR' => array(
        'state' => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'CW' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'required' => false,
        ),
    ),
    'CY' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'CZ' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'DE' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
        ),
    ),
    'DK' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'DO' => array(
        'state' => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'EC' => array(
        'state' => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'EE' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'ET' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'FI' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'FR' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'GG' => array(
        'state' => array(
            'required' => false,
            'label'    => __( 'Parish', 'fluent-cart' ),
        ),
    ),
    'GH' => array(
        'postcode' => array(
            'required' => false,
        ),
        'state'    => array(
            'label' => __( 'Region', 'fluent-cart' ),
        ),
    ),
    'GP' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'GF' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'GR' => array(
        'state' => array(
            'required' => false,
        ),
    ),
    'GT' => array(
        'postcode' => array(
            'required' => false,
        ),
        'state'    => array(
            'label' => __( 'Department', 'fluent-cart' ),
        ),
    ),
    'HK' => array(
        'postcode' => array(
            'required' => false,
        ),
        'city'     => array(
            'label' => __( 'Town / District', 'fluent-cart' ),
        ),
        'state'    => array(
            'label' => __( 'Region', 'fluent-cart' ),
        ),
    ),
    'HN' => array(
        'state' => array(
            'label' => __( 'Department', 'fluent-cart' ),
        ),
    ),
    'HU' => array(
        'last_name'  => array(
            'class'    => array( 'form-row-first' ),
            'priority' => 10,
        ),
        'first_name' => array(
            'class'    => array( 'form-row-last' ),
            'priority' => 20,
        ),
        'postcode'   => array(
            'class'    => array( 'form-row-first', 'address-field' ),
            'priority' => 65,
        ),
        'city'       => array(
            'class' => array( 'form-row-last', 'address-field' ),
        ),
        'address_1'  => array(
            'priority' => 71,
        ),
        'address_2'  => array(
            'priority' => 72,
        ),
        'state'      => array(
            'label'    => __( 'County', 'fluent-cart' ),
            'required' => false,
        ),
    ),
    'ID' => array(
        'state' => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'IE' => array(
        'postcode' => array(
            'required' => true,
            'label'    => __( 'Eircode', 'fluent-cart' ),
        ),
        'state'    => array(
            'label' => __( 'County', 'fluent-cart' ),
        ),
    ),
    'IS' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'IL' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'IM' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'IN' => array(
        'postcode' => array(
            'label' => __( 'PIN Code', 'fluent-cart' ),
        ),
        'state'    => array(
            'label' => __( 'State', 'fluent-cart' ),
        ),
    ),
    'IR' => array(
        'state'     => array(
            'priority' => 50,
        ),
        'city'      => array(
            'priority' => 60,
        ),
        'address_1' => array(
            'priority' => 70,
        ),
        'address_2' => array(
            'priority' => 80,
        ),
    ),
    'IT' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => true,
            'label'    => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'JM' => array(
        'city'     => array(
            'label' => __( 'Town / City / Post Office', 'fluent-cart' ),
        ),
        'postcode' => array(
            'required' => false,
            'label'    => __( 'Postal Code', 'fluent-cart' ),
        ),
        'state'    => array(
            'required' => true,
            'label'    => __( 'Parish', 'fluent-cart' ),
        ),
    ),
    'JP' => array(
        'last_name'  => array(
            'class'    => array( 'form-row-first' ),
            'priority' => 10,
        ),
        'first_name' => array(
            'class'    => array( 'form-row-last' ),
            'priority' => 20,
        ),
        'postcode'   => array(
            'class'    => array( 'form-row-first', 'address-field' ),
            'priority' => 65,
        ),
        'state'      => array(
            'label'    => __( 'Prefecture', 'fluent-cart' ),
            'class'    => array( 'form-row-last', 'address-field' ),
            'priority' => 66,
        ),
        'city'       => array(
            'priority' => 67,
        ),
        'address_1'  => array(
            'priority' => 68,
        ),
        'address_2'  => array(
            'priority' => 69,
        ),
    ),
    'KN' => array(
        'postcode' => array(
            'required' => false,
            'label'    => __( 'Postal code', 'fluent-cart' ),
        ),
        'state'    => array(
            'required' => true,
            'label'    => __( 'Parish', 'fluent-cart' ),
        ),
    ),
    'KR' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'KW' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'LV' => array(
        'state' => array(
            'label'    => __( 'Municipality', 'fluent-cart' ),
            'required' => false,
        ),
    ),
    'LB' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'MF' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'MQ' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'MT' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'MZ' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'NI' => array(
        'state' => array(
            'label' => __( 'Department', 'fluent-cart' ),
        ),
    ),
    'NL' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'NG' => array(
        'postcode' => array(
            'label'    => __( 'Postcode', 'fluent-cart' ),
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'label' => __( 'State', 'fluent-cart' ),
        ),
    ),
    'NZ' => array(
        'postcode' => array(
            'label' => __( 'Postcode', 'fluent-cart' ),
        ),
        'state'    => array(
            'required' => false,
            'label'    => __( 'Region', 'fluent-cart' ),
        ),
    ),
    'NO' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'NP' => array(
        'state'    => array(
            'label' => __( 'State / Zone', 'fluent-cart' ),
        ),
        'postcode' => array(
            'required' => false,
        ),
    ),
    'PA' => array(
        'state' => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'PL' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'PR' => array(
        'city'  => array(
            'label' => __( 'Municipality', 'fluent-cart' ),
        ),
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'PT' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'PY' => array(
        'state' => array(
            'label' => __( 'Department', 'fluent-cart' ),
        ),
    ),
    'RE' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'RO' => array(
        'state' => array(
            'label'    => __( 'County', 'fluent-cart' ),
            'required' => true,
        ),
    ),
    'RS' => array(
        'city'     => array(
            'required' => true,
        ),
        'postcode' => array(
            'required' => true,
        ),
        'state'    => array(
            'label'    => __( 'District', 'fluent-cart' ),
            'required' => false,
        ),
    ),
    'RW' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'SG' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'city'  => array(
            'required' => false,
        ),
    ),
    'SK' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'SI' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'SR' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'SV' => array(
        'state' => array(
            'label' => __( 'Department', 'fluent-cart' ),
        ),
    ),
    'ES' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'LI' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'LK' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'LU' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'MD' => array(
        'state' => array(
            'label' => __( 'Municipality / District', 'fluent-cart' ),
        ),
    ),
    'SE' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'TR' => array(
        'postcode' => array(
            'priority' => 65,
        ),
        'state'    => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'UG' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'city'     => array(
            'label'    => __( 'Town / Village', 'fluent-cart' ),
            'required' => true,
        ),
        'state'    => array(
            'label'    => __( 'District', 'fluent-cart' ),
            'required' => true,
        ),
    ),
    'US' => array(
        'postcode' => array(
            'label' => __( 'ZIP Code', 'fluent-cart' ),
        ),
        'state'    => array(
            'label' => __( 'State', 'fluent-cart' ),
        ),
    ),
    'UY' => array(
        'state' => array(
            'label' => __( 'Department', 'fluent-cart' ),
        ),
    ),
    'GB' => array(
        'postcode' => array(
            'label' => __( 'Postcode', 'fluent-cart' ),
        ),
        'state'    => array(
            'label'    => __( 'County', 'fluent-cart' ),
            'required' => false,
        ),
    ),
    'ST' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
        'state'    => array(
            'label' => __( 'District', 'fluent-cart' ),
        ),
    ),
    'VN' => array(
        'state'     => array(
            'required' => false,
            'hidden'   => true,
        ),
        'postcode'  => array(
            'priority' => 65,
            'required' => false,
            'hidden'   => false,
        ),
        'address_2' => array(
            'required' => false,
            'hidden'   => false,
        ),
    ),
    'WS' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'YT' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'ZA' => array(
        'state' => array(
            'label' => __( 'Province', 'fluent-cart' ),
        ),
    ),
    'ZW' => array(
        'postcode' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
    'PS' => array(
        'state' => array(
            'required' => false,
            'hidden'   => true,
        ),
    ),
);
