<?php

namespace FluentCart\App\Events\Order;

use FluentCart\App\Models\Order;
use FluentCart\App\Events\EventDispatcher;
use FluentCart\App\Listeners;


class OrderCanceled extends EventDispatcher
{
    public string $hook = 'fluent_cart/order_canceled';

    protected array $listeners = [
        Listeners\Order\OrderDeleted::class,
//        Listeners\UpdateStock::class
    ];

    /**
     * @var $order Order
     */
    public Order $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
        $this->order->load('customer', 'shipping_address', 'billing_address');
    }

    public function toArray(): array
    {
        return [
            'order'    => $this->order,
            'customer' => $this->order->customer ?? [],
        ];
    }

    public function getActivityEventModel()
    {
        return $this->order;
    }

    public function afterDispatch()
    {
        do_action($this->hook, $this->toArray());
    }

    public function shouldCreateActivity(): bool
    {
        return true; // TODO: Change the autogenerated stub
    }
}
