<?php
/**
 * View: Summary View - Single Event Title
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events-pro/v2/summary/date-group/event/title.php
 *
 * See more documentation about our views templating system.
 *
 * @link http://evnt.is/1aiy
 *
 * @version 7.7.11
 *
 * @since 5.7.0
 * @since 7.7.11 Switch from `h3` to `h4`.
 *
 * @var WP_Post $event The event post object with properties added by the `tribe_get_event` function.
 *
 * @see tribe_get_event() For the format of the event object.
 */

?>
	<h4 class="tribe-common-h8 tribe-common-h7--min-medium tribe-events-pro-summary__event-title">
		<?php $this->template( 'summary/date-group/event/title/featured' ); ?>
		<a
			href="<?php echo esc_url( $event->permalink ); ?>"
			title="<?php echo esc_attr( $event->title ); ?>"
			rel="bookmark"
			class="tribe-events-pro-summary__event-title-link tribe-common-anchor-thin"
		>
			<?php
			// phpcs:ignore
			echo $event->title;
			?>
		</a>
	</h4>
