<?php
/**
 * Controller for Events Calendar Pro integrations.
 *
 * @since 6.4.0
 *
 * @package TEC\Events_Pro\Integrations
 */

namespace TEC\Events_Pro\Integrations;

use Automattic\WooCommerce\Utilities\FeaturesUtil;
use TEC\Common\Contracts\Provider\Controller as Controller_Base;

/**
 * Class Controller
 *
 * @since 6.4.0
 *
 * @package TEC\Events_Pro\Integrations
 */
class Controller extends Controller_Base {

	/**
	 * Determines if this controller will register.
	 * This is present due to how UOPZ works, it will fail we have the boolean living on the method.
	 *
	 * @since 6.4.0
	 *
	 * @var bool $is_active If the integration is active.
	 */
	protected bool $is_active = true;

	/**
	 * {@inheritDoc}
	 *
	 * @since 6.4.0
	 *
	 * @return bool
	 */
	public function is_active(): bool {
		return $this->is_active;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @since 6.4.0
	 */
	public function do_register(): void {
		$this->boot();

		// Load plugin integration providers once the TEC integration has loaded.
		$this->container->register_on_action( 'tec_events_elementor_loaded', Plugins\Elementor\Controller::class );
		$this->container->register( Themes\Kadence\Provider::class );
		$this->container->register( Plugins\WP_All_Export\Controller::class );

		add_action( 'before_woocommerce_init', [ $this, 'declare_woo_hpos_support' ] );
	}

	/**
	 * {@inheritDoc}
	 *
	 * @since 6.4.0
	 */
	public function unregister(): void {
		remove_action( 'before_woocommerce_init', [ $this, 'declare_woo_hpos_support' ] );
	}

	/**
	 * Declare compatibility with WooCommerce HPOS.
	 *
	 * @since 7.7.6
	 *
	 * @return void
	 */
	public function declare_woo_hpos_support(): void {
		if ( class_exists( FeaturesUtil::class ) ) {
			FeaturesUtil::declare_compatibility( 'custom_order_tables', EVENTS_CALENDAR_PRO_FILE, true );
		}
	}
}
