<?php
/**
 * The Template for displaying the Tickets Commerce PayPal status.
 *
 * @version 5.3.0
 *
 * @since 5.1.10
 * @since 5.3.0 Using generic CSS classes for gateway instead of PayPal.
 *
 * @var Tribe__Tickets__Admin__Views                  $this                  [Global] Template object.
 * @var string                                        $plugin_url            [Global] The plugin URL.
 * @var TEC\Tickets\Commerce\Gateways\PayPal\Merchant $merchant              [Global] The merchant class.
 * @var TEC\Tickets\Commerce\Gateways\PayPal\Signup   $signup                [Global] The Signup class.
 * @var bool                                          $is_merchant_active    [Global] Whether the merchant is active or not.
 * @var bool                                          $is_merchant_connected [Global] Whether the merchant is connected or not.
 */

defined( 'ABSPATH' ) || exit;

if ( $is_merchant_active ?? false ) {
	return;
}

$error_messages = $signup->get_errors_from_on_boarded_data();
?>
<div class="tec-tickets__admin-settings-tickets-commerce-gateway-connected-row">
	<div class="tec-tickets__admin-settings-tickets-commerce-gateway-connected-col1">
		<?php esc_html_e( 'PayPal Status:', 'event-tickets' ); ?>
	</div>
	<div class="tec-tickets__admin-settings-tickets-commerce-gateway-connected-col2">
		<span class="tec-tickets__admin-settings-tickets-commerce-gateway-connect-text--connected">
			<?php esc_html_e( 'Connected', 'event-tickets' ); ?> <span class="dashicons dashicons-saved"></span>
		</span>

		<?php if ( is_array( $error_messages ) ) : ?>
			<ul>
				<?php foreach ( $error_messages as $error_message ) : ?>
					<li><span class="dashicons dashicons-warning" style="color: red;"></span> <?php echo esc_html( $error_message ); ?></li>
				<?php endforeach; ?>
			</ul>
		<?php endif; ?>
	</div>
</div>
<?php
