# WooCommerce modeling of stock and capacity

## Initial state
One Series with 4 Series Passes, each with a different capacity setting.

-- Series (shared capacity of 300)
post_id	meta_key	meta_value
19	_tribe_hide_attendees_list
19	_tribe_default_ticket_provider	Tribe__Tickets_Plus__Commerce__WooCommerce__Main
19	_tec-series-show-title	1
19	_tec_autogenerated_checksum	8c623fd8b7d925553d500b94ac30ab23
19	_tec_autogenerated	1
19	_edit_lock	1683192030:1
19	_tribe_ticket_capacity	300
19	_tribe_ticket_version	5.6.0-dev
19	_tribe_ticket_use_global_stock	1
19	_tribe_ticket_global_stock_level	300
19	_EventCost	123.00
19	_EventCost	21.00
19	_EventCost	54.00

-- Series Pass (unlimited capacity)
post_id	meta_key	meta_value
20	total_sales	0
20	_tax_status	taxable
20	_tax_class
20	_manage_stock	no
20	_backorders	no
20	_sold_individually	no
20	_virtual	yes
20	_downloadable	no
20	_download_limit	-1
20	_download_expiry	-1
20	_wc_average_rating	0
20	_wc_review_count	0
20	_product_version	7.6.1
20	_tribe_wooticket_for_event	19
20	_sku	20-1-UNLIMITED-WOO-TICKET
20	_tribe_ticket_show_description	yes
20	_regular_price	1200
20	_price	1200
20	_transient_timeout__tribe_woo_order_item_count_incomplete	1683796923
20	_transient__tribe_woo_order_item_count_incomplete	a:3:{s:5:"total";i:0;s:14:"recorded_sales";i:0;s:13:"reduced_stock";i:0;}
20	_tribe_ticket_capacity	-1
20	_tribe_ticket_version	5.6.0-dev
20	_tribe_tickets_ar_iac	none
20	_tribe_tickets_meta	a:0:{}
20	_type	series_pass
20	_ticket_start_date	2023-05-04 00:00:00

-- Series Pass (shared capacity of 300)
post_id	meta_key	meta_value
21	total_sales	0
21	_tax_status	taxable
21	_tax_class
21	_manage_stock	yes
21	_backorders	no
21	_sold_individually	no
21	_virtual	yes
21	_downloadable	no
21	_download_limit	-1
21	_download_expiry	-1
21	_stock	300
21	_stock_status	instock
21	_wc_average_rating	0
21	_wc_review_count	0
21	_product_version	7.6.1
21	_tribe_wooticket_for_event	19
21	_sku	21-1-SHARED-CAP-WOO-TICKET
21	_tribe_ticket_show_description	yes
21	_regular_price	123
21	_price	123
21	_global_stock_mode	global
21	_transient_timeout__tribe_woo_order_item_count_incomplete	1683796945
21	_transient__tribe_woo_order_item_count_incomplete	a:3:{s:5:"total";i:0;s:14:"recorded_sales";i:0;s:13:"reduced_stock";i:0;}
21	_tribe_ticket_version	5.6.0-dev
21	_tribe_ticket_capacity	300
21	_tribe_tickets_ar_iac	none
21	_tribe_tickets_meta	a:0:{}
21	_type	series_pass
21	_ticket_start_date	2023-05-04 00:00:00

-- Series Pass (capped capacity of 123)
post_id	meta_key	meta_value
22	total_sales	0
22	_tax_status	taxable
22	_tax_class
22	_manage_stock	yes
22	_backorders	no
22	_sold_individually	no
22	_virtual	yes
22	_downloadable	no
22	_download_limit	-1
22	_download_expiry	-1
22	_stock	123
22	_stock_status	instock
22	_wc_average_rating	0
22	_wc_review_count	0
22	_product_version	7.6.1
22	_tribe_wooticket_for_event	19
22	_sku	22-1-CAPPED-CAP-WOO-TICKET
22	_tribe_ticket_show_description	yes
22	_regular_price	21
22	_price	21
22	_global_stock_mode	capped
22	_tribe_ticket_capacity	123
22	_tribe_ticket_version	5.6.0-dev
22	_tribe_tickets_ar_iac	none
22	_tribe_tickets_meta	a:0:{}
22	_type	series_pass
22	_transient_timeout__tribe_woo_order_item_count_incomplete	1683796964
22	_transient__tribe_woo_order_item_count_incomplete	a:3:{s:5:"total";i:0;s:14:"recorded_sales";i:0;s:13:"reduced_stock";i:0;}
22	_ticket_start_date	2023-05-04 00:00:00

-- Series Pass (own capacity of 2389)
post_id	meta_key	meta_value
23	total_sales	0
23	_tax_status	taxable
23	_tax_class
23	_manage_stock	yes
23	_backorders	no
23	_sold_individually	no
23	_virtual	yes
23	_downloadable	no
23	_download_limit	-1
23	_download_expiry	-1
23	_stock	2389
23	_stock_status	instock
23	_wc_average_rating	0
23	_wc_review_count	0
23	_product_version	7.6.1
23	_tribe_wooticket_for_event	19
23	_sku	23-1-OWN-CAP-WOO-TICKET
23	_tribe_ticket_show_description	yes
23	_regular_price	54
23	_price	54
23	_global_stock_mode	own
23	_tribe_ticket_capacity	2389
23	_tribe_ticket_version	5.6.0-dev
23	_tribe_tickets_ar_iac	none
23	_tribe_tickets_meta	a:0:{}
23	_type	series_pass
23	_transient_timeout__tribe_woo_order_item_count_incomplete	1683796986
23	_transient__tribe_woo_order_item_count_incomplete	a:3:{s:5:"total";i:0;s:14:"recorded_sales";i:0;s:13:"reduced_stock";i:0;}
23	_ticket_start_date	2023-05-04 00:00:00

### Observations
1. When using WooCommerce, each Ticket is actually a WooCommerce product (custom post type `product`).
2. The meta used to create the Ticket is pulled from the product meta.
3. WooCommerce itself relies on that meta to be set and exist in the database to function properly.
4. The `_manage_stock` meta key is set and used by WooCommerce.