# Changelog

### [6.9.1] 2026-01-28

* Fix - Fix currency symbol position support in Purchase Rules admin interface. [ETP-1126]
* Tweak - Add confirmation before deleting Purchase Rules. [ETP-1127]
* Tweak - Changed views: `purchase-rules/admin/empty-content`
* Tweak - Fix styling and extra spaces in the Scope and Criteria fields in the Purchase Rule form. [ETP-1124]
* Tweak - Fix text alignment on the Purchase Rules page. [ETP-1128]
* Tweak - Improve Purchase Rules descriptions with italicized keywords and standardized Oxford comma usage. [ETP-1125]
* Tweak - Update the Add Purchase Rules modal so the content list handles scrolling.
* Language - 0 new strings added, 5 updated, 0 fuzzied, and 0 obsoleted.

### [6.9.0] 2025-11-18

* Version - Event Tickets Plus 6.9.0 is only compatible with Event Tickets 5.27.0 or higher.
* Feature - Introduces Purchase Rules which can help you configure logical discounts or restrictions for your ticket sales. [ETP-1028]
* Tweak - Added filters: `tec_tickets_plus_purchase_rules_feature_active`, `tec_tickets_plus_purchase_rules_frontend_single_post_data`, `tec_tickets_plus_purchase_rules_restriction_messages`, `tec_tickets_plus_purchase_rules_scope_evaluation_batch_size`, `tec_tickets_plus_purchase_rules_periodic_scope_evaluation_interval`, `tec_tickets_plus_purchase_rules_rule_translations`, `tec_tickets_plus_purchase_rules_rule_descriptions`, `tec_rest_swagger_{$type}_definition`, `tec_rest_swagger_definition`
* Tweak - Added actions: `tec_tickets_plus_purchase_rules_admin_single_post_before_render_button`, `tec_tickets_plus_purchase_rules_restriction_messages_added`, `tec_tickets_plus_purchase_rules_restriction_not_met`, `tec_tickets_plus_purchase_rules_tables_registered`, `tec_tickets_plus_purchase_rules_tables_not_registered`
* Tweak - Changed views: `purchase-rules/admin/edit`, `purchase-rules/admin/empty-content`, `purchase-rules/admin/list`, `purchase-rules/admin/single-order`, `purchase-rules/admin/single/button`, `purchase-rules/admin/single/panel`, `purchase-rules/checkout`, `purchase-rules/email`, `purchase-rules/order-details`, `v2/attendee-registration/content/attendees/fields`, `v2/attendee-registration/content/attendees/remove-button`, `v2/modal/cart`, `v2/modal/item/remove`
* Tweak - Removes ticket quantity control from attendee registration modal. [ETP-1061]
* Language - 127 new strings added, 41 updated, 1 fuzzied, and 1 obsoleted.

### [6.8.4] 2025-10-28

* Fix - Move out TicketsCommerce dependency from loading seating assets. [ET-2336]
* Fix - Prevent stock and sales double-counting when moving WooCommerce attendees between events. [ETP-1009]
* Tweak - Added actions: `tec_conditional_content_header_notice`
* Tweak - Changed views: `waitlist/admin/page`
* Language - 0 new strings added, 26 updated, 0 fuzzied, and 0 obsoleted.

### [6.8.3] 2025-09-16

* Language - Comment: Fix a typo in the title of the waitlist form. [ETP-1084]
* Language - 0 new strings added, 0 updated, 1 fuzzied, and 0 obsoleted.

### [6.8.2] 2025-09-09

* Tweak - Add requires plugin header to prevent activating ETP when ET is not active. [ETP-1025]
* Tweak - Updated check in logic for WooCommerce to fix an issue with PHP 8.3+. [ETP-1024]
* Language - 0 new strings added, 3 updated, 0 fuzzied, and 0 obsoleted.

### [6.8.1] 2025-09-02

* Tweak - Removes Square fee notice when Event Tickets Plus has an active subscription. [ET-2548]
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted.

### [6.8.0] 2025-08-19

* Version - Event Tickets Plus 6.8.0 is only compatible with Event Tickets 5.26.0 or higher.
* [EXPERIMENTAL] Feature - Extending new REST endpoints, with Plus functionality. Note: This API is for experimental use only and requires the X-TEC-EEA header. It may be subject to breaking changes in upcoming releases.
* Language - 3 new strings added, 26 updated, 0 fuzzied, and 0 obsoleted.

### [6.7.0] 2025-07-16

* Version - Event Tickets Plus 6.7.0 is only compatible with Event Tickets 5.25.0 or higher.
* Feature - Added a new REST API endpoint for the Offline checkin that enables batch processing of check-in or uncheckin operations in a single request. [ETP-1000]
* Feature - For the new offline checkin app we have added new admin interface components that display duplicate checkin notices and detailed checkin history error logs for attendees. [ETP-1003]
* Fix - Add logic to prevent duplicate totals showing on the Attendees Page. [ET-2308]
* Fix - Avoid redirects to the Attendee Registration page if WooCommerce is completing an order. [ETP-1022]
* Fix - Ensure that when an attendee of a WooCommerce ticket is deleted, it's properly reflected in the issued tickets and total sales numbers. [ET-2305]
* Fix - Make sure add_submenu_page is called correctly to avoid deprecation messages. [TEC-5529]
* Tweak - Added filters: `event_tickets_attendees_edd_checkin_stati`, `event_tickets_attendees_woo_checkin_stati`, `tec_tickets_plus_bulk_checkin_limit`
* Language - 30 new strings added, 27 updated, 0 fuzzied, and 0 obsoleted.

### [6.6.1] 2025-06-18

* Version - Event Tickets Plus 6.6.1 is only compatible with Event Tickets 5.24.2 or higher.
* Fix - Ensure WooCommerce Block cart page does not interrupt seated tickets functionality. [SL-291]
* Language - 0 new strings added, 13 updated, 0 fuzzied, and 0 obsoleted.

### [6.6.0] 2025-06-11

* Version - Event Tickets Plus 6.6.0 is only compatible with Event Tickets 5.24.1 or higher.
* Feature - Ticket Presets. Save time creating tickets with the new reusable tickets functionality. Create a ticket once, use on unlimited events.
* Tweak - Added filters: `tec_tickets_plus_ticket_presets_enabled`, `tec_tickets_plus_ticket_presets_active`, `event_tickets_plus_meta_fields_by_preset`, `tribe_tickets_plus_meta_field_class`, `tec_tickets_plus_preset_meta`, `tribe_tickets_plus_presets_decimal_places`, `tribe_tickets_plus_presets_decimal_separator`, `tribe_tickets_plus_presets_thousands_separator`
* Tweak - Added actions: `tec_tickets_plus_save_as_preset_modal_fields`, `tec_tickets_plus_ticket_presets_activated`
* Tweak - Changed views: `meta/birth`, `meta/datetime`, `meta/email`, `meta/number`, `meta/telephone`, `meta/url`, `tickets-plus/attendee-list-checkbox-rsvp`, `tickets-plus/attendee-list-checkbox-tickets`, `tickets-plus/orders-edit-meta`, `tickets-plus/orders-tickets`, `tickets-wallet-plus/apple-wallet/emails/template-parts/body/apple-pass`, `tickets-wallet-plus/apple-wallet/emails/template-parts/header/head/styles`, `v2/attendee-registration/button/back-to-cart`, `v2/attendee-registration/button/submit`, `v2/attendee-registration/content`, `v2/attendee-registration/content/attendees/content`, `v2/attendee-registration/content/attendees/error`, `v2/attendee-registration/content/attendees/fields`, `v2/attendee-registration/content/attendees/remove-button`, `v2/attendee-registration/content/event`, `v2/attendee-registration/content/event/summary`, `v2/attendee-registration/content/event/summary/description`, `v2/attendee-registration/content/event/summary/title`, `v2/attendee-registration/content/notice`, `v2/attendee-registration/content/title`, `v2/attendee-registration/footer`, `v2/attendee-registration/mini-cart`, `v2/attendee-registration/mini-cart/footer`, `v2/commerce/checkout/cart/item/details/extra`, `v2/commerce/checkout/cart/item/details/extra/fields`, `v2/commerce/checkout/cart/item/details/extra/name/iac`, `v2/components/meta/birth`, `v2/components/meta/checkbox`, `v2/components/meta/datetime`, `v2/components/meta/email`, `v2/components/meta/number`, `v2/components/meta/radio`, `v2/components/meta/select`, `v2/components/meta/telephone`, `v2/components/meta/text`, `v2/components/meta/url`, `v2/modal/attendee-registration`, `v2/modal/attendee-registration/footer`, `v2/modal/attendee-registration/notice/non-ar`, `v2/modal/attendee-registration/title`, `v2/modal/cart`, `v2/modal/form`, `v2/modal/item/total`, `v2/tickets/commerce/fields`
* Fix - Add check if attendee is an array in allow_resending_email. [ETP-1011]
* Fix - Fix the logic when checking if the requirements for PDF generation are met. [ETP-963]
* Language - 102 new strings added, 51 updated, 1 fuzzied, and 0 obsoleted.

### [6.5.1.1] 2025-06-06

* Fix - Utilize the newer version of our build process to ensure inline svgs are being handled properly. [TCMN-188]

### [6.5.1] 2025-06-03

* Version - Event Tickets Plus 6.5.1 is only compatible with Event Tickets 5.24.0 or higher.
* Tweak - Added filters: `tec_tickets_plus_waitlist_ticket_about_to_go_to_sale_seconds`
* Tweak - Changed views: `v2/commerce/checkout/cart/item/details/extra`, `v2/commerce/checkout/cart/item/details/extra/fields`, `v2/commerce/checkout/cart/item/details/extra/name/attendee`, `v2/commerce/checkout/cart/item/details/extra/name/iac`, `v2/commerce/checkout/header/links/modify-attendees`
* Tweak - Moved Ticket's Stats logic into Event Tickets for reusability. [ET-2383]
* Fix - Handle fatal error when image libraries are missing on the server [ETP-1018]
* Language - 0 new strings added, 15 updated, 0 fuzzied, and 0 obsoleted.

### [6.5.0] 2025-05-20

* Version - Event Tickets Plus 6.5.0 is only compatible with Event Tickets 5.23.0 or higher.
* Tweak - Add support for horizontal layout blocks in settings pages for improved visual organization.
* Tweak - Updated styling for settings forms with new classes like `tec-settings-form__header-block` and `tec-settings-form__section-header`.
* Tweak - Updated the Attendee Registration and Integrations settings pages with improved UI and clearer descriptions.
* Tweak - Improve settings layout for WooCommerce integration with better organization and clearer messaging.
* Tweak - Moved email footer credit setting to appear before `tec-settings-email-email-styling-wrapper-end`.
* Tweak - Consolidated Tickets Commerce description to use paragraph formatting.
* Tweak - Eliminated duplicate vendor dependencies in asset loading by removing 'tribe-tickets-plus-gutenberg-vendor'.
* Tweak - Renamed asset group paths for better organization and more consistent naming.
* Tweak - Transitioned from `tribe_asset` to `tec_asset` for modern asset handling.
* Fix - Optimized Seating feature to properly register assets when on single event pages.
* Fix - Improved WooCommerce integration with assigned seating to display notice text more elegantly.
* Fix - Updated JavaScript files throughout to use consistent formatting and coding standards.
* Fix - Fixed deprecated message display for assigned seating with WooCommerce.
* Compatibility - Updated the plugin to use the new group paths system for assets.
* Language - 0 new strings added, 109 updated, 1 fuzzied, and 1 obsoleted.

### [6.4.0] 2025-05-13

* Feature - Move QR-Related code from ET to Common [TEC-5426]
* Feature - Move QR code library to Common [TEC-5403]
* Tweak - Added actions: `tec_tickets_plus_fully_loaded`, `tec_tickets_wallet_plus_fully_loaded`
* Tweak - Avoid multiple inits of Tribe__Tickets_Plus__Commerce__WooCommerce__Main resulting in duplicate hooks. [ECP-1002]
* Language - 0 new strings added, 36 updated, 0 fuzzied, and 0 obsoleted.

### [6.3.0.2] 2025-03-26

* Fix - Seating load causing fatal on Cart and Checkout page when TicketsCommerce was inactive. [ETP-999]

### [6.3.0.1] 2025-03-20

* Fix - Resolve Waitlist problems on Blocks Editor.

### [6.3.0] 2025-03-13

* Feature - WooCommerce integration for seating tickets, allowing admins to create and sell seating tickets with WooCommerce. [SL-209]
* Fix - Regenerate Order action not showing up on orders when HPOS is enabled. [ETP-998]
* Tweak - Added filters: `tec_tickets_plus_seating_register_ar_assets`, `tec_tickets_plus_seating_is_checkout_page`, `tec_tickets_plus_woocommerce_attendee_regeneration`.
* Language - 8 new strings added, 12 updated, 1 fuzzied, and 0 obsoleted.

### [6.2.0] 2025-03-06

* Version - Event Tickets Plus 6.2.0 is only compatible with Event Tickets 5.20.0 or higher.
* Feature - Added Waitlist functionality. [ETP-944]
* Tweak - Added actions: `tec_tickets_plus_waitlist_before_metabox`, `tec_tickets_plus_waitlist_before_inject_html_in_{$hook_prefix}_block`, `tec_tickets_plus_waitlist_before_inject_html_in_block`, `tec_tickets_plus_waitlist_after_inject_html_in_{$hook_prefix}_block`, `tec_tickets_plus_waitlist_after_inject_html_in_block`, `tec_tickets_plus_waitlist_subscriber_pre_notify`, `tec_tickets_plus_waitlist_subscriber_post_notify`, `tec_tickets_plus_waitlist_before_create_subscriber`, `tec_tickets_plus_waitlist_after_create_subscriber`, `tec_tickets_plus_waitlist_before_delete_subscribers`, `tec_tickets_plus_waitlist_no_pending_subscribers_to_delete`, `tec_tickets_plus_waitlist_failed_delete_subscribers`, `tec_tickets_plus_waitlist_after_delete_subscribers`, `tec_tickets_plus_waitlist_before_delete`, `tec_tickets_plus_waitlist_after_delete`, `tec_tickets_plus_waitlist_no_subscribers_to_process`, `tec_tickets_plus_waitlist_subscriber_being_processed`, `tec_tickets_plus_waitlist_subscribers_batch_processed`, `tribe_log`
* Tweak - Added filters: `tec_tickets_plus_waitlist_feature_active`, `tec_tickets_plus_waitlist_subscriber_notify_meta`, `tec_tickets_plus_waitlist_is_active`, `tec_tickets_plus_waitlist_conditional_label`, `tec_tickets_plus_waitlist_process_subscribers_batch_size`, `tec_tickets_plus_waitlist_interval_between_batches`, `tec_tickets_plus_waitlist_subscribers_batch_errors`
* Tweak - Changed views: `waitlist/admin/empty-content`, `waitlist/admin/metabox`, `waitlist/admin/page`, `waitlist/form`
* Fix - Restore Ticket's API capability checks to take place in controller and not in internal API [ET-2313]
* Language - 107 new strings added, 32 updated, 0 fuzzied, and 0 obsoleted.

### [6.1.5.2] 2025-02-27

* Fix - Template conditional appearance, ensuring the SKU field appears when editting a Ticket created through WooCommerce. [ETP-996]

### [6.1.5.1] 2025-02-20

* Security - Hardened the API around ticket and attendee creation, editing, and deletion. Props to "the sneaky squirrel" for the report! [SVUL-14]
* Language - 0 new strings added, 18 updated, 0 fuzzied, and 0 obsoleted.

### [6.1.5] 2025-02-10

* Tweak - Adds ORDER BY clause in order queries for event which they were created through WooCommerce to avoid possible randomness. [ETP-960]
* Tweak - Introduce method `get_sale_price_details` which enables to retrieve sale details for a ticket created through WooCommerce. [ET-2100]
* Tweak - Updated metabox HTML with new dependency requirements for adding and editing tickets in the classic editor. [ET-2287]
* Fix - Added check for correct return type for `hijack_ticket_link`. [ETP-871]
* Language - 0 new strings added, 23 updated, 0 fuzzied, and 0 obsoleted.

### [6.1.4] 2025-01-30

* Fix - Update asset, dependencies, customizations to align with WordPress 6.7 and React 18. [TEC-5322]
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted.

### [6.1.3] 2025-01-22

* Version - Bump tested-up-to version for WooCommerce [ECP-1882]
* Fix - Moved Email resend handler under 'init' action with other providers to avoid fatals during updates. [ET-2274]
* Language - 0 new strings added, 3 updated, 0 fuzzied, and 0 obsoleted.

### [6.1.2] 2024-12-17

* Tweak - Changed views: `tickets-plus/attendee-list-checkbox-rsvp`, `tickets-plus/attendee-list-checkbox-tickets`, `tickets-plus/orders-edit-meta`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details`
* Tweak - Updated file paths in the folder 'src/views/tickets-plus' for `attendee-list-checkbox-rsvp.php`, `attendee-list-checkbox-tickets.php`, and `orders-edit-meta.php` from `[your-theme]/tribe` to `[your-theme]/tribe-events`. [ETP-888]
* Fix - Attendee registration fields will now appear when the AR modal is disabled. [ET-2266]
* Fix - Corrected all template override paths in `src/admin-views/manual-attendees` files and set `set_template_folder_lookup` to `true`. [ETP-961]
* Fix - Ensure that number_format is used with a float value to prevent issues with PHP 8.0+. [ETP-962]
* Fix - Prevent Seating scripts from loading in Attendee Registration page or Checkout when there are no Seating Tickets in cart. [ETP-964]
* Fix - Remove an additional `pdf/` being added to the template override path for the files in the `attendee-details` directory. [ET-2265]
* Fix - You will now be correctly forwarded to the attendee registration page when using IAC with the attendee registration modal disabled. [ETP-950]
* Language - 0 new strings added, 31 updated, 0 fuzzied, and 0 obsoleted.

### [6.1.1] 2024-11-19

* Version - Event Tickets Plus 6.1.1 is only compatible with Event Tickets 5.17.0 or higher.
* Feature - Update Seating assets into using Group Paths. [SL-246]
* Fix - Activate PDF Passes if GD ext. installed. Safer configuration of TCPDF library. [SL-234, SL-247]
* Fix - Show seat labels in attendee registration page or modal. [SL-251]
* Language - 1 new strings added, 6 updated, 0 fuzzied, and 0 obsoleted.

### [6.1.0] 2024-10-30

* Version - Event Tickets Plus 6.1.0 is only compatible with Event Tickets 5.16.0 or higher.
* Feature - Added integration with new premium Seating product for Event Tickets.
* Tweak - Added filters: `tribe_tickets_plus_ticket_is_unlimited`, `tec_tickets_ar_modal_arguments`, `tec_tickets_ar_modal_id`
* Tweak - Changed views: `v2/attendee-registration/content/attendees/fields`, `v2/modal/cart`, `v2/tickets/submit/button-modal`

### [6.0.5] 2024-10-09

* Feature - Include alternate ticket providers into new Tickets Home page. [ET-2173]
* Fix - Load the full Payment Element if we have Wallets enabled. [ETP-942]
* Fix - Add Event Tickets Plus meta during ticket duplication [ECP-1826].
* Fix - Change the meta_value from %d to %s, saving SQL from needing to cast the value to evaluate it. [GTRIA-1236]
* Language - 0 new strings added, 23 updated, 0 fuzzied, and 0 obsoleted

### [6.0.4] 2024-09-26

* Fix - Load the full Payment Element if we have Wallets enabled. [ETP-942]
* Fix - Change the meta_value from %d to %s, saving SQL from needing to cast the value to evaluate it. [GTRIA-1236]
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted

### [6.0.3] 2024-09-11

* Fix - Corrected an issue where WooCommerce emails were sent prematurely when moving an attendee to a new ticket. [ETP-939]
* Fix - Corrected an issue where moving attendees with WooCommerce did not update the Order ID or Product ID, causing inconsistencies in the attendee's data and related views. [ETP-928]
* Tweak - Updated the order of parameters sent to the explode function for WooCommerce Orders Report. [ETP-937]
* Tweak - Updated compatibility logic for WooCommerce HPOS. [ETP-940]
* Language - 0 new strings added, 19 updated, 0 fuzzied, and 0 obsoleted

### [6.0.2] 2024-08-20

* Tweak - Moved attendee, orders, and ticket related endpoint registering for Power Automate and Zapier endpoints to Event Tickets Plus. [EVA-160]
* Tweak - Added actions: `tec_tickets_plus_attendee_bind_implementations`
* Language - 0 new strings added, 6 updated, 0 fuzzied, and 0 obsoleted

### [6.0.1] 2024-08-06

* Fix - Resolve issue with Zapier action endpoints (find attendees, & find tickets) return the error: "Sorry, you are not allowed to do that." [TEC-5123]
* Tweak - Added filters: `tec_tickets_wallet_plus_tab_settings`, `tec_tickets_wallet_plus_settings_fields`, `tec_tickets_wallet_plus_settings_sections`, `tec_tickets_wallet_plus_passes_controller_get_modifiers`, `tec_tickets_wallet_plus_{$slug}_checkbox_list_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_checkbox_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_color_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_dropdown_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_text_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_image_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_toggle_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_wysiwyg_get_setting_definition`, `tec_tickets_wallet_plus_whodat_client_endpoint`, `tec_tickets_wallet_plus_whodat_client_base_url`, `tec_tickets_wallet_plus_legacy_template_path`, `tec_tickets_wallet_plus_passes_apple_wallet_pass_package_should_attach_image_bits`, `tec_tickets_wallet_plus_apple_pass_data`, `tec_tickets_wallet_plus_apple_pass_data_{$attendee_id}`, `tec_tickets_wallet_plus_apple_preview_pass_data`, `tec_tickets_wallet_plus_apple_settings_fields`, `tec_tickets_wallet_plus_passes`, `tec_tickets_wallet_plus_pdf_pass_template_vars`, `tec_tickets_wallet_plus_pdf_pass_get_pdf_object`, `tec_tickets_wallet_plus_pdf_pass_filename`, `tec_tickets_wallet_plus_pdf_sample_template_context`, `tec_tickets_wallet_plus_pdf_settings_fields`
* Tweak - Changed views: `tickets-wallet-plus/apple-wallet/emails/template-parts/body/apple-pass`, `tickets-wallet-plus/apple-wallet/emails/template-parts/header/head/styles`, `tickets-wallet-plus/apple-wallet/rsvp/apple-wallet-button`, `tickets-wallet-plus/attendees-list/passes`, `tickets-wallet-plus/components/apple-wallet-button`, `tickets-wallet-plus/components/pdf-button`, `tickets-wallet-plus/my-tickets/passes`, `tickets-wallet-plus/pdf/pass`, `tickets-wallet-plus/pdf/pass/body`, `tickets-wallet-plus/pdf/pass/body/additional-information`, `tickets-wallet-plus/pdf/pass/body/additional-information/content`, `tickets-wallet-plus/pdf/pass/body/additional-information/heading`, `tickets-wallet-plus/pdf/pass/body/post-title`, `tickets-wallet-plus/pdf/pass/body/sidebar`, `tickets-wallet-plus/pdf/pass/body/ticket-info`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details/name`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details/qr-image`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details/security-code`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details/ticket-title`, `tickets-wallet-plus/pdf/pass/body/ticket-info/image`, `tickets-wallet-plus/pdf/pass/footer`, `tickets-wallet-plus/pdf/pass/footer/credit`, `tickets-wallet-plus/pdf/pass/header`, `tickets-wallet-plus/pdf/pass/styles`, `tickets-wallet-plus/pdf/rsvp/pdf-button`
* Language - 0 new strings added, 3 updated, 0 fuzzied, and 0 obsoleted

### [6.0.0] 2024-07-22

* Version - Event Tickets Plus 6.0.0 is only compatible with Event Tickets 5.13.0 and higher.
* Feature - Added PDF Tickets.
* Feature - Added Apple Wallet passes.
* Feature - Added automation integrations with Zapier, and Microsoft Power Automate.
* Tweak - Added filters: `tec_tickets_wallet_plus_tab_settings`, `tec_tickets_wallet_plus_settings_fields`, `tec_tickets_wallet_plus_settings_sections`, `tec_tickets_wallet_plus_passes_controller_get_modifiers`, `tec_tickets_wallet_plus_{$slug}_checkbox_list_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_checkbox_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_color_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_dropdown_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_text_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_image_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_toggle_get_setting_definition`, `tec_tickets_wallet_plus_{$slug}_wysiwyg_get_setting_definition`, `tec_tickets_wallet_plus_whodat_client_endpoint`, `tec_tickets_wallet_plus_whodat_client_base_url`, `tec_tickets_wallet_plus_legacy_template_path`, `tec_tickets_wallet_plus_passes_apple_wallet_pass_package_should_attach_image_bits`, `tec_tickets_wallet_plus_apple_pass_data`, `tec_tickets_wallet_plus_apple_pass_data_{$attendee_id}`, `tec_tickets_wallet_plus_apple_preview_pass_data`, `tec_tickets_wallet_plus_apple_settings_fields`, `tec_tickets_wallet_plus_passes`, `tec_tickets_wallet_plus_pdf_pass_template_vars`, `tec_tickets_wallet_plus_pdf_pass_get_pdf_object`, `tec_tickets_wallet_plus_pdf_pass_filename`, `tec_tickets_wallet_plus_pdf_sample_template_context`, `tec_tickets_wallet_plus_pdf_settings_fields`
* Tweak - Changed views: `tickets-wallet-plus/apple-wallet/emails/template-parts/body/apple-pass`, `tickets-wallet-plus/apple-wallet/emails/template-parts/header/head/styles`, `tickets-wallet-plus/apple-wallet/rsvp/apple-wallet-button`, `tickets-wallet-plus/attendees-list/passes`, `tickets-wallet-plus/components/apple-wallet-button`, `tickets-wallet-plus/components/pdf-button`, `tickets-wallet-plus/my-tickets/passes`, `tickets-wallet-plus/pdf/pass`, `tickets-wallet-plus/pdf/pass/body`, `tickets-wallet-plus/pdf/pass/body/additional-information`, `tickets-wallet-plus/pdf/pass/body/additional-information/content`, `tickets-wallet-plus/pdf/pass/body/additional-information/heading`, `tickets-wallet-plus/pdf/pass/body/post-title`, `tickets-wallet-plus/pdf/pass/body/sidebar`, `tickets-wallet-plus/pdf/pass/body/ticket-info`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details/name`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details/qr-image`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details/security-code`, `tickets-wallet-plus/pdf/pass/body/ticket-info/attendee-details/ticket-title`, `tickets-wallet-plus/pdf/pass/body/ticket-info/image`, `tickets-wallet-plus/pdf/pass/footer`, `tickets-wallet-plus/pdf/pass/footer/credit`, `tickets-wallet-plus/pdf/pass/header`, `tickets-wallet-plus/pdf/pass/styles`, `tickets-wallet-plus/pdf/rsvp/pdf-button`
* Language - 54 new strings added, 17 updated, 0 fuzzied, and 0 obsoleted

### [5.10.3] 2024-07-18

* Tweak - Initialized class variables for WooCommerce to fix an issue with PHP 8.3+. [ETP-926]
* Tweak - When using `add_event_title_for_order_item` with WooCommerce an additional check will occur to confirm the product is a ticket. [ETP-921]
* Language - 0 new strings added, 24 updated, 0 fuzzied, and 0 obsoleted

### [5.10.2] 2024-05-08

* Fix - Corrected an issue where saving Attendee data was saving it in the incorrect format. [ETP-910]
* Fix - When exporting attendees with incorrect Attendee data, the correct data will display. [ETP-910]
* Fix - Option to restock tickets on refunded orders will now be available in WooCommerce, when HPOS is enabled. [ETP-898]
* Language - 0 new strings added, 6 updated, 0 fuzzied, and 0 obsoleted

### [5.10.1] 2024-04-18

* Fix - Orders report for posts using EDD as their provider will display the correct quantity numbers. [ETP-897]
* Fix - Removed additional limitations on who can see the "Public Attendees List". [ETP-908]
* Feature - Add compatibility with the new Attendees page. [ET-1707]
* Language - 1 new strings added, 16 updated, 0 fuzzied, and 0 obsoleted

### [5.10.0] 2024-04-04

* Tweak - Enhanced the style to the sale price on the front end.
* Language - 0 new strings added, 3 updated, 0 fuzzied, and 0 obsoleted

### [5.9.4] 2024-03-25

* Feature - Add the Series Pass email template. [ET-1854]
* Tweak - Optimized the Orders page when WooCommerce is being used. [ET-2065]
* Language - 0 new strings added, 11 updated, 0 fuzzied, and 0 obsoleted

### [5.9.3] 2024-03-12

* Fix - Prevent error from occurring when sorting the tickets meta box within the classic editor. [ET-1941]
* Tweak - Refactored WooCommerce HPOS logic to speed up retrieving orders. [ETP-903]
* Tweak - Hide attendee opt-out meta from the WooCommerce order details page. [ETP-880]
* Security - Added filterable role access to the orders page (`tec_tickets_report_{$page_slug}_page_role_access`). [SVUL-1]
* Language - 0 new strings added, 24 updated, 0 fuzzied, and 0 obsoleted

### [5.9.2] 2024-02-19

* Feature - Support per Event attendance for Series Pass Attendees for manual and app based check-ins. [ET-1936]
* Language - 0 new strings added, 32 updated, 0 fuzzied, and 0 obsoleted

### [5.9.1] 2024-02-06

* Fix - Sort the attendees the same as they were entered for WooCommerce orders. [ETP-890]
* Fix - Sort the attendees the same as they were entered for Easy Digital Download orders. [ETP-891]
* Fix - Resolve edge case usages for Shortcode with Attendees Listing.
* Fix - Update usage of `method_exists()` to comply with PHP 8.1 standards. [ET-1759]
* Fix - Show re-send ticket email checkbox when updating attendee email on the My Tickets page. [ETP-893]
* Tweak - Event Tickets Plus is now compatible with WooCommerce High-Performance Order Storage (HPOS). [ET-1914]
* Tweak - Added filter: `tec_tickets_get_field_meta_for_attendee`.
* Language - 2 new strings added, 21 updated, 0 fuzzied, and 0 obsoleted

### [5.9.0] 2024-01-22

* Version - Event Tickets Plus 5.9.0 is only compatible with Event Tickets 5.8.0 and higher.
* Feature - Added support for Series Passes with QR Codes, Shared Capacity and Attendee Registration.
* Tweak - Added filters: `tec_tickets_plus_woocommerce_order_event_details`, `tec_tickets_plus_editor_capacity_table_tickets`, `tec_tickets_plus_editor_capacity_table_tickets_by_type`, `tec_tickets_plus_editor_capacity_table_capacity_by_type`, `tec_tickets_plus_editor_capacity_table_total_capacity`, `tec_tickets_plus_editor_capacity_table_label_for_type`, `tec_tickets_plus_my_tickets_order_list_ticket_type_titles`
* Language - 2 new strings added, 45 updated, 3 fuzzied, and 0 obsoleted

### [5.8.1] 2023-12-13

* Fix - QR codes should now work when using the legacy emails system. [GTRIA-1133]
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted

### [5.8.0] 2023-11-16

* Version - Event Tickets Plus 5.8.0 is only compatible with Event Tickets 5.7.0 and higher.
* Feature - Include all the features to have Wallet Plus compatibility into Event Tickets Plus.
* Language - 3 new strings added, 57 updated, 1 fuzzied, and 29 obsoleted

### [5.7.7] 2023-11-01

* Feature - WooCommerce and Easy Digital Downloads Order report pages are updated with new design. [ET-1810]
* Language - 0 new strings added, 8 updated, 0 fuzzied, and 6 obsoleted

### [5.7.6] 2023-10-11

* Version - Event Tickets Plus 5.7.6 is only compatible with Event Tickets 5.6.6 and higher.
* Fix - Ticket property invalidation to ensure capacity, inventory and availability are correctly invalidated. [ET-1887]
* Tweak - Make use of the QR Code library from Event Tickets to generate QR codes for tickets, instead of including one in Event Tickets Plus. [ETWP-29]
* Language - 3 new strings added, 25 updated, 0 fuzzied, and 1 obsoleted

### [5.7.5] 2023-09-13

* Fix - Ensure that the attendee collection setting displays correctly when retrieving individual ticket. [ETP-873]
* Fix - Checkout links formatting incorrectly in some themes. [ETP-867]
* Fix - Prevent some button background styles from being overridden by theme editors. [ET-1815]
* Tweak - Removed some deprecated filter_vars to avoid PHP 8.1 warnings. [ET-1800]
* Tweak - Add `total_type_label` to list of Attendance Totals for use on the Attendees page. [ET-1842]
* Language - 0 new strings added, 3 updated, 0 fuzzied, and 0 obsoleted

### [5.7.4] 2023-08-16

* Fix - Fixed displaying WooCommerce Ticket prices including tax or vat. [ETP-833]
* Fix - Ensure the Attendees page displays correctly when accessed through the Events Manager. [ECP-1527]
* Fix - Avoid duplication of manually created attendees for Easy Digital Downloads. [ETP-869]
* Fix - Random fatal error occurring when using Elementor. [ET-1829]
* Fix - Resolved an issue where deleting a WooCommerce ticket would result in an error. [ETP-870]
* Fix - Fixed showing saved ARF values for checkbox as not selected while editing an attendee. [ETP-875]
* Fix - Allowed filtering of Ticket Meta cookie name to fix conflict with Pantheon hosting [GTRIA-1024]
* Tweak - Cache Tickets objects for performance improvements. [ET-1808]
* Language - 0 new strings added, 25 updated, 0 fuzzied, and 0 obsoleted

### [5.7.3] 2023-07-18

* Tweak - Add going/not-going status while adding RSVP attendees manually. [ETP-706]
* Tweak - Refactored CSS for Tickets Emails to better conform to email client CSS standards. [ETP-872]
* Fix - The Attendee List will now be correctly displayed when the 'Show attendees list on event page' option is enabled within the classic editor. [ETP-623]
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted

### [5.7.2] 2023-06-29

* Fix - Addressed an issue where the system would provide duplicate plugin names when encountering an invalid license key. [ET-1738]
* Language - 0 new strings added, 24 updated, 0 fuzzied, and 0 obsoleted

### [5.7.1] 2023-06-22

* Version - Event Tickets Plus 5.7.1 is only compatible with Event Tickets 5.6.1 and higher.
* Fix - Lock our container usage(s) to the new Service_Provider contract in tribe-common. This prevents conflicts and potential fatals with other plugins that use a di52 container.

### [5.7.0.1] 2023-06-20

* Fix - Resolved issues with Attendee Registration not being bound correctly on loading. [ET-1771]

### [5.7.0] 2023-06-15

* Feature - Introduction of Tickets Emails, the new and improved solution for managing Event Tickets related emails.
* Tweak - Changed views: `v2/emails/template-parts/body/ticket/ar-fields`, `v2/emails/template-parts/body/ticket/ar-fields/data`, `v2/emails/template-parts/body/ticket/ar-fields/key`, `v2/emails/template-parts/body/ticket/ar-fields/value`, `v2/emails/template-parts/body/ticket/qr-image`, `v2/emails/template-parts/header/head/ar-styles`
* Language - 9 new strings added, 18 updated, 3 fuzzied, and 2 obsoleted

### [5.6.10] 2023-05-04

* Fix - Resolved missing default IAC setting during Ticket CSV Import. [ETP-840]
* Language - 3 new strings added, 13 updated, 3 fuzzied, and 0 obsoleted

### [5.6.9] 2023-04-03

* Fix - When using WooCommerce the SKU will properly appear when creating a ticket using Community Tickets. [CT-64]
* Language - 3 new strings added, 17 updated, 0 fuzzied, and 0 obsoleted

### [5.6.8] 2023-03-08

* Tweak - Code maintenance for the attendees screen. [ET-1635]
* Tweak - Add description for the Attendees Registration settings tab. [ETP-855]
* Tweak - Add options to alter RSVP status from Admin edit screen for attendees. [ETP-843]
* Fix - Resolved missing Attendee Collection and Information for the blocks editor while on Post and Pages. [ETP-831]
* Language - 4 new strings added, 27 updated, 0 fuzzied, and 1 obsoleted

### [5.6.7] 2023-02-22

* Version - Event Tickets Plus 5.6.7 is only compatible with Event Tickets 5.5.8 and higher.
* Tweak - PHP version compatibility bumped to PHP 7.4
* Tweak - Version Composer updated to 2
* Tweak - Version Node updated to 18.13.0
* Tweak - Version NPM update to 8.19.3

### [5.6.6.1] 2023-02-14

* Fix - Add a safe-check for the Easy Digital Downloads implementation to prevent a fatal error. [ETP-857]

### [5.6.6] 2023-02-09

* Fix - Resolved attendance count on Public Attendee List while using the `tribe_tickets_attendees` shortcode. [ETP-850]
* Fix - Resolved attendee check-in list for Easy Digital Downloads not working and Order edit URL. [ETP-842]
* Fix - Prevent error occurring when `register_uninstall_hook` was being called. [ETP-852]
* Language - 2 new strings added, 9 updated, 0 fuzzied, and 0 obsoleted

### [5.6.5] 2023-01-16

* Fix - Fixed Attendee info date field format not matching the date format set in the settings. [ETP-816]
* Fix - Fixed order report showing error when WooCommerce orders are refunded. [ETP-849]
* Language - 0 new strings added, 8 updated, 0 fuzzied, and 0 obsoleted

### [5.6.4] 2022-12-08

* Tweak - Sorting support added on WooCommerce Order report page Order, Email, Date, Status, and Total columns. [ET-1527]
* Fix - WooCommerce stock updates with Ticket Stock to keep the stock within max capacity. [ETP-830]
* Fix - Going into a Ticket Fieldsets menu keeps the sidebar menu active. [ETP-809]
* Language - 24 new strings added, 55 updated, 0 fuzzied, and 18 obsoleted

### [5.6.3] 2022-11-09

* Fix - Helps multiple of the same ticket form modals by targeting the selected form instead of a global parameter. [ETP-810]
* Fix - Added attendee label validation so duplicate labels can't be used which was creating database issues. [ETP-803]
* Fix - Helps multiple of the same ticket form modals by targeting the selected form instead of a global parameter. [GTRIA-729]

### [5.6.2] 2022-10-31

* Tweak - Display dependency missing warning notice for QR code setup. [ETP-759]
* Tweak - Add option to check-in QR codes only for events that are happening now. [ETP-820]
* Tweak - Introduced new Integrations tab for Tickets Settings. [ETP-806]
* Tweak - Introduced new QR code banner for Event Tickets Plus App connection. [ETP-822]
* Fix - Properly save the check-in details for attendees on check-in. [ETP-819]
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted

### [5.6.1] 2022-09-22

* Version - Updated the Minimum Required Version of PHP to 7.3
* Tweak - Improved stability and compatibility with latest version of EDD (v3.0)
* Language - 0 new strings added, 12 updated, 0 fuzzied, and 0 obsoleted

### [5.6.0] 2022-09-06

* Version - Event Tickets Plus 5.6.0 is only compatible with Event Tickets 5.5.0 and higher
* Version - Event Tickets Plus 5.6.0 is only compatible with The Events Calendar 6.0.0 and higher.
* Tweak - Adds a compatibility layer to work with the new Recurrence Backend Engine in TEC/ECP.
* Language - 0 new strings added, 15 updated, 0 fuzzied, and 0 obsoleted

### [5.5.3] 2022-08-15

* Tweak - Include attendee information for authorized requests on the `qr` REST API endpoint. [ETP-804]
* Fix - Include Attendee Registration Information for authorized requests on the `attendees` REST API endpoint. [ETP-805]
* Language - 0 new strings added, 7 updated, 0 fuzzied, and 0 obsoleted

### [5.5.2] 2022-07-05

* Fix - Fixed stock sync for WooCommerce tickets when attendees are moved between tickets. [ETP-687]
* Fix - Remove duplicate `Total Event Capacity` wording. [ET-1535]
* Fix - Remove promotion of Event Ticket Plus on Tickets Commerce payments settings page. [ET-1528]
* Language - 1 new strings added, 21 updated, 0 fuzzied, and 3 obsoleted.

### [5.5.1] 2022-06-08

* Tweak - Attendee Registration settings moved to a separate tab. [ETP-797]
* Fix - Fixed wrong text domains in few places. [ETP-795]

### [5.5.0] 2022-05-19

* Version - Event Tickets Plus 5.5.0 is only compatible with Event Tickets 5.4.0 and higher
* Feature - Adding compatibility for the new Tickets menu on the WordPress admin. [ET-1335]
* Language - 0 new strings added, 12 updated, 0 fuzzied, and 0 obsoleted

### [5.4.4.1] 2022-05-12

* Fix - Ensure that Event Tickets Plus customers never encounter application fees on Stripe for Tickets Commerce purchases. [ET-1513]

### [5.4.4] 2022-05-11

* Feature - Added Elementor widgets for Event Tickets and RSVP. [ETP-731]
* Tweak - Added icon and styling to field info in the classic editor's ticket list. [ET-1494]
* Tweak - Added filters: `tribe_event_tickets_plus_elementor_registered_{$this->type}`.
* Fix - In some cases, enabling Object Cache was not saving Attendee Registration data properly. [ETP-796]
* Fix - Fixed missing target and rel attribute for admin view links. [ETP-792]
* Language - 11 new strings added, 15 updated, 0 fuzzied, and 0 obsoleted.

### [5.4.3] 2022-04-28

* Fix - Resolve issue where a valid license key was sometimes identified as invalid when transients were cleared. [ET-1498]
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted.

### [5.4.2] 2022-04-05

* Tweak - Hide 'View My Tickets' link when showing tickets within the `[tribe_tickets]` shortcode. [ETP-775]
* Tweak - Add `tec_tickets_hide_view_my_tickets_link` filter to override the hiding of the 'View My Tickets' link. [ETP-775]
* Tweak - Added filters: `tec_tickets_hide_view_my_tickets_link`
* Tweak - Changed views: `v2/attendee-registration/content/event`, `v2/commerce/checkout/header/links/modify-attendees`
* Fix - Avoid saving `,` as decimal separator for WooCommerce Ticket prices on some currency configurations. [ETP-782]
* Fix - Fixed Attendee Registration page not working with WooCommerce 6.3.0. [ETP-785]
* Fix - Show the modify attendee link text properly depending on the count of attendees with Attendee Registration fields. [ETP-768]
* Language - 2 new strings added, 20 updated, 1 fuzzied, and 0 obsoleted

### [5.4.1] 2022-03-15

* Fix - Fixed an issue when viewing attendees using Community Event Tickets and Tickets Commerce. [CT-52]
* Fix - Fixed shared capacity calculation while moving Easy Digital Download attendees from shared capacity tickets. [ETP-284]
* Language - 0 new strings added, 12 updated, 0 fuzzied, and 0 obsoleted

### [5.4.0] 2022-02-24

* Version - Event Tickets Plus 5.4.0 is only compatible with Event Tickets 5.3.0 and higher
* Feature - Introduction of premium features for Stripe for Tickets Commerce. [ET-1342]
* Language - 16 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted

### [5.3.3] 2022-01-19

* Fix - Fixed shared capacity calculation while moving WooCommerce attendees from shared capacity tickets. [ETP-283]
* Fix - Removed ajax caching from the Attendee Registration page. [GTRIA-626]
* Language - 2 new strings added, 19 updated, 0 fuzzied, and 0 obsoleted

### [5.3.2] 2021-12-15

* Feature - Added a way to remove specific attendees from the Attendee Registration Modal prior to checking out. [ETP-143]
* Tweak - Added a `ticket_id` parameter to filter a specific ticket or tickets within the RSVP and Tickets shortcodes. [ETP-763]
* Fix - Fixed the `Add Attendee` modal from generating a 500 error when two or more tickets have been enabled for an event. [ETP-764]
* Language - 1 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted

### [5.3.1] 2021-11-17

* Tweak - Added filter `tribe_tickets_manual_attendee_allow_email_resend` to allow customization of email resending via Manual Attendees depending on status. [ETP-703]
* Fix - When an Attendee has cancelled or refunded a ticket resending the email is now disabled. [ETP-703]
* Fix - Fixed Attendee Registration meta data when using EDD and having multiple attendees. [ETP-755]
* Fix - Totals on attendee registration page fixed when period is used as the thousand separator. [ETP-757]
* Language - 0 new strings added, 5 updated, 0 fuzzied, and 0 obsoleted

### [5.3.0] 2021-11-04

* Feature - Introduction of Tickets Commerce, the new and improved solution you can set up to sell tickets with Event Tickets.
* Language - 2 new strings added, 30 updated, 0 fuzzied, and 0 obsoleted

### [5.2.10] 2021-09-28

* Tweak - Changed the `provider` URL variable name to `tickets_provider`. The filter `tribe_tickets_get_provider_query_slug` allows for customization. [ET-543]
* Tweak - Added the `isValidForm.eventTicketsModal` JS event to allow for third party plugins to provide their own validation logic. [ETP-752]
* Fix - Removed the ability to resend tickets from the Attendees page to Attendees who cancelled or refunded their ticket. [ETP-703]
* Fix - Fix the inconsistent vertical spacing between attendee registration fields in admin view. [ETP-748]
* Language - 0 new strings added, 23 updated, 0 fuzzied, and 0 obsoleted

### [5.2.9] 2021-08-31

* Fix - Fixed cart calculation inconsistency with WooCommerce when the "Number of decimals" setting was set to `0`. [ETP-324]
* Enhancement - Added description field support for Attendee Registration Fields. [ETP-712]
* Enhancement - Updated layout and content for attendee registration fields. [ETP-741]
* Tweak - Added the ability to hide attendee data from public view via the AR Modal. [ETP-127]
* Language - 5 new strings added, 14 updated, 0 fuzzied, and 2 obsoleted

### [5.2.8] 2021-08-03

* Feature - Added filter `tribe_tickets_plus_woo_meta_data_enabled` to toggle additional fields in WooCommerce. [ETP-737]
* Feature - Added filter `tribe_tickets_plus_woo_meta_data_filter` to filter additional fields in WooCommerce. [ETP-737]
* Tweak - Updated WooCommerce to use `wc_get_order` instead of `new WC_Order`. [ETP-141]
* Fix - Fix the validation for the text and telephone "Attendee Registration Fields" so that it doesn't take empty spaces as valid when the field is required. [ETP-733]
* Language - 0 new strings added, 31 updated, 0 fuzzied, and 0 obsoleted

### [5.2.7.1] 2021-07-20

* Fix - Conflict with WooCommerce Analytics. Ensure admin JS is enqueued only on relevant pages in the dashboard. [ETP-736]

### [5.2.7] 2021-07-07

* Tweak - Added `$ticket_id` parameter to the `tribe_events_tickets_metabox_edit_ajax_advanced` filter. [ETP-111]
* Feature - Allow regeneration of attendees for WooCommerce orders. [ETP-707]
* Feature - Enhanced WooCommerce templates for showing ticket and attendee data in Order details pages and emails. [ETP-724]
* Language - 10 new strings added, 25 updated, 0 fuzzied, and 0 obsoleted

### [5.2.6] 2021-06-23

* Tweak - Ensure admin JS is only enqueued on relevant pages in the dashboard. [TEC-3904]
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted

### [5.2.5] 2021-06-09

* Feature - Add a new Resend-tickets action link for attendees within the admin attendee list view. [ETP-704]
* Fix - Fixed shared capacity stock sync after attendee deletion, for WooCommerce tickets. [ETP-651]
* Fix - Fixed shared capacity stock sync after attendee deletion, for Easy Digital Downloads tickets. [ETP-285]
* Fix - Fixed shared capacity stock not getting updated when any WooCommerce Order is cancelled. [ETP-664]
* Fix - Allow admins to restock refunded order tickets manually. [ETP-475]
* Fix - Problem with the "opt-out" being always on when using the Attendee Registration Modal. [ETP-727]
* Tweak - Added singular and plural support for the Attendee Registration notice regarding tickets without Attendee Registration fields in cart. [ETP-657]
* Language - 8 new strings added, 26 updated, 1 fuzzied, and 0 obsoleted

### [5.2.4] 2021-05-12

* Feature - Placeholder support added for Text, Email, Telephone and URL Attendee Registration Fields. [ETP-711]
* Fix - The Attendee Registration modal cart, now makes the right calculation when removing items. [ETP-715]
* Fix - Show total attendance count for `tribe_attendee_list` shortcode title. [ETP-129]
* Tweak - Add Attendee Registration Fields to the Tickets editor UI for the classic editor. [ETP-594]
* Tweak - Add new filter to allow filtering of the QR Code check-in API key. [ETP-720]
* Tweak - Added filters: `tribe_tickets_modal_show_if_no_ticket_with_ar_in_cart`, `tribe_tickets_plus_manual_attendees_view_send_ticket_email_for_new_attendees`, `event_tickets_plus_placeholder_enabled_ar_fields`, `event_tickets_plus_requested_api_is_valid`
* Tweak - Changed views: `meta/email`, `meta/telephone`, `meta/text`, `meta/url`, `v2/attendee-registration/mini-cart`
* Language - 3 new strings added, 17 updated, 0 fuzzied, and 0 obsoleted

### [5.2.3] 2021-04-22

* Tweak - Handle changes on the attendee meta fieldset styles when Individual Attendee Collection is enabled. [ETP-699]
* Tweak - Added filters: `tribe_tickets_modal_show_if_no_ticket_with_ar_in_cart`, `tribe_tickets_plus_manual_attendees_view_send_ticket_email_for_new_attendees`
* Tweak - Changed views: `v2/attendee-registration/mini-cart`
* Language - 1 new strings added, 5 updated, 0 fuzzied, and 1 obsoleted

### [5.2.2.1] 2021-03-30

* Fix - Resolve PHP notices when creating new tickets with Attendee Registration Information. [ETP-713]

### [5.2.2] 2021-03-30

* Fix - WooCommerce PayPal attendees are now effectively generate immediately if the setting is set to immediately generate them. [ETP-698]
* Tweak - Attendee registration fields in the admin are now open when first added. [ETP-593]
* Tweak - Add notice and Individual Attendee Collection mocked fields to the attendee registration fields in the fieldset editor and the Attendee Registration settings per ticket basis. [ETP-683]
* Tweak - Show resend ticket order action for WooCommerce attendees manually added from the Attendees Report. [ETP-688]
* Tweak - Add new filter `tribe_tickets_plus_manual_attendees_view_send_ticket_email_for_new_attendees` that lets you return false to disable sending ticket emails to new attendees added manually through the Attendees admin report.
* Tweak - Added filters: `tribe_tickets_modal_show_if_no_ticket_with_ar_in_cart`, `tribe_tickets_plus_manual_attendees_view_send_ticket_email_for_new_attendees`
* Tweak - Changed views: `v2/attendee-registration/mini-cart`
* Language - 9 new strings added, 20 updated, 0 fuzzied, and 3 obsoleted

### [5.2.1] 2021-03-04

* Fix - Compatibility with WordPress 5.7 and jQuery 3.5.X [ETP-626]
* Fix - Attendees will no longer have a new user created (if they did not already exist), which was introduced in Event Tickets Plus 5.2.0. To turn this on, you can simply add the filter `add_filter( 'tribe_tickets_attendee_create_user_from_email', '__return_true' );`
* Fix - Removed the 'Edit' column from the Attendees Report export CSV file. [ETP-652]
* Tweak - Add filter `tribe_tickets_modal_show_if_no_ticket_with_ar_in_cart` you can return false on to skip the Attendee Registration Modal if no tickets with Attendee Registration fields are in cart. [ETP-516]
* Tweak - Tweaked incomplete order status queries for MySQL 8+ compatibility in the WooCommerce integration. [ETP-669]
* Language - 0 new strings added, 30 updated, 0 fuzzied, and 0 obsoleted

### [5.2.0] 2021-02-16

* Feature - You can now add and edit attendees directly from the Attendees Report screen -- Choose the ticket or RSVP then fill out the attendee details and a ticket will be set up and emailed to them. You can edit existing attendees and all of the things you love about Attendee Registration has come along for the party too! [ETP-366]
* Feature - WooCommerce and Easy Digital Download attendees are now generated through the new Event Tickets 5.1.0 Attendees API which provides more flexibility for adding and editing attendees at the code-level. [ETP-366]
* Feature - There's a new Orders API for setting up a corresponding WooCommerce or Easy Digital Downloads order for an attendee generated through the Attendees API. [ETP-366]
* Fix - Add a workaround for a potential WooCommerce fatal error until WooCommerce 5.1 is released. [ETP-635]
* Fix - Always enforce an integer for WooCommerce when we use the cart contents because some WooCommerce-related plugins may directly modify the cart contents and set the quantity to an unexpected format (float). [ETP-631]
* Fix - Ensure form submissions for Attendee Registration Information is prepared when updating the persistent cookie the same as it is prepared for creating the cookie.
* Fix - Ensure single Attendee Registration Fields are retained properly when processing Attendee Registration Information for storage. [ETP-642]
* Tweak - Handle currently selected values in the Attendee Registration Field templates (v2) for Birth Date field, Radio field, and Checkbox field.
* Tweak - Allow providing values to Attendee Registration Fields at the code level so the fields can be prepopulated on render. [ETP-366]
* Tweak - Extend the Attendees Repository code from Event Tickets for Tribe Commerce and RSVPs so that meta integration is handled directly on attendee save. [ETP-366]
* Tweak - Added filters: `tribe_tickets_plus_manual_attendees_user_allowed_to_add`, `tribe_tickets_plus_manual_attendees_user_allowed_to_edit`, `tribe_tickets_plus_manual_attendees_add_capabilities`, `tribe_tickets_plus_manual_attendees_edit_capabilities`, `tribe_tickets_plus_manual_attendees_show_on_front`, `tribe_tickets_plus_meta_render_table_meta_data_orphaned_data`, `tribe_tickets_plus_repositories_traits_attendee_meta`, `tribe_tickets_manual_attendees_enabled`
* Tweak - Removed filters: `wootickets_attendee_insert_args`
* Tweak - Added actions: `event_tickets_woocommerce_tickets_generated`, `event_tickets_woocommerce_tickets_generated_for_product`
* Tweak - Changed views: `attendees-list`, `eddtickets/tickets`, `login-to-purchase`, `meta`, `meta/birth`, `meta/checkbox`, `meta/datetime`, `meta/email`, `meta/number`, `meta/radio`, `meta/select`, `meta/telephone`, `meta/text`, `meta/url`, `tickets-plus/attendee-list-checkbox-rsvp`, `tickets-plus/attendee-list-checkbox-tickets`, `tickets-plus/email-qr`, `tickets-plus/orders-edit-meta`, `tickets-plus/orders-tickets`, `tpp/attendees-list-optout`, `v2/attendee-registration/button/back-to-cart`, `v2/attendee-registration/button/submit`, `v2/attendee-registration/content`, `v2/attendee-registration/content/attendees/content`, `v2/attendee-registration/content/attendees/error`, `v2/attendee-registration/content/attendees/fields`, `v2/attendee-registration/content/event`, `v2/attendee-registration/content/event/summary`, `v2/attendee-registration/content/event/summary/description`, `v2/attendee-registration/content/event/summary/title`, `v2/attendee-registration/content/notice`, `v2/attendee-registration/content/title`, `v2/attendee-registration/footer`, `v2/attendee-registration/mini-cart`, `v2/attendee-registration/mini-cart/title`, `v2/components/meta/birth`, `v2/components/meta/checkbox`, `v2/components/meta/datetime`, `v2/components/meta/email`, `v2/components/meta/number`, `v2/components/meta/radio`, `v2/components/meta/select`, `v2/components/meta/telephone`, `v2/components/meta/text`, `v2/components/meta/url`, `v2/iac/attendee-registration/email-disclaimer`, `v2/iac/attendee-registration/unique-email-error`, `v2/iac/attendee-registration/unique-name-error`, `v2/iac/my-tickets/resend-email-template`, `v2/modal/attendee-registration`, `v2/modal/attendee-registration/footer`, `v2/modal/attendee-registration/notice/error`, `v2/modal/attendee-registration/notice/non-ar`, `v2/modal/attendee-registration/title`, `v2/modal/cart`, `v2/modal/form`, `v2/modal/item/opt-out`, `v2/modal/item/remove`, `v2/modal/item/total`, `v2/modal/target`, `v2/tickets/commerce/fields`, `v2/tickets/commerce/fields/edd`, `v2/tickets/commerce/fields/woo`, `v2/tickets/submit/button-modal`, `wootickets/tickets`
* Language - 28 new strings added, 40 updated, 0 fuzzied, and 0 obsoleted

### [5.1.2] 2021-01-20

* Fix - Prevent potential fatal errors by passing the currency object to the context for the tickets footer template in the Attendee Registration mini cart in all cases. [ETP-629]
* Fix - Multiple shortcodes `[tribe_tickets post_id="ID"]` in a single page will now properly work with Modal and adding to cart. [ETP-627]
* Fix - 2 new strings added, 3 updated, 0 fuzzied, and 2 obsoleted

### [5.1.1] 2020-12-15

* Feature - V2 Customizer - Add background color css overrides. [ETP-556]
* Feature - V2 Customizer - Add Event Title color css overrides. [ETP-576]
* Feature - V2 Customizer - Add Event Date & Time color css overrides. [ETP-575]
* Fix - Resolve a potential fatal error when saving a page using the Block Editor that contains the Attendee Registration Page shortcode. [ETP-598]
* Fix - Resolve PHP notices on the Attendee Registration Page from WooCommerce and Easy Digital Commerce ticket details when multiple Commerce Providers may be available. [ETP-599]
* Tweak - Added support for placeholders on the new Meta Field views (v2/components/meta/*.php) and make use of them in Individual Attendee Collection to show "Optional" text when collection is optional. [ETP-577]
* Tweak - Moved ticket editor warnings to Event Tickets. [ET-947]
* Tweak - Add opaque backgrounds for selected bordered elements. [ETP-579]
* Language - 1 new strings added, 8 updated, 0 fuzzied, and 3 obsoleted

### [5.1.0.2] 2020-11-24

* Fix - Resolve notices and fatal errors related to `[tribe_tickets]` shortcode, happening since version 5.1.0.

### [5.1.0.1] 2020-11-19

* Fix - Require Event Tickets 5.0.3+ for compatibility purposes on certain areas Event Tickets Plus that have direct calls to Event Tickets functionality. [ETP-578]

### [5.1.0] 2020-11-19

* Feature - New Individual Attendee Collection functionality now allows for collection of individual names and emails for each attendee for Tribe Commerce, WooCommerce, and Easy Digital Download tickets. You can enable this option per ticket and choose to make the fields optional or required. [ETP-364]
* Feature - An optional new set of Ticket-specific views have been added that make it easier to customize and require less updating by our team in the future. The new views have greater automated testing coverage to improve long term stability. These views must be enabled in order to make use of the new Individual Attendee Collection feature. [ETP-364]
* Fix - Hide showing attendee list option in the Community Ticket submission form if Block editor is enabled. [CT-37]
* Fix - Properly remove temporary meta storage after checkout when optional Attendee Registration field values are all submitted as empty. [ETP-558]
* Fix - Shared capacity stock changes while updating ticket. [ETP-562]
* Tweak - Add help section update notice texts for updated directory structure. [ETP-542]
* Language - 32 new strings added, 68 updated, 0 fuzzied, and 1 obsoleted
* Tweak - Added filters: `tribe_tickets_plus_attendee_registration_iac_options`, `tribe_tickets_plus_attendee_registration_iac_default_setting_for_all_tickets`, `tribe_tickets_plus_attendee_registration_iac_setting_for_ticket`, `tribe_tickets_plus_attendee_registration_iac_setting_label_for_ticket`, `tribe_tickets_plus_attendee_registration_iac_fields`, `tribe_tickets_plus_attendee_registration_view_ticket_data`, `tribe_tickets_attendee_registration_has_required_meta`, `tribe_tickets_attendee_registration_is_meta_up_to_date`, `tribe_attendee_registration_cart_provider`, `tribe_attendee_registration_form_no_provider_class`, `tribe_attendee_registration_form_classes`, `tribe_attendee_registration_form_class`, `tribe_tickets_attendee_create_individual_name`, `tribe_tickets_plus_attendee_save_meta`, `tribe_tickets_attendee_create_individual_email`, `tribe_tickets_plus_editor_configuration_vars`, `tribe_tickets_plus_meta_field_class`, `tribe_tickets_plus_ticket_has_meta_enabled`, `tribe_tickets_plus_meta_field_pre_value`, `tribe_tickets_plus_meta_field_types_collection`, `tribe_tickets_my_tickets_allow_email_resend_on_attendee_email_update`, `tribe_tickets_plus_show_unlimited_availability`, `tribe_tickets_plus_hide_attendees_list_optout`
* Tweak - Added actions: `tribe_tickets_plus_after_csv_import_ticket_created`, `tribe_tickets_plus_commerce_paypal_meta_before_save`, `tribe_tickets_plus_meta_contents_up_to_date`, `tribe_tickets_plus_attendee_update`, `tribe_tickets_plus_after_my_tickets_attendee_update`, `tribe_tickets_plus_after_my_tickets_attendee_updates`, `tribe_tickets_registration_content_before_all_events`
* Tweak - Changed views: `attendees-list`, `eddtickets/tickets`, `login-to-purchase`, `meta`, `meta/birth`, `meta/checkbox`, `meta/datetime`, `meta/email`, `meta/number`, `meta/radio`, `meta/select`, `meta/telephone`, `meta/text`, `meta/url`, `tickets-plus/attendee-list-checkbox-rsvp`, `tickets-plus/attendee-list-checkbox-tickets`, `tickets-plus/email-qr`, `tickets-plus/orders-edit-meta`, `tickets-plus/orders-tickets`, `tpp/attendees-list-optout`, `v2/attendee-registration/button/back-to-cart`, `v2/attendee-registration/button/submit`, `v2/attendee-registration/content`, `v2/attendee-registration/content/attendees/content`, `v2/attendee-registration/content/attendees/error`, `v2/attendee-registration/content/attendees/fields`, `v2/attendee-registration/content/event`, `v2/attendee-registration/content/event/summary`, `v2/attendee-registration/content/event/summary/description`, `v2/attendee-registration/content/event/summary/title`, `v2/attendee-registration/content/notice`, `v2/attendee-registration/content/title`, `v2/attendee-registration/footer`, `v2/attendee-registration/mini-cart`, `v2/attendee-registration/mini-cart/title`, `v2/components/meta/birth`, `v2/components/meta/checkbox`, `v2/components/meta/datetime`, `v2/components/meta/email`, `v2/components/meta/number`, `v2/components/meta/radio`, `v2/components/meta/select`, `v2/components/meta/telephone`, `v2/components/meta/text`, `v2/components/meta/url`, `v2/iac/attendee-registration/email-disclaimer`, `v2/iac/attendee-registration/unique-email-error`, `v2/iac/attendee-registration/unique-name-error`, `v2/iac/my-tickets/resend-email-template`, `v2/modal/attendee-registration`, `v2/modal/attendee-registration/footer`, `v2/modal/attendee-registration/notice/error`, `v2/modal/attendee-registration/notice/non-ar`, `v2/modal/attendee-registration/title`, `v2/modal/cart`, `v2/modal/form`, `v2/modal/item/opt-out`, `v2/modal/item/remove`, `v2/modal/item/total`, `v2/modal/target`, `v2/tickets/commerce/fields`, `v2/tickets/commerce/fields/edd`, `v2/tickets/commerce/fields/woo`, `v2/tickets/submit/button-modal`, `wootickets/tickets`

### [5.0.1] 2020-09-21

* Fix - Remove 'provider' query parameter from WooCommerce Cart and Checkout links to avoid conflicts with some payment gateways. It still gets added to the Attendee Registration page's URL. [ETP-322]
* Fix - Display Attendee Registration notice only to sites that have upgraded, and on the tribe settings page. [ETP-430]
* Fix - Save fieldset checkbox label when adding Attendee Registration Information. [ETP-323]
* Language - 0 new strings added, 6 updated, 0 fuzzied, and 0 obsoleted

### [5.0.0] 2020-08-26

* Feature - With our revamped RSVP experience, Attendee Registration fields have been cleaned up for RSPVs and will be served through Event Tickets Plus. Any customizations or style updates to these fields should be revisited and updated to match your current markup in their new template locations. [ET-866]
* Fix - Updated our HTML markup, accompanying CSS, and JS click event handling for WordPress 5.5 compatibility where we have toggle boxes when editing Attendee Registration Information. [ETP-380]
* Fix - Replace usage of MultiByte package when it's not available, use `tribe_strtoupper` instead of `mb_strtoupper` and `mb_detect_encoding` [ETP-411] [ETP-412] [VE-150]
* Tweak - Removed unused HTML files in the plugin root folder that were there for your reference to our plugin's data collection transparency. This information is included within WordPress' Privacy Guide at /wp-admin/privacy-policy-guide.php [ETP-348]
* Tweak - The shortcode `[tribe_tickets_rsvp]` is now compatible with the new refreshed RSVP frontend views feature in Event Tickets 5.0. [ETP-386]
* Tweak - Changed views: `meta/birth`, `v2/components/meta/birth`, `v2/components/meta/checkbox`, `v2/components/meta/datetime`, `v2/components/meta/email`, `v2/components/meta/number`, `v2/components/meta/radio`, `v2/components/meta/select`, `v2/components/meta/telephone`, `v2/components/meta/text`, `v2/components/meta/url`
* Language - 5 new strings added, 11 updated, 0 fuzzied, and 0 obsoleted

### [4.12.3] 2020-07-28

* Feature - Add trigger actions (attendee registered, attendee check in) in WooCommerce and Easy Digital Downloads to notify Promoter. [ETP-350]
* Fix - Do not run our commerce provider integration code if that provider's core plugin is not currently active. For example, no fatal error should occur if an event has sold a WooCommerce ticket but now the core WooCommerce plugin is disabled. [ETP-333]
* Tweak - Added the `tribe_tickets_is_woocommerce_active()` function (one for Easy Digital Downloads already existed). [ETP-333]
* Tweak - Display all of a post's order tabs in the Attendees Report admin screen. Example: if a post's ticket provider was Easy Digital Downloads Tickets and such tickets were sold, then the post's provider changed to WooCommerce Tickets, the Attendees Report screen should show both the Easy Digital Downloads order history tab and the WooCommerce order history tab, regardless of which ticket provider is currently the default. [ETP-333]
* Tweak - Update usage of `Tribe__Tickets__Tickets::get_ticket_provider_instance()`, as it now returns a class instance instead of class name string. [ETP-333]
* Tweak - Update usage of `Tribe__Tickets__Tickets::get_event_ticket_provider()`, as it now returns false if the ticket provider is no longer active. [ETP-333]
* Tweak - Use Event Tickets' new `Tribe__Tickets__Tickets::get_attendee_optout_key()` to simplify getting the optout key regardless of ticket provider class and accounting for legacy code. [ETP-333]
* Tweak - Add labels to each select input for the Attendee Information's Birth Date field. [ETP-338]
* Tweak - Modify parameters on `register_rest_route` to include `permission_callback` to prevent notices on WordPress 5.5.
* Language - 3 new strings added, 38 updated, 0 fuzzied, and 0 obsoleted

### [4.12.2] 2020-06-24

* Tweak - Resolve a PHP notice when rendering the Birth Date field. [ETP-330]
* Language - 0 new strings added, 4 updated, 0 fuzzied, and 0 obsoleted

### [4.12.1] 2020-05-20

* Feature - Added new field types to choose from when requiring Attendee Information on a Ticket or RSVP: Email, URL, Date of Birth, Date and Telephone. [ETP-89]
* Feature - Add integration with new Event Tickets post and event filtering so it supports Easy Digital Downloads and WooCommerce. [ETP-318]
* Feature - Multiple shortcodes added: [ETP-313]
    * `[tribe_tickets_rsvp]` and `[tribe_tickets]` display the purchasing block(s) for RSVP + Tickets, just RSVP, or just Tickets, as aptly named. Both have the `post_id` argument for the post/page/event for which tickets were created.
    * `[tribe_tickets_attendees]` displays the public list of attendees. It requires the `post_id` of the event to display the attendees and has an optional `title` argument to set the title of the block in the HTML.
    * `[tribe_tickets_protected_content]` is an enclosing shortcode where any content within its opening and closing tags will only appear if the currently logged in user does (or doesn't if `ticketed=0`) have a ticket for the specified `post_id` (defaults to the current post if not set). You may optionally specify the Ticket ID(s) in addition to the Post ID, such as `ticket_ids="32,50,90"` which checks if the attendee has a ticket to any of the Ticket ID(s).
    * `[tribe_tickets_rsvp_protected_content]` is an enclosing shortcode where any content within its opening and closing tags will only appear if the currently logged in user does (or doesn't if `rsvpd=0`) have an RSVP for the specified `post_id` (defaults to the current post if not set). You may optionally specify the RSVP ID(s) in addition to the Post ID, such as `rsvp_ids="32,50,90"` which checks if the attendee has an RSVP to any of the RSVP ID(s).
    * For anyone using our past extension (no longer available) that introduced these shortcodes, the extension will be deactivated automatically to avoid conflicts.
* Fix - Update the `orders-tickets` template to account for a passed post to be of an unregistered post type, such as for an Event post when The Events Calendar plugin is disabled. [ETP-320]
* Language - 15 new strings added, 38 updated, 1 fuzzied, and 4 obsoleted

### [4.12.0] 2020-04-23

* Fix - Output the correct event capacity as a formatted integer in the admin meta box, which also renders on the Community Events Tickets form. [ETP-307]
* Fix - Prevent errors when a post has previously sold tickets for a now-deactivated Ticket Provider (WooCommerce or Easy Digital Downloads). [ETP-235]
* Fix - Remove the provider parameter from the WooCommerce checkout URL to prevent conflicts when completing orders, with payment gateways using parameters. [ETP-222]
* Fix - Fully deprecate the `wootickets-tickets-email-enabled` filter with its `tribe_tickets_plus_email_enabled` replacement (introduced in version 4.7.1). Props to @aaemnnosttv for identifying the incomplete deprecation. [ETP-197]
* Tweak - Use the new attendees code implemented in Event Tickets to reduce duplicated code in both plugins. [ETP-311]
* Tweak - Implement WooCommerce price suffix for the tickets block when you have the WooCommerce tax feature enabled. [ET-620]
* Tweak - Load plugin text domain on the new 'tribe_load_text_domains' hook instead of the 'plugins_loaded' hook to support third-party translation providers. [ETP-308]

### [4.11.4] 2020-03-18

* Fix - Save updated shared capacity for event/post if the argument is passed to the REST API endpoint for an Easy Digital Downloads or WooCommerce ticket. [ETP-267]
* Fix - Make sure when changing unlimited ticket to be a shared capacity ticket that the empty individual capacity gets properly overridden to the shared capacity for WooCommerce and Easy Digital Downloads. [ETP-262]
* Fix - Add `sku` and `description` to the REST API endpoint for tickets for Easy Digital Downloads because they were returning empty. [ETP-262]
* Fix - Protect classic editor tickets meta box code by avoiding direct calls to WooCommerce methods without prior validation that they are defined. [ETP-149]
* Fix - Log potential QR code warnings to correct logger instead of causing a fatal error. [ETP-287]
* Tweak - Update the logic to set the maximum allowed to be purchased at a time via WooCommerce, in line with the changes to Event Tickets' changes to the `tribe_tickets_get_ticket_max_purchase` filter. [ETP-149]
* Tweak - Improve support for Promoter with Easy Digital Downloads and WooCommerce by extending the range of actions where Promoter is notified of changes. [ETP-265]
* Language - 0 new strings added, 23 updated, 0 fuzzied, and 0 obsoleted

### [4.11.3] 2020-02-26

* Fix - The script to check if required Attendee Information exists before purchasing a ticket no longer conflicts with the actual form submission. [ET-686]
* Fix - Save initial shared capacity value for global stock correctly on first WooCommerce/Easy Digital Downloads ticket so availability shows as expected instead of zero. [ETP-221]
* Fix - Prevent fatal error when deleting WooCommerce tickets. [ETP-229]
* Language - 0 new strings added, 21 updated, 0 fuzzied, and 0 obsoleted

### [4.11.2] 2020-02-06

* Feature - Implement new functions from Event Tickets to easily rename ticket types and ensure consistent wording. Many translated strings will need updating. [ETP-145]
* Fix - Correct checks to WooCommerce `is_on_sale()`, `get_regular_price()` and `get_sale_price()`. [ETP-47]
* Fix - Correct text domain strings that did not match `event-tickets-plus`. [ET-592]
* Fix - Ensure we are correctly checking `ticket_end_date` when saving the ticket start and end date from the ticket editor. [ETP-159]
* Fix - Do not add `&provider=tribe_wooticket` query argument to WooCommerce Cart and Checkout URLs if there aren't tickets in the Cart. [ETP-52]
* Tweak - Modify filter to enable security code check during QR checkin by default. [ETP-91]
* Tweak - Additional escaping in the `woocommerce-metabox-capacity` admin-view template and clean up code formatting of some view templates. [ETP-145]
* Tweak - Add a note to the public Attendees List opt-out checkbox in tickets admin (classic editor only). [ET-615]
* Tweak - Removed filters: `wootickets_email_message`
* Tweak - Changed views: `attendees-list`, `tickets-plus/orders-edit-meta`, `tickets-plus/orders-tickets`
* Language - 50 new strings added, 68 updated, 29 fuzzied, and 43 obsoleted

### [4.11.1.1] 2020-01-30

* Tweak - Remove duplicate ticket script to prevent JavaScript conflicts. [ET-596]

### [4.11.1] 2019-12-19

* Tweak - Avoid loading plugin assets on post types that are not tickets-enabled post types [124403]
* Tweak - Tweak styles around asterisk for required attendee registration inputs. [137285]
* Tweak - Ensure font weight is standardized for attendee fields on single-event and tickets views. [137285]
* Fix - WooCommerce tickets no longer show negative quantity available to purchase, such as if a ticket product is already oversold and backorders are not allowed [133432]
* Language - 0 new strings added, 22 updated, 0 fuzzied, and 0 obsoleted

### [4.11.0.2] 2019-12-12

* Fix - Clean up the way we query pending orders for tickets, add caching to prevent repeated queries, and optimize meta calls for order information. [138485]
* Fix - Update the WooCommerce minimum version as version prior to 3.7 are now incompatible. [138483]

### [4.11.0.1] 2019-12-11

* Fix - Prevent Composer Autoloader from taking too much time loading files and stop autoloading a class unnecessarily on each page load [138389]
* Fix - Correct a bad `self` reference in `Tribe__Tickets_Plus__Commerce__WooCommerce__Meta` that could cause a fatal. [138383]

### [4.11] 2019-12-10

* Feature - Utilize the new `tribe-dialog` for WooCommerce & Easy Digital Downloads "Get Tickets" buttons [129434]
* Feature - Add option to turn on/off Attendee Registration Modal. On by default _for new installs_ only [133048]
* Feature - Detect changes of WooCommerce Ticket Products in the cart with AR fields and redirect to AR page on change [131139]
* Feature - Use the block ticket template for WooCommerce and Easy Digital Downloads ticket views [132568]
* Feature - Deprecate templates for WooCommerce and Easy Digital Downloads ticket views [132568]
* Tweak - Change the way we add options to the ticket settings tab. [133048]
* Tweak - Add ability to track installed version history. Added `$version_history_slug` and `$latest_version_slug` properties to `Tribe__Tickets_Plus__Main` [133048]
* Tweak - Add links back to the Attendee Registration page from WooCommerce and Easy Digital Downloads checkout pages. [129449]
* Tweak - Minimum required WordPress version updated to WordPress 4.9
* Tweak - Added filters: `tribe_tickets_plus_edd_cart_url`, `tribe_tickets_plus_edd_checkout_url`, `woocommerce_add_to_cart_validation`, `tribe_tickets_plus_woo_checkout_url`, `tribe_tickets_plus_meta_storage_get_hash_cookie`, `tribe_tickets_plus_meta_storage_combine_new_and_saved_meta`
* Tweak - Removed filters: `tribe_tickets_plus_hide_attendees_list_optout`, `tribe_events_tickets_woo_cart_class`, `tribe_events_tickets_woo_quantity_column_class`, `tribe_events_tickets_row_class`, `tribe_events_tickets_woo_quantity_column_class`, `tribe_tickets_plus_hide_attendees_list_optout`
* Tweak - Added actions: `event_tickets_plus_edd_send_ticket_emails`, `tribe_tickets_plus_meta_storage_set_hash_cookie`, `tribe_tickets_plus_meta_storage_delete_hash_cookie`, `event_tickets_plus_attendee_meta_update`
* Tweak - Removed actions: `wootickets_tickets_after_quantity_input`
* Tweak - Changed views: `eddtickets/tickets`, `wootickets/tickets`
* Fix - Make sure we're done processing RSVP attendee meta before we clear the cookie used to sync with the temporary transient meta. [138003]
* Language - 3 new strings added, 5 updated, 0 fuzzied, and 0 obsoleted

### [4.10.10] 2019-11-13

* Feature - Added an 'Unlimited' drop-down option to the Stock filter for Advanced Post Manager to avoid having to manually filter by '-1' [123365]
* Feature - Stock and Sales values for Advanced Post Manager now display as formatted numbers (such as 'Unlimited' instead of '-1' stock and '2,520' instead of '2520' sales)
* Fix - Adjust Stock and Sales filter values for Advanced Post Manager display [123365]
* Fix - Avoid potential PHP fatal errors with Advanced Post Manager [120782]
* Fix - Correct display value for Advanced Post Manager's Stock column for events with Global Stock [73766]
* Fix - Unlimited stock events now appear when searching "Ticket Stock is at least ..." [73766]
* Language - 0 new strings added, 16 updated, 0 fuzzied, and 0 obsoleted

### [4.10.9] 2019-10-14

* Fix - Attendees Report's "Orders" tab now displays amount sold and available regardless of amount, including for unlimited and zero remaining for Easy Digital Downloads and WooCommerce attendees [134108]
* Fix - Prevent Attendee Registration saving from storing only the last attendee's information for all Easy Digital Downloads attendees [134408]
* Language - 0 new strings added, 13 updated, 0 fuzzied, and 0 obsoleted

### [4.10.8] 2019-10-01

* Tweak - Add compatibility for plugins that separate tickets into separate line items and allow filtering those tickets found in the cart [133639]
* Tweak - Added filters: `tribe_tickets_plus_edd_tickets_in_cart`, `tribe_tickets_plus_woocommerce_tickets_in_cart`
* Fix - Prevent PHP notices when updating Attendee Fields on the My Tickets Page [132829]
* Fix - Prevent throwing notices on the orders view if there are no orders to show [127506]
* Fix - Update outdated gradient direction syntax in `wootickets.pcss` [133243]
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted

### [4.10.7] 2019-09-16

* Tweak - Reduced file size by removing .po files and directing anyone creating or editing local translations to translations.theeventscalendar.com [128053]
* Tweak - Add class exists check for `Tribe__Tickets_Plus__Commerce__WooCommerce__Email` to prevent fatal error in rare cases [130183]
* Tweak - Added filters: `tribe_tickets_plus_get_total_complete`, `tribe_tickets_plus_get_total_refunded`, `event_tickets_plus_commerce_edd_refunded_payment_statuses`
* Tweak - Changed views: `eddtickets/tickets`, `meta/checkbox`, `meta/number`, `meta/radio`, `meta/select`, `meta/text`, `tickets-plus/orders-edit-meta`, `wootickets/tickets`
* Fix - Adjust WooCommerce attendee totals to account for refunded (do not include refunded in completed) [126734]
* Fix - Correctly check for attendees created just before sending ticket emails, which resolves ticket email problems when adding a ticket and then another product to the cart and checking out [130597]
* Fix - Get each ticket's quantity available in a filterable way [119822]
* Fix - Dependency checker now correctly identifies missing Event Tickets on activation or deactivation of Event Tickets with The Events Calendar active [123459]
* Fix - Fix the attendee registration settings slugs used in the `retro_attendee_page_option` functionality [128264]
* Fix - Check for available stock by using `_tribe_ticket_capacity` instead of `_stock` meta field in Easy Digital Downloads [132585]
* Fix - Resolved issue with saving Attendee Information checkbox and radio field values when editing them [131727]
* Fix - Prevent PHP notices when an optional radio button is left empty in attendee information [134109]
* Language - 1 new strings added, 36 updated, 0 fuzzied, and 0 obsoleted

### [4.10.6] 2019-08-22

* Tweak - Don't duplicate IDs, correct templates as needed [131430]
* Tweak - Remove fee calculation coding from WooCommerce Tickets Order Report and replace with filters for Community Tickets to utilize [128843]
* Tweak - Added filters: `tribe_tickets_plus_edd_order_table_classes`, `tribe_tickets_plus_woocommerce_order_table_classes`, `tribe_tickets_plus_woocommerce_orders_columns`, `tribe_tickets_plus_woocommerce_filter_column_total`, `tribe_tickets_plus_woocommerce_filter_individual_order_totals_in_event_sales`, `tribe_tickets_plus_woocommerce_filter_report_event_sales_total`, `tribe_tickets_order_report_show_title`, `tribe_tickets_edd_order_report_show_title`, `tribe_tickets_edd_order_report_title`, `tribe_tickets_order_report_show_title`, `tribe_tickets_woocommerce_order_report_show_title`, `tribe_tickets_woocommerce_order_report_title`
* Tweak - Removed filters: `tribe_events_orders_report_site_fees_note`
* Tweak - Added actions: `tribe_tickets_plus_woocommerce_sales_report_after_order_breakdown`
* Fix - Replace calculations in WC order report to utilize filters so Community Tickets (and other plugins) can add/modify them as needed. [130279]
* Language - 1 new strings added, 18 updated, 0 fuzzied, and 2 obsoleted

### [4.10.5.1] 2019-06-13

* Fix - Correct broken attendee list in classic editor [128946]
* Fix - Account for visitors getting to the WooCommerce cart or checkout screens in a manner other than our checkout flow, such as directly visiting the URL [128505]
* Fix - Correctly query and join the necessary tables when WooCommerce or Easy Digital Downloads are not activated for queries against `purchaser_name` or `purchaser_email` [128881]
* Language - 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted

### [4.10.5] 2019-05-23

* Feature - Implemented our abstract Object-relational Mapping layer for Easy Digital Downloads / WooCommerce Attendees and increased stability with more automated tests [123468]
* Tweak - Added ability to query attendees by provider using `tribe_attendees( 'woo' )` and `tribe_attendees( 'edd' )` [123468]
* Tweak - Added filters: `tribe_tickets_plus_attendees_list_limit_attendees`
* Language - 0 new strings added, 18 updated, 0 fuzzied, and 0 obsoleted

### [4.10.4] 2019-05-14

* Feature - Add tooltips to Attendee report, utilizing new tooltip object in tribe-common [120856]
* Feature - Add support for checkbox values returning as "Checked" when populating data for attendee list exports [126735]
* Tweak - Verify the status of attendee as complete when checking in using the REST API [122458]
* Tweak - Utilize the order items to generate the Order Report for WooCommerce instead of attendees [93785]
* Tweak - Remove canceled orders from counting as Pending Competition on the WooCommerce Tickets Order Page [120862]
* Tweak - Changed some tooltip text on the attendee report page for clarity around capacity/inventory/stock [126342]
* Tweak - Adjust styling of the Attendee Information required fields indicator [126779]
* Tweak - Added filters: `tribe_tickets_plus_get_total_cancelled`, `tribe_events_tickets_plus_attendees_list_checkbox_label`
* Fix - Update shared capacity on deletion of attendee for WooCommerce and Easy Digital Downloads Attendees [106516]
* Fix - Make Attendees Report match the order report, specifically "Total Tickets Issued" should not include cancelled tickets [69823]
* Fix - Make sure that `WC()->cart` is set before we try to get it's contents [126779]
* Fix - Prevent tickets from being counted twice in the order report when 2 or more tickets included in an order [106516]
* Fix - Ensure capacity changes for source and target tickets when moving a ticket from one type to another [102636]
* Fix - Deprecate old option key `ticket-attendee-info-slug` for attendee registration shortcode to prevent errors [126856]
* Fix - Change cookie settings so that Attendee Information is passed through to checkout on non-secure sites properly [25964]
* Fix - Alter query so Easy Digital Downloads `Stock_Control->get_purchased_inventory()` takes moved tickets into account [124657]
* Language - 9 new strings added, 26 updated, 0 fuzzied, and 1 obsoleted

### [4.10.3] 2019-04-23

* Tweak - Changed minimum supported version of The Events Calendar to 4.9
* Tweak - Allow menu order to be saved when saving tickets [121703]
* Tweak - Add hooks before WooCommerce and Easy Digital Downloads Attendees are generated `tribe_tickets_plus_woo_before_generate_tickets` and `tribe_tickets_plus_edd_before_generate_tickets` [124675]
* Tweak - Add CSS for `tribe_events_modal` class when query string is present in URL [123818]
* Tweak - Modify the attendee meta to remove empty values, but keep zero and improve the escaping of data [123892]
* Tweak - Add support for display 0 when it is a value in attendee meta [123892]
* Tweak - Change Attendee Registration page options to use ID instead of page slug [124997]
* Tweak - Use new `tribe_attendee_registration_form_classes` hook to add form classes for Easy Digital Downloads and WooCommerce [124997]
* Tweak - Added actions: `tribe_tickets_plus_woo_before_generate_tickets`, `tribe_tickets_plus_woo_before_generate_tickets`
* Fix - Add Deleted Attendees Count to Easy Digital Downloads and add checks for Easy Digital Downloads and WooCommerce Tickets to only increase counter once per attendee [122083]
* Fix - Filter the Attendee Registration display to only show tickets for the current provider. Add functions to add provider to cart and Attendee Registration URL [122317]
* Language - 0 new strings added, 16 updated, 1 fuzzied, and 0 obsoleted

### [4.10.2] 2019-04-01

* Tweak - Change text on Tickets WooCommerce settings to properly reflect delay changes [123623]
* Tweak - Add option to use a different page as the default Attendee Registration page using the `[tribe_attendee_registration]` shortcode [123044]
* Tweak - Update hooks used to notify promoter of changes [124118]
* Tweak - Add new hook `tribe_tickets_plus_woo_reset_attendee_cache` to notify when an WooCommerce attendee is reset on cache [124118]
* Tweak - Changed views: `meta/checkbox`, `meta/radio`, `tickets-plus/orders-edit-meta`
* Fix - Change priority of initializing of CSV mapping [123401]
* Fix - Use a md5 hash for checkbox and radio option names to prevent fields from not saving if they a large amount of characters and handle the processing of them [119448]
* Fix - Swap similar methods with each other for statuses of ticket generation and emails in WooCommerce, thanks to @aaemnnosttv for the code! [123242]
* Fix - Add filter for better overriding of archive title [123065]
* Fix - Prevent missing stati causing query errors [123011]
* Fix - Trigger showing the submit button in "my tickets" view [114111]
* Fix - Handle null/empty values when iterating through attendee fields [123516]
* Language - 5 new strings added, 27 updated, 0 fuzzied, and 1 obsoleted

### [4.10.1.3] 2019-03-15

* Fix - Correct issue with WooCommerce ticket charges not being sent to Stripe and other gateways [124123]

### [4.10.1.2] 2019-03-14

* Tweak - Add new hook `tribe_tickets_plus_woo_reset_attendee_cache` to notify when an WooCommerce attendee is reset on cache [124118]
* Tweak - Added actions: `tribe_tickets_plus_woo_reset_attendee_cache`
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted

### [4.10.1.1] 2019-03-06

* Feature - Add hooks to notify Promoter when an event with Easy Digital Downloads and WooCommerce tickets have changes [123732]
* Fix - correctly clear attendees cache when delayed tickets are generated [123559]
* Language - 0 new strings added, 18 updated, 0 fuzzied, and 0 obsoleted

### [4.10.1] 2019-02-26

* Tweak - Added setting in Settings->Tickets->WooCommerce to turn off attendee generation delay [121818]
* Tweak - Add wp ajax action to save attendee meta [121592]
* Tweak - Added filter: `tribe_tickets_woo_settings` [121818]
* Tweak - Added filters: `tribe_tickets_woo_settings`, `tribe_tickets_tickets_in_cart`
* Tweak - Changed views: `meta/checkbox`, `meta/text`, `tickets-plus/orders-tickets`
* Fix - Fix bug on classic RSVP for mobile viewport [120226]
* Fix - Only show attendee registration for RSVP if going [121026]
* Fix - Allow users to always access attendee registration page if tickets in cart have meta [121819]
* Fix - Allow tickets with required and non-required meta to be saved together [121821]
* Fix - Fix mobile styles for tickets and RSVP [118299]
* Fix - Prevent fatal errors on front end ticket page if the provider is deactivated [122322]
* Fix - Allow empty checkboxes as valid if they are the only field [122321]
* Fix - Don't add extra checkboxes for empty lines [122321]
* Language - 9 new strings added, 23 updated, 1 fuzzied, and 0 obsoleted

### [4.10.0.2] 2019-02-08

* Fix - Prevent fatals in Meta when testing for blocks [122361]
* Fix - Ensure lang files are loading correctly [122544]
* Fix - Reduce WC PayPal delay from 5 minutes to 5 seconds [121818]

### [4.10.0.1] 2019-02-07

* Fix - Ensure attendee meta does not get erased on block editor ticket update [122361]

### [4.10] 2019-02-05

* Feature - Add system to check plugin versions to inform you to update and prevent site breaking errors [116841]
* Feature - Add order page for Easy Digital Downloads [116745]
* Tweak - Add a class to admin attendee meta markup
* Tweak - Update plugin header [90398]
* Tweak - Add tooltips and additional information to WooCommerce Orders page header [115914]
* Tweak - Added filters: `tribe_events_tickets_edd_orders_table_column`, `tribe_tickets_plus_edd_order_link_url`, `tribe_tickets_woo_cart_url`, `tribe_not_php_version_names`
* Tweak - Added actions: `tribe_tickets_plus_report_event_details_list_top`, `tribe_tickets_plus_report_event_details_list_bottom`, `tribe_tickets_plus_after_event_details_list`
* Tweak - Changed views: `wootickets/tickets`
* Fix - When adding a WooCommerce ticket to the cart, redirect only if the "WooCommerce" setting is set. Thanks to Thomas and Ilkka for flagging this! [46648]
* Deprecated - The functions `event_tickets_plus_is_incompatible_tickets_core_installed()`, `event_tickets_plus_check_for_init_failure()` and `event_tickets_plus_setup_fail_message()` and `register_active_plugin()`, `on_load()`, `plugins_loaded()` method has been deprecated in `Tribe__Tickets_Plus__Main` in favor of Plugin Dependency Checking system
* Deprecated - Class Tribe__Tickets_Plus__Commerce__EDD__Orders_Report use Tribe__Tickets_Plus__Commerce__EDD__Orders__Report instead
* Deprecated - `filter_attendee_order_link()` in Tribe__Tickets_Plus__Editor, replaced with method in Easy Digital Downloads and WooCommerce to filter order link using `tribe_filter_attendee_order_link`
* Language - 11 new strings added, 42 updated, 1 fuzzied, and 7 obsoleted

### [4.9.2] 2019-01-15

* Tweak - Added a filterable 5 minute delay of ticket generation to WooCommerce tickets to avoid race conditions when IPN and PDT responses arrive simultaneously [119945]
* Tweak - Added filters: `tribe_ticket_generation_delay`, `tribe_tickets_plus_order_pagination`
* Fix - Fix attendee registration user experience [119465]
* Fix - Fix attendee registration for RSVP block FE [119800]

### [4.9.1] 2018-12-19

* Fix - Avoid fatal error when completing an order via WooCommerce [119705]
* Fix - Prevent `WC_Product_Simple` from fataling when filtering max purchase limit on Tickets Block view [119861]
* Language - 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted

### [4.9] 2018-11-29

* Feature - added new registration page for collecting attendee registration information as part of the check out process.
* Tweak - Changed views: `eddtickets/tickets.php` and `wootickets/tickets.php`
* Language - 0 new strings added, 19 updated, 0 fuzzied, and 0 obsoleted

### [4.8.3] 2018-10-22

* Fix - Display availability message when there are no tickets for WooCommerce tickets [115200]
* Fix - Include orphaned Attendee Meta in the export. Thanks Kelly for flagging this! [74425]
* Language - 34 new strings added, 41 updated, 1 fuzzied, and 6 obsoleted

### [4.8.2] 2018-10-03

* Tweak - Add `tribe_tickets_plus_qr_enabled` filter [113627]

### [4.8.1] 2018-09-12

* Feature - Add a filter to enable security code check during QR checkin, `tribe_tickets_plus_qr_check_security_code`  [87756]
* Fix - Show the ticket table when tickets are all sold out, show message in list view [111893]
* Tweak - Set `tribe_tickets_plus_trash_ticket` filter to true by default [112409]
* Tweak - Added internal methods to WooCommerce and Easy Digital Downloads to handle more atomic Views for Gutenberg extension [112478]

### [4.8] 2018-08-22

* Feature - Include a Tickets REST API endpoint for read operations [108021]
* Feature - Include WooCommerce tickets and Easy Digital Downloads tickets fields in the WP personal data erase [108491]
* Fix - Properly update attendees transient when checkin/unchekin an attendee for WooCommerce and Easy Digital Downloads Tickets, in order to see changes immediately. Thanks to Adam for the report! [104355]
* Tweak - WooCommerce Orders Sales by Ticket section to remove duplicate data [110034]
* Tweak - Attendees section to clarify infomation [110038]

### [4.7.6] 2018-08-01

* Feature - New template file for inserting the QR codes in tickets emails. Props to @madebyelmcity for bringing this up [62181]
* Fix - Fix Easy Digital Downloads tickets stock being borked after updating capacity. Thanks to @lvdesigner and @artstream8401 for flagging this! [106741]
* Fix - Prevent ticket unavailability message from displaying twice with multiple ticket providers [110014]
* Tweak - Adjusted order status output in the tickets order report tab to use translated version. Props to @websource for the report [109640]
* Feature - Include RSVP, Tribe Commerce, WooCommerce tickets and Easy Digital Downloads tickets fields data in WP personal data export [108488]

### [4.7.5] 2018-07-09

* Feature - Add QR API settings field and button to generate key [102116]
* Feature - Add base REST API system and endpoint for QR check in [102107]
* Feature - Add security code and REST path to QR code url and require use of security code for REST check in [102112]
* Fix - When adding a WooCommerce ticket to the cart, redirect only if the "WooCommerce" setting is set. Thanks to Thomas and Ilkka for flagging this! [46648]
* Fix - Display unavailability message when tickets are not yet or no longer available [81334]
* Tweak - Add `tribe_tickets_plus_trash_ticket` filter to give the opportunity to trash tickets when deleted instead of actually deleting them [46393]

### [4.7.4] 2018-06-20

* Fix - Fixed an issue with new "Enable QR codes for tickets?" option being only visible if WooCommerce was active [107236]
* Language - 2 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted

### [4.7.3] 2018-05-29

* Tweak - Make QR codes optional via new "Enable QR codes for tickets?" option in Tickets settings [41649]
* Fix - Remove attendees from the public list if their order have failed (Thanks @beerddwr for flagging this!) [103912]
* Fix - Fixed an issue where Easy Digital Downloads was throwing insufficient stock error for shared capacity tickets (props to @artstream8401 for reporting this!) [101079]
* Fix - Clean the attendees cache every time an order is updated, so the changes are reflected immediately (Thanks @bartenderatlas, @artistinformatici, @danceworks and others for reporting) [103831]
* Fix - Synchronize the event cost when a WooCommerce sale start or end (Thanks @floydcountrystore for notifying us!) [104019]
* Fix - Ensured that the tickets start and end sale date respect the event timezone (props @Ryan, @Georges and others for flagging this!) [76683]
* Fix - Add class to handle WooCommerce order refunds on a ticket basis [102081]
* Fix - Prevent the event tickets page to break when Easy Digital Downloads is deactivated and there were Easy Digital Downloads orders [64253]
* Fix - Add default title to the ticket field set if none provided [70739]
* Fix - Sanitize HTML classes for ticket attendee details in the admin area (Thanks @Gergana, @ucheng and @mr-d for flagging this!) [65385]
* Fix - Ignore whitespaces in ticket required fields (props @jonahgirl and @seanaguilar for notifying us!) [95950]
* Fix - Render ticket fields without label (Thanks @creeert-net and @daviddweb for spotting this) [63286]
* Tweak - Made the QR code base URL default to having a trailing slash to prevent issues with some server configurations [74797]
* Tweak - Added new `tribe_tickets_qr_code_base_url` to allow easy filtering of the QR code base URL [74797]
* Language - 5 new strings added, 74 updated, 0 fuzzied, and 1 obsoleted

### [4.7.2] 2018-04-18

* Feature - Add new action, `tribe_tickets_before_front_end_ticket_form`, if tickets has been expired and the tickets form is not rendered any more [98203]
* Fix - Fixed an issue where shared capacity would reduce available stock on load of the event editor; thanks to Sherman, Michael, and Greg for bringing it up! [94702]
* Fix - Fixed emails with Easy Digital Downloads tickets not being sent [102216]
* Fix - Added new column in the CSV import of tickets for the "Show ticket description" value, accompanied by new filter `tribe_tickets_plus_import_ticket_data` to change the data before ticket creation via CSV (thanks to April in our Help Desk for flagging this problem!) [96162]

### [4.7.1] 2018-03-28

* Feature - Added updater class to enable changes on future updates [84675]
* Fix - Resolved undefined variable error that could occur when purchasing tickets via WooCommerce in some circumstances (thanks to @justlevine for flagging this problem) [73562]
* Fix - Added safety checks to stop customers from buying tickets left in the cart *after* the ticket sale dates have passed (our thanks to Lawrence in the forums for flag this problem) [90765]
* Fix - Added checks to help prevent tickets from inadvertently being added to the cart more than once when site visitors use the browser refresh button (thanks to Preethi in our forums for reporting this problem) [89843]
* Fix - Fixed some broken functionality and design elements on the front-end "Who's Attending?" list on ticketed events (thanks to @learningarchitects and others for reporting this bug!) [95236]
* Fix - Restored the order notes that get added to orders when a tickets email is manually re-sent to a customer (props to Nick H. in our forums for spotting this bug) [91730]
* Fix - Restored functionality of the custom WooCommerce tickets email subject line (props to @ilardo for surfacing this bug in the forums) [99755]
* Fix - Corrected a number of wrongly declared textdomains (thanks to @websource for drawing our attention to this)
* Fix - Make sure the sales page does not trigger any error when `get_current_screen` does not return an object (thanks to @artistinformatici for report this problem in our forums) [101881]
* Fix - Prevented a fatal error that would sometimes arise when viewing events with Easy Digital Downloads tickets [95402]
* Tweak - Modified WooCommerce ticket inputs so that they are disabled when viewed by unauthenticated users, when a requirement for users to login before purchasing is in effect [96464]
* Tweak - Added caching to `get_orders_by_status` call to avoid unnecessarily repeated queries [99161]
* Tweak - Fixed harmless (but annoying) PHP notice that would sometimes arise when tickets were in the same WooCommerce cart as non-ticket products (thanks @liblogger for reporting this one!) [94170]
* Tweak - Fixed a PHP notice that would sometimes arise when deleting tickets with attendees (thanks to @svkg for reporting this in our forums) [97787]
* Tweak - Added logic to clear cookies and storage used from a product when it is removed from the cart [90902]
* Tweak - Added new filter `tribe_tickets_plus_email_enabled` to allow for enabling or disabling the tickets emails - this replaces the now-deprecated `wootickets-tickets-email-enabled` filter [99755]
* Tweak - Added new filter `tribe_tickets_plus_woocommerce_order_link_url` to allow for remove of the order links on front end order report [93923]

### [4.7] 2018-03-13

* Feature - Extended capacity and stock control for Tribe Commerce Paypal Tickets
* Fix - Remove the Purchase Limit field from WooCommerce and Easy Digital Downloads tickets back-end edit form [95479]
* Tweak - Addressed some issues where the ticket form would sometimes show up even when all tickets' end-sale dates had passed (props to @reckling and others for reporting this!) [94724]
* Tweak - Added filters: `tribe_tickets_plus_woo_get_attendees`, `tribe_tickets_plus_hide_attendees_list_optout`
* Tweak - Removed actions: `wootickets_generate_ticket_attendee`
* Tweak - Changed views: `login-to-purchase`, `tpp/attendees-list-optout`
* Language - 2 new strings added, 60 updated, 1 fuzzied, and 14 obsoleted

### [4.6.2] 2017-12-07

* Fix - Make sure Stock is updated accordingly based on total sales when updating capacity [93601]
* Fix - Resolved bug where "Purchase limit" field was not saving correctly [92914]
* Fix - Fixed an issue where the wrong number of tickets available would be shown in WooCommerce and Easy Digital Downloads purchase forms [71118]
* Tweak - Added filter to change the default value for the option to show attendees on the event, 'tribe_tickets_plus_default_show_attendees_value' [80620]
* Tweak - Prevent Easy Digital Downloads from being a provider for front-end Community Tickets, as only WooCommerce is allowed for that [91758]
* Tweak - Updated tooltip text for Capacity settings when using Easy Digital Downloads [94042]
* Tweak - Event capacity field will be enabled if never set via Ticket creation form [90823]
* Tweak - Modified warning toggle with tribe prefix [91215]
* Tweak - Avoid printing the SKU ticket fields on frontend forms (e.g. Community Event Tickets) [91208]
* Tweak - Added helper text to selection of ecommerce plugin to clarify what that changes [93919]
* Tweak - Decreased the width of the ticket capacity fields so they're sized more proportionally to the values they hold [93042]
* Tweak - Fixed some typos in names of deprecated properties on the Tribe__Tickets_Plus__Commerce__WooCommerce__Main class [90848]
* Tweak - Resolved problems with importing sale time for tickets [92936]
* Language - 2 new strings added, 24 updated, 0 fuzzied, and 0 obsoleted

### [4.6.1.1] 2017-11-24

* Fix - Ensure attendee meta information is available within the admin environment [94142]
* Language - 1 new strings added, 52 updated, 0 fuzzied, and 0 obsoleted

### [4.6.1] 2017-11-21

* Fix - Added checkin status class to Easy Digital Downloads to fix checkin buttons showing as disabled [92247]
* Fix - Formats properly when displaying Unlimited capacity Tickets [92243]
* Fix - Prevents deleted shared event capacity to still factor in when no tickets are sharing capacity [91125]
* Fix - Updating capacity for the event all tickets gets Stock validation preventing Out of Stock message [93103]
* Tweak - Easy Digital Downloads quantity styling to match WooCommerce and RSVP forms [92551]
* Tweak - Only display admin links in Community Tickets if user is able to access the admin [79565]
* Tweak - Added filters: `tribe_events_tickets_edd_display_ecommerce_links`, `tribe_filter_attendee_order_link`
* Tweak - Removed filters: `tribe_events_tickets_woo_display_ecommerce_links`

### [4.6] 2017-11-09

* Feature - Fully redesigned ticket editor interface
* Feature - Ticket description is now optional for frontend display
* Feature - Introduced "shared capacity" to replace "global stock"
* Feature - Introduced "Sell up to" capacity field to replace "global stock with cap"
* Feature - Improved helper text and error messages
* Feature - Reorder tickets via drag and drop
* Feature - Updated time pickers for start and end sale
* Fix - Improved clarity around ticket availability
* Feature - Total Event Capacity display
* Feature - Introduced filter to change the default value for the option to show attendees on the event, 'tribe_tickets_plus_default_show_attendees_value' [80620]
* Fix - `Woocommerce->get_attendees()` and `EDD->get_attendees()` signatures now require the `$attendees_query` is a `WP_Query` to match the abstract method
* Tweak - Added filters: `tribe_events_tickets_module_name`, `tribe_tickets_get_default_module`, `tribe_events_tickets_woo_display_ecommerce_links`
* Tweak - Removed filters: `tribe_events_tickets_woo_display_sku`
* Tweak - Added actions: `tribe_events_tickets_metabox_edit_ajax_advanced`
* Tweak - Removed actions: `wootickets_after_`, `wootickets_after_save_ticket`
* Tweak - Changed views: `eddtickets/tickets`, `meta`, `wootickets/tickets`
* Tweak - Made unlimited capacity an explicit option
* Tweak - Changed ecommerce usage setting to per-event instead of per-ticket
* Tweak - Changed minimum supported version of WooCommerce to 3.0
* Tweak - Changed minimum supported version of WordPress to 4.5
* Language - 41 new strings added, 67 updated, 2 fuzzied, and 13 obsoleted

### [4.5.6] 2017-10-18

* Feature - Added new filter, `tribe_tickets_plus_meta_cookie_flag`, that lets users manually control the updating of attendee meta storage cookies. [68609]
* Fix - Updated some template files to use the `wc_get_cart_url()` function (instead of calling the `get_cart_url()` WC method directly) to prevent PHP notices [90706]
* Fix - Improved some aspects of temporary storage of attendee meta during the checkout process; the data persists more reliably (props to @slny311 and others) [68609]
* Fix - Re-added legacy WooCommerce version 2.x _visibility "hidden" meta to ticket Products (missing as of version 4.4.7 until now).
* Fix - Added support for the resend tickets email action when running alongside WooCommerce 3.2.x (with thanks to Benjamin Schreier for highlighting this) [90884]
* Fix - Fixed an issue with Easy Digital Downloads tickets not being correctly assigned to users in some cases (thank you @atmedia for reporting this!) [88894]
* Tweak - Added new `wootickets_ticket_email_attachments` filter [90576]
* Tweak - Added CSS class and filter to table rows in WooCommerce ticket purchase form (thank you @helgatheviking for coding this) [89807]
* Tweak - Started using Woo's Decimal Separator setting on the Add Ticket screens [41459]
* Compatibility - Minimum supported version of WooCommerce is now 2.5 [90706]

### [4.5.5] 2017-09-20

* Fix - Fix issue where "Who's Attending?" list would often incorrectly report the number of people attending an event [87429]
* Fix - Prevent blank option values for fields like radio, checkbox, and dropdown [72409]
* Tweak - Make the bottom-border on some WooCommerce ticket elements more consistent in color and width (props to @webidextrous for reporting this!) [81562]

### [4.5.4] 2017-09-06

* Fix - Fixed issue where "Who's Attending?" list would often fail to show up on custom post types. [73052]
* Fix - Fixed dates in Orders report for items with status other than complete [77694]
* Fix - Ensure that if an Attendee is deleted, it cannot be "checked in" (props to ahelman for reporting this!) [75744]
* Tweak - Added new filter `tribe_event_tickets_plus_email_meta_fields` (thanks @carlosmachado for the suggestion) [63516]
* Tweak - Adjusted multiline option markup for meta fields type text [67508]
* Tweak - Fixed incorrect plugin version in code documentation [87065]
* Tweak - Purge unused meta fields template file [72411]
* Tweak - Changed views: `eddtickets/tickets.php` and `wootickets/tickets.php`
* Tweak - New template tags: `unhook_event_tickets_order_link_logic()`
* Language - 1 new strings added, 19 updated, 0 fuzzied, and 0 obsoleted

### [4.5.3] 2017-07-26

* Fix - Fixed some included files' paths to ensure they can be overwritten in line with our Themer's Guide [68228]
* Fix - Fixed some PHP notices that would show up when buying Easy Digital Downloads tickets [83227]

### [4.5.2] 2017-07-13

* Fix - Adjustments to improve compatibility with WooCommerce 3.x during check-in and when sending emails [80769]
* Fix - Prevent errors in relation to our integration with the WooCommerce email system [80502]
* Fix - Allow users to disable WooCommerce ticket emails by deselecting all trigger statuses [73183]
* Tweak - Remove references to legacy plugins in the tickets form [41541]
* Tweak - Remove view files from deprecated e-commerce providers [82547]
* Tweak - Added a filter to hide the attendee optout option in the tickets form [46087]

### [4.5.1] 2017-06-28

* Fix - Ensure the correct user ID is associated with tickets/attendees (props: @Andras) [76305]
* Fix - Ensure the event_id and ticket_id variables are usable within the tribe_tickets_plus_qr_handle_redirects filter (props: @Cliff) [81333]

### [4.5.0.1] 2017-06-22

* Fix - Prevent fatals involving Commerce Classes and Tribe__Tickets__Tickets

### [4.5] 2017-06-22

* Feature - Show remaining ticket count, buy now now buttons in list views of The Events Calendar [71092 & 71094]
* Feature - An API to get ticket, attendee, event, and order infomation from a post id for RSVP, Easy Digital Downloads, and WooCommerce Tickets [74363]
* Tweak - Removed support for Shopp and WP E-Commerce plugins [71909]
* Tweak - Added filters: `tribe_events_tickets_woo_quantity_column_class`
* Tweak - Removed filters: `shopptickets_assign_to_category`, `shopptickets_ticket_category`, `shopptickets_generate_tickets_hook`, `shopptickets_historical_purchase_names`, `shopptickets_ticket_category_description`, `shopptickets_ticket_category_parent`, `tribe_tickets_plus_shopp_get_ticket`, `shopptickets_ticket_price_html`, `shopptickets_quantity_selector_options`, `shopptickets_ticket_email_content`, `shopptickets_ticket_email_headers`, `shopptickets_ticket_email_attachments`, `shopptickets_ticket_email_recipient`, `shopptickets_ticket_email_subject`, `wpectickets_order_is_complete`, `wpecticket_fulfilment_error_message`, `tribe_tickets_plus_wpec_get_ticket`, `wpectickets_ticket_price_html`
* Tweak - Removed actions: `event_tickets_shopp_attendee_created`, `event_tickets_shopp_ticket_created`, `shopptickets_checkin`, `shopptickets_uncheckin`, `event_tickets_wpec_attendee_created`, `event_tickets_wpec_ticket_created`, `wpectickets-send-tickets-email`, `eddtickets_ticket_deleted`, `wpectickets_checkin`, `wpectickets_uncheckin`
* Tweak - Changed views: `eddtickets/tickets`, `shopptickets/tickets`, `tickets-plus/attendee-list-checkbox-rsvp`, `tickets-plus/attendee-list-checkbox-tickets`, `wootickets/tickets`, `wpectickets/tickets`
* Language - 0 new strings added, 34 updated, 0 fuzzied, and 21 obsoleted [event-tickets-plus]

### [4.4.9] 2017-06-01

* Feature - Overlay over ticket fields when javascript is disabled to prevent ticket orders [63912]
* Performance - Remove unnecessary ticket stock queries and avoid running some where unnecessary (our thanks to @mindshare for highlighting some of these issues) [79683]
* Tweak - Included a New Filter `tribe_tickets_plus_qr_handle_redirects` to give the chance to modify the QR checkin redirect URL [78677]

### [4.4.8] 2017-05-17

* Fix - Do not add "you will received your tickets in another email" messaging to refund notices (our thanks to Shadi Habbal for highlighting this) [73561]
* Tweak - Shopp and WP E-Commerce integrations have been deprecated prior to removal in a future release [71909]
* Tweak - Further adjustments made to our plugin licensing system [78506]

### [4.4.7] 2017-05-04

* Fix - Ensure catalog visibility and other product attributes for WooCommerce-driven tickets are set as expected [77092]
* Fix - Ensure attendee infomation is retained in a WooCommerce session for the user to prevent loss of data [65181]
* Fix - On refund of WooCommerce Tickets, add stock back to global and capped stock if enabled [66803]
* Tweak - adjustments made to our plugin licensing system

### [4.4.6] 2017-04-19

* Fix - Improvements to ensure attendee list optout functionality works with WooCommerce 3.x (thanks to @jtsternberg for highlighting these issues) [77012]
* Fix - Fixed a number of text domains for proper string translation (Thanks to @websource and @Frank) [76084] [76964]
* Tweak - Add a hook making it possible to override the initial ticket number (props @cliffordp) [74942]

### [4.4.5] 2017-04-10

* Fix - Changes to support WooCommerce 3.0 [76308]
* Tweak - Raises the minimum support version of WooCommerce to 2.2 [76535]

### [4.4.4] 2017-03-23

* Fix - Ensure additional attendee meta data is stored regardless of attendee record generation settings (Thanks for the report @hans) [75140]
* Fix - Improve handling of unlimited ticket stock in relation to WooCommerce tickets (Thank you @jtsternberg for the Pull Request fix via github) [74123]

### [4.4.3] 2017-03-08

* Fix - Prevent fatal when attempting to render QR codes when gzuncompress() is unavailable [73498]
* Fix - Fixed a bug that meant the Attendee Meta info didn't work on multiple tickets purchased at same time (thanks to @robertstaddon for the report) [74036]

### [4.4.2] 2017-02-09

* Fix - Replaced WooCommerce autocomplete feature with order status based controls to regulate the generation of attendees and emails (thats for the report @Bryan) [71893]
* Fix - Added license file [72529]

### [4.4.1] 2017-01-26

* Fix - Prevent throwing fatals for Global Stock when only RSVP tickets exists (Thanks for Reporting Scott) [65888]
* Tweak - Improvements to the Front End Tickets UX Styles [71378]

### [4.4] 2017-01-09

* Tweak - Various improvements to ticket order reports [65888]
* Tweak - Update the WooCommerce Orders Tab with better descriptions and breakdown of tickets sold by order status [66012]
* Tweak - Ensures the manage_stock property of Easy Digital Downloads tickets is not false when tickets have no inventory left [67176]
* Tweak - Adds tabbed view support [66015]

### [4.3.5] 2016-12-20

* Tweak - Updated the template override instructions in a number of templates [68229]
* Fix - Prevent Easy Digital Downloads from throwing fatals on Price HTML methods [70265]
* Fix - Update order-autocompletion logic to work with current versions of WooCommerce [66803]

### [4.3.4] 2016-12-08

* Fix - Fieldset admin menu shows correctly when only Event Tickets is active [67821]

### [4.3.3] 2016-11-16

* Tweak - Included a New Filter `tribe_events_tickets_woo_get_ticket` for better ticket control on WooCommerce (Props to @helgatheviking) [69144]
* Tweak - Included a New Filter `tribe_events_tickets_edd_get_ticket` for better ticket control on Easy Digital Downloads (Props to @helgatheviking) [69144]
* Tweak - Included a New Filter `tribe_events_tickets_shopp_get_ticket` for better ticket control on Shopp (Props to @helgatheviking) [69144]
* Tweak - Included a New Filter `tribe_events_tickets_wpec_get_ticket` for better ticket control on WPEC (Props to @helgatheviking) [69144]

### [4.3.2] 2016-11-02

* Tweak - Included a New Filter `tribe_events_wootickets_ticket_price_html` to allow control over Price HTML for WooCommerce (Props to @helgatheviking) [68555]
* Tweak - Included a New Filter `eddtickets_ticket_price_html` to allow control over Price HTML for Easy Digital Downloads (Props to @helgatheviking) [68555]
* Tweak - Included a New Filter `wpectickets_ticket_price_html` to allow control over Price HTML for WPEC (Props to @helgatheviking) [68555]
* Tweak - Included a New Filter `shopptickets_ticket_price_html` to allow control over Price HTML for Shopp (Props to @helgatheviking) [68555]
* Tweak - Now WooCommerce Attendees and the Orders are linked via a Metabox (Props to @helgatheviking) [68555]
* Tweak - Included a New Filter `tribe_events_tickets_woo_cart_class` to allow Classes customization for the tickets form on WooCommerce (Props to @helgatheviking) [68556]
* Tweak - Included a New Filter `tribe_events_tickets_woo_quantity_column_class` to allow Classes customization for the tickets price column on WooCommerce (Props to @helgatheviking) [68556]
* Fix - Hide on Attendees List does not show if option checked in admin for Easy Digital Downloads, WPEC, and Shopp tickets [46708]
* Fix - Enable custom meta in all ticket emails [66751]

### [4.3.1] 2016-10-20

* Fix - Prevents fatal around transients for Cart usage (thanks for the report @Port) [66468]
* Tweak - Registered plugin as active with Tribe Common. [66657]

### [4.3] 2016-10-13

* Tweak - Improved integration with the attendee screen and enhanced options for customizing same [61992, 66004]
* Fix - Fix issue where custom attendee meta fields sometimes failed to render the meta field templates [67235]

### [4.2.7.1] 2016-09-21

* Fix - Fixed a call to the The Events Calendar "Tribe__Events__Main" class causing fatal errors when The Events Calendar is not installed or activated

### [4.2.7] 2016-09-15

* Fix - Improve the My Tickets (order-tickets.php) template logic to work with all ticketing providers (our thanks go out to Maksem who highlighted this problem)
* Fix - Stop logic for dealing with recurring events from impacting other post types
* Fix - Ensure ticket meta functions as expected with the Easy Digital Downloads ticket provider
* Tweak - Share "tickets unavailable" messaging across ticketing providers to prevent unnecessary duplication

### [4.2.6] 2016-08-31

* Fix - Resolved conflict with WooCommerce Memberships plugin that would cause ticket prices to be erroneously discounted while editing them (Initially reported by @foxfirecr8 - thank you!)
* Fix - Improved the logic handling attendee meta data collection to avoid instances where a large number of tickets would cause data loss (Thank you to @FRANK for his help in reporting this)

### [4.2.5] 2016-08-17

* Fix - Resolved warnings during WPEC checkouts that prevented proper page redirection after ticket purchases (props to @sewhouston in the support forums for reporting this!)
* Tweak - Allow for basic HTML tag support in attendee meta fields (Shout out to @lpoindexter for reporting this on in the forums.)

### [4.2.4] 2016-08-03

* Fix - Avoid Organizer and Venue being unset when updating a WooCommerce managed event ticket in WooCommerce
* Fix - Limit the potential for race conditions leading to duplicate "human readable" IDs

### [4.2.3] 2016-07-20

* Fix - Hide attendee optout meta field from the WooCommerce Individual Order Items (thanks @Douglas for getting this report into us via the support forums.)

### [4.2.2] 2016-07-06

* Fix - Update of price in WooCommerce does not update _EventCost
* Fix - Add attendee meta info to tickets email
* Fix - Ensure continued compatibility with WooCommerce
* Fix - Ensure continued compatibility with WP E-Commerce
* Fix - Made sure a SKU will be automatically generated for WooCommerce tickets if not provided.
* Fix - Resolve issue where "Don't list me on attendees public attendees list" is visible even when "Hide attendees list" is checked in admin

### [4.2.1] 2016-06-22

* Fix - Add attendee meta for all non event post types in the CSV export
* Fix - Use numeric ID for QR checkin instead of the new Human Readable format
* Fix - Restore APM functionality with tickets
* Fix - Ensure proper behavior of attendees list checkbox
* Fix - Remove notices in attendees export by CSV or Email when using Community Tickets

### [4.2] 2016-06-08

* Feature - Authenticated attendees now can edit meta fields created by the event admin
* Feature - Global stock support added to the Easy Digital Downloads integration (Thank you dimitrilongo for the report!)
* Tweak - Added event tickets unique ID generation to have human-readable event ticket identification hashes across events (Thanks to Matt Broffman for submitting this idea on UserVoice!)
* Tweak - Language files in the `wp-content/languages/plugins` path will be loaded before attempting to load internal language files (Thank you to user @aafhhl for bringing this to our attention!)
* Tweak - Added messaging about ticket availability to the Easy Digital Downloads, Shopp, WooCommerce, and WPEC ticket forms (Props to @masteradhoc on GitHub for this change!)
* Tweak - Record the user ID associated with the creation of new attendee records
* Tweak - Updated plugin description on admin plugin page
* Tweak - Move plugin CSS to PostCSS
* Fix - Prevent Fatals when GD Library is not active on the server (Thanks to @jamesgol for fixing the bug)

### [4.1.3] 2016-05-19

* Fix - Automatically restock ticket inventory when an attendee is deleted (WooCommerce implementation)
* Fix - Improve counting of deleted attendee records
* Fix - Make the meta.php template overrideable

### [4.1.2] 2016-04-11

* Tweak - The front-end list of RSVP attendees is now hidden by default
* Fix - WooCommerce status change on orders will no longer trigger an empty email (Thanks @W David for the report here)
* Fix - The broken link in the Easy Digital Downloads ticket email no longer links to a hole in the internet (Thanks to @Safety for the report in the forums)

### [4.1.1] 2016-03-30

* Tweak - Add filters for generated attendee and order data; tribe_tickets_attendee_data and tribe_tickets_order_data, respectively
* Fix - Resolved issue where QR checkins were falsely reporting that attendees were already checked in (Thanks to Christopher from our forums for reporting this!)
* Fix - Resolved issue where cancelled and refunded orders were still being used in the WooCommerce order report revenue calculations (Props to Ameet for reporting this issue!)

### [4.1] 2016-03-15

* Feature - Added the ability to collect custom attendee data with ticket reservation/purchases
* Feature - Pending attendees can now be displayed on the Attendees report for WooCommerce-driven ticket purchases
* Feature - Added ticket sales and ticket stock field support for Advanced Post Manager
* Feature - Added the ability to display the list of attendees on the event page (complete with attendee opt-out support)
* Tweak - Adjusted text on some ticket setting fields
* Fix - Resolved issue where the "Email" link on the Attendees Report would sometimes error out rather than send an email of the attendees
* Fix - Fixed an incorrect image URL on the Attendees Report
* Fix - Prevent multiple check-ins by QR codes for RSVP and ecommerce tickets
* Fix - Add missing `<table>` tag on the QR code HTML
* Fix - Improve front-end notices for recurring event

### [4.0.5] 2016-02-17

* Fix - Prevent tickets from being attached to Commerce provider products/downloads
* Fix - Prevent bad encoding on WooCommerce Ticket emails
* Fix - Prevent Notice on bad usage of `tribe_events_get_ticket_event()`
* Fix - Use method instead of a property inside of get_event_for_ticket() for all 4 eCommerce tickets

### [4.0.4] 2015-12-23

* Fix - Resolved bug where payment types that reduce stock manually (like checks and cash on delivery) were incorrectly totaling the available tickets once a purchase was made (Big thanks to user Tommy and tigertoertchen who helped us resolve this issue!)

### [4.0.3] 2015-12-22

* Fix - Resolved issue where pending payments were being double-counted when calculating total sales for a ticket (Thank you liblogger for bringing this to our attention!)
* Fix - Fixed issue where Orders in the Orders Report were excluded if the "Blog pages show at most" setting in WP was lower than the number of orders for an event (Thank you Ameet for the report!)
* Fix - Resolved fatal caused by PHP 5.4 and lower with WooCommerce when querying cancelled tickets (Cheers to Eric for reporting this issue!)

### [4.0.2] 2015-12-16

* Tweak - Gracefully handle negative inventories (Thank you Ameet for the report!)
* Fix - Resolved bug where the textdomain was not loaded at the appropriate time causing translations to fail (Cheers to Stéphane Bergeron for bringing this up!)
* Fix - Corrected the URL in the popup about Event Tickets being a prerequisite (Thanks for the tip websource!)

### [4.0.1] 2015-12-10

* Tweak - Added performance improvements to the generation of the WooCommerce Orders table
* Tweak - Added hooks to inject event information into Event Tickets attendees reports
* Fix - Resolved issue where a ticket that was created with a blank stock would show a stock of 0 on page reload

### [4.0] 2015-12-02

* Feature - Initial release
