<?php
/**
 * Vertical Line Grid layout class.
 *
 * @package Envira_Gallery
 */

namespace Envira\Frontend\Gallery_Markup\Layouts;

use Envira\Frontend\Gallery_Markup\Base;

/**
 * Vertical Line Grid layout class.
 */
class Vertical_Line_Grid extends Base {
	/**
	 * Generate wrapper classes.
	 *
	 * @return array
	 */
	protected function get_wrapper_classes() {
		$classes   = parent::get_wrapper_classes();
		$classes[] = 'envira-layout-vertical-line-grid';
		$classes[] = 'envira-gallery-theme-' . envira_get_config( 'gallery_theme', $this->data );

		return $classes;
	}

	/**
	 * Get container class.
	 *
	 * @return array
	 */
	protected function get_container_classes() {
		$classes = parent::get_container_classes();
		// Keep default container classes from Base.
		return $classes;
	}

	/**
	 * Override markup method to add CSS variable to wrapper.
	 *
	 * @return string
	 */
	public function markup() {
		// Get columns for CSS variable
		$columns = absint( envira_get_config( 'columns', $this->data ) );
		$columns = $columns > 0 ? $columns : 3;

		// Add filter to include CSS variable in wrapper
		add_filter(
			'envira_gallery_output_shortcode_schema_microdata',
			function ( $microdata ) use ( $columns ) {
				return $microdata . ' style="--envira-columns: ' . $columns . ';"';
			},
			10,
			1
		);

		// Get parent markup
		$markup = parent::markup();

		// Remove filter to prevent affecting other galleries
		remove_all_filters( 'envira_gallery_output_shortcode_schema_microdata' );

		return $markup;
	}
}
