<?php
/**
 * Vertical Focus item layout class.
 *
 * @since 1.10.1
 *
 * @package Envira_Gallery
 * @author  Envira Gallery Team <support@enviragallery.com>
 */

namespace Envira\Frontend\Gallery_Markup\Layouts;

use Envira\Frontend\Gallery_Markup\Item;
use Envira\Utils\Shortcode_Utils;

/**
 * Vertical_Focus item class.
 */
class Vertical_Focus_Item extends Item {
	/**
	 * Displays the caption and title on hover.
	 *
	 * @return string
	 */
	protected function gallery_image_caption_titles() {
		return '';
	}

	/**
	 * Helper method for getting item wrapper styles.
	 *
	 * @param numeric $gutter Gutter size.
	 * @param numeric $margin Margin.
	 *
	 * @return string
	 */
	protected function get_item_wrapper_styles( $gutter, $margin ) {
		return '';
	}

	/**
	 * Generate link open tag.
	 *
	 * @param string $lightbox_caption Lightbox caption.
	 * @param string $lightbox_title Lightbox title.
	 *
	 * @return string
	 */
	protected function get_link_open_tag( $lightbox_caption, $lightbox_title ) {

		$output = parent::get_link_open_tag( $lightbox_caption, $lightbox_title );

		$link_class = Shortcode_Utils::classnames(
			[
				"envira-gallery-$this->unique_id",
				'envira-gallery-vertical-focus-link',
				'envira-gallery-vertical-focus-item',
			]
		);

		// Remove gallery link class to prevent lightbox from opening.
		$output = str_replace( 'envira-gallery-link', '', $output );

		// Append link classes to output.
		$output = str_replace( 'class="', 'class="' . $link_class . ' ', $output );

		return $output;
	}
}
