<?php
/**
 * Vertical_Focus layout class.
 *
 * @since 1.10.1
 *
 * @package Envira_Gallery
 * @author  Envira Gallery Team <support@enviragallery.com>
 */

namespace Envira\Frontend\Gallery_Markup\Layouts;

use Envira\Frontend\Gallery_Markup\Base;
use Envira\Utils\Shortcode_Utils;

/**
 * Vertical_Focus layout class.
 */
class Vertical_Focus extends Base {

	/**
	 * Constructor
	 *
	 * Handles EXIF settings.
	 *
	 * @param array $config All needed data.
	 */
	public function __construct( $config ) {

		parent::__construct( $config );

		// Disable exif and enable exif in lightbox if enabled.
		if ( isset( $this->data['config']['exif'] ) ) {
			$this->data['config']['exif'] = false;
		}

		if ( isset( $this->data['config']['exif_lightbox'] ) ) {
			$is_lightbox = 1 === $this->data['config']['exif_lightbox'] ?? false;
			// Enable exif in lightbox.
			if ( $is_lightbox ) {
				$this->data['config']['exif_lightbox'] = true;
			}
		}
	}

	/**
	 * Generate wrapper classes
	 *
	 * @since 1.10.1
	 */
	protected function get_wrapper_classes() {
		$classes   = parent::get_wrapper_classes();
		$classes[] = 'envira-layout-vertical-focus';
		$classes[] = 'envira-gallery-theme-' . envira_get_config( 'gallery_theme', $this->data );

		return $classes;
	}

	/**
	 * Get container class. Method intended to be extended.
	 *
	 * @return array
	 */
	protected function get_container_classes() {
		$classes   = parent::get_container_classes();
		$classes[] = 'envira-layout-vertical-focus--container';

		return $classes;
	}

	/**
	 * Get item config.
	 *
	 * @param array $config Item config.
	 *
	 * @return Vertical_Focus_Item
	 */
	protected function get_item_object( $config ) {
		return new Vertical_Focus_Item( $config );
	}

	/**
	 * HTML gallery output before container.
	 *
	 * @param string $gallery_markup Gallery Markup.
	 *
	 * @return string|null
	 */
	protected function envira_gallery_output_before_container( $gallery_markup ) {
		$gallery_markup = parent::envira_gallery_output_before_container( $gallery_markup );
		return "$gallery_markup<div class='envira-layout-vertical-focus--wrapper' data-envira-post-id=" . get_the_ID() . "><div class='envira-layout-vertical-focus--highlighted'></div>";
	}

	/**
	 * Clear the float to prevent layout issues.
	 *
	 * @param string $gallery_markup Gallery Markup.
	 *
	 * @return string|null
	 */
	protected function envira_gallery_output_after_container( $gallery_markup ) {
		$gallery_markup = parent::envira_gallery_output_after_container( $gallery_markup );
		return "$gallery_markup</div><div class='envira-clear'></div>";
	}
}
