<?php
/**
 * Spread Harmony layout class.
 *
 * @since ??
 *
 * @package Envira_Gallery
 * @author  Envira Gallery Team <support@enviragallery.com>
 */

namespace Envira\Frontend\Gallery_Markup\Layouts;

use Envira\Frontend\Gallery_Markup\Base;
use Envira\Frontend\Gallery_Markup\Layouts\Spread_Harmony_Item;

/**
 * Spread Harmony layout class.
 */
class Spread_Harmony extends Base {
	/**
	 * Generate wrapper classes
	 *
	 * @since ??
	 */
	protected function get_wrapper_classes() {
		$classes   = parent::get_wrapper_classes();
		$classes[] = 'envira-layout-spread-harmony';

		return $classes;
	}

	/**
	 * Get container class. Method intended to be extended.
	 *
	 * @return array
	 */
	protected function get_container_classes() {
		$classes   = parent::get_container_classes();
		$classes[] = 'envira-layout-spread-harmony--container';

		return $classes;
	}

	/**
	 * Get item config.
	 *
	 * @param array $config Item config.
	 *
	 * @return Spread_Harmony_Item
	 */
	protected function get_item_object( $config ) {
		return new Spread_Harmony_Item( $config );
	}

	/**
	 * Add script after container.
	 *
	 * @param string $gallery_markup Gallery markup.
	 * @return string
	 */
	protected function envira_gallery_output_after_container( $gallery_markup ) {
		$gallery_markup = parent::envira_gallery_output_after_container( $gallery_markup );

		$script = '<script>
  // Pattern: [rowOffset, colStart, rowSpan, colSpan]
  const pattern = [
    [0, 1, 1, 1],  // item 1
    [1, 2, 1, 1],  // item 3
    [0, 3, 2, 2],  // item 2
    [2, 1, 2, 2],  // item 4
    [2, 3, 1, 1],  // item 5
    [3, 4, 1, 1],  // item 6
  ];

  function applyGridLayout() {
    const items = document.querySelectorAll(".envira-gallery-item");
    const blockHeight = 4;        // number of rows per pattern block
    const patternLength = pattern.length;

    
    if (window.innerWidth >= 400) {
      items.forEach((item, index) => {
        const block = Math.floor(index / patternLength);      // which pattern repetition block
        const patternIndex = index % patternLength;           // which pattern item inside the block
        const [rowOffset, colStart, rowSpan, colSpan] = pattern[patternIndex];

        const gridRowStart = block * blockHeight + rowOffset + 1;
        const gridRowEnd = gridRowStart + rowSpan;
        const gridColumnStart = colStart;
        const gridColumnEnd = colStart + colSpan;

        item.style.gridRowStart = gridRowStart;
        item.style.gridRowEnd = gridRowEnd;
        item.style.gridColumnStart = gridColumnStart;
        item.style.gridColumnEnd = gridColumnEnd;
      });
    } else {
      // Reset grid positioning on mobile
      items.forEach((item) => {
        item.style.gridRowStart = "";
        item.style.gridRowEnd = "";
        item.style.gridColumnStart = "";
        item.style.gridColumnEnd = "";
      });
    }
  }

  // Apply layout on load
  applyGridLayout();

  // Reapply layout on window resize
  window.addEventListener("resize", applyGridLayout);
</script>';

		return $gallery_markup . $script;
	}
}
