<?php
/**
 * Creative layout class.
 *
 * @since 1.9.17
 *
 * @package Envira_Gallery
 * @author  Envira Gallery Team <support@enviragallery.com>
 */

namespace Envira\Frontend\Gallery_Markup\Layouts;

use Envira\Frontend\Gallery_Markup\Base;

/**
 * Creative layout class.
 */
class Creative extends Base {
	/**
	 * Generate wrapper classes
	 *
	 * @since 1.9.17
	 */
	protected function get_wrapper_classes() {
		$classes   = parent::get_wrapper_classes();
		$classes[] = 'envira-layout-creative';

		return $classes;
	}

	/**
	 * Get container class. Method intended to be extended.
	 *
	 * @return array
	 */
	protected function get_container_classes() {
		$classes   = parent::get_container_classes();
		$classes[] = 'envira-layout-creative--container';

		return $classes;
	}

	/**
	 * Get item config.
	 *
	 * @param array $config Item config.
	 *
	 * @return Automatic_Item
	 */
	protected function get_item_object( $config ) {
		return new Creative_Item( $config );
	}
}
