<?php
/**
 * Functions.
 *
 * @package Envira_Gallery
 */

// Conditionally load the template tag.
if ( ! function_exists( 'envira_dynamic' ) ) {
	/**
	 * Template tag function for outputting dynamic galleries with Envira.
	 *
	 * @since 1.0.0
	 *
	 * @param array $args  Args used for the gallery init script.
	 * @param bool  $result Flag for returning or echoing the gallery content.
	 */
	function envira_dynamic( $args = [], $result = false ) {

		// If no ID, return false.
		if ( empty( $args['id'] ) ) {
			return false;
		}

		// Pull out the ID and remove from args.
		$id = $args['id'];
		unset( $args['id'] );

		// Call main Envira Gallery template tag function.
		envira_gallery( $id, 'dynamic', $args, $result );
	}
}

// Conditionally load the template tag.
if ( ! function_exists( 'envira_dynamic_album' ) ) {
	/**
	 * Template tag function for outputting dynamic albums with Envira.
	 *
	 * @since 1.0.0
	 *
	 * @param array $args  Args used for the gallery init script.
	 * @param bool  $result Flag for returning or echoing the gallery content.
	 */
	function envira_dynamic_album( $args = [], $result = false ) {

		// If no ID, return false.
		if ( empty( $args['id'] ) ) {
			return false;
		}

		// Pull out the ID and remove from args.
		$id = $args['id'];
		unset( $args['id'] );

		// Call main Envira Gallery template tag function.
		envira_album( $id, 'dynamic', $args, $result );
	}
}
