<?php
/**
 * Subscription Scheduled Activation Reminder Email.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/csd-customer-subscription-scheduled-activation-reminder.php.
 */
defined( 'ABSPATH' ) || exit;

/**
 * Email header.
 * 
 * @since 1.0.0
 */
do_action( 'woocommerce_email_header', $email_heading, $email );
?>

<?php /* translators: %s: Customer first name */ ?>
<p><?php printf( esc_html__( 'Hi %s,', 'email-reminders-for-woocommerce-subscriptions' ), esc_html( $subscription->get_billing_first_name() ) ); ?></p>
<?php /* translators: %s: Start date */ ?>
<p><?php printf( wp_kses_post( __( 'This is a reminder that your subscription will become active on <code>%s</code>. Your subscription\'s details are as follows:', 'email-reminders-for-woocommerce-subscriptions' ) ), esc_html( date_i18n( wc_date_format(), $subscription->get_time( 'start', 'site' ) ) ) ); ?></p>
<?php
/**
 * Email subscription details.
 * 
 * @since 1.0.0
 */
do_action( 'woocommerce_subscriptions_email_order_details', $subscription, $sent_to_admin, $plain_text, $email );

/**
 * Email customer details.
 * 
 * @since 1.0.0
 */
do_action( 'woocommerce_email_customer_details', $subscription, $sent_to_admin, $plain_text, $email );

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
}

/**
 * Email footer.
 * 
 * @since 1.0.0
 */
do_action( 'woocommerce_email_footer', $email );
