<?php

defined( 'ABSPATH' ) || exit;

/**
 * Emails class.
 * 
 * @class ASP_ERWS_Emails
 * @package Class
 */
class ASP_ERWS_Emails {

	/**
	 * Init the email class hooks in all emails that can be sent.
	 */
	public static function init() {
		add_filter( 'woocommerce_email_classes', __CLASS__ . '::add_email_classes' );
		add_filter( 'woocommerce_email_actions', __CLASS__ . '::add_email_actions' );
		add_action( 'asp_erws_is_email_sent_success', __CLASS__ . '::is_email_sent', 10, 3 );

		ASP_ERWS_Email_Preview::init();
	}

	/**
	 * Gets an array of email classes.
	 * 
	 * @return array
	 */
	public static function get_email_classes() {
		/**
		 * Gets an array of email classes.
		 * 
		 * @since 2.4.0
		 */
		$email_classes = apply_filters( 'asp_erws_get_email_classes', array(
			'ASP_ERWS_Email_Customer_Subscription_Trial_Ending_Reminder',
			'ASP_ERWS_Email_Customer_Subscription_Manual_Renewal_Reminder',
			'ASP_ERWS_Email_Customer_Subscription_Auto_Renewal_Reminder',
			'ASP_ERWS_Email_Customer_Subscription_Expiration_Reminder',
			'ASP_ERWS_Email_Customer_Subscription_After_Expiry_Reminder',
				) );

		return $email_classes;
	}

	/**
	 * Gets an array of email actions.
	 * 
	 * @return array
	 */
	public static function get_email_actions() {
		/**
		 * Gets an array of email actions.
		 * 
		 * @since 2.4.0
		 */
		$email_actions = apply_filters( 'asp_erws_get_email_actions', array(
			'asp_erws_woocommerce_subscriptions_remind_trial_ending',
			'asp_erws_woocommerce_subscriptions_remind_manual_renewal',
			'asp_erws_woocommerce_subscriptions_remind_auto_renewal',
			'asp_erws_woocommerce_subscriptions_remind_expiration',
			'asp_erws_woocommerce_subscriptions_remind_after_expiry',
			'asp_erws_woocommerce_subscriptions_remind_csd_scheduled_activation',
				) );

		return $email_actions;
	}

	/**
	 * Load our email classes.
	 * 
	 * @param array $emails
	 */
	public static function add_email_classes( $emails ) {
		foreach ( self::get_email_classes() as $email_class ) {
			$email_filename         = str_replace( '_', '-', strtolower( $email_class ) );
			$emails[ $email_class ] = include __DIR__ . "/emails/class-{$email_filename}.php";
		}

		return $emails;
	}

	/**
	 * Hook in all our emails to notify.
	 */
	public static function add_email_actions( $email_actions ) {
		if ( is_callable( array( 'WCS_Staging', 'is_duplicate_site' ) ) && WCS_Staging::is_duplicate_site() && ! defined( 'WCS_FORCE_EMAIL' ) ) {
			return $email_actions;
		}

		foreach ( self::get_email_actions() as $email_action ) {
			$email_actions[] = $email_action;
		}

		return $email_actions;
	}

	/**
	 * Adds the subscription note after the email sent.
	 * 
	 * @param bool $bool
	 * @param WC_Subscription $subscription
	 * @param WC_Email $email
	 */
	public static function is_email_sent( $bool, $subscription, $email ) {
		if ( $bool ) {
			/* translators: 1: email title 2: email recipient */
			$subscription->add_order_note( sprintf( __( '<code>%1$s</code> email has been sent to %2$s.', 'email-reminders-for-woocommerce-subscriptions' ), $email->title, $email->recipient ) );
		} else {
			/* translators: 1: email title 2: email recipient */
			$subscription->add_order_note( sprintf( __( 'Failed to sent <code>%1$s</code> email to %2$s.', 'email-reminders-for-woocommerce-subscriptions' ), $email->title, $email->recipient ) );
		}
	}
}

ASP_ERWS_Emails::init();
