<?php
defined( 'ABSPATH' ) || exit;

/**
 * Before custom email reminder template criteria tab.
 * 
 * @since 1.8.0
 */
do_action( 'asp_erws_admin_before_custom_template_data_criteria', $custom_template );

$product_cats = ASP_ERWS_Admin::get_product_terms( array( 'taxonomy' => 'product_cat' ) );
$user_roles   = ASP_ERWS_Admin::get_user_roles();
?>
<div id="criteria_custom_template_data" class="panel woocommerce_options_panel">
	<div class="options_group">

		<p class="asp-erws-form-field _criteria_product_filter_field">
			<label for="_criteria_product_filter">
				<?php esc_html_e( 'Product Filter', 'email-reminders-for-woocommerce-subscriptions' ); ?>
			</label>
			<select id="_criteria_product_filter" name="_criteria_product_filter">
				<option value="all-products" <?php selected( 'all-products', $custom_template->get_criteria_product_filter(), true ); ?>><?php esc_html_e( 'All products', 'email-reminders-for-woocommerce-subscriptions' ); ?></option>
				<option value="included-products" <?php selected( 'included-products', $custom_template->get_criteria_product_filter(), true ); ?>><?php esc_html_e( 'Include products', 'email-reminders-for-woocommerce-subscriptions' ); ?></option>		
				<option value="included-product-cats" <?php selected( 'included-product-cats', $custom_template->get_criteria_product_filter(), true ); ?>><?php esc_html_e( 'Include categories', 'email-reminders-for-woocommerce-subscriptions' ); ?></option>
			</select>
		</p>

		<p class="asp-erws-form-field _criteria_products_field">
			<label for="_criteria_products">
				<?php esc_html_e( 'Select Products', 'email-reminders-for-woocommerce-subscriptions' ); ?>
			</label>
			<?php
			asp_erws_admin_search_field( array(
				'class'       => 'wc-product-search',
				'id'          => '_criteria_products',
				'type'        => 'product',
				'multiple'    => true,
				'placeholder' => __( 'Search for a product&hellip;', 'email-reminders-for-woocommerce-subscriptions' ),
				'options'     => $custom_template->get_criteria_products(),
			) );
			?>
		</p>

		<p class="asp-erws-form-field _criteria_product_cats_field">
			<label for="_criteria_product_cats">
				<?php esc_html_e( 'Select Product Categories', 'email-reminders-for-woocommerce-subscriptions' ); ?>
			</label>
			<select name="_criteria_product_cats[]" multiple="multiple" class="wc-enhanced-select">
				<?php foreach ( $product_cats as $key => $val ) : ?>
					<?php if ( is_array( $val ) ) : ?>
						<optgroup label="<?php echo esc_attr( $key ); ?>">
							<?php foreach ( $val as $option_key_inner => $option_value_inner ) : ?>
								<option value="<?php echo esc_attr( $option_key_inner ); ?>" <?php selected( in_array( ( string ) $option_key_inner, $custom_template->get_criteria_product_cats(), true ), true ); ?>><?php echo esc_html( $option_value_inner ); ?></option>
							<?php endforeach; ?>
						</optgroup>
					<?php else : ?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( in_array( $key, $custom_template->get_criteria_product_cats() ), true, true ); ?>><?php echo esc_html( $val ); ?></option>
					<?php endif; ?>
				<?php endforeach; ?>
			</select>
		</p>

		<p class="asp-erws-form-field _criteria_user_filter_field">
			<label for="_criteria_user_filter"><?php esc_html_e( 'User Filter', 'email-reminders-for-woocommerce-subscriptions' ); ?></label>
			<select id="_criteria_user_filter" name="_criteria_user_filter">
				<option value="all-users" <?php selected( 'all-users', $custom_template->get_criteria_user_filter(), true ); ?>><?php esc_html_e( 'All users', 'email-reminders-for-woocommerce-subscriptions' ); ?></option>
				<option value="included-users" <?php selected( 'included-users', $custom_template->get_criteria_user_filter(), true ); ?>><?php esc_html_e( 'Include users', 'email-reminders-for-woocommerce-subscriptions' ); ?></option>		
				<option value="included-user-roles" <?php selected( 'included-user-roles', $custom_template->get_criteria_user_filter(), true ); ?>><?php esc_html_e( 'Include user roles', 'email-reminders-for-woocommerce-subscriptions' ); ?></option>
			</select>
		</p>

		<p class="asp-erws-form-field _criteria_users_field">
			<label for="_criteria_users">
				<?php esc_html_e( 'Select Users', 'email-reminders-for-woocommerce-subscriptions' ); ?>
			</label>
			<?php
			asp_erws_admin_search_field( array(
				'class'       => 'wc-customer-search',
				'id'          => '_criteria_users',
				'type'        => 'customer',
				'multiple'    => true,
				'placeholder' => __( 'Search for a user&hellip;', 'email-reminders-for-woocommerce-subscriptions' ),
				'options'     => $custom_template->get_criteria_users(),
			) );
			?>
		</p>

		<p class="asp-erws-form-field _criteria_user_roles_field">
			<label for="_criteria_user_roles">
				<?php esc_html_e( 'Select User Roles', 'email-reminders-for-woocommerce-subscriptions' ); ?>
			</label>
			<select name="_criteria_user_roles[]" multiple="multiple" class="wc-enhanced-select">
				<?php foreach ( $user_roles as $key => $val ) : ?>
					<?php if ( is_array( $val ) ) : ?>
						<optgroup label="<?php echo esc_attr( $key ); ?>">
							<?php foreach ( $val as $option_key_inner => $option_value_inner ) : ?>
								<option value="<?php echo esc_attr( $option_key_inner ); ?>" <?php selected( in_array( ( string ) $option_key_inner, $custom_template->get_criteria_user_roles(), true ), true ); ?>><?php echo esc_html( $option_value_inner ); ?></option>
							<?php endforeach; ?>
						</optgroup>
					<?php else : ?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( in_array( $key, $custom_template->get_criteria_user_roles() ), true, true ); ?>><?php echo esc_html( $val ); ?></option>
					<?php endif; ?>
				<?php endforeach; ?>
			</select>
		</p>
	</div>
</div>
<?php
/**
 * After custom email reminder template criteria tab.
 * 
 * @since 1.8.0
 */
do_action( 'asp_erws_admin_after_custom_template_data_criteria', $custom_template );
