<?php

/**
 * Subscription Expiration Reminder Email.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/plain/customer-subscription-expiration-reminder.php.
 */
defined( 'ABSPATH' ) || exit;

echo esc_html( $email_heading ) . "\n\n";

/* translators: %s: Customer first name */
echo sprintf( esc_html__( 'Hi %s,', 'email-reminders-for-woocommerce-subscriptions' ), esc_html( $subscription->get_billing_first_name() ) ) . "\n\n";
/* translators: %s: End date */
echo sprintf( esc_html__( 'This is a reminder that your subscription will expire on %s. Your subscription\'s details are as follows:', 'email-reminders-for-woocommerce-subscriptions' ), esc_html( date_i18n( wc_date_format(), $subscription->get_time( 'end', 'site' ) ) ) ) . "\n\n";

echo "\n\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n";

/**
 * Add email order details.
 * 
 * @since 1.0.0
 */
do_action( 'woocommerce_subscriptions_email_order_details', $subscription, $sent_to_admin, $plain_text, $email );

/**
 * Add email order meta.
 * 
 * @since 1.0.0
 */
do_action( 'woocommerce_email_order_meta', $subscription, $sent_to_admin, $plain_text, $email );

// translators: view subscription url
echo "\n" . sprintf( esc_html_x( 'View Subscription: %s', 'in plain emails for subscription information', 'email-reminders-for-woocommerce-subscriptions' ), esc_url( $subscription->get_view_order_url() ) ) . "\n";

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

/**
 * Add email customer details.
 * 
 * @since 1.0.0
 */
do_action( 'woocommerce_email_customer_details', $subscription, $sent_to_admin, $plain_text, $email );

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo esc_html( wp_strip_all_tags( wptexturize( $additional_content ) ) );
	echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";
}

/**
 * Get the email footer text.
 * 
 * @since 1.0.0
 */
echo esc_html( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) );
