<?php
defined( 'ABSPATH' ) || exit;

/**
 * Before custom email reminder template shortcodes.
 * 
 * @since 1.8.0
 */
do_action( 'asp_erws_admin_before_custom_template_shortcodes', $custom_template );
?>
<table class="widefat striped">
	<thead>
		<tr>
			<th><?php esc_html_e( 'Shortcode', 'email-reminders-for-woocommerce-subscriptions' ); ?></th>
			<th><?php esc_html_e( 'Purpose', 'email-reminders-for-woocommerce-subscriptions' ); ?></th>
		</tr>
	</thead>
	<tbody>                
		<?php foreach ( $email_shortcodes as $shortcode => $purpose ) { ?>
			<tr>
				<td><code><?php echo esc_html( $shortcode ); ?></code></td>
				<td><?php echo esc_html( $purpose ); ?></td>
			</tr>
		<?php } ?>
	</tbody>
</table>
<?php
/**
 * After custom email reminder template shortcodes.
 * 
 * @since 1.8.0
 */
do_action( 'asp_erws_admin_after_custom_template_shortcodes', $custom_template );
