<?php
defined( 'ABSPATH' ) || exit;

/**
 * Custom Email Reminder Template Test Email.
 * 
 * @class ASP_ERWS_Meta_Box_Custom_Template_Test_Email
 * @package Class
 */
class ASP_ERWS_Meta_Box_Custom_Template_Test_Email {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post $post Post object.
	 */
	public static function output( $post ) {
		global $post, $the_custom_template;

		if ( ! is_object( $the_custom_template ) ) {
			$the_custom_template = new ASP_ERWS_Custom_Template( $post->ID );
		}

		$custom_template = $the_custom_template;
		$subscriptions   = wcs_get_subscriptions( array( 'subscriptions_per_page' => 10, 'return' => 'ids' ) );
		?>
		<ul class="order_actions submitbox">
			<?php
			/**
			 * Before custom email reminder template test email.
			 * 
			 * @since 1.8.0
			 */
			do_action( 'asp_erws_custom_template_test_email_start', $post->ID );
			?>
			<li class="wide">
				<label for="recipients"><?php esc_html_e( 'Email recipient(s)', 'email-reminders-for-woocommerce-subscriptions' ); ?><?php echo wp_kses_post( wc_help_tip( __( 'Enter recipients (comma separated) for this email.', 'email-reminders-for-woocommerce-subscriptions' ) ) ); ?></label>
				<input type="text" id="recipients" name="_recipients" value="<?php echo esc_attr( get_option( 'admin_email' ) ); ?>"/>
			</li>

			<li class="wide">
				<label for="subscription_id"><?php esc_html_e( 'Select a subscription', 'email-reminders-for-woocommerce-subscriptions' ); ?></label>
				<select id="subscription_id" name="_subscription_id">
					<?php if ( ! empty( $subscriptions ) ) { ?>
						<?php foreach ( $subscriptions as $subscription ) { ?>
							<option value="<?php echo esc_attr( $subscription->get_id() ); ?>">#<?php echo esc_html( $subscription->get_id() ); ?></option>
						<?php } ?>
					<?php } else { ?>
						<option value="0"><?php esc_html_e( 'No subscription found', 'email-reminders-for-woocommerce-subscriptions' ); ?></option>
					<?php } ?>
				</select>
			</li>

			<li class="wide">
				<?php echo wp_kses_post( __( '<b>Note:</b> Please save the template once you have finished editing so that your changes will be reflected on your email.', 'email-reminders-for-woocommerce-subscriptions' ) ); ?>
			</li>

			<li class="wide email-actions">
				<button type="button" class="button button-primary" name="_send_email" value=""><?php esc_html_e( 'Send email', 'email-reminders-for-woocommerce-subscriptions' ); ?></button>
			</li>
			<?php
			/**
			 * After custom email reminder template test email.
			 * 
			 * @since 1.8.0
			 */
			do_action( 'asp_erws_custom_template_test_email_end', $post->ID );
			?>
		</ul>
		<?php
	}
}
