<?php
defined( 'ABSPATH' ) || exit;

/**
 * Custom Email Reminder Template Actions.
 * 
 * @class ASP_ERWS_Meta_Box_Custom_Template_Actions
 * @package Class
 */
class ASP_ERWS_Meta_Box_Custom_Template_Actions {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post $post Post object.
	 */
	public static function output( $post ) {
		global $post, $the_custom_template;

		if ( ! is_object( $the_custom_template ) ) {
			$the_custom_template = new ASP_ERWS_Custom_Template( $post->ID );
		}

		$custom_template = $the_custom_template;
		?>
		<ul class="order_actions submitbox">
			<?php
			/**
			 * Before custom email reminder template actions.
			 * 
			 * @since 1.8.0
			 */
			do_action( 'asp_erws_custom_template_actions_start', $post->ID );
			?>
			<li class="wide">
				<select name="_status">
					<?php foreach ( asp_erws_get_custom_template_statuses() as $status_name => $status_label ) { ?>
						<option value="<?php echo esc_attr( $status_name ); ?>" <?php selected( 'asp-' . $custom_template->get_status( 'edit' ), $status_name, true ); ?>><?php echo esc_html( $status_label ); ?></option>
					<?php } ?>
				</select>
			</li>

			<li class="wide">
				<div id="delete-action">
					<?php
					if ( current_user_can( 'delete_post', $post->ID ) ) {
						if ( ! EMPTY_TRASH_DAYS ) {
							$delete_text = __( 'Delete permanently', 'email-reminders-for-woocommerce-subscriptions' );
						} else {
							$delete_text = __( 'Move to Trash', 'email-reminders-for-woocommerce-subscriptions' );
						}
						?>
						<a class="submitdelete deletion" href="<?php echo esc_url( get_delete_post_link( $post->ID ) ); ?>"><?php echo esc_html( $delete_text ); ?></a>
						<?php
					}
					?>
				</div>
				<button type="submit" class="button save_order button-primary" name="save" value="<?php echo 'auto-draft' === $post->post_status ? esc_attr__( 'Create', 'email-reminders-for-woocommerce-subscriptions' ) : esc_attr__( 'Update', 'email-reminders-for-woocommerce-subscriptions' ); ?>"><?php echo 'auto-draft' === $post->post_status ? esc_html__( 'Create', 'email-reminders-for-woocommerce-subscriptions' ) : esc_html__( 'Update', 'email-reminders-for-woocommerce-subscriptions' ); ?></button>
			</li>

			<?php
			/**
			 * After custom email reminder template actions.
			 * 
			 * @since 1.8.0
			 */
			do_action( 'asp_erws_custom_template_actions_end', $post->ID );
			?>
		</ul>
		<?php
	}

	/**
	 * Save meta box data.
	 *
	 * @param int $post_id
	 * @param WP_Post $post
	 */
	public static function save( $post_id, $post, $posted ) {
		$custom_template = new ASP_ERWS_Custom_Template( $post_id );

		$errors = $custom_template->set_props( array(
			'slug'                    => isset( $posted[ 'post_title' ] ) ? sanitize_title( wp_unslash( $posted[ 'post_title' ] ) ) : '',
			'email_slug'              => isset( $posted[ '_email_slug' ] ) ? sanitize_title( wp_unslash( $posted[ '_email_slug' ] ) ) : '',
			'email_sending_interval'  => isset( $posted[ '_email_sending_interval' ] ) ? sanitize_title( wp_unslash( $posted[ '_email_sending_interval' ] ) ) : '',
			'email_subject'           => isset( $posted[ '_email_subject' ] ) ? wc_clean( wp_unslash( $posted[ '_email_subject' ] ) ) : '',
			'email_heading'           => isset( $posted[ '_email_heading' ] ) ? wc_clean( wp_unslash( $posted[ '_email_heading' ] ) ) : '',
			'email_content'           => isset( $posted[ '_email_content' ] ) ? wp_unslash( $posted[ '_email_content' ] ) : '',
			'criteria_product_filter' => isset( $posted[ '_criteria_product_filter' ] ) ? sanitize_title( wp_unslash( $posted[ '_criteria_product_filter' ] ) ) : 'all-products',
			'criteria_user_filter'    => isset( $posted[ '_criteria_user_filter' ] ) ? sanitize_title( wp_unslash( $posted[ '_criteria_user_filter' ] ) ) : 'all-users',
			'criteria_products'       => isset( $posted[ '_criteria_products' ] ) ? array_values( array_filter( ( array ) wp_unslash( $posted[ '_criteria_products' ] ) ) ) : array(),
			'criteria_product_cats'   => isset( $posted[ '_criteria_product_cats' ] ) ? array_values( array_filter( ( array ) wp_unslash( $posted[ '_criteria_product_cats' ] ) ) ) : array(),
			'criteria_users'          => isset( $posted[ '_criteria_users' ] ) ? array_values( array_filter( ( array ) wp_unslash( $posted[ '_criteria_users' ] ) ) ) : array(),
			'criteria_user_roles'     => isset( $posted[ '_criteria_user_roles' ] ) ? array_values( array_filter( ( array ) wp_unslash( $posted[ '_criteria_user_roles' ] ) ) ) : array(),
				) );

		if ( ! $custom_template->get_priority() ) {
			$custom_templates = asp_erws_get_custom_templates();
			$order                           = 1;

			$custom_template->set_priority( $order );

			if ( $custom_templates->has_template ) {
				foreach ( $custom_templates->templates as $_tmpl ) {
					$order++;

					$_tmpl->set_priority( $order );
					$_tmpl->save();
				}
			}
		}

		if ( is_wp_error( $errors ) ) {
			ASP_ERWS_Admin::add_error( $errors->get_error_message() );
		}

		/**
		 * Custom email reminder template before save manually.
		 * 
		 * @since 1.8.0
		 */
		do_action( 'asp_erws_admin_custom_template_before_save', $custom_template, $posted );

		$custom_template->update_status( wc_clean( wp_unslash( $posted[ '_status' ] ) ) );
	}
}
