<?php

/**
 * Plugin Name: Email Reminders for WooCommerce Subscriptions
 * Description: This plugin helps you to automatically send scheduled reminder emails in advance for subscription trial ending, subscription due(manual and auto renewal), subscription expiry to your customers, etc.
 * Version: 2.6.0
 * Author: AspiringPlugins
 * Author URI: https://aspiringplugins.com/
 * Text Domain: email-reminders-for-woocommerce-subscriptions
 * Domain Path: /languages
 * 
 * Tested up to: 6.9.0
 * WC requires at least: 5.0.0
 * WC tested up to: 10.4.3
 * WCS requires at least: 3.1.0
 * WCS tested up to: 8.2.1
 * Requires Plugins: woocommerce,woocommerce-subscriptions
 * 
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Woo: 18734001996841:53215a21a77f1408b7bbbce175d868a6

 */
defined( 'ABSPATH' ) || exit;

/**
 * Define our plugin constants.
 */
define( 'ASP_ERWS_PLUGIN_FILE', __FILE__ );
define( 'ASP_ERWS_ABSPATH', dirname( ASP_ERWS_PLUGIN_FILE ) . '/' );
define( 'ASP_ERWS_PLUGIN_BASENAME', plugin_basename( ASP_ERWS_PLUGIN_FILE ) );
define( 'ASP_ERWS_VERSION', '2.6.0' );
define( 'ASP_ERWS_MIN_WC_VER', '5.0.0' );
define( 'ASP_ERWS_MIN_WCS_VER', '3.1.0' );

/**
 * WooCommere missing notice.
 */
function asp_erws_missing_wc_notice() {
	echo "<div class='error'><p>Email Reminders for WooCommerce Subscriptions Plugin requires <a href='http://woocommerce.com/' target='_blank'>WooCommerce</a> plugin to be installed and active.</p></div>";
}

/**
 * WooCommere Subscriptions missing notice.
 */
function asp_erws_missing_wcs_notice() {
	echo "<div class='error'><p>Email Reminders for WooCommerce Subscriptions plugin requires <a href='http://woocommerce.com/products/woocommerce-subscriptions/' target='_blank'>WooCommerce Subscriptions</a> plugin to be installed and active.</p></div>";
}

/**
 * WooCommerce not supported notice.
 */
function asp_erws_wc_not_supported() {
	echo '<div class="error"><p>Email Reminders for WooCommerce Subscriptions plugin requires <strong> WooCommerce ' . esc_attr( ASP_ERWS_MIN_WC_VER ) . ' or greater </strong> to be installed and active.</p></div>';
}

/**
 * WooCommerce Subscriptions not supported notice.
 */
function asp_erws_wcs_not_supported() {
	echo '<div class="error"><p>Email Reminders for WooCommerce Subscriptions plugin requires <strong> WooCommerce Subscriptions ' . esc_attr( ASP_ERWS_MIN_WCS_VER ) . ' or greater </strong> to be installed and active.</p></div>';
}

/**
 * Add HPOS support.
 */
add_action( 'before_woocommerce_init', function () {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

/**
 * Init Email Reminders for WooCommerce Subscriptions.
 */
function asp_init_email_reminders_for_woocommerce_subscriptions() {
	if ( ! class_exists( 'WooCommerce' ) ) {
		add_action( 'admin_notices', 'asp_erws_missing_wc_notice' );
		return;
	}

	if ( version_compare( WC_VERSION, ASP_ERWS_MIN_WC_VER, '<' ) ) {
		add_action( 'admin_notices', 'asp_erws_wc_not_supported' );
		return;
	}

	if ( ! class_exists( 'WC_Subscriptions' ) ) {
		add_action( 'admin_notices', 'asp_erws_missing_wcs_notice' );
		return;
	}

	if ( version_compare( WC_Subscriptions::$version, ASP_ERWS_MIN_WCS_VER, '<' ) ) {
		add_action( 'admin_notices', 'asp_erws_wcs_not_supported' );
		return;
	}

	// Include main class file.
	if ( ! class_exists( 'ASP_Email_Reminders_For_Woocommerce_Subscriptions' ) ) {
		include_once 'includes/class-email-reminders-for-woocommerce-subscriptions.php';
	}

	/**
	 * Returns the main instance of Email Reminders for WooCommerce Subscriptions.
	 *
	 * @return ASP_Email_Reminders_For_Woocommerce_Subscriptions
	 */
	function ASP_ERWS() {
		return ASP_Email_Reminders_For_Woocommerce_Subscriptions::instance();
	}

	/**
	 * Allow our plugin to run only if the plugin dependencies are met.
	 */
	ASP_ERWS();
}

add_action( 'plugins_loaded', 'asp_init_email_reminders_for_woocommerce_subscriptions' );
