<?php

defined( 'ABSPATH' ) || exit;

/**
 * Emails class.
 * 
 * @class ASP_ERWS_Emails
 * @package Class
 */
class ASP_ERWS_Emails {

	/**
	 * Init the email class hooks in all emails that can be sent.
	 */
	public static function init() {
		add_filter( 'woocommerce_email_classes', __CLASS__ . '::add_email_classes' );
		add_filter( 'woocommerce_email_actions', __CLASS__ . '::add_email_actions' );
		add_action( 'asp_erws_is_email_sent_success', __CLASS__ . '::is_email_sent', 10, 3 );
	}

	/**
	 * Load our email classes.
	 * 
	 * @param array $emails
	 */
	public static function add_email_classes( $emails ) {
		$emails[ 'ASP_ERWS_Email_Customer_Subscription_Trial_Ending_Reminder' ]   = include __DIR__ . '/emails/class-asp-erws-email-customer-subscription-trial-ending-reminder.php';
		$emails[ 'ASP_ERWS_Email_Customer_Subscription_Manual_Renewal_Reminder' ] = include __DIR__ . '/emails/class-asp-erws-email-customer-subscription-manual-renewal-reminder.php';
		$emails[ 'ASP_ERWS_Email_Customer_Subscription_Auto_Renewal_Reminder' ]   = include __DIR__ . '/emails/class-asp-erws-email-customer-subscription-auto-renewal-reminder.php';
		$emails[ 'ASP_ERWS_Email_Customer_Subscription_Expiration_Reminder' ]     = include __DIR__ . '/emails/class-asp-erws-email-customer-subscription-expiration-reminder.php';
		$emails[ 'ASP_ERWS_Email_Customer_Subscription_After_Expiry_Reminder' ]   = include __DIR__ . '/emails/class-asp-erws-email-customer-subscription-after-expiry-reminder.php';
		return $emails;
	}

	/**
	 * Hook in all our emails to notify.
	 */
	public static function add_email_actions( $email_actions ) {
		if ( is_callable( array( 'WCS_Staging', 'is_duplicate_site' ) ) && WCS_Staging::is_duplicate_site() && ! defined( 'WCS_FORCE_EMAIL' ) ) {
			return $email_actions;
		}

		$email_actions[] = 'asp_erws_woocommerce_subscriptions_remind_trial_ending';
		$email_actions[] = 'asp_erws_woocommerce_subscriptions_remind_manual_renewal';
		$email_actions[] = 'asp_erws_woocommerce_subscriptions_remind_auto_renewal';
		$email_actions[] = 'asp_erws_woocommerce_subscriptions_remind_expiration';
		$email_actions[] = 'asp_erws_woocommerce_subscriptions_remind_after_expiry';
		return $email_actions;
	}

	/**
	 * Adds the subscription note after the email sent.
	 * 
	 * @param bool $bool
	 * @param WC_Subscription $subscription
	 * @param WC_Email $email
	 */
	public static function is_email_sent( $bool, $subscription, $email ) {
		if ( $bool ) {
			/* translators: 1: email title 2: email recipient */
			$subscription->add_order_note( sprintf( __( '<code>%1$s</code> email has been sent to %2$s.', 'email-reminders-for-woocommerce-subscriptions' ), $email->title, $email->recipient ) );
		} else {
			/* translators: 1: email title 2: email recipient */
			$subscription->add_order_note( sprintf( __( 'Failed to sent <code>%1$s</code> email to %2$s.', 'email-reminders-for-woocommerce-subscriptions' ), $email->title, $email->recipient ) );
		}
	}
}

ASP_ERWS_Emails::init();
