<?php
defined( 'ABSPATH' ) || exit;
?>
<div class="panel-wrap asp-erws-custom-template-data-panel-wrap">  
	<span class="custom-template-data-hidden-box email_slug_box hidden"> &mdash;
		<label for="_email_slug">
			<select name="_email_slug">
				<?php foreach ( ASP_ERWS()->get_reminders() as $slug => $val ) { ?>
					<option value="<?php echo esc_attr( $slug ); ?>"
					<?php
					if ( is_array( $custom_template->get_email_slug() ) ) {
						selected( in_array( ( string ) $slug, $custom_template->get_email_slug(), true ), true );
					} else {
						selected( $custom_template->get_email_slug(), ( string ) $slug );
					}
					?>
							>
								<?php echo esc_html( $val ); ?>
					</option>
				<?php } ?>
			</select>
			<?php echo wp_kses_post( wc_help_tip( __( 'Select the reminder email you want to customize here. <br><b>Note:</b> Please configure reminder intervals under <b>WooCommerce > Settings > Subscriptions > Email Reminders</b> before customizing this template so that it will work.', 'email-reminders-for-woocommerce-subscriptions' ) ) ); ?>
		</label>
	</span>  

	<ul class="asp_erws_custom_template_data_tabs wc-tabs">
		<?php foreach ( self::get_custom_template_data_tabs() as $key => $_tab ) : ?>
			<li class="<?php echo esc_attr( $key ); ?>_options <?php echo esc_attr( $key ); ?>_tab <?php echo esc_attr( isset( $_tab[ 'class' ] ) ? implode( ' ', ( array ) $_tab[ 'class' ] ) : ''  ); ?>">
				<a href="#<?php echo esc_attr( $_tab[ 'target' ] ); ?>"><span><?php echo esc_html( $_tab[ 'label' ] ); ?></span></a>
			</li>
		<?php endforeach; ?>
		<?php
		/**
		 * Custom email reminder template data tabs.
		 * 
		 * @since 1.8.0
		 */
		do_action( 'asp_erws_custom_template_data_panel_tabs' );
		?>
	</ul>
	<?php
	self::output_tabs();

	/**
	 * Custom email reminder template data tab content.
	 * 
	 * @since 1.8.0
	 */
	do_action( 'asp_erws_custom_template_data_panels' );
	?>
</div>
<div class="clear"></div>
