<?php
defined( 'ABSPATH' ) || exit;

/**
 * Before custom email reminder template general tab.
 * 
 * @since 1.8.0
 */
do_action( 'asp_erws_admin_before_custom_template_data_general', $custom_template );
?>
<div id="general_custom_template_data" class="panel woocommerce_options_panel">
	<?php
	/**
	 * Before custom email reminder template general tab fields.
	 * 
	 * @since 1.8.0
	 */
	do_action( 'asp_erws_admin_custom_template_data_before_general_fields', $custom_template );
	?>

	<div class="options_group">
		<p class="asp-erws-form-field _email_sending_interval_field">
			<label for="_email_sending_interval"><?php esc_html_e( 'Send email', 'email-reminders-for-woocommerce-subscriptions' ); ?></label>
			<input type="number" name="_email_sending_interval" min="1" required="required" id="email_sending_interval" placeholder="<?php esc_attr_e( 'e.g. 1', 'email-reminders-for-woocommerce-subscriptions' ); ?>" value="<?php echo esc_attr( $custom_template->get_email_sending_interval() ); ?>"/>
			<span class="description"><?php echo wp_kses_post( $email_field_atts[ 'description' ][ 'custom_template_sending_interval' ] ); ?></span>
		</p>
	</div>

	<fieldset class="fieldset_group">
		<legend><i><b><?php esc_html_e( 'Customize your email here', 'email-reminders-for-woocommerce-subscriptions' ); ?></b></i></legend>

		<p class="_email_subject_field">
			<label for="_email_subject"><?php esc_html_e( 'Email subject', 'email-reminders-for-woocommerce-subscriptions' ); ?></label>
			<input type="text" name="_email_subject" id="_email_subject" placeholder="<?php echo esc_attr( $email_field_atts[ 'placeholder' ][ 'subject' ] ); ?>" value="<?php echo esc_attr( $custom_template->get_email_subject() ); ?>"/>
			<span class="description"><?php echo wp_kses_post( $email_field_atts[ 'description' ][ 'subject' ] ); ?></span>
		</p>

		<p class="_email_heading_field">
			<label for="_email_heading"><?php esc_html_e( 'Email heading', 'email-reminders-for-woocommerce-subscriptions' ); ?></label>
			<input type="text" name="_email_heading" id="_email_heading" placeholder="<?php echo esc_attr( $email_field_atts[ 'placeholder' ][ 'heading' ] ); ?>" value="<?php echo esc_attr( $custom_template->get_email_heading() ); ?>"/>
			<span class="description"><?php echo wp_kses_post( $email_field_atts[ 'description' ][ 'heading' ] ); ?></span>
		</p>

		<p class="_email_content_field">
			<label for="_email_content"><?php esc_html_e( 'Email content', 'email-reminders-for-woocommerce-subscriptions' ); ?></label>
			<?php wp_editor( htmlspecialchars_decode( $custom_template->get_email_content(), ENT_QUOTES ), '_email_content', array( 'editor_height' => '200' ) ); ?>
		</p>
	</fieldset>
</div>
<?php
/**
 * After custom email reminder template general tab.
 * 
 * @since 1.8.0
 */
do_action( 'asp_erws_admin_after_custom_template_data_general', $custom_template );
