<?php

defined( 'ABSPATH' ) || exit;

/**
 * Admin product custom email reminder templates handler.
 * 
 * @class ASP_ERWS_Admin_List_Table_Product_Custom_Templates
 * @package Class
 */
class ASP_ERWS_Admin_List_Table_Product_Custom_Templates extends WC_Admin_List_Table {

	/**
	 * Post type.
	 *
	 * @var string
	 */
	protected $list_table_type = 'asp_erws_custom_tmpl';

	/**
	 * To not show blank slate.
	 *
	 * @param string $which String which tablenav is being shown.
	 */
	public function maybe_render_blank_state( $which ) {
		global $post_type;

		if ( $post_type === $this->list_table_type && 'bottom' === $which ) {
			$counts = ( array ) wp_count_posts( $post_type );
			unset( $counts[ 'auto-draft' ] );
			$count  = array_sum( $counts );

			if ( 0 < $count ) {
				return;
			}

			$this->render_blank_state();

			echo '<style type="text/css">#posts-filter .wp-list-table, #posts-filter .search-box, #posts-filter .tablenav.top, .tablenav.bottom .actions, .tablenav.bottom .tablenav-pages, .wrap .subsubsub:not(.asp-erws-sub-sections)  { display: none; } #posts-filter .tablenav.bottom { height: auto; } </style>';
		}
	}

	/**
	 * Render blank state.
	 */
	protected function render_blank_state() {
		$trial_ending            = get_option( 'erws_trial_ending_reminder_days' );
		$manual_renewal          = get_option( 'erws_manual_renewal_reminder_days' );
		$auto_renewal            = get_option( 'erws_auto_renewal_reminder_days' );
		$expire_before           = get_option( 'erws_expiration_reminder_days' );
		$expire_after            = get_option( 'erws_after_expiry_reminder_days' );
		$reminder_not_configured = empty( $trial_ending ) && empty( $manual_renewal ) && empty( $auto_renewal ) && empty( $expire_before ) && empty( $expire_after );

		echo '<div class="woocommerce-BlankState">';
		echo '<h2 class="woocommerce-BlankState-message">';
		echo '<span class="dashicons dashicons-bell"></span>';
		echo '<span class="message">' . esc_html__( 'Custom email reminder templates are a great way to create flexible subscription email reminder templates for your customers. They will appear here once created.', 'email-reminders-for-woocommerce-subscriptions' ) . '</span>';
		echo '</h2>';
		echo '<a class="woocommerce-BlankState-cta button-primary button ' . ( $reminder_not_configured ? 'asp-erws-not-clickable' : '' ) . '" href="' . esc_url( admin_url( 'post-new.php?post_type=asp_erws_custom_tmpl' ) ) . '">' . esc_html__( 'Create your first custom email reminder template', 'email-reminders-for-woocommerce-subscriptions' ) . '</a>';
		echo '</div>';
	}

	/**
	 * Define which columns to show on this screen.
	 *
	 * @param array $columns Existing columns.
	 * @return array
	 */
	public function define_columns( $columns ) {
		$columns = array(
			'cb'             => $columns[ 'cb' ],
			'name'           => __( 'Name', 'email-reminders-for-woocommerce-subscriptions' ),
			'status'         => __( 'Status', 'email-reminders-for-woocommerce-subscriptions' ),
			'reminder_email' => __( 'Reminder email', 'email-reminders-for-woocommerce-subscriptions' ),
			'send_email'     => __( 'Send email', 'email-reminders-for-woocommerce-subscriptions' ),
			'date'           => __( 'Date', 'email-reminders-for-woocommerce-subscriptions' ),
		);

		return $columns;
	}

	/**
	 * Define which columns are sortable.
	 *
	 * @param array $columns Existing columns.
	 * @return array
	 */
	public function define_sortable_columns( $columns ) {
		$custom = array(
			'name' => 'post_title',
		);

		return wp_parse_args( $custom, $columns );
	}

	/**
	 * Define bulk actions.
	 *
	 * @param array $actions Existing actions.
	 * @return array
	 */
	public function define_bulk_actions( $actions ) {
		unset( $actions[ 'edit' ] );
		return $actions;
	}

	/**
	 * Get row actions to show in the list table.
	 *
	 * @param array   $actions Array of actions.
	 * @param WP_Post $post Current post object.
	 * @return array
	 */
	public function get_row_actions( $actions, $post ) {
		unset( $actions[ 'inline hide-if-no-js' ] );
		return $actions;
	}

	/**
	 * Handle any custom filters.
	 *
	 * @param array $query_vars Query vars.
	 * @return array
	 */
	public function query_filters( $query_vars ) {
		//Sorting
		if ( empty( $query_vars[ 'orderby' ] ) ) {
			$query_vars[ 'orderby' ] = 'menu_order';
		}

		if ( empty( $query_vars[ 'order' ] ) ) {
			$query_vars[ 'order' ] = 'ASC';
		}

		return $query_vars;
	}

	/**
	 * Render individual columns.
	 *
	 * @param string $column Column ID to render.
	 * @param int    $post_id Post ID.
	 */
	public function render_columns( $column, $post_id ) {
		$custom_template = asp_erws_get_custom_template( $post_id );
		$emails          = WC()->mailer()->get_emails();

		switch ( $column ) {
			case 'name':
				printf( '<b><a href="%1$s">%2$s</a></b>', esc_url( $custom_template->get_edit_custom_template_url() ), wp_kses_post( $custom_template->get_name() ) );
				break;
			case 'status':
				/* translators: 1: status class 2: status name */
				echo wp_kses_post( sprintf( '<mark class="asp-erws-status %s"><span>%s</span></mark>', esc_attr( sanitize_html_class( 'status-' . $custom_template->get_status() ) ), esc_html( asp_erws_get_custom_template_status_name( $custom_template->get_status() ) ) ) );
				break;
			case 'slug':
				echo wp_kses_post( $custom_template->get_slug() );
				break;
			case 'reminder_email':
				$reminders            = ASP_ERWS()->get_reminders();
				echo isset( $reminders[ $custom_template->get_email_slug() ] ) ? wp_kses_post( $reminders[ $custom_template->get_email_slug() ] ) : '&ndash;';
				break;
			case 'send_email':
				$selected_email_class = ASP_ERWS()->get_email_class_from_reminder_slug( $custom_template->get_email_slug() );

				echo '<b>';
				echo wp_kses_post( $custom_template->get_email_sending_interval() );
				echo '</b>';

				if ( ! empty( $selected_email_class ) && ! empty( $emails[ $selected_email_class ] ) ) {
					$selected_reminder_email = $emails[ $selected_email_class ];

					if ( $selected_reminder_email->supports_custom_template() ) {
						echo '&nbsp;';
						echo wp_kses_post( $selected_reminder_email->get_custom_template_sending_interval_description() );
					}
				}
				break;
		}
	}
}

new ASP_ERWS_Admin_List_Table_Product_Custom_Templates();
