<?php
defined( 'ABSPATH' ) || exit;

/**
 * Get global variable.
 * 
 * @return mixed
 */
function asp_erws_get_global_var( $context = 'get' ) {
    switch ( $context ) {
        case 'request':
            return $_REQUEST;
        case 'post':
            return $_POST;
        case 'files':
            return $_FILES;
        case 'get':
            return $_GET;
    }

    return '';
}

/**
 * Includes the file.
 *
 * @param string $dir
 */
function asp_erws_may_include_file( $dir ) {
    if ( is_readable( $dir ) ) {
        require_once $dir;
    }
}

/**
 * Wrapper for print_r().
 * 
 * @return string
 */
function asp_erws_print_r( $value, $bool ) {
    return print_r( $value, $bool );
}

/**
 * Get WC admin search field.
 * 
 * @param array $args
 * @param bool $echo
 * @return string echo search field
 */
function asp_erws_admin_search_field( $args = array(), $echo = true ) {
    $args = wp_parse_args( $args, array(
        'class'             => '',
        'id'                => '',
        'name'              => '',
        'type'              => '',
        'action'            => '',
        'placeholder'       => '',
        'css'               => '',
        'multiple'          => true,
        'allow_clear'       => true,
        'selected'          => true,
        'limit'             => '-1',
        'include'           => array(),
        'exclude'           => array(),
        'options'           => array(),
        'custom_attributes' => array(),
            ) );

    // Custom attribute handling.
    $custom_attributes = array();
    if ( ! empty( $args[ 'custom_attributes' ] ) && is_array( $args[ 'custom_attributes' ] ) ) {
        foreach ( $args[ 'custom_attributes' ] as $attribute => $attribute_value ) {
            $custom_attributes[] = esc_attr( $attribute ) . '="' . esc_attr( $attribute_value ) . '"';
        }
    }

    ob_start();
    ?>
    <select 
        id="<?php echo esc_attr( $args[ 'id' ] ); ?>" 
        class="<?php echo esc_attr( $args[ 'class' ] ); ?>" 
        name="<?php echo esc_attr( '' !== $args[ 'name' ] ? $args[ 'name' ] : $args[ 'id' ]  ); ?><?php echo ( $args[ 'multiple' ] ) ? '[]' : ''; ?>" 
        data-action="<?php echo esc_attr( $args[ 'action' ] ); ?>" 
        data-placeholder="<?php echo esc_attr( $args[ 'placeholder' ] ); ?>" 
        data-limit="<?php echo esc_attr( $args[ 'limit' ] ); ?>" 
        data-include="<?php echo wc_esc_json( wp_json_encode( $args[ 'include' ] ) ); ?>" 
        data-exclude="<?php echo wc_esc_json( wp_json_encode( $args[ 'exclude' ] ) ); ?>" 
        <?php echo ( $args[ 'allow_clear' ] ) ? 'data-allow_clear="true"' : ''; ?> 
        <?php echo ( $args[ 'multiple' ] ) ? 'multiple="multiple"' : ''; ?> 
        <?php echo wp_kses_post( implode( ' ', $custom_attributes ) ); ?>
        style="<?php echo esc_attr( $args[ 'css' ] ); ?>">
            <?php
            if ( ! is_array( $args[ 'options' ] ) ) {
                $args[ 'options' ] = ( array ) $args[ 'options' ];
            }

            $args[ 'options' ] = array_filter( $args[ 'options' ] );
            foreach ( $args[ 'options' ] as $id ) {
                $option_value = '';

                switch ( $args[ 'type' ] ) {
                    case 'product':
                        $product = wc_get_product( $id );
                        if ( $product ) {
                            $option_value = wp_kses_post( $product->get_formatted_name() );
                        }
                        break;
                    case 'customer':
                        $user = get_user_by( 'id', $id );
                        if ( $user ) {
                            $option_value = ( esc_html( $user->display_name ) . '(#' . absint( $user->ID ) . ' &ndash; ' . esc_html( $user->user_email ) . ')' );
                        }
                        break;
                    default:
                        $post = get_post( $id );
                        if ( $post ) {
                            $option_value = sprintf( '(#%s) %s', $post->ID, wp_kses_post( $post->post_title ) );
                        }
                        break;
                }

                if ( $option_value ) {
                    ?>
                <option value="<?php echo esc_attr( $id ); ?>" <?php echo ( $args[ 'selected' ] ) ? 'selected="selected"' : ''; ?>><?php echo wp_kses_post( $option_value ); ?></option>
                <?php
            }
        }
        ?>
    </select>
    <?php
    if ( $echo ) {
        ob_end_flush();
    } else {
        return ob_get_clean();
    }
}
