<?php

defined( 'ABSPATH' ) || exit;

/**
 * Custom Email Reminder Template Shortcodes.
 * 
 * @class ASP_ERWS_Meta_Box_Custom_Template_Shortcodes
 * @package Class
 */
class ASP_ERWS_Meta_Box_Custom_Template_Shortcodes {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post $post Post object.
	 */
	public static function output( $post ) {
		global $post, $the_custom_template;

		if ( ! is_object( $the_custom_template ) ) {
			$the_custom_template = new ASP_ERWS_Custom_Template( $post->ID );
		}

		$custom_template  = $the_custom_template;
		$email_shortcodes = array();

		echo '<span class="asp-erws-custom-template-shortcodes">';
		include 'views/html-custom-template-shortcodes.php';
		echo '</span>';
	}
}
