<?php

defined( 'ABSPATH' ) || exit;

/**
 * Custom Email Reminder Template Data.
 * 
 * @class ASP_ERWS_Meta_Box_Custom_Template_Data
 * @package Class
 */
class ASP_ERWS_Meta_Box_Custom_Template_Data {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post $post
	 */
	public static function output( $post ) {
		global $post, $the_custom_template;

		if ( ! is_object( $the_custom_template ) ) {
			$the_custom_template = new ASP_ERWS_Custom_Template( $post->ID );
		}

		$custom_template      = $the_custom_template;
		$custom_template_post = $post;

		wp_nonce_field( 'asp_erws_save_data', 'asp_erws_save_meta_nonce' );

		include 'views/html-custom-template-data-panel.php';
	}

	/**
	 * Show tab content/settings.
	 */
	private static function output_tabs() {
		global $post, $the_custom_template;

		$custom_template  = $the_custom_template;
		$email_field_atts = array();

		echo '<span class="asp-erws-general-custom-template-data">';
		if ( ! empty( $email_field_atts ) ) {
			include 'views/html-custom-template-data-general.php';
		}
		echo '</span>';

		echo '<span class="asp-erws-criteria-custom-template-data">';
		include 'views/html-custom-template-data-criteria.php';
		echo '</span>';
	}

	/**
	 * Return array of tabs to show.
	 *
	 * @return array
	 */
	private static function get_custom_template_data_tabs() {
		/**
		 * Get admin custom email reminder template data tabs.
		 * 
		 * @since 1.8.0
		 */
		$tabs = apply_filters( 'asp_erws_admin_custom_template_data_tabs', array(
			'general'  => array(
				'label'  => __( 'General', 'email-reminders-for-woocommerce-subscriptions' ),
				'target' => 'general_custom_template_data',
			),
			'criteria' => array(
				'label'  => __( 'Criteria', 'email-reminders-for-woocommerce-subscriptions' ),
				'target' => 'criteria_custom_template_data',
			),
				) );

		return $tabs;
	}
}
