/* global asp_erws_admin_params, ajaxurl */

jQuery( function( $ ) {
    'use strict';

    // Add buttons to custom email reminder template screen.
    var $custom_templates_screen = $( 'body.edit-php.post-type-asp_erws_custom_tmpl' ),
            $edit_custom_template_screen = $( 'body.post-new-php.post-type-asp_erws_custom_tmpl,body.post-php.post-type-asp_erws_custom_tmpl' ),
            $custom_templates_screen_title = $custom_templates_screen.find( '.wp-header-end' ),
            $edit_custom_template_screen_title = $edit_custom_template_screen.find( '.wp-header-end' );

    if ( $custom_templates_screen_title.length > 0 ) {
        $custom_templates_screen_title.before( '&nbsp;<a class="page-title-action" href="' + asp_erws_admin_params.back_to_settings_url + '">' + asp_erws_admin_params.i18n_back_to_settings_label + '</a>' );
    }

    if ( $edit_custom_template_screen_title.length > 0 ) {
        $edit_custom_template_screen_title.before( '<a class="page-title-action" href="' + asp_erws_admin_params.back_to_all_custom_templates_url + '">' + asp_erws_admin_params.i18n_back_to_all_label + '</a>' );
        $edit_custom_template_screen_title.before( '&nbsp;&nbsp;<a class="page-title-action" href="' + asp_erws_admin_params.back_to_settings_url + '">' + asp_erws_admin_params.i18n_back_to_settings_label + '</a>' );
    }

    var is_blocked = function( $node ) {
        return $node.is( '.processing' ) || $node.parents( '.processing' ).length;
    };

    /**
     * Block a node visually for processing.
     *
     * @param {JQuery Object} $node
     */
    var block = function( $node ) {
        $.blockUI.defaults.overlayCSS.cursor = 'wait';

        if ( ! is_blocked( $node ) ) {
            $node.addClass( 'processing' ).block( {
                message : null,
                overlayCSS : {
                    background : '#fff',
                    opacity : 0.6
                }
            } );
        }
    };

    /**
     * Unblock a node after processing is complete.
     *
     * @param {JQuery Object} $node
     */
    var unblock = function( $node ) {
        $node.removeClass( 'processing' ).unblock();
    };

    // Type box.
    if ( $( 'body' ).hasClass( 'wc-wp-version-gte-55' ) ) {
        $( '.custom-template-data-hidden-box' ).appendTo( '#asp_erws_custom_template_data .hndle' );
    } else {
        $( '.custom-template-data-hidden-box' ).appendTo( '#asp_erws_custom_template_data .hndle span' );
    }

    $( function() {
        // Prevent inputs in meta box headings opening/closing contents.
        $( '#asp_erws_custom_template_data' ).find( '.hndle' ).unbind( 'click.postboxes' );
        $( '#asp_erws_custom_template_data' ).on( 'click', '.hndle', function( event ) {

            // If the user clicks on some form input inside the h3 the box should not be toggled.
            if ( $( event.target ).filter( 'input, option, label, select' ).length ) {
                return;
            }

            $( '#asp_erws_custom_template_data' ).toggleClass( 'closed' );
        } );
    } );

    $( 'a.asp-erws-not-clickable' ).click( function( e ) {
        e.preventDefault();
        window.alert( asp_erws_admin_params.i18n_custom_template_creation_warning );
        return false;
    } );

    var metaboxes_custom_template_data = {
        $wrapper : $( '#asp_erws_custom_template_data' ),
        $testWrapper : $( '#asp_erws_custom_template_test_email' ),
        init : function() {
            if ( 0 === this.$wrapper.length ) {
                return false;
            }

            this.$wrapper.on( 'click', '.asp_erws_custom_template_data_tabs li.active', this.activeTab );
            this.$wrapper.on( 'change', 'select[name="_email_slug"]', this.emailSlugChanged );
            this.$wrapper.find( '.asp_erws_custom_template_data_tabs li.active' ).click();
            this.$wrapper.find( 'select[name="_email_slug"]' ).change();

            this.$testWrapper.on( 'click', 'button[name="_send_email"]', this.sendEmail );
        },
        activeTab : function( e ) {
            e.preventDefault();

            if ( $( e.currentTarget ).is( '.general_tab' ) ) {
                metaboxes_custom_template_data.general.init();
            } else if ( $( e.currentTarget ).is( '.criteria_tab' ) ) {
                metaboxes_custom_template_data.criteria.init();
            }
        },
        emailSlugChanged : function( e ) {
            e.preventDefault();

            block( $( '#post' ) );
            $.ajax( {
                type : 'POST',
                url : asp_erws_admin_params.ajax_url,
                dataType : 'json',
                data : {
                    action : 'asp_erws_custom_template_email_data',
                    security : asp_erws_admin_params.custom_template_email_data_nonce,
                    template_id : asp_erws_admin_params.post_id,
                    email_slug : $( this ).val()
                },
                success : function( response ) {
                    if ( response.success ) {
                        $( '#asp_erws_custom_template_data' ).find( '.asp-erws-general-custom-template-data' ).empty().append( response.data.general_section_html );
                        $( '#asp_erws_custom_template_data' ).find( '.asp-erws-criteria-custom-template-data' ).empty().append( response.data.criteria_section_html );
                        $( '#asp_erws_custom_template_shortcodes' ).find( '.asp-erws-custom-template-shortcodes' ).empty().append( response.data.shortcodes_section_html );

                        $( document.body ).trigger( 'wc-enhanced-select-init' );
                        $( 'ul.wc-tabs li:visible' ).eq( 0 ).find( 'a' ).trigger( 'click' );
                    }
                },
                complete : function() {
                    unblock( $( '#post' ) );
                }
            } );
            return false;
        },
        sendEmail : function( e ) {
            e.preventDefault();

            block( $( '#asp_erws_custom_template_test_email' ) );
            $.ajax( {
                type : 'POST',
                url : asp_erws_admin_params.ajax_url,
                dataType : 'json',
                data : {
                    action : 'asp_erws_test_custom_template_email',
                    security : asp_erws_admin_params.custom_template_email_test_nonce,
                    template_id : asp_erws_admin_params.post_id,
                    email_recipients : $( '#asp_erws_custom_template_test_email' ).find( 'input[name="_recipients"]' ).val(),
                    email_sending_interval : $( '#asp_erws_custom_template_data' ).find( 'input[name="_email_sending_interval"]' ).val(),
                    email_slug : $( '#asp_erws_custom_template_data' ).find( 'select[name="_email_slug"]' ).val(),
                    subscription_id : $( '#asp_erws_custom_template_test_email' ).find( 'select[name="_subscription_id"]' ).val()
                },
                success : function( response ) {
                    if ( response.success ) {
                        window.alert( response.data.message );
                    } else {
                        window.alert( response.data.error );
                    }
                },
                complete : function() {
                    unblock( $( '#asp_erws_custom_template_test_email' ) );
                }
            } );
            return false;
        },
        general : {
            init : function() {

            }
        },
        criteria : {
            init : function() {
                metaboxes_custom_template_data.$wrapper
                        .on( 'change', '#_criteria_product_filter', this.productFilterChanged )
                        .on( 'change', '#_criteria_user_filter', this.userFilterChanged )

                        .find( '#_criteria_product_filter,#_criteria_user_filter' ).change();
            },
            productFilterChanged : function( e ) {
                e.preventDefault();

                $( e.currentTarget ).closest( 'div' ).find( '._criteria_products_field,._criteria_product_cats_field' ).hide();

                if ( 'included-products' === $( e.currentTarget ).val() ) {
                    $( e.currentTarget ).closest( 'div' ).find( '._criteria_products_field' ).show();
                } else if ( 'included-product-cats' === $( e.currentTarget ).val() ) {
                    $( e.currentTarget ).closest( 'div' ).find( '._criteria_product_cats_field' ).show();
                }
            },
            userFilterChanged : function( e ) {
                e.preventDefault();

                $( e.currentTarget ).closest( 'div' ).find( '._criteria_users_field,._criteria_user_roles_field' ).hide();

                if ( 'included-users' === $( e.currentTarget ).val() ) {
                    $( e.currentTarget ).closest( 'div' ).find( '._criteria_users_field' ).show();
                } else if ( 'included-user-roles' === $( e.currentTarget ).val() ) {
                    $( e.currentTarget ).closest( 'div' ).find( '._criteria_user_roles_field' ).show();
                }
            }
        }
    };

    metaboxes_custom_template_data.init();

    $( document ).on( 'click', '#asp_erws_existing_subscriptions_scheduler', function( e ) {
        e.preventDefault();

        var $this = $( this ),
                intervalsConfigured = false;

        if ( $this.is( '.asp-erws-is-busy' ) ) {
            return false;
        }

        $.each( $this.closest( 'table' ).find( ':input[name]' ), function( i ) {
            if ( $.isNumeric( this.value ) && this.value > 0 ) {
                intervalsConfigured = true;
            }
        } );

        if ( ! intervalsConfigured ) {
            $this.removeClass( 'is-busy' );
            window.alert( asp_erws_admin_params.i18n_scheduled_error );
            return false;
        }

        if ( window.confirm( asp_erws_admin_params.i18n_prompt_schedule_now ) ) {
            $this.addClass( 'asp-erws-is-busy' );
            $.ajax( {
                type : 'POST',
                url : asp_erws_admin_params.ajax_url,
                data : {
                    action : 'asp_erws_init_existing_subscriptions_scheduler',
                    security : asp_erws_admin_params.existing_subscriptions_scheduler_nonce,
                    intervals : $this.closest( 'table' ).find( ':input[name]' ).serialize()
                },
                complete : function() {
                    setTimeout( function() {
                        window.alert( asp_erws_admin_params.i18n_scheduled_success );
                        $this.removeClass( 'asp-erws-is-busy' );
                        $this.removeClass( 'is-busy' );
                    }, 5000 );
                },
                dataType : 'json'
            } );
        } else {
            $this.removeClass( 'is-busy' );
        }

        return false;
    } );
} );
