<?php
/**
 * License log.
 *
 * @package   EDD\SoftwareLicensing\Licenses
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Licenses;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Database\Row;

/**
 * Class LicenseLog
 *
 * @since 3.9.0
 * @package EDD\Licenses
 *
 * @todo extend EDD\Database\Row
 */
class LogLicense extends Row {

	/**
	 * The license log ID.
	 *
	 * @since 3.9.0
	 * @var int
	 */
	protected $id;

	/**
	 * The license log license ID.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $license_id;

	/**
	 * The license log subject.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $subject;

	/**
	 * The license log date created.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $date_created;

	/**
	 * The license log date modified.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $date_modified;

	/**
	 * The license log UUID.
	 *
	 * @since 3.9.0
	 * @var string
	 */
	protected $uuid;
}
