<?php
/**
 * Activation
 *
 * This class is for working with license activations in EDD Software Licensing.
 *
 * @package   EDD\SoftwareLicensing\Licenses
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Licenses;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Database\Row;

/**
 * Class Activation
 *
 * @since 3.9.0
 * @package EDD\SoftwareLicensing\Licenses
 */
class Activation extends Row {

	/**
	 * Magic GET function.
	 *
	 * @since 3.9.0
	 * @param string $key The property.
	 * @return mixed The value.
	 */
	public function __get( $key = '' ) {

		if ( 'site_id' === $key ) {
			$key = 'id';
		}

		return parent::__get( $key );
	}
}
