<?php
/**
 * LowKeys email.
 *
 * @package EDD
 * @subpackage Emails
 * @since 3.9.0
 */

namespace EDD\SoftwareLicensing\Emails\Types;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\Emails\Types\Email;

/**
 * Class LowKeys
 *
 * @since 3.9.0
 * @package EDD
 * @subpackage Emails
 */
class LowKeys extends Email {

	/**
	 * The email ID.
	 *
	 * @var string
	 * @since 3.9.0
	 */
	protected $id = 'sl_low_keys';

	/**
	 * The email context.
	 *
	 * @var string
	 * @since 3.9.0
	 */
	protected $context = 'download';

	/**
	 * The email recipient type.
	 *
	 * @var string
	 * @since 3.9.0
	 */
	protected $recipient_type = 'admin';

	/**
	 * The download object.
	 *
	 * @var \EDD_SL_Download
	 * @since 3.9.0
	 */
	private $download;

	/**
	 * LowKeys constructor.
	 *
	 * @since 3.9.0
	 *
	 * @param int $download_id The download ID.
	 */
	public function __construct( $download_id ) {
		$this->download = new \EDD_SL_Download( $download_id );
	}

	protected function set_to_email() {
		$this->send_to = $this->get_email()->get_admin_recipient_emails();
	}

	/**
	 * Set the email message.
	 *
	 * @since 3.9.0
	 * @return void
	 */
	protected function set_message() {
		parent::set_message();

		$this->message = $this->process_tags( $this->message, $this->download->ID, $this->download );
	}
}
