<?php
/**
 * Deprecated Retroactive processing trait to hold methods that are no longer used.
 *
 * @package EDD\SoftwareLicensing\Deprecated\Retroactive
 * @copyright Copyright (c) 2025, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.9.0
*/

namespace EDD\SoftwareLicensing\Deprecated;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Retroactive trait.
 *
 * @since 3.9.0
*/
trait Retroactive {

	/**
	 * Retrieve all downloads that have licensing enabled.
	 *
	 * @since 2.4
	 * @deprecated 3.9.0
	 * @return array
	*/
	public static function get_licensed_products() {
		$args = array(
			'post_type' => 'download',
			'nopaging'  => true,
			'fields'    => 'ids',
			'meta_key'  => '_edd_sl_enabled',
			'value'     => '1',
		);

		return get_posts( $args );
	}

	/**
	 * Display the license generation status
	 *
	 * @since 2.4
	 * @deprecated 3.9.0
	 * @return void
	*/
	public function show_status( $count, $posts, $download_id ) {}

	/**
	 * Load necessary scripts
	 *
	 * @since 2.4
	 * @deprecated 3.9.0
	*/
	public static function scripts( $hook ) {}

	/**
	 * Get all payments that are missing license keys
	 *
	 * @since 2.4
	 * @deprecated 3.9.0
	 * @return array
	*/
	public static function get_unlicensed_payments() {
		return array();
	}

	/**
	 * Process an ajax post to generate keys for a license.
	 *
	 * @since 2.4
	 * @deprecated 3.9.0
	 * @return void
	*/
	public function edd_sl_process_retroactive_post() {}

	/**
	 * Generate the license keys for a payment during an ajax post
	 *
	 * @param int $payment_id         The payment/order ID.
	 * @param int $download_id        The download ID.
	 * @param boolean|object $payment The payment object, if it is known.
	 *
	 * @since 2.4
	 * @deprecated 3.9.0
	 * @return mixed
	*/
	public static function generate_license_keys( $payment_id, $download_id, $payment = false ) {
		return 0;
	}

	/**
	 * Retrieve payment details screen URL
	 *
	 * @since       2.4
	 * @deprecated 3.9.0
	 * @return      string
	*/
	public static function get_order_url( $payment_id ) {
		$link_base = admin_url( 'edit.php?post_type=download&page=edd-payment-history&view=view-order-details' );

		return esc_url( add_query_arg( 'id', $payment_id, $link_base ) );
	}
}
