<?php
/**
 * License Logs Table.
 *
 * @package     EDD
 * @subpackage  Database\Tables
 * @copyright   Copyright (c) 2023, Easy Digital Downloads, LLC
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.9.0
 */

namespace EDD\SoftwareLicensing\Database\Tables;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Database\Table;

/**
 * Setup the global "edd_logs" database table
 *
 * @since 3.9.0
 */
final class LogsLicenses extends Table {

	/**
	 * Table name.
	 *
	 * @access protected
	 * @since 3.9.0
	 * @var string
	 */
	protected $name = 'logs_licenses';

	/**
	 * Database version.
	 *
	 * @access protected
	 * @since 3.9.0
	 * @var int
	 */
	protected $version = 202402130;

	/**
	 * Array of upgrade versions and methods
	 *
	 * @since 3.9.0
	 *
	 * @var array
	 */
	protected $upgrades = array();

	/**
	 * Setup the database schema.
	 *
	 * @access protected
	 * @since 3.9.0
	 * @return void
	 */
	protected function set_schema() {
		$this->schema = "
			id bigint(20) unsigned NOT NULL auto_increment,
			license_id bigint(20) unsigned NOT NULL default '0',
			subject varchar(200) NOT NULL,
			content longtext default '',
			date_created datetime NOT NULL default CURRENT_TIMESTAMP,
			date_modified datetime NOT NULL default CURRENT_TIMESTAMP,
			uuid varchar(100) NOT NULL default '',
			PRIMARY KEY (id),
			KEY license_id (license_id),
			KEY date_created (date_created)
		";
	}
}
