<?php
/**
 * License Meta Table.
 *
 * @package     EDD\SoftwareLicensing\Database\Tables
 * @copyright   Copyright (c) 2024, Easy Digital Downloads, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.9.0
 */

namespace EDD\SoftwareLicensing\Database\Tables;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Database\Table;

/**
 * Setup the global "edd_licensemeta" database table
 *
 * @since 3.9.0
 */
final class LicenseActivationsData extends Table {

	/**
	 * Table name
	 *
	 * @access protected
	 * @since 3.9.0
	 * @var string
	 */
	protected $name = 'license_activations_data';

	/**
	 * Database version
	 *
	 * @access protected
	 * @since 3.9.0
	 * @var int
	 */
	protected $version = 202409240;

	/**
	 * Array of upgrade versions and methods
	 *
	 * @since 3.9.0
	 *
	 * @var array
	 */
	protected $upgrades = array();

	/**
	 * Setup the database schema
	 *
	 * @access protected
	 * @since 3.9.0
	 * @return void
	 */
	protected function set_schema() {
		$this->schema = '
			id bigint(20) NOT NULL AUTO_INCREMENT,
			activation_id bigint(20) NOT NULL,
			product_id bigint(20) NOT NULL,
			product_version varchar(50) DEFAULT NULL,
			date_created datetime NOT NULL,
			date_modified datetime NOT NULL,
			PRIMARY KEY (id),
			KEY activation_id (activation_id),
			KEY activation_id_product_id (activation_id, product_id)
		';
	}
}
