<?php

namespace EDD\SoftwareLicensing\Database\Schemas;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Database\Schema;

/**
 * Class LogsLicenses
 *
 * @since 3.9.0
 * @package EDD\Database\Schemas
 */
class LogsLicenses extends Schema {

	/**
	 * The database columns.
	 *
	 * @since 3.9.0
	 * @var array
	 */
	public $columns = array(

		// id.
		array(
			'name'     => 'id',
			'type'     => 'bigint',
			'length'   => 20,
			'unsigned' => true,
			'extra'    => 'auto_increment',
			'primary'  => true,
			'sortable' => true,
		),

		// license_id.
		array(
			'name'       => 'license_id',
			'type'       => 'bigint',
			'length'     => 20,
			'unsigned'   => true,
			'sortable'   => true,
			'allow_null' => false,
		),

		// subject.
		array(
			'name'       => 'subject',
			'type'       => 'varchar',
			'length'     => 200,
			'default'    => '',
			'sortable'   => true,
			'searchable' => true,
			'allow_null' => false,
		),

		// content.
		array(
			'name'       => 'content',
			'type'       => 'longtext',
			'default'    => '',
			'searchable' => true,
		),

		// date_created.
		array(
			'name'       => 'date_created',
			'type'       => 'datetime',
			'default'    => '',
			'created'    => true,
			'date_query' => true,
			'sortable'   => true,
		),

		// date_modified.
		array(
			'name'       => 'date_modified',
			'type'       => 'datetime',
			'default'    => '',
			'modified'   => true,
			'date_query' => true,
			'sortable'   => true,
		),

		// uuid.
		array(
			'uuid' => true,
		),
	);
}
