<?php

namespace EDD\SoftwareLicensing\Database\Schemas;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Database\Schema;

/**
 * Class Licenses
 *
 * @since 3.9.0
 * @package EDD\Database\Schemas
 */
class Licenses extends Schema {

	/**
	 * The database columns.
	 *
	 * @since 3.9.0
	 * @var array
	 */
	public $columns = array(
		array(
			'name'     => 'id',
			'type'     => 'bigint',
			'length'   => 20,
			'unsigned' => true,
			'extra'    => 'auto_increment',
			'primary'  => true,
			'sortable' => true,
		),
		array(
			'name'     => 'license_key',
			'type'     => 'varchar',
			'length'   => 255,
			'unsigned' => true,
			'sortable' => true,
			'default'  => null,
		),
		array(
			'name'       => 'status',
			'type'       => 'varchar',
			'length'     => 20,
			'default'    => 'inactive',
			'sortable'   => true,
			'searchable' => true,
			'allow_null' => false,
		),
		array(
			'name'       => 'download_id',
			'type'       => 'bigint',
			'length'     => 20,
			'searchable' => true,
			'allow_null' => false,
		),
		array(
			'name'       => 'price_id',
			'type'       => 'bigint',
			'length'     => 20,
			'allow_null' => true,
			'default'    => null,
		),
		array(
			'name'    => 'payment_id',
			'type'    => 'bigint',
			'length'  => 20,
			'default' => null,
		),
		array(
			'name'       => 'cart_index',
			'type'       => 'bigint',
			'length'     => 20,
			'default'    => 0,
			'allow_null' => false,
		),
		array(
			'name'       => 'date_created',
			'type'       => 'datetime',
			'default'    => '',
			'created'    => true,
			'date_query' => true,
			'sortable'   => true,
			'allow_null' => false,
		),
		array(
			'name'    => 'expiration',
			'type'    => 'bigint',
			'length'  => 32,
			'default' => null,
		),
		array(
			'name'       => 'parent',
			'type'       => 'bigint',
			'length'     => 20,
			'unsigned'   => true,
			'allow_null' => false,
			'default'    => 0,
		),
		array(
			'name'     => 'customer_id',
			'type'     => 'bigint',
			'length'   => 20,
			'unsigned' => true,
			'default'  => null,
		),
		array(
			'name'     => 'user_id',
			'type'     => 'bigint',
			'length'   => 20,
			'unsigned' => true,
			'default'  => null,
		),
	);
}
