<?php
/**
 * License Activations database schema.
 *
 * @package   EDD\SoftwareLicensing\Database\Schemas
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Database\Schemas;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Database\Schema;

/**
 * Class LicenseActivations
 *
 * @since 3.9.0
 * @package EDD\Database\Schemas
 */
class LicenseActivationsData extends Schema {

	/**
	 * The database columns.
	 *
	 * @since 3.9.0
	 * @var array
	 */
	public $columns = array(
		array(
			'name'     => 'id',
			'type'     => 'bigint',
			'length'   => 20,
			'unsigned' => true,
			'extra'    => 'auto_increment',
			'primary'  => true,
			'sortable' => true,
		),
		array(
			'name'       => 'activation_id',
			'type'       => 'bigint',
			'length'     => 20,
			'allow_null' => false,
		),
		array(
			'name'       => 'product_id',
			'type'       => 'bigint',
			'length'     => 20,
			'allow_null' => false,
		),
		array(
			'name'    => 'product_version',
			'type'    => 'varchar',
			'length'  => 50,
			'default' => null,
		),
		array(
			'name'       => 'date_created',
			'type'       => 'datetime',
			'default'    => '',
			'created'    => true,
			'date_query' => true,
			'sortable'   => true,
		),
		array(
			'name'       => 'date_modified',
			'type'       => 'datetime',
			'default'    => '',
			'modified'   => true,
			'date_query' => true,
			'sortable'   => true,
		),
	);
}
