<?php
/**
 * Activation Query Class.
 *
 * @package   EDD\SoftwareLicensing\Database\Queries
 * @copyright Copyright (c) 2024, Easy Digital Downloads, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Database\Queries;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\Database\Query;

/**
 * Class used for querying items.
 *
 * @since 3.9.0
 *
 * @see \EDD\Database\Queries\Query::__construct() for accepted arguments.
 */
class LicenseActivationsData extends Query {

	/** Table Properties ******************************************************/

	/**
	 * Name of the database table to query.
	 *
	 * @since 3.9.0
	 * @access public
	 * @var string
	 */
	protected $table_name = 'license_activations_data';

	/**
	 * String used to alias the database table in MySQL statement.
	 *
	 * @since 3.9.0
	 * @access public
	 * @var string
	 */
	protected $table_alias = 'lad';

	/**
	 * Name of class used to setup the database schema
	 *
	 * @since 3.9.0
	 * @access public
	 * @var string
	 */
	protected $table_schema = '\\EDD\\SoftwareLicensing\\Database\\Schemas\\LicenseActivationsData';

	/** Item ******************************************************************/

	/**
	 * Name for a single item
	 *
	 * @since 3.9.0
	 * @access public
	 * @var string
	 */
	protected $item_name = 'license_activation_data';

	/**
	 * Plural version for a group of items.
	 *
	 * @since 3.9.0
	 * @access public
	 * @var string
	 */
	protected $item_name_plural = 'license_activations_data';

	/** Cache *****************************************************************/

	/**
	 * Group to cache queries and queried items in.
	 *
	 * @since 3.9.0
	 * @access public
	 * @var string
	 */
	protected $cache_group = 'license-activation-data';
}
