<?php
/**
 * Loader class.
 *
 * @package     EDD\SoftwareLicensing\Cron
 * @copyright   Copyright (c) 2025, Sandhills Development, LLC
 * @license     https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       3.9.0
 */

namespace EDD\SoftwareLicensing\Cron;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\SubscriberInterface;

/**
 * Loader class.
 *
 * @since 3.9.0
 */
class Loader implements SubscriberInterface {

	/**
	 * Register the hooks.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	public static function get_subscribed_events(): array {
		return array(
			'edd_cron_events'     => 'register_events',
			'edd_cron_components' => 'register_components',
		);
	}

	/**
	 * Register the events.
	 *
	 * @since 3.9.0
	 * @param array $events The events to register.
	 * @return array
	 */
	public function register_events( $events ): array {
		$events[] = new Events\Daily();

		return $events;
	}

	/**
	 * Load any components registered that have cron events.
	 *
	 * @since 3.9.0
	 * @param array $components The components to register.
	 * @return array
	 */
	public function register_components( $components ): array {
		return array_merge( $components, $this->get_registered_components() );
	}

	/**
	 * Get the registered components.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	private function get_registered_components() {
		return array(
			Components\Reminders::class,
			Components\Expire::class,
		);
	}
}
