<?php
/**
 * Software Licensing Core class.
 *
 * @package   EDD\SoftwareLicensing
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

use EDD\EventManagement\Subscribers;

/**
 * Core class.
 */
class Core extends Subscribers {

	/**
	 * Get the service providers.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	protected function get_service_providers() {
		return array(
			new Components\Loader(),
			new Checkout\Cart(),
			new RemoteRequests\Loader(),
			new Downloads\Package(),
			new Cron\Loader(),
		);
	}

	/**
	 * Get the admin providers.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	protected function get_admin_providers() {
		return array(
			new Admin\Downloads\Meta(),
			new Admin\Downloads\Metabox(),
			new Admin\Orders\Refunds(),
			new Admin\Licensing\Retroactive(),
			new Admin\Reports\Loader(),
			new Admin\Notices(),
		);
	}
}
