<?php
/**
 * Loader class.
 *
 * @package   EDD\SoftwareLicensing\Components
 * @copyright Copyright (c) 2024, Sandhills Development, LLC
 * @license   https://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Components;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

use EDD\EventManagement\SubscriberInterface;

/**
 * Loader class.
 *
 * @since 3.9.0
 */
class Loader implements SubscriberInterface {

	/**
	 * Get the subscribed events.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	public static function get_subscribed_events() {
		return array(
			'edd_setup_components' => 'setup_components',
		);
	}

	/**
	 * Set up components with Berlin.
	 *
	 * @since 3.9.0
	 */
	public function setup_components() {
		$components = array(
			Licenses::class,
			LicenseLogs::class,
			LicenseActivations::class,
			LicenseActivationsData::class,
		);

		foreach ( $components as $component ) {
			$component::setup_components();
		}
	}
}
