<?php
/**
 * License  Component
 *
 * @package EDD\SoftwareLicensing\Components\Licenses
 * @since 3.9.0
 */

namespace EDD\SoftwareLicensing\Components;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

class Licenses {

	/**
	 * Register the license component.
	 *
	 * @since 3.9.0
	 * @return void
	 */
	public static function setup_components() {
		edd_register_component(
			'license',
			array(
				'schema' => '\\EDD\\SoftwareLicensing\\Database\\Schemas\\Licenses',
				'table'  => '\\EDD\\SoftwareLicensing\\Database\\Tables\\Licenses',
				'query'  => '\\EDD\\SoftwareLicensing\\Database\\Queries\\License',
				'object' => '\\EDD\\SoftwareLicensing\\Licenses\\License',
				'meta'   => '\\EDD\\SoftwareLicensing\\Database\\Tables\\LicenseMeta',
			)
		);
	}
}
