<?php
/**
 * Settings class.
 *
 * @package   EDD-Software-Licensing
 * @since     3.9.0
 */

namespace EDD\SoftwareLicensing\Admin;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit; // @codeCoverageIgnore

/**
 * Settings class.
 *
 * @since 3.9.0
 */
class Settings {

	/**
	 * Get the settings.
	 *
	 * @since 3.9.0
	 * @return array
	 */
	public static function get() {
		return array(
			array(
				'id'            => 'edd_sl_force_increase',
				'name'          => __( 'Disable Unique Activations', 'edd_sl' ),
				'check'         => __( 'Do not require a unique identifier when activating a license key.', 'edd_sl' ),
				'type'          => 'checkbox_toggle',
				'tooltip_title' => __( 'What are Unique Activations?', 'edd_sl' ),
				'tooltip_desc'  => __( 'Software Licensing will typically require the software to pass a URL along with a license to check the license limit. Note that if you sell desktop software, you could use the URL parameter to track the ID of the computer running the license by passing the computer\'s ID in the URL parameter. For more on this, please see the documentation. Checking this will always increase or decrease the activation count when an API request to activate or deactivate the license has been made.', 'edd_sl' ),
			),
			array(
				'id'            => 'edd_sl_bypass_local_hosts',
				'name'          => __( 'Ignore Local Host URLs?', 'edd_sl' ),
				'check'         => __( 'Allow local development domains and IPs to be activated without counting towards the activation limit totals. The URL will still be logged.', 'edd_sl' ),
				'type'          => 'checkbox_toggle',
				'tooltip_title' => __( 'What is a Local Host?', 'edd_sl' ),
				'tooltip_desc'  => __( 'People who are in the developmental stages of their website will often build it offline using their own computer. This is called a Local Host. ', 'edd_sl' ),
			),
			array(
				'id'            => 'edd_sl_readme_parsing',
				'name'          => __( 'Selling WordPress Plugins?', 'edd_sl' ),
				'check'         => __( 'Enable advanced readme.txt file parsing for selling WordPress plugins.', 'edd_sl' ),
				'type'          => 'checkbox_toggle',
				'tooltip_title' => __( 'What is readme.txt?', 'edd_sl' ),
				'tooltip_desc'  => __( 'Properly built WordPress plugins will include a readme.txt file which includes things like the version, license, author, description, and more. Checking this will add a metabox to each download which allows for plugin data to be auto filled based on the included ReadMe.txt file in your plugin. Note that this is optional even if you are selling WordPress plugins.', 'edd_sl' ),
			),
			array(
				'id'            => 'edd_sl_inline_upgrade_links',
				'name'          => __( 'Display Inline Upgrade Links', 'edd_sl' ),
				'check'         => __( 'Display inline upgrade links for customers who have upgradable purchases.', 'edd_sl' ),
				'type'          => 'checkbox_toggle',
				'tooltip_title' => __( 'Where are upgrade links displayed?', 'edd_sl' ),
				'tooltip_desc'  => __( 'Inline upgrade links are displayed below the \'Add To Cart\' button in products lists and on on individual product pages.', 'edd_sl' ),
			),
			array(
				'id'            => 'edd_sl_proration_method',
				'name'          => __( 'Proration Method', 'edd_sl' ),
				'desc'          => __( 'Specify how to calculate proration for license upgrade.', 'edd_sl' ),
				'type'          => 'select',
				'options'       => array(
					'cost-based' => __( 'Cost-Based Calculation', 'edd_sl' ),
					'time-based' => __( 'Time-Based Calculation', 'edd_sl' ),
				),
				'tooltip_title' => __( 'How are prorations calculated?', 'edd_sl' ),
				'tooltip_desc'  => __( 'Cost-based calculation is a type of pseudo-proration where the value of an upgrade is calculated based on the cost difference between the current and new licenses.<br /><br />Time-based calculation is true proration in which the amount of time remaining on the current license is calculated to adjust the cost of the new license.', 'edd_sl' ),
				'std'           => 'cost-based',
			),
			array(
				'id'            => 'edd_sl_renewals',
				'name'          => __( 'Allow Renewals', 'edd_sl' ),
				'check'         => __( 'Allow customers to renew their license keys.', 'edd_sl' ),
				'type'          => 'checkbox_toggle',
				'tooltip_title' => __( 'What does \'Allow Renewals\' do?', 'edd_sl' ),
				'tooltip_desc'  => self::get_renewal_tooltip(),
			),
			array(
				'id'            => 'edd_sl_email_matching',
				'name'          => __( 'Enforce Email Matching', 'edd_sl' ),
				'check'         => __( 'Enforce email matching on license renewals.', 'edd_sl' ),
				'type'          => 'checkbox_toggle',
				'tooltip_title' => __( 'What does \'Email Matching\' mean?', 'edd_sl' ),
				'tooltip_desc'  => __( 'Email matching restricts renewal of licenses to the email address used to originally purchase the license. This prevents license keys from being renewed by a different customer than purchased it.', 'edd_sl' ),
			),
			array(
				'id'            => 'edd_sl_renewal_discount',
				'name'          => __( 'Renewal Discount', 'edd_sl' ),
				'desc'          => __( 'Enter a discount amount as a percentage, such as 10. Or enter 0 for no discount.', 'edd_sl' ),
				'type'          => 'text',
				'size'          => 'small',
				'tooltip_title' => __( 'When is this renewal discount used?', 'edd_sl' ),
				'tooltip_desc'  => self::get_renewal_discount_tooltip(),
			),
			array(
				'id'            => 'edd_sl_disable_discounts',
				'name'          => __( 'Disable Discount Codes on Renewals', 'edd_sl' ),
				'check'         => __( 'Prevent customers from using non-renewal discounts in conjunction with renewals.', 'edd_sl' ),
				'type'          => 'checkbox_toggle',
				'tooltip_title' => __( 'Disable Discount Codes', 'edd_sl' ),
				'tooltip_desc'  => __( 'This will disable the option to redeem discount codes when the cart contains a license renewal.', 'edd_sl' ),
			),
			array(
				'id'    => 'edd_sl_show_cart_item_expiration',
				'name'  => __( 'Show Expiration', 'edd_sl' ),
				'check' => __( 'Show the license expiration date in the checkout cart.', 'edd_sl' ),
				'type'  => 'checkbox_toggle',
			),
		);
	}

	/**
	 * Gets the renewal tooltip based on whether Recurring is active or not.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	private static function get_renewal_tooltip() {
		if ( class_exists( 'EDD_Recurring' ) ) {
			return __( 'Checking this will give customers the ability to enter their license key on the checkout page and renew it. They\'ll also get renewal reminders to their email, and can also renew from their account page (if that page uses the [edd_license_keys] shortcode). NOTE: If the product is a Recurring product and the customer\'s subscription is still active, it will automatically renew even if this option is disabled.', 'edd_sl' );
		}

		return __( 'Checking this will give customers the ability to enter their license key on the checkout page and renew it. They\'ll also get renewal reminders to their email, and can also renew from their account page (if that page uses the [edd_license_keys] shortcode).', 'edd_sl' );
	}

	/**
	 * Gets the renewal discount tooltip based on whether Recurring is active or not.
	 *
	 * @since 3.9.0
	 * @return string
	 */
	private static function get_renewal_discount_tooltip() {
		if ( class_exists( 'EDD_Recurring' ) ) {
			return __( 'When the user is on the checkout page renewing their license, this discount will be automatically applied to their renewal purchase. NOTE: If the product is a Recurring product and the customer\'s subscription is still active, it will automatically renew with this discount applied.', 'edd_sl' );
		}

		return __( 'When the user is on the checkout page renewing their license, this discount will be automatically applied to their renewal purchase.', 'edd_sl' );
	}
}
